/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.image;

import cc.lechun.common.enums.image.ImageStatusEnum;
import cc.lechun.common.enums.image.ImageTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.annotation.ReadDataSource;
import cc.lechun.mall.dao.image.ImageMapper;
import cc.lechun.mall.dao.image.ImageTypeMapper;
import cc.lechun.mall.entity.image.ImageEntity;
import cc.lechun.mall.entity.image.ImageTypeEntity;
import cc.lechun.mall.iservice.image.ImageInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImageService
extends BaseService
implements ImageInterface {
    @Autowired
    private ImageTypeMapper imageTypeMapper;
    @Autowired
    private ImageMapper imageMapper;
    @Autowired
    private OssService ossService;

    @Override
    @ReadDataSource
    public ImageTypeEntity getImageType(int typeId) {
        return (ImageTypeEntity)this.imageTypeMapper.selectByPrimaryKey(Integer.valueOf(typeId));
    }

    @Override
    public ImageTypeEntity saveImageType(String typeName, String typePath) {
        ImageTypeEntity imageTypeEntity = new ImageTypeEntity();
        imageTypeEntity.setTypeCreateTime(DateUtils.now());
        imageTypeEntity.setTypeName(typeName);
        imageTypeEntity.setTypePath(typePath);
        imageTypeEntity.setStatus(ImageStatusEnum.all.getValue());
        imageTypeEntity.setFileType(ImageTypeEnum.pic.getValue());
        this.imageTypeMapper.insertSelective(imageTypeEntity);
        return imageTypeEntity;
    }

    @Override
    @ReadDataSource
    public List<ImageTypeEntity> getImageTypeList() {
        return this.imageMapper.getImageTypeList();
    }

    @Override
    @ReadDataSource
    public ImageEntity getImage(long imageId) {
        return (ImageEntity)this.imageMapper.selectByPrimaryKey(Long.valueOf(imageId));
    }

    @Override
    @Transactional
    public BaseJsonVo saveImage(int platformGroupId, int typeId, String imageName, String filePath, String userId) throws IOException {
        ImageTypeEntity imageTypeEntity = this.getImageType(typeId);
        if (imageTypeEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7c7b\u578b");
        }
        if (StringUtils.isEmpty((String)imageTypeEntity.getTypePath())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u7c7b\u578b\u8def\u5f84");
        }
        ImageEntity imageEntity = new ImageEntity();
        imageEntity.setTypeId(typeId);
        imageEntity.setStatus((short)1);
        imageEntity.setCreateTime(DateUtils.now());
        imageEntity.setImageName(imageName);
        imageEntity.setImagePath(filePath);
        imageEntity.setUserId(userId);
        imageEntity.setPlatformGroupId(platformGroupId);
        this.imageMapper.insertSelective(imageEntity);
        return BaseJsonVo.success((Object)imageEntity);
    }

    @Override
    public void deleteImage(long imageId) {
        ImageEntity imageEntity = this.getImage(imageId);
        imageEntity.setStatus((short)-1);
        this.imageMapper.updateByPrimaryKeySelective(imageEntity);
    }

    @Override
    @ReadDataSource
    public PageInfo getImageList(String imageName, int pageNum, int pageSize, int typeId, int platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        this.imageMapper.getImageList(imageName, typeId, platformGroupId);
        PageInfo pg = page.toPageInfo();
        pg.getList().forEach(imageEntityVo -> imageEntityVo.setAllImagePath(this.ossService.getImageResoure(imageEntityVo.getImagePath())));
        return pg;
    }
}

