/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.item.IndexItemMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexItemEntity;
import cc.lechun.mall.entity.item.IndexItemVo;
import cc.lechun.mall.entity.item.IndexNavEntity;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.item.IndexShowTypeEnum;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.deliver.DeliverInterface;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallIndexNavInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallIndexItemService
extends BaseService
implements MallIndexItemInterface {
    @Value(value="${lechun.oldapi.domain}")
    private String oldApiHost;
    @Autowired
    private IndexItemMapper indexItemMapper;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallIndexNavInterface indexNavInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private CustomerAddressInterface addressService;
    @Autowired
    private DeliverInterface deliverService;
    @Autowired
    private MallIndexItemInterface indexItemInterface;

    @ReadThroughSingleCache(namespace="IndexItemList", expiration=3600)
    public List<IndexItemEntity> getList(@ParameterValueKeyProvider String navId) {
        IndexItemEntity indexItemEntity = new IndexItemEntity();
        indexItemEntity.setNavId(navId);
        List indexItemEntities = this.indexItemMapper.getList(indexItemEntity);
        if (indexItemEntities != null && indexItemEntities.size() > 0) {
            indexItemEntities.sort((c1, c2) -> c1.getItemSn().compareTo(c2.getItemSn()));
        }
        return indexItemEntities;
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexItemListVo", expiration=3600)
    public List<IndexItemVo> getIndexItemList(@ParameterValueKeyProvider String navId) {
        ArrayList<IndexItemVo> indexItemVos = new ArrayList<IndexItemVo>();
        List<IndexItemEntity> indexItemEntities = this.getList(navId);
        try {
            if (indexItemEntities != null && indexItemEntities.size() > 0) {
                for (IndexItemEntity i : indexItemEntities) {
                    BuildPageEntity buildPageEntity;
                    IndexItemVo indexItemVo = new IndexItemVo();
                    ObjectConvert.fatherConvertToChild((Object)i, (Object)indexItemVo);
                    if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue()))) {
                        MallProductEntity productEntity = this.productInterface.getProduct(i.getProId());
                        indexItemVo.setItemName(productEntity != null ? productEntity.getProName() : "\u672a\u627e\u5230\u5546\u54c1");
                    }
                    if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue()))) {
                        MallPromotionEntity promotion = this.promotionInterface.getPromotion(i.getProId());
                        indexItemVo.setItemName(promotion != null ? promotion.getPromotionName() : "\u672a\u627e\u5230\u4fc3\u9500");
                    }
                    if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue()))) {
                        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByActiveNo(i.getProId());
                        indexItemVo.setItemName(activeEntity != null ? activeEntity.getActiveName() : "\u672a\u627e\u5230\u6d3b\u52a8");
                    }
                    if (i.getItemType().equals(String.valueOf(SalesTypeEnum.SALES_GROUP.getValue()))) {
                        MallProductGroupEntity group = this.groupInterface.getGroup(i.getProId());
                        indexItemVo.setItemName(group != null ? group.getGroupName() : "\u672a\u627e\u5230\u5957\u88c5");
                    }
                    indexItemVo.setModuleListName((buildPageEntity = this.buildPageInterface.getBuildPage(i.getBuildPageId())) != null ? buildPageEntity.getPageName() : "\u672a\u627e\u5230\u5217\u8868\u6a21\u677f");
                    buildPageEntity = this.buildPageInterface.getBuildPage(i.getDetailBuildPageId());
                    indexItemVo.setMobuleDetailName(buildPageEntity != null ? buildPageEntity.getPageName() : "\u672a\u627e\u5230\u8be6\u60c5\u6a21\u677f");
                    indexItemVo.setItemTypeName(SalesTypeEnum.getName(Integer.parseInt(i.getItemType())));
                    indexItemVo.setShowTypeName(IndexShowTypeEnum.getName(i.getIndexShowType()));
                    indexItemVos.add(indexItemVo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return indexItemVos;
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexItemEntity", expiration=3600)
    public IndexItemEntity getIdnexItem(@ParameterValueKeyProvider String indexItemId) {
        return (IndexItemEntity)this.indexItemMapper.selectByPrimaryKey((Serializable)((Object)indexItemId));
    }

    @Override
    public BaseJsonVo saveIndexItem(IndexItemEntity indexItemEntity) {
        int count = 0;
        if (indexItemEntity.getIndexItemId() == null || indexItemEntity.getIndexItemId().isEmpty()) {
            indexItemEntity.setIndexItemId(IDGenerate.getUniqueIdStr());
            count = this.indexItemMapper.insertSelective(indexItemEntity);
        } else {
            count = this.indexItemMapper.updateByPrimaryKeySelective(indexItemEntity);
        }
        if (count > 0) {
            this.removeCache(indexItemEntity.getNavId(), indexItemEntity.getIndexItemId());
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo deleteIndexItem(String indexItemId) {
        IndexItemEntity indexItemEntity = (IndexItemEntity)this.indexItemMapper.selectByPrimaryKey((Serializable)((Object)indexItemId));
        if (indexItemEntity != null) {
            this.removeCache(indexItemEntity.getNavId(), indexItemId);
        }
        if (this.indexItemMapper.deleteByPrimaryKey((Serializable)((Object)indexItemId)) == 1) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteIndexItemByNavId(String navId) {
        int count = 0;
        List<IndexItemVo> indexItemEntities = this.getIndexItemList(navId);
        try {
            if (indexItemEntities != null && indexItemEntities.size() > 0) {
                for (IndexItemEntity indexItemEntity : indexItemEntities) {
                    this.removeCache(indexItemEntity.getNavId(), indexItemEntity.getIndexItemId());
                    count = this.indexItemMapper.deleteByPrimaryKey((Serializable)((Object)indexItemEntity.getIndexItemId()));
                    if (count != 0) continue;
                    throw new RuntimeException();
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        if (count == 0) {
            return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getIndexNavProductList(Integer platformId, String customerId, int itemType) {
        BaseJsonVo rtn;
        if (customerId == null) {
            customerId = "";
        }
        if (platformId == null) {
            platformId = 1;
        }
        if ((rtn = customerId.isEmpty() ? this.indexItemInterface.getIndexNavProductListWithoutSpeedupNoLogin(platformId, customerId, itemType) : this.indexItemInterface.getIndexNavProductListWithoutSpeedup(platformId, customerId, itemType)).isSuccess()) {
            List vos = (List)rtn.getValue();
            return rtn;
        }
        return rtn;
    }

    private BaseJsonVo getIndexNavProductListWithoutSpeedupNoCache(final Integer platformId, final String customerId, int itemType) {
        List<IndexNavEntity> navs = this.indexNavInterface.getEnableIndexNavList(platformId);
        ArrayList removeNavs = new ArrayList();
        final ArrayList navVos = new ArrayList();
        final String isVip = this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday";
        try {
            ExecutorService pool = Executors.newFixedThreadPool(navs.size());
            for (final IndexNavEntity nav : navs) {
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        List<IndexItemEntity> indexItemEntities = MallIndexItemService.this.getList(nav.getIndexNavId());
                        IndexNavVo indexNavVo = new IndexNavVo();
                        indexNavVo.setIndexNavId(nav.getIndexNavId());
                        indexNavVo.setCountDown(nav.getCountdown());
                        indexNavVo.setModuleId(nav.getBuildPageId());
                        indexNavVo.setNavModuleId(nav.getNavBuildPageId());
                        indexNavVo.setTerminal(nav.getPlatformId());
                        indexNavVo.setNavName(nav.getNavName());
                        indexNavVo.setNavName1(nav.getNavName1());
                        indexNavVo.setNavName2(nav.getNavName2());
                        indexNavVo.setNavName3(nav.getNavName3());
                        indexNavVo.setNavSn(nav.getNavSn());
                        indexNavVo.setIsvipday(isVip);
                        indexNavVo.setPlatformId(nav.getPlatformId());
                        ArrayList<Object> objects = new ArrayList<Object>();
                        if (indexItemEntities != null) {
                            indexItemEntities.sort((c1, c2) -> c1.getItemSn().compareTo(c2.getItemSn()));
                            for (IndexItemEntity indexItemEntity : indexItemEntities) {
                                IndexActiveVo indexActiveVo;
                                MallIndexProductVo indexProductVo;
                                MallIndexGroupVo indexGroupVo;
                                MallIndexPromotionVo indexPromotionVo;
                                if (indexItemEntity.getItemType().equals("1") && (indexPromotionVo = MallIndexItemService.this.getIndexPromotion(customerId, platformId, indexItemEntity)) != null) {
                                    objects.add(indexPromotionVo);
                                    if (nav.getCountdown() == 1 && indexPromotionVo != null) {
                                        indexNavVo.setSecond(indexPromotionVo.getSecond());
                                        indexNavVo.setSeconds(indexPromotionVo.getSeconds());
                                        indexNavVo.setBeginTime(indexPromotionVo.getBeginTime());
                                        indexNavVo.setEndTime(indexPromotionVo.getEndTime());
                                        indexNavVo.setHour(indexPromotionVo.getHour());
                                        indexNavVo.setMinute(indexPromotionVo.getMinute());
                                    }
                                }
                                if (indexItemEntity.getItemType().equals("2") && (indexGroupVo = MallIndexItemService.this.getIndexGroup(customerId, platformId, indexItemEntity)) != null) {
                                    objects.add(indexGroupVo);
                                }
                                if (indexItemEntity.getItemType().equals("4") && (indexProductVo = MallIndexItemService.this.getIndexProduct(customerId, platformId, indexItemEntity)) != null) {
                                    objects.add(indexProductVo);
                                }
                                if (!indexItemEntity.getItemType().equals("5") || (indexActiveVo = MallIndexItemService.this.getIndexActive(customerId, platformId, indexItemEntity)) == null) continue;
                                objects.add(indexActiveVo);
                                if (nav.getCountdown() != 1 || indexActiveVo == null) continue;
                                indexNavVo.setSecond(indexActiveVo.getSecond());
                                indexNavVo.setSeconds(indexActiveVo.getSeconds());
                                indexNavVo.setBeginTime(indexActiveVo.getBeginTime());
                                indexNavVo.setEndTime(indexActiveVo.getEndTime());
                                indexNavVo.setHour(indexActiveVo.getHour());
                                indexNavVo.setMinute(indexActiveVo.getMinute());
                            }
                        }
                        indexNavVo.setItems(objects);
                        if (objects.size() > 0) {
                            indexNavVo.setItems(objects);
                        }
                        navVos.add(indexNavVo);
                    }
                });
            }
            pool.shutdown();
            boolean loop = true;
            while (loop = !pool.awaitTermination(2L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
        navVos.sort((c1, c2) -> c1.getNavSn().compareTo(c2.getNavSn()));
        return BaseJsonVo.success(navVos);
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavProductListNoLogin", expiration=300)
    public BaseJsonVo getIndexNavProductListWithoutSpeedupNoLogin(@ParameterValueKeyProvider(order=0) Integer platformId, String customerId, @ParameterValueKeyProvider(order=1) int itemType) {
        return this.getIndexNavProductListWithoutSpeedupNoCache(platformId, customerId, itemType);
    }

    @Override
    @ReadThroughSingleCache(namespace="IndexNavProductList", expiration=300)
    public BaseJsonVo getIndexNavProductListWithoutSpeedup(@ParameterValueKeyProvider(order=0) Integer platformId, @ParameterValueKeyProvider(order=1) String customerId, @ParameterValueKeyProvider(order=2) int itemType) {
        return this.getIndexNavProductListWithoutSpeedupNoCache(platformId, customerId, itemType);
    }

    private MallIndexPromotionVo getIndexPromotion(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        MallIndexPromotionVo indexPromotionVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.promotionInterface.buildIndexPromotionVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexPromotionVo = (MallIndexPromotionVo)baseJsonVo.getValue();
            indexPromotionVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexPromotionVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexPromotionVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexPromotionVo.setModuleId(indexItemEntity.getBuildPageId());
            indexPromotionVo.setItemSn(indexItemEntity.getItemSn());
            indexPromotionVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexPromotionVo;
    }

    private MallIndexGroupVo getIndexGroup(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        MallIndexGroupVo indexGroupVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.groupInterface.buildIndexGroupVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexGroupVo = (MallIndexGroupVo)baseJsonVo.getValue();
            indexGroupVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexGroupVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexGroupVo.setModuleId(indexItemEntity.getBuildPageId());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexGroupVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexGroupVo.setItemSn(indexItemEntity.getItemSn());
            indexGroupVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexGroupVo;
    }

    private MallIndexProductVo getIndexProduct(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        MallIndexProductVo indexProductVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.productInterface.buildIndexProductVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexProductVo = (MallIndexProductVo)baseJsonVo.getValue();
            indexProductVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexProductVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setModuleId(indexItemEntity.getBuildPageId());
            indexProductVo.setItemSn(indexItemEntity.getItemSn());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexProductVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexProductVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexProductVo;
    }

    private IndexActiveVo getIndexActive(String customerId, int platformId, IndexItemEntity indexItemEntity) {
        BaseJsonVo baseJsonVo;
        IndexActiveVo indexActiveVo = null;
        if (indexItemEntity != null && (baseJsonVo = this.activeInterface.buildIndexActiveVo(indexItemEntity.getProId(), customerId)).isSuccess()) {
            BuildPageEntity buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getDetailBuildPageId());
            indexActiveVo = (IndexActiveVo)baseJsonVo.getValue();
            indexActiveVo.setModuleDetailId(indexItemEntity.getDetailBuildPageId());
            indexActiveVo.setDetailWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexActiveVo.setModuleId(indexItemEntity.getBuildPageId());
            buildPageEntity = this.buildPageInterface.getBuildPage(indexItemEntity.getBuildPageId());
            indexActiveVo.setItemSn(indexItemEntity.getItemSn());
            indexActiveVo.setWebFlag(buildPageEntity == null ? "" : buildPageEntity.getWebFlag());
            indexActiveVo.setDetailUrl(this.getItemDetailUrl("/template/pagebuild/", platformId, indexItemEntity.getNavId(), Integer.valueOf(indexItemEntity.getItemType()), indexItemEntity.getProId()));
        }
        return indexActiveVo;
    }

    private void removeCache(String indexNavId, String indexItemId) {
        this.memcachedService.delete("IndexItemEntity", String.valueOf(indexItemId));
        this.memcachedService.delete("IndexItemList", String.valueOf(indexNavId));
        this.memcachedService.delete("IndexItemListVo", String.valueOf(indexNavId));
    }

    @Override
    public String getItemDetailUrl(String modulePath, int platformId, String navId, int itemType, String itemId) {
        return modulePath + platformId + "_" + navId + "_" + itemType + "_" + itemId + ".html";
    }

    @Override
    public List<MallSelectDataVo> getItems(int itemType, int platformGroupId) {
        if (itemType == SalesTypeEnum.SALES_PRODUCT.getValue()) {
            return this.productInterface.getOptionProductList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_GROUP.getValue()) {
            return this.groupInterface.getOptionGroupList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_PROMOTION.getValue()) {
            return this.promotionInterface.getOptionPromotionList(platformGroupId);
        }
        if (itemType == SalesTypeEnum.SALES_ACTIVE.getValue()) {
            return this.activeInterface.getOptionActiveList(platformGroupId);
        }
        return new ArrayList<MallSelectDataVo>();
    }

    @Override
    @ReadThroughSingleCache(namespace="ItemDetail", expiration=300)
    public BaseJsonVo getItemDetail(String customerId, @ParameterValueKeyProvider(order=1) String itemId, @ParameterValueKeyProvider(order=2) int itemType, @ParameterValueKeyProvider(order=3) Integer level) {
        if (SalesTypeEnum.SALES_PROMOTION.getValue() == itemType) {
            return this.promotionInterface.buildIndexPromotionVo(itemId, customerId);
        }
        if (SalesTypeEnum.SALES_PRODUCT.getValue() == itemType) {
            return this.productInterface.buildIndexProductVo(itemId, customerId);
        }
        if (SalesTypeEnum.SALES_GROUP.getValue() == itemType) {
            return this.groupInterface.buildIndexGroupVo(itemId, customerId);
        }
        if (SalesTypeEnum.SALES_ACTIVE.getValue() == itemType) {
            return this.activeInterface.buildIndexActiveVo(itemId, customerId);
        }
        return BaseJsonVo.error((String)"\u7c7b\u578b\u9519\u8bef");
    }
}

