/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.item;

import cc.lechun.active.entity.active.IndexActiveVo;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.item.BuildPageEntity;
import cc.lechun.mall.entity.item.IndexNavVo;
import cc.lechun.mall.entity.item.ItemsVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallIndexGroupVo;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.iservice.item.MallBuildPageInterface;
import cc.lechun.mall.iservice.item.MallIndexItemInterface;
import cc.lechun.mall.iservice.item.MallPageConfigInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.utils.ScpUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPageConfigService
extends BaseService
implements MallPageConfigInterface {
    @Autowired
    private MallBuildPageInterface buildPageInterface;
    @Autowired
    private MallVipInterface vipInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallIndexItemInterface indexItemInterface;

    @Override
    public BaseJsonVo buildIndexPage(int platformId) {
        List<BuildPageEntity> buildPageEntities = this.buildPageInterface.getBuildPageByNavType(platformId, (short)7);
        if (buildPageEntities == null || buildPageEntities.size() == 0) {
            return BaseJsonVo.error((String)("\u5e73\u53f0[" + platformId + "],\u9996\u9875\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728"));
        }
        String content = buildPageEntities.get(0).getPageContent();
        if (content.isEmpty()) {
            return BaseJsonVo.error((String)("\u9996\u9875\u6a21\u677f[" + buildPageEntities.get(0).getPageName() + "]\u5185\u5bb9\u4e3a\u7a7a"));
        }
        content = content.replace("${terminal}", String.valueOf(platformId));
        content = content.replace("${isvipday}", this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        BaseJsonVo baseJsonVo = this.savePageFile(platformId, content, "index" + platformId + ".html", 1);
        return baseJsonVo;
    }

    @Override
    public BaseJsonVo buildIndexNavModule(IndexNavVo navVo) {
        if (navVo.getNavModuleId() <= 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u5bfc\u822a\u680f\u6a21\u677f"));
        }
        BuildPageEntity buildPage = this.buildPageInterface.getBuildPage(navVo.getNavModuleId());
        if (buildPage == null) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5bfc\u822a\u680f\u6a21\u677f\u4e0d\u5b58\u5728"));
        }
        String content = buildPage.getPageContent();
        if (content.isEmpty()) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5bfc\u822a\u680f\u6a21\u677f[" + buildPage.getPageName() + "]\u5185\u5bb9\u4e3a\u7a7a"));
        }
        content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)navVo), content);
        return BaseJsonVo.success((Object)content);
    }

    @Override
    public BaseJsonVo buildNavModule(IndexNavVo navVo) {
        if (navVo.getModuleId() <= 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u677f\u5757\u6a21\u677f"));
        }
        BuildPageEntity buildPage = this.buildPageInterface.getBuildPage(navVo.getModuleId());
        if (buildPage == null) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u677f\u5757\u6a21\u677f\u4e0d\u5b58\u5728"));
        }
        String content = buildPage.getPageContent();
        if (content.isEmpty()) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u677f\u5757\u6a21\u677f[" + buildPage.getPageName() + "]\u5185\u5bb9\u4e3a\u7a7a"));
        }
        content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)navVo), content);
        return BaseJsonVo.success((Object)content);
    }

    @Override
    public BaseJsonVo buildItemModule(IndexNavVo navVo, Map<Integer, StringBuilder> detailListMap) {
        List<Object> objects = navVo.getItems();
        StringBuilder itemModule = new StringBuilder();
        ArrayList detailModule = new ArrayList();
        if (objects == null || objects.size() == 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u5546\u54c1"));
        }
        ItemsVo itemsVo = new ItemsVo();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        for (Object o : objects) {
            if (o instanceof MallIndexProductVo) {
                itemsVo.setProductVo((MallIndexProductVo)o);
                itemsVo.setItemType(((MallIndexProductVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexProductVo)o).getModuleId());
                itemsVo.setProductName(((MallIndexProductVo)o).getProductName());
                baseJsonVo = this.buildModule(navVo, itemsVo, detailListMap);
                if (baseJsonVo.isSuccess()) {
                    itemModule.append(baseJsonVo.getValue().toString());
                    itemModule.append("\r\n");
                }
            }
            if (o instanceof MallIndexGroupVo) {
                itemsVo.setGroupVo((MallIndexGroupVo)o);
                itemsVo.setItemType(((MallIndexGroupVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexGroupVo)o).getModuleId());
                itemsVo.setProductName(((MallIndexGroupVo)o).getGroupName());
                baseJsonVo = this.buildModule(navVo, itemsVo, detailListMap);
                if (baseJsonVo.isSuccess()) {
                    itemModule.append(baseJsonVo.getValue().toString());
                    itemModule.append("\r\n");
                }
            }
            if (o instanceof MallIndexPromotionVo) {
                itemsVo.setPromotionVo((MallIndexPromotionVo)o);
                itemsVo.setItemType(((MallIndexPromotionVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexPromotionVo)o).getModuleId());
                itemsVo.setProductName(((MallIndexPromotionVo)o).getProductName());
                baseJsonVo = this.buildModule(navVo, itemsVo, detailListMap);
                if (baseJsonVo.isSuccess()) {
                    itemModule.append(baseJsonVo.getValue().toString());
                    itemModule.append("\r\n");
                }
            }
            if (!(o instanceof IndexActiveVo)) continue;
            itemsVo.setIndexActiveVo((IndexActiveVo)o);
            itemsVo.setItemType(((IndexActiveVo)o).getItemType());
            itemsVo.setModuleId(((IndexActiveVo)o).getModuleId());
            itemsVo.setProductName(((IndexActiveVo)o).getActiveName());
            baseJsonVo = this.buildModule(navVo, itemsVo, detailListMap);
            if (!baseJsonVo.isSuccess()) continue;
            itemModule.append(baseJsonVo.getValue().toString());
            itemModule.append("\r\n");
        }
        return BaseJsonVo.success((Object)itemModule);
    }

    @Override
    public BaseJsonVo buildItemDetailModule(IndexNavVo navVo) {
        int platformId = navVo.getPlatformId();
        String navId = navVo.getIndexNavId();
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        List<Object> objects = navVo.getItems();
        ItemsVo itemsVo = new ItemsVo();
        if (objects == null || objects.size() == 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u5546\u54c1"));
        }
        for (Object o : objects) {
            String fileName;
            String content = "";
            if (o instanceof MallIndexProductVo) {
                itemsVo.setProductVo((MallIndexProductVo)o);
                itemsVo.setItemType(((MallIndexProductVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexProductVo)o).getModuleDetailId());
                itemsVo.setProductName(((MallIndexProductVo)o).getProductName());
                baseJsonVo = this.buildDetailModule(navVo, itemsVo);
                if (baseJsonVo.isSuccess()) {
                    content = baseJsonVo.getValue().toString();
                    fileName = this.indexItemInterface.getItemDetailUrl("", platformId, navId, itemsVo.getItemType(), itemsVo.getProductVo().getProductId());
                    this.savePageFile(platformId, content, fileName, 0);
                }
            }
            if (o instanceof MallIndexGroupVo) {
                itemsVo.setGroupVo((MallIndexGroupVo)o);
                itemsVo.setItemType(((MallIndexGroupVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexGroupVo)o).getModuleDetailId());
                itemsVo.setProductName(((MallIndexGroupVo)o).getGroupName());
                baseJsonVo = this.buildDetailModule(navVo, itemsVo);
                if (baseJsonVo.isSuccess()) {
                    content = baseJsonVo.getValue().toString();
                    fileName = this.indexItemInterface.getItemDetailUrl("", platformId, navId, itemsVo.getItemType(), itemsVo.getGroupVo().getGroupId());
                    this.savePageFile(platformId, content, fileName, 0);
                }
            }
            if (o instanceof MallIndexPromotionVo) {
                itemsVo.setPromotionVo((MallIndexPromotionVo)o);
                itemsVo.setItemType(((MallIndexPromotionVo)o).getItemType());
                itemsVo.setModuleId(((MallIndexPromotionVo)o).getModuleDetailId());
                itemsVo.setProductName(((MallIndexPromotionVo)o).getProductName());
                baseJsonVo = this.buildDetailModule(navVo, itemsVo);
                if (baseJsonVo.isSuccess()) {
                    content = baseJsonVo.getValue().toString();
                    fileName = this.indexItemInterface.getItemDetailUrl("", platformId, navId, itemsVo.getItemType(), itemsVo.getPromotionVo().getPromotionId());
                    this.savePageFile(platformId, content, fileName, 0);
                }
            }
            if (!(o instanceof IndexActiveVo)) continue;
            itemsVo.setIndexActiveVo((IndexActiveVo)o);
            itemsVo.setItemType(((IndexActiveVo)o).getItemType());
            itemsVo.setModuleId(((IndexActiveVo)o).getModuleDetailId());
            itemsVo.setProductName(((IndexActiveVo)o).getActiveName());
            baseJsonVo = this.buildDetailModule(navVo, itemsVo);
            if (!baseJsonVo.isSuccess()) continue;
            content = baseJsonVo.getValue().toString();
            fileName = this.indexItemInterface.getItemDetailUrl("", platformId, navId, itemsVo.getItemType(), itemsVo.getIndexActiveVo().getActiveNo());
            this.savePageFile(platformId, content, fileName, 0);
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo buildModule(IndexNavVo navVo, ItemsVo itemsVo, Map<Integer, StringBuilder> detailListMap) {
        if (itemsVo.getModuleId() <= 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u5546\u54c1[" + itemsVo.getProductName() + "]\u6a21\u677f"));
        }
        BuildPageEntity buildPage = this.buildPageInterface.getBuildPage(itemsVo.getModuleId());
        if (buildPage == null) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5546\u54c1\u6a21\u677f\u4e0d\u5b58\u5728"));
        }
        String content = buildPage.getPageContent();
        if (content.isEmpty()) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5546\u54c1\u6a21\u677f[" + buildPage.getPageName() + "]\u5185\u5bb9\u4e3a\u7a7a"));
        }
        if (itemsVo.getItemType() == 1) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getPromotionVo()), content);
        }
        if (itemsVo.getItemType() == 2) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getGroupVo()), content);
        }
        if (itemsVo.getItemType() == 4) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getProductVo()), content);
        }
        if (itemsVo.getItemType() == 5) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getIndexActiveVo()), content);
        }
        if (detailListMap != null) {
            StringBuilder sb = detailListMap.get(itemsVo.getItemType());
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(content);
            if (detailListMap.containsKey(itemsVo.getItemType())) {
                detailListMap.remove(itemsVo.getItemType());
            }
            detailListMap.put(itemsVo.getItemType(), sb);
        }
        return BaseJsonVo.success((Object)content);
    }

    private BaseJsonVo buildDetailModule(IndexNavVo navVo, ItemsVo itemsVo) {
        if (itemsVo.getModuleId() <= 0) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u6ca1\u6709\u914d\u7f6e\u5546\u54c1[" + itemsVo.getProductName() + "]\u6a21\u677f"));
        }
        BuildPageEntity buildPage = this.buildPageInterface.getBuildPage(itemsVo.getModuleId());
        if (buildPage == null) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5546\u54c1\u6a21\u677f\u4e0d\u5b58\u5728"));
        }
        String content = buildPage.getPageContent();
        if (content.isEmpty()) {
            return BaseJsonVo.error((String)("\u5bfc\u822a\u680f[" + navVo.getNavName() + "],\u5546\u54c1\u6a21\u677f[" + buildPage.getPageName() + "]\u5185\u5bb9\u4e3a\u7a7a"));
        }
        if (itemsVo.getItemType() == 1) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getPromotionVo()), content);
        }
        if (itemsVo.getItemType() == 2) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getGroupVo()), content);
        }
        if (itemsVo.getItemType() == 4) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getProductVo()), content);
        }
        if (itemsVo.getItemType() == 5) {
            content = this.getReplaceContent(navVo, ObjectConvert.objectConvertToMap((Object)itemsVo.getIndexActiveVo()), content);
        }
        return BaseJsonVo.success((Object)content);
    }

    @Override
    public BaseJsonVo savePageFile(int platformId, String content, String fileName, int isFirstPage) {
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(platformId);
        if (platFormEntity == null) {
            return BaseJsonVo.error((String)("\u5e73\u53f0[" + platformId + "]\u4e0d\u5b58\u5728"));
        }
        String[] htmlPaths = platFormEntity.getWebPath().split(";");
        String remotePath = "";
        try {
            for (String indexPath : htmlPaths) {
                if (indexPath.isEmpty()) continue;
                if (isFirstPage == 1) {
                    remotePath = indexPath;
                    indexPath = indexPath + fileName;
                } else {
                    remotePath = indexPath + "/template/pagebuild/";
                    indexPath = indexPath + "/template/pagebuild/" + fileName;
                }
                String contentOld = "";
                if (FileUtils.fileExists((String)indexPath)) {
                    contentOld = FileUtils.fileRead((String)indexPath, (String)"UTF-8");
                }
                if (content.equals(contentOld)) continue;
                FileUtils.fileWrite((String)indexPath, (String)"UTF-8", (String)content);
                ScpUtils.putFile(indexPath, remotePath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return BaseJsonVo.error((String)("\u6587\u4ef6" + fileName + "\u4fdd\u5b58\u5931\u8d25"));
        }
        return BaseJsonVo.success((Object)"");
    }

    private String getReplaceContent(IndexNavVo navVo, Map<String, String> map, String content) {
        for (String key : map.keySet()) {
            String val = map.get(key);
            if (key.equals("productTagName") || key.equals("groupTagsName")) {
                String otherName = "";
                for (String s : val.split(";")) {
                    otherName = otherName + "<span class=\"tag\">" + s + "</span>";
                }
                content = content.replace("${" + key + "}", otherName);
                continue;
            }
            if (key.equals("items")) continue;
            if (key.equals("picMap")) {
                Map picMap = JsonUtils.stringToMap((String)val.replace("{", "{\"").replace("}", "\"}").replace("=", "\":\"").replace("], ", "]\",\""));
                for (String k : picMap.keySet()) {
                    String v = (String)picMap.get(k);
                    if (v == null) continue;
                    v = v.replace("[", "").replace("]", "").replace("\"", "");
                    k = k.replace("Product", "").replace("Promotion", "").replace("Group", "").replace("Active", "").replace("Vip", "");
                    String[] arr = v.split(",");
                    int i = 0;
                    for (String a : arr) {
                        content = content.replace("${" + k + i + "}", a);
                        content = content.replace("${" + k + "}", a);
                        ++i;
                    }
                }
                continue;
            }
            content = content.replace("${" + key + "}", val);
        }
        content = content.replace("${isvipday}", navVo.getIsvipday());
        content = content.replace("${terminal}", String.valueOf(navVo.getPlatformId()));
        return content;
    }
}

