/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.alipay;

import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.pay.AliPayInputEntity;
import cc.lechun.mall.entity.pay.AliPayNotifyEntity;
import cc.lechun.mall.entity.pay.AliPayRefundEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import cc.lechun.mall.service.pay.alipay.AlipaySign;
import cc.lechun.mall.service.pay.alipay.AlipayWapConfig;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.request.AlipayTradeCloseRequest;
import com.alipay.api.request.AlipayTradeQueryRequest;
import com.alipay.api.request.AlipayTradeRefundRequest;
import com.alipay.api.request.AlipayTradeWapPayRequest;
import com.alipay.api.response.AlipayTradeCloseResponse;
import com.alipay.api.response.AlipayTradeQueryResponse;
import com.alipay.api.response.AlipayTradeRefundResponse;
import java.math.BigDecimal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="alipay.alipaySubWapPay")
public class AlipayWapService
extends BaseService
implements PayStrategyInterface {
    @Autowired
    private AlipayWapConfig alipayWapConfig;

    @Override
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        AliPayInputEntity aliPayInputEntity = new AliPayInputEntity();
        aliPayInputEntity.setOut_trade_no(inputEntity.getTradeNo());
        aliPayInputEntity.setPassback_params(inputEntity.getOrderMainNo());
        aliPayInputEntity.setSubject("\u4e50\u7eafnewwepApp\u5546\u57ce\u8ba2\u5355");
        aliPayInputEntity.setTotal_amount(inputEntity.getPayAmount().floatValue());
        AlipayClient alipayClient = this.alipayWapConfig.getAlipayClient(inputEntity);
        AlipayTradeWapPayRequest alipayRequest = new AlipayTradeWapPayRequest();
        alipayRequest.setReturnUrl(inputEntity.getReturnUrl());
        alipayRequest.setNotifyUrl(inputEntity.getNotifyUrl());
        alipayRequest.setBizContent(JsonUtils.toJson((Object)aliPayInputEntity, (boolean)false));
        String form = "";
        try {
            AlipayResponse response = alipayClient.pageExecute((AlipayRequest)alipayRequest);
            form = response.getBody();
        }
        catch (Exception e) {
            result.setError("\u8c03\u7528\u652f\u4ed8\u5b9d\u5931\u8d25");
            e.printStackTrace();
        }
        PayOutputEntity aliPayOutputEntity = new PayOutputEntity();
        aliPayOutputEntity.setOrderMainNo(inputEntity.getOrderMainNo());
        aliPayOutputEntity.setCharSet(inputEntity.getCharset());
        aliPayOutputEntity.setForm(form);
        aliPayOutputEntity.setPayJsUrl(inputEntity.getRequestDomain());
        aliPayOutputEntity.setStatus(PayStatusEnum.TO_PAY_SUCCESS.getValue());
        aliPayOutputEntity.setPayTypeId(inputEntity.getPayType());
        aliPayOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
        aliPayOutputEntity.setSendContent(JsonUtils.toJson((Object)alipayRequest, (boolean)true));
        aliPayOutputEntity.setSendUrl(inputEntity.getRequestDomain());
        aliPayOutputEntity.setReturnContent(form);
        result.setValue((Object)aliPayOutputEntity);
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(T t) {
        this.logger.info("\u5f00\u59cb\u63a5\u6536\u56de\u8c03\u53c2\u6570");
        Boolean isSuccess = false;
        BaseJsonVo result = new BaseJsonVo();
        PayInputEntity inputEntity = (PayInputEntity)t;
        AliPayNotifyEntity aliPayNotifyEntity = (AliPayNotifyEntity)inputEntity.getEntity();
        boolean signVerified = AlipaySign.sign(aliPayNotifyEntity.getRequestMap(), inputEntity.getPublicKey(), inputEntity.getCharset(), inputEntity.getSignType());
        this.logger.info("Alipay\u652f\u4ed8\u56de\u8c03\uff0c\u9a8c\u8bc1\u7b7e\u540d:" + signVerified + "aliPayNotifyEntity" + JsonUtils.toJson((Object)aliPayNotifyEntity.getRequestMap(), (boolean)false) + "," + inputEntity.getPublicKey() + "," + inputEntity.getCharset() + "," + inputEntity.getSignType());
        if (signVerified) {
            if (inputEntity.getAppId().equals(aliPayNotifyEntity.getAppId()) && inputEntity.getSellerEmail().equals(aliPayNotifyEntity.getSellerEmail()) && (aliPayNotifyEntity.getTradeStatus().equals("TRADE_SUCCESS") || aliPayNotifyEntity.getTradeStatus().equals("TRADE_FINISHED"))) {
                if (inputEntity.getPayAmount().compareTo(aliPayNotifyEntity.getTotalAmount()) != 0) {
                    this.logger.error("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4" + inputEntity.getPayAmount().doubleValue() + "--" + aliPayNotifyEntity.getTotalAmount().doubleValue());
                    result.setError("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u91d1\u989d\u4e0d\u4e00\u81f4");
                    return result;
                }
                if (!inputEntity.getTradeNo().equals(aliPayNotifyEntity.getOutTradeNo())) {
                    this.logger.error("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4" + inputEntity.getTradeNo() + "--" + aliPayNotifyEntity.getOutTradeNo());
                    result.setError("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4");
                    return result;
                }
                if (!inputEntity.getAppId().equals(aliPayNotifyEntity.getAppId())) {
                    this.logger.error("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u4ea4\u6613\u5355\u53f7\u4e0d\u4e00\u81f4" + inputEntity.getAppId() + "--" + aliPayNotifyEntity.getAppId());
                    result.setError("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0cAppId\u4e0d\u4e00\u81f4");
                    return result;
                }
                isSuccess = true;
                result.setValue((Object)aliPayNotifyEntity);
                this.logger.info("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u7b7e\u540d\u6210\u529f");
            } else {
                this.logger.error("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u652f\u4ed8\u72b6\u6001\u9519\u8bef");
            }
        } else {
            this.logger.error("Alipay\u652f\u4ed8\u56de\u8c03\u5b8c\u6210\uff0c\u7b7e\u540d\u5931\u8d25:");
            isSuccess = false;
        }
        if (!isSuccess.booleanValue()) {
            result.setError("AlipayWap\u652f\u4ed8\u5931\u8d25");
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        return null;
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        AlipayClient alipayClient = this.alipayWapConfig.getAlipayClient(inputEntity);
        AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
        request.setBizContent("{\"out_trade_no\":\"" + inputEntity.getTradeNo() + "\",\"trade_no\":\"\"  }");
        BaseJsonVo result = new BaseJsonVo();
        try {
            AlipayTradeQueryResponse response = (AlipayTradeQueryResponse)alipayClient.execute((AlipayRequest)request);
            AliPayNotifyEntity aliPayNotifyEntity = new AliPayNotifyEntity();
            if (response != null) {
                aliPayNotifyEntity.setAppId(inputEntity.getAppId());
                aliPayNotifyEntity.setAliPayTradeNo(response.getTradeNo());
                aliPayNotifyEntity.setBuyerId(response.getBuyerUserId());
                aliPayNotifyEntity.setBuyerLogonId(response.getBuyerLogonId());
                aliPayNotifyEntity.setGmtPayment(DateUtils.now((String)"yyyy-MM-dd HH:mm:ss"));
                aliPayNotifyEntity.setOutTradeNo(response.getOutTradeNo());
                aliPayNotifyEntity.setPassbackParams(inputEntity.getOrderMainNo());
                aliPayNotifyEntity.setReceiptAmount(BigDecimal.valueOf(Double.parseDouble(response.getReceiptAmount())));
                aliPayNotifyEntity.setSellerEmail(inputEntity.getSellerEmail());
                aliPayNotifyEntity.setSellerId("");
                aliPayNotifyEntity.setTotalAmount(BigDecimal.valueOf(Double.parseDouble(response.getTotalAmount())));
                aliPayNotifyEntity.setTradeStatus(response.getTradeStatus());
                if (inputEntity.getAppId().equals(aliPayNotifyEntity.getAppId()) && inputEntity.getSellerEmail().equals(aliPayNotifyEntity.getSellerEmail()) && (aliPayNotifyEntity.getTradeStatus().equals("TRADE_SUCCESS") || aliPayNotifyEntity.getTradeStatus().equals("TRADE_FINISHED"))) {
                    result.setValue((Object)aliPayNotifyEntity);
                    this.logger.info("Alipay\u652f\u4ed8\u67e5\u8be2\u5b8c\u6210\uff0c\u7b7e\u540d\u6210\u529f");
                    return result;
                }
                result.setError("Alipay\u652f\u4ed8\u4fe1\u606f\u9519\u8bef\u6216\u4e0d\u5b58\u5728\u652f\u4ed8\u8ba2\u5355");
            } else {
                result.setError("Alipay\u4e0d\u5b58\u5728\u652f\u4ed8\u8ba2\u5355");
            }
        }
        catch (AlipayApiException e) {
            this.logger.error("\u67e5\u8be2\u652f\u4ed8\u5b9d\u8ba2\u5355,\u5f02\u5e38:" + e.toString());
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        boolean btn = false;
        this.logger.info("\u5f00\u59cb\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355\uff0c\u4ea4\u6613\u5355\u53f7:" + inputEntity.getTradeNo() + "_" + inputEntity.getCustomerId());
        AlipayClient alipayClient = this.alipayWapConfig.getAlipayClient(inputEntity);
        AlipayTradeCloseRequest request = new AlipayTradeCloseRequest();
        request.setBizContent("{\"trade_no\":\"" + inputEntity.getThirdTradeNo() + "\",\"out_trade_no\":\"" + inputEntity.getTradeNo() + "\",\"operator_id\":\"" + inputEntity.getCustomerId() + "\"  }");
        AlipayTradeCloseResponse response = null;
        this.logger.info("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355:" + request.getBizContent());
        try {
            response = (AlipayTradeCloseResponse)alipayClient.execute((AlipayRequest)request);
            this.logger.info("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355,\u8fd4\u56de\u503c:" + response.getCode() + "_" + response.getMsg());
            if (response.isSuccess()) {
                btn = true;
            }
            this.logger.info("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355,\u8fd4\u56de\u503c:" + btn);
        }
        catch (AlipayApiException e) {
            this.logger.error("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355,\u5f02\u5e38:" + e.toString());
            e.printStackTrace();
        }
        if (!btn) {
            result.setError("\u5173\u95ed\u652f\u4ed8\u5b9d\u8ba2\u5355\u5931\u8d25");
        }
        return result;
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        if (inputEntity.getPayAmount().floatValue() < inputEntity.getRefundAmount().floatValue()) {
            result.setError("\u9000\u6b3e\u91d1\u989d\u5927\u4e8e\u652f\u4ed8\u91d1\u989d");
            return result;
        }
        AlipayClient alipayClient = this.alipayWapConfig.getAlipayClient(inputEntity);
        AlipayTradeRefundRequest request = new AlipayTradeRefundRequest();
        request.setBizContent("{\"out_trade_no\":\"" + inputEntity.getTradeNo() + "\",\"trade_no\":\"\",\"refund_amount\":" + inputEntity.getRefundAmount() + ",\"refund_reason\":\"\u6b63\u5e38\u9000\u6b3e\",\"out_request_no\":\"" + inputEntity.getRefundBillNo() + "\",\"operator_id\":\"" + inputEntity.getCustomerId() + "\"  }");
        try {
            AlipayTradeRefundResponse response = (AlipayTradeRefundResponse)alipayClient.execute((AlipayRequest)request);
            if (response != null) {
                if (response.isSuccess()) {
                    AliPayRefundEntity aliPayRefundEntity = new AliPayRefundEntity();
                    aliPayRefundEntity.setBuyerLogonId(response.getBuyerLogonId());
                    aliPayRefundEntity.setBuyerUserId(response.getBuyerUserId());
                    aliPayRefundEntity.setFundChange(response.getFundChange());
                    aliPayRefundEntity.setGmtRefundPay(response.getGmtRefundPay());
                    aliPayRefundEntity.setOpenId(response.getOpenId());
                    aliPayRefundEntity.setOutTradeNo(response.getOutTradeNo());
                    aliPayRefundEntity.setRefundFee(response.getRefundFee());
                    aliPayRefundEntity.setSendBackFee(response.getSendBackFee());
                    aliPayRefundEntity.setStoreName(response.getStoreName());
                    aliPayRefundEntity.setTradeNo(response.getTradeNo());
                    result.setValue((Object)aliPayRefundEntity);
                } else {
                    result.setError(response.getMsg() + response.getSubMsg());
                }
            } else {
                result.setError("\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u7a7a\u5bf9\u8c61");
            }
        }
        catch (AlipayApiException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        return new BaseJsonVo();
    }
}

