/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.payservice;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.payservice.PayStaffInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.api.PayServiceAPI;
import weixin.popular.bean.payservice.StaffInfo;
import weixin.popular.bean.payservice.StaffResult;

@Service
public class PayStaffService
implements PayStaffInterface {
    private static final Logger log = LoggerFactory.getLogger(PayStaffService.class);
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;

    @Override
    public BaseJsonVo setStaffService(Integer platformGroupId, String mobile, String corpid, String store_id, Integer platformId, String userId) {
        WeiXinBaseEntity weiXinBaseEntity = this.weiXinBaseInterface.getQiYeAccessTokenByPlatformId(6);
        String accessToken = weiXinBaseEntity.getAccessToken();
        StaffInfo staffInfo = PayServiceAPI.getStaff((String)accessToken, (String)userId);
        log.info("\u4f01\u4e1a\u5458\u5de5:{}", (Object)staffInfo.toString());
        StaffResult staffResult = null;
        String path = "/deploy/cert/apiclient_cert.pem";
        try {
            log.info("\u4f01\u4e1aid:{},\u95e8\u5e97id:{},\u5458\u5de5\u540d\u79f0:{},\u624b\u673a\u53f7:{},\u4e8c\u7ef4\u7801:{},\u5546\u6237\u53f7:{},avatar:{},userId:{},\u8bc1\u4e66:{}", new Object[]{corpid, corpid, staffInfo.getName(), staffInfo.getMobile(), staffInfo.getQr_code(), weiXinBaseEntity.getMchId(), staffInfo.getAvatar(), userId, path});
            staffResult = PayServiceAPI.register((String)store_id, (String)corpid, (String)staffInfo.getName(), (String)staffInfo.getMobile(), (String)staffInfo.getQr_code(), (String)weiXinBaseEntity.getMchId(), (String)staffInfo.getAvatar(), (String)userId, (String)path);
            log.info("\u6ce8\u518c\u72b6\u6001:{}", (Object)staffResult.toString());
        }
        catch (Exception e) {
            log.info("\u9519\u8bef\u6d88\u606f:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (staffResult != null && staffResult.getGuide_id() != null) {
            List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 211);
            DictionaryEntity dictionaryEntity = new DictionaryEntity();
            if (list.size() > 0) {
                dictionaryEntity = list.get(list.size() - 1);
                Integer key = Integer.valueOf(dictionaryEntity.getDictionaryKey()) + 1;
                dictionaryEntity.setDictionaryKey(key.toString());
                dictionaryEntity.setDictionaryName(staffResult.getGuide_id());
                dictionaryEntity.setRemark("\u670d\u52a1\u4eba\u5458id");
                short s = (short)(dictionaryEntity.getSort().intValue() + 1);
                dictionaryEntity.setSort(s);
                dictionaryEntity.setDictionaryTypeId(211);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            } else {
                dictionaryEntity.setDictionaryKey("1");
                dictionaryEntity.setDictionaryName(staffResult.getGuide_id());
                dictionaryEntity.setRemark("\u670d\u52a1\u4eba\u5458id");
                dictionaryEntity.setSort((short)1);
                dictionaryEntity.setDictionaryTypeId(211);
                dictionaryEntity.setPlatformGroupId(platformGroupId);
            }
            this.dictionaryInterface.saveDictionary(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryName(), dictionaryEntity.getSort().shortValue(), dictionaryEntity.getRemark());
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u670d\u52a1\u4eba\u5458\u6ce8\u518c\u5931\u8d25");
    }

    @Override
    public BaseJsonVo saveStaffInfo(String guide_id, Integer platformGroupId) {
        List<DictionaryEntity> list = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 211);
        DictionaryEntity dictionaryEntity = new DictionaryEntity();
        if (list.size() > 0) {
            dictionaryEntity = list.get(list.size() - 1);
            Integer key = Integer.valueOf(dictionaryEntity.getDictionaryKey()) + 1;
            dictionaryEntity.setDictionaryKey(key.toString());
            dictionaryEntity.setDictionaryName(guide_id);
            dictionaryEntity.setRemark("\u670d\u52a1\u4eba\u5458id");
            short s = (short)(dictionaryEntity.getSort().intValue() + 1);
            dictionaryEntity.setSort(s);
            dictionaryEntity.setDictionaryTypeId(211);
            dictionaryEntity.setPlatformGroupId(platformGroupId);
        } else {
            dictionaryEntity.setDictionaryKey("1");
            dictionaryEntity.setDictionaryName(guide_id);
            dictionaryEntity.setRemark("\u670d\u52a1\u4eba\u5458id");
            dictionaryEntity.setSort((short)1);
            dictionaryEntity.setDictionaryTypeId(211);
            dictionaryEntity.setPlatformGroupId(platformGroupId);
        }
        this.dictionaryInterface.saveDictionary(dictionaryEntity.getPlatformGroupId(), dictionaryEntity.getDictionaryTypeId(), dictionaryEntity.getDictionaryKey(), dictionaryEntity.getDictionaryName(), dictionaryEntity.getSort().shortValue(), dictionaryEntity.getRemark());
        return BaseJsonVo.success((Object)"");
    }
}

