/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.prepay;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.prepay.PrepayCardMapper;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardExportVO;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardService
extends BaseService<PrepayCardEntity, String>
implements PrepayCardInterface {
    @Resource
    PrepayCardMapper prepayCardMapper;

    @Override
    public Boolean batchIsUsed(Integer batchId) {
        PrepayCardEntity param = new PrepayCardEntity();
        param.setBatchId(batchId);
        List list = this.prepayCardMapper.getList(param);
        return list != null && list.size() != 0;
    }

    @Override
    public List<PrepayCardExportVO> getBatchPwds(Integer batchId) {
        return this.prepayCardMapper.getBatchPwds(batchId);
    }

    @Override
    public List<String> getPwds() {
        return this.prepayCardMapper.getPwds();
    }

    @Override
    public PageInfo<PrepayCardExportVO> getViewList(PrepayCardEntity card, PageForm pageForm) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.prepayCardMapper.getViewList(card);
        PageInfo pg = page.toPageInfo();
        ArrayList vos = new ArrayList();
        pg.getList().forEach(map -> {
            PrepayCardExportVO vo = new PrepayCardExportVO();
            vo.setCardId(((Map)map).get("CARD_ID").toString());
            vo.setCardPassword(((Map)map).get("CARD_PASSWORD").toString());
            if ((Integer)((Map)map).get("STATUS_NAME") == 0) {
                vo.setCreateTime("");
            } else {
                vo.setCreateTime(DateUtils.formatDate((Date)((Date)((Map)map).get("CREATE_TIME")), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            switch ((Integer)((Map)map).get("STATUS_NAME")) {
                case 0: {
                    vo.setStatusName("\u672a\u9886\u53d6");
                    break;
                }
                case 1: {
                    vo.setStatusName("\u5df2\u9886\u53d6");
                    break;
                }
                case 2: {
                    vo.setStatusName("\u5df2\u6fc0\u6d3b");
                    break;
                }
                case 3: {
                    vo.setStatusName("\u6682\u505c");
                    break;
                }
                case 4: {
                    vo.setStatusName("\u914d\u9001\u4e2d");
                    break;
                }
                case 5: {
                    vo.setStatusName("\u7981\u7528/\u9000\u6b3e");
                    break;
                }
                case 6: {
                    vo.setStatusName("\u5df2\u5b8c\u6210");
                    break;
                }
                default: {
                    vo.setStatusName("\u672a\u77e5\u72b6\u6001");
                }
            }
            vo.setUsedCount(String.valueOf((Integer)((Map)map).get("TOTAL_COUNT") - (Integer)((Map)map).get("REMAIN_COUNT")));
            vo.setNickName(((Map)map).get("NICK_NAME") == null ? null : ((Map)map).get("NICK_NAME").toString());
            vos.add(vo);
        });
        pg.setList(vos);
        return pg;
    }

    @Override
    public List<PrepayCardExportVO> getViewList(PrepayCardEntity card) {
        List<Map<String, Object>> viewList = this.prepayCardMapper.getViewList(card);
        ArrayList<PrepayCardExportVO> vos = new ArrayList<PrepayCardExportVO>();
        viewList.forEach(map -> {
            PrepayCardExportVO vo = new PrepayCardExportVO();
            vo.setCardId(map.get("CARD_ID").toString());
            vo.setCardPassword(map.get("CARD_PASSWORD").toString());
            if ((Integer)map.get("STATUS_NAME") == 0) {
                vo.setCreateTime("");
            } else {
                vo.setCreateTime(DateUtils.formatDate((Date)((Date)map.get("CREATE_TIME")), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            switch ((Integer)map.get("STATUS_NAME")) {
                case 0: {
                    vo.setStatusName("\u672a\u9886\u53d6");
                    break;
                }
                case 1: {
                    vo.setStatusName("\u5df2\u9886\u53d6");
                    break;
                }
                case 2: {
                    vo.setStatusName("\u5df2\u6fc0\u6d3b");
                    break;
                }
                case 3: {
                    vo.setStatusName("\u6682\u505c");
                    break;
                }
                case 4: {
                    vo.setStatusName("\u914d\u9001\u4e2d");
                    break;
                }
                case 5: {
                    vo.setStatusName("\u7981\u7528/\u9000\u6b3e");
                    break;
                }
                case 6: {
                    vo.setStatusName("\u5df2\u5b8c\u6210");
                    break;
                }
                default: {
                    vo.setStatusName("\u672a\u77e5\u72b6\u6001");
                }
            }
            vo.setUsedCount(String.valueOf((Integer)map.get("TOTAL_COUNT") - (Integer)map.get("REMAIN_COUNT")));
            vo.setNickName(map.get("NICK_NAME") == null ? null : map.get("NICK_NAME").toString());
            vos.add(vo);
        });
        return vos;
    }
}

