/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.common.enums.sales.ProductPicTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.mall.dao.sales.MallProductPicMapper;
import cc.lechun.mall.entity.sales.MallProductPicEntity;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import com.alibaba.fastjson.JSON;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallProductPicService
implements MallProductPicInterface {
    private static final Logger logger = LoggerFactory.getLogger(MallProductPicService.class);
    @Autowired
    private MallProductPicMapper productPicMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private OssService ossInterface;

    @Override
    @ReadThroughSingleCache(namespace="getProductPic", expiration=300)
    public List<MallProductPicEntity> getProductPics(@ParameterValueKeyProvider(order=0) String proId, @ParameterValueKeyProvider(order=1) Integer picType) {
        MallProductPicEntity params = new MallProductPicEntity();
        params.setProId(proId);
        params.setGroupType(picType);
        List<MallProductPicEntity> list = this.productPicMapper.getListBySort(params);
        list.forEach(entity -> entity.setFullRelativeUrl(this.ossInterface.getImageResoure(entity.getFullRelativeUrl())));
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="getImageList", expiration=600)
    public List<String> getProductPicUrl(@ParameterValueKeyProvider(order=0) String itemId, @ParameterValueKeyProvider(order=1) Integer picType) {
        String path = "proImgStorage/";
        MallProductPicEntity picEntity = new MallProductPicEntity();
        picEntity.setProId(itemId);
        picEntity.setGroupType(picType);
        List picEntities = this.productPicMapper.getList(picEntity);
        if (picEntities != null && picEntities.size() > 0) {
            String url = "";
            for (MallProductPicEntity p : picEntities) {
                url = p.getFullRelativeUrl();
                if (url != null && !url.isEmpty()) continue;
                p.setFullRelativeUrl(path + p.getPicAddr() + "_O." + p.getExpName());
            }
            return picEntities.stream().map(c -> this.ossInterface.getImageResoure(c.getFullRelativeUrl())).collect(Collectors.toList());
        }
        ArrayList<String> n = new ArrayList<String>();
        n.add("");
        return n;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallProductPicService.getPicList", expiration=600)
    public List<MallProductPicEntity> getPicList(@ParameterValueKeyProvider String itemId) {
        MallProductPicEntity picEntity = new MallProductPicEntity();
        picEntity.setProId(itemId);
        return this.productPicMapper.getList(picEntity);
    }

    @Override
    public List<MallProductPicEntity> getProductPics(String proId, int picType, int sort) {
        MallProductPicEntity params = new MallProductPicEntity();
        params.setProId(proId);
        params.setGroupType(picType);
        params.setSort(sort);
        List list = this.productPicMapper.getList(params);
        list.forEach(entity -> entity.setFullRelativeUrl(this.ossInterface.getImageResoure(entity.getFullRelativeUrl())));
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallProductPicService.getProductPics", expiration=600)
    public Map<String, List<String>> getProductPicUrlMap(@ParameterValueKeyProvider(order=0) String itemId, @ParameterValueKeyProvider(order=1) Integer saleType) {
        String path = "proImgStorage/";
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        List<MallProductPicEntity> picEntities = this.getPicList(itemId);
        List<ProductPicTypeEnum> picTypeEnums = ProductPicTypeEnum.getList(saleType);
        picTypeEnums.forEach(c -> {
            String url = "";
            if (picEntities != null && picEntities.size() > 0) {
                List tmpPics = picEntities.stream().filter(p -> p.getGroupType().intValue() == c.getValue()).collect(Collectors.toList());
                if (tmpPics != null && tmpPics.size() > 0) {
                    for (MallProductPicEntity p2 : tmpPics) {
                        url = p2.getFullRelativeUrl();
                        if (url != null && !url.isEmpty()) continue;
                        p2.setFullRelativeUrl(path + p2.getPicAddr() + "_O." + p2.getExpName());
                    }
                    map.put(c.getName(), tmpPics.stream().map(cc -> this.ossInterface.getImageResoure(cc.getFullRelativeUrl())).collect(Collectors.toList()));
                } else {
                    ArrayList<String> n = new ArrayList<String>();
                    n.add("");
                    map.put(c.getName(), n);
                }
            } else {
                ArrayList<String> n = new ArrayList<String>();
                n.add("");
                map.put(c.getName(), n);
            }
        });
        return map;
    }

    @Override
    public void save(MallProductPicEntity pic) {
        pic.setPicId(IDGenerate.getUniqueIdStr());
        pic.setCreateTime(DateUtils.now());
        String[] picNames = pic.getFullRelativeUrl().split("/");
        String picName = picNames[picNames.length - 1];
        if (StringUtils.isNotEmpty((CharSequence)picName) && picName.contains(".")) {
            String[] picAddrs = picName.split("\\.");
            pic.setPicAddr(picAddrs[0]);
            pic.setExpName(picAddrs[picAddrs.length - 1]);
        }
        this.productPicMapper.insert(pic);
        this.removeCache(pic.getProId(), pic.getPicType());
        this.removeCache(pic.getProId(), pic.getGroupType());
    }

    @Override
    public void saveBatch(String picListJson) {
        logger.info("*******\u6279\u91cf\u4e0a\u4f20\u56fe\u7247**saveBatch*********picList={}", (Object)picListJson);
        if (StringUtils.isNotEmpty((CharSequence)picListJson)) {
            String json = null;
            try {
                json = URLDecoder.decode(picListJson, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            List picList = JSON.parseArray((String)json, MallProductPicEntity.class);
            logger.info("*******\u6279\u91cf\u4e0a\u4f20\u56fe\u7247**saveBatch*JSON\u8f6cJavaBean\u540e\u503c********MallProductPicEntityList={}", (Object)JSON.toJSONString((Object)picList));
            if (picList != null && picList.size() > 0) {
                MallProductPicEntity params = new MallProductPicEntity();
                params.setProId(((MallProductPicEntity)picList.get(0)).getProId());
                params.setGroupType(((MallProductPicEntity)picList.get(0)).getPicType());
                List list = this.productPicMapper.getList(params);
                int i = 1;
                Optional<MallProductPicEntity> maxSort = list.stream().max(Comparator.comparing(MallProductPicEntity::getSort));
                if (maxSort.isPresent()) {
                    i = maxSort.get().getSort() + 1;
                }
                for (MallProductPicEntity mallProductPicEntity : picList) {
                    mallProductPicEntity.setSort(i);
                    ++i;
                    mallProductPicEntity.setGroupType(mallProductPicEntity.getPicType());
                    mallProductPicEntity.setPicType(mallProductPicEntity.getPicType() % 10);
                    mallProductPicEntity.setPicId(IDGenerate.getUniqueIdStr());
                    mallProductPicEntity.setCreateTime(DateUtils.now());
                    String[] picNames = mallProductPicEntity.getFullRelativeUrl().split("/");
                    String picName = picNames[picNames.length - 1];
                    if (StringUtils.isNotEmpty((CharSequence)picName) && picName.contains(".")) {
                        String[] picAddrs = picName.split("\\.");
                        mallProductPicEntity.setPicAddr(picAddrs[0]);
                        mallProductPicEntity.setExpName(picAddrs[picAddrs.length - 1]);
                    }
                    this.productPicMapper.insert(mallProductPicEntity);
                    this.removeCache(mallProductPicEntity.getProId(), mallProductPicEntity.getPicType());
                    this.removeCache(mallProductPicEntity.getProId(), mallProductPicEntity.getGroupType());
                }
            }
        }
    }

    @Override
    public void delete(String picId) {
        MallProductPicEntity picEntity = (MallProductPicEntity)this.productPicMapper.selectByPrimaryKey((Serializable)((Object)picId));
        if (picEntity != null) {
            this.productPicMapper.deleteProductPicModifySort(picEntity);
            this.removeCache(picEntity.getProId(), picEntity.getPicType());
            this.removeCache(picEntity.getProId(), picEntity.getGroupType());
        }
        this.productPicMapper.deleteByPrimaryKey((Serializable)((Object)picId));
    }

    private void removeCache(String itemId, int picType) {
        this.memcachedService.delete("getProductPic", new String[]{itemId, String.valueOf(picType)});
        this.memcachedService.delete("getImageList", new String[]{itemId, String.valueOf(picType)});
        this.memcachedService.delete("MallProductPicService.getPicList", itemId);
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_PROMOTION.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_GROUP.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_PRODUCT.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, String.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue())});
        this.memcachedService.delete("MallProductPicService.getProductPics", new String[]{itemId, "6"});
    }

    @Override
    public void modifyProductPicSort(String picId, int sort, Integer groupType, String proId) {
        MallProductPicEntity mallProductPicEntity = this.productPicMapper.getPicInfoByPicId(picId);
        if (mallProductPicEntity != null) {
            int oldSort = mallProductPicEntity.getSort();
            int i = oldSort - sort;
            if (i < 0) {
                this.productPicMapper.modifyOtherProductPicSortDown(proId, groupType, sort, oldSort);
            }
            if (i > 0) {
                this.productPicMapper.modifyOtherProductPicSortUp(proId, groupType, sort, oldSort);
            }
        }
        this.productPicMapper.modifyProductPicSort(picId, sort);
        this.removeCache(proId, groupType);
    }
}

