/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.iservice.collage.CollageInterface;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallOrderProductMapper;
import cc.lechun.mall.entity.sales.MallFreeVO;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderGroupAndProductVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderProductService
extends BaseService
implements MallOrderProductInterface {
    @Autowired
    private MallOrderProductMapper orderProductMapper;
    @Autowired
    @Lazy
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    @Lazy
    private CollageInterface collageInterface;

    @Override
    public BaseJsonVo buildOrderProductEntities(MallMainOrderVo mainOrderVo) {
        String message = "";
        ArrayList<MallOrderProductEntity> orderProductEntities = new ArrayList<MallOrderProductEntity>();
        ArrayList<MallOrderGroupProductEntity> orderGroupProductEntities = new ArrayList<MallOrderGroupProductEntity>();
        try {
            String inviteId = "";
            BigDecimal[] total = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
            BigDecimal[] savedNew = new BigDecimal[]{new BigDecimal(0)};
            BigDecimal[] savedMul = new BigDecimal[]{new BigDecimal(0)};
            if (mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.COLLAGE.getValue() && mainOrderVo.getMallOrderVos().get(0) != null && StringUtils.isNotEmpty((String)mainOrderVo.getMallOrderVos().get(0).getDefineField()) && StringUtils.isNotEmpty((String)(inviteId = JsonUtils.stringToMap((String)URLDecoder.decode(mainOrderVo.getMallOrderVos().get(0).getDefineField(), "utf-8")).get("inviteId").toString()))) {
                savedNew[0] = this.collageInterface.getNewUserCollageOrderReductionVo(inviteId);
                savedMul[0] = this.collageInterface.getDiscountCollageOrderReductionVo(inviteId);
                if (savedNew[0] == null) {
                    savedNew[0] = new BigDecimal(0);
                }
                if (savedMul[0] == null) {
                    savedMul[0] = new BigDecimal(0);
                }
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                MallOrderProductEntity orderProductEntity;
                if (orderVo.getProducts() != null && orderVo.getProducts().size() > 0) {
                    for (MallProductVO mallProductVO : orderVo.getProducts()) {
                        orderProductEntity = this.buildOrderProduct(mallProductVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        MallOrderGroupProductEntity entity3 = this.orderGroupProductInterface.buildOrderGroupProductEntity(mallProductVO, null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                        total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity3.getUnitPrice(), (Integer)entity3.getQuantity()));
                        orderGroupProductEntities.add(entity3);
                    }
                }
                if (orderVo.getGroups() != null && orderVo.getGroups().size() > 0) {
                    for (MallGroupVO mallGroupVO : orderVo.getGroups()) {
                        orderProductEntity = this.buildOrderProduct(mallGroupVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        for (MallProductVO pp : mallGroupVO.getProductList()) {
                            MallOrderGroupProductEntity entity2 = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, mallGroupVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                            total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity2.getUnitPrice(), (Integer)entity2.getQuantity()));
                            orderGroupProductEntities.add(entity2);
                        }
                    }
                }
                if (orderVo.getPromotions() != null && orderVo.getPromotions().size() > 0) {
                    for (MallPromotionVO mallPromotionVO : orderVo.getPromotions()) {
                        orderProductEntity = this.buildOrderProduct(mallPromotionVO, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        total[0] = PriceUtils.add((BigDecimal)total[0], (BigDecimal)orderProductEntity.getTotalPrice());
                        orderProductEntities.add(orderProductEntity);
                        if (mallPromotionVO.getGroup() != null) {
                            for (MallProductVO pp : mallPromotionVO.getGroup().getProductList()) {
                                mallPromotionVO.getGroup().setCount(mallPromotionVO.getCount());
                                MallOrderGroupProductEntity entity2 = this.orderGroupProductInterface.buildOrderGroupProductEntity(pp, mallPromotionVO.getGroup(), mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo());
                                total[1] = PriceUtils.add((BigDecimal)total[1], (BigDecimal)PriceUtils.multiply((BigDecimal)entity2.getUnitPrice(), (Integer)entity2.getQuantity()));
                                orderGroupProductEntities.add(entity2);
                            }
                        }
                        if (mallPromotionVO.getProduct() == null) continue;
                        orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(mallPromotionVO.getProduct(), null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                    }
                }
                if (orderVo.getFrees() == null || orderVo.getFrees().size() <= 0) continue;
                for (MallFreeVO mallFreeVO : orderVo.getFrees()) {
                    for (MallProductVO p : mallFreeVO.getProductList()) {
                        orderProductEntity = this.buildOrderProduct(p, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo());
                        orderProductEntities.add(orderProductEntity);
                        orderGroupProductEntities.add(this.orderGroupProductInterface.buildOrderGroupProductEntity(p, null, mainOrderVo.getMainOrderNo(), orderVo.getOrderNo(), orderProductEntity.getOrderProductNo()));
                    }
                }
            }
            if (savedNew[0].compareTo(BigDecimal.ZERO) != 0 || savedMul[0].compareTo(BigDecimal.ZERO) != 0) {
                orderProductEntities.forEach(entity -> {
                    entity.setCollageNewAmount(PriceUtils.multiply((BigDecimal)savedNew[0], (BigDecimal)PriceUtils.divide((BigDecimal)entity.getTotalPrice(), (BigDecimal)total[0])));
                    entity.setCollageMulAmount(PriceUtils.multiply((BigDecimal)savedMul[0], (BigDecimal)PriceUtils.divide((BigDecimal)entity.getTotalPrice(), (BigDecimal)total[0])));
                });
            }
            MallOrderGroupAndProductVo orderGroupAndProductVo = new MallOrderGroupAndProductVo();
            orderGroupAndProductVo.setOrderGroupProductEntities(orderGroupProductEntities);
            orderGroupAndProductVo.setOrderProductEntities(orderProductEntities);
            return BaseJsonVo.success((Object)orderGroupAndProductVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38";
            this.logger.error("\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38[\u521b\u5efa\u8ba2\u5355\u5546\u54c1\u5931\u8d25]", (Throwable)e);
            return BaseJsonVo.error((String)message);
        }
    }

    private MallOrderProductEntity buildOrderProduct(MallProductVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(p.getFullcutAmount());
        orderProductEntity.setGroupId("");
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_PRODUCT.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(new BigDecimal(p.getProPrice()));
        orderProductEntity.setQuantity(p.getCount());
        orderProductEntity.setProductId(p.getProId());
        orderProductEntity.setProductName(p.getProName());
        orderProductEntity.setPromotionProductId("");
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag((short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        return orderProductEntity;
    }

    private MallOrderProductEntity buildOrderProduct(MallGroupVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(new BigDecimal(0));
        orderProductEntity.setGroupId(p.getGroupId());
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_GROUP.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(p.getPrice());
        orderProductEntity.setQuantity(p.getCount());
        orderProductEntity.setProductId("");
        orderProductEntity.setProductName(p.getGroupName());
        orderProductEntity.setPromotionProductId("");
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag(p.getUseCoupon() == null ? (short)0 : (short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        return orderProductEntity;
    }

    private MallOrderProductEntity buildOrderProduct(MallPromotionVO p, String orderMainNo, String orderNo) {
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setActivityNo("");
        orderProductEntity.setChannelOrderproductNo("");
        orderProductEntity.setDeliverQuantity(0);
        orderProductEntity.setFullCutAmount(new BigDecimal(0));
        if (p.getGroup() != null) {
            orderProductEntity.setGroupId(p.getGroup().getGroupId());
        } else {
            orderProductEntity.setProductId(p.getProduct().getProId());
        }
        orderProductEntity.setGroupType(SalesTypeEnum.SALES_PROMOTION.getValue());
        orderProductEntity.setOrderMainNo(orderMainNo);
        orderProductEntity.setOrderNo(orderNo);
        orderProductEntity.setOrderProductNo(String.valueOf(IDGenerate.getUniqueID()));
        orderProductEntity.setOriginalPrice(p.getOriginPrice());
        orderProductEntity.setQuantity(p.getCount());
        if (orderProductEntity.getProductId() == null) {
            orderProductEntity.setProductId("");
        }
        orderProductEntity.setProductName(p.getPromotionName());
        orderProductEntity.setPromotionProductId(p.getPromotionProductId());
        orderProductEntity.setTicketAmount(p.getCouponAmount());
        orderProductEntity.setTicketFlag(p.getUseCoupon() == null ? (short)0 : (short)p.getUseCoupon().intValue());
        orderProductEntity.setTotalPrice(PriceUtils.multiply((BigDecimal)p.getFactPrice(), (Integer)p.getCount()));
        orderProductEntity.setUnitPrice(p.getFactPrice());
        if (StringUtils.isNotEmpty((String)p.getPromotionId())) {
            orderProductEntity.setPromotionId(p.getPromotionId());
        }
        return orderProductEntity;
    }

    @Override
    public boolean insertOrderProduct(MallOrderProductEntity orderProductEntity) {
        int i = this.orderProductMapper.insertSelective(orderProductEntity);
        return i == 1;
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductList(MallOrderProductEntity orderProductEntity) {
        return this.orderProductMapper.getList(orderProductEntity);
    }

    @Override
    public int getUserPromotionBuyCount(String promotionId, String customerId) {
        return this.orderProductMapper.getUserPromotionBuyCount(promotionId, customerId);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderNo(String orderNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderNo(orderNo);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderMianNo(String orderMainNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderMianNo(orderMainNo);
    }

    @Override
    @Transactional
    public void deleteByOrderNo(String orderNo) {
        this.orderProductMapper.deleteByOrderNo(orderNo);
        this.orderGroupProductInterface.deleteByOrderNo(orderNo);
    }

    @Override
    public List<MallOrderProductEntity> getOrderProductInfoByOrderMianNoPromotion(String orderMainNo) {
        return this.orderProductMapper.getOrderProductInfoByOrderMianNoPromotion(orderMainNo);
    }

    @Override
    public MallOrderProductEntity getOrderProductInfoByProduct(String orderNo, String productId) {
        return this.orderProductMapper.getOrderProductInfoByProduct(orderNo, productId);
    }

    @Override
    public MallOrderProductEntity selectByPrimaryKey(String orderProductNo) {
        return (MallOrderProductEntity)this.orderProductMapper.selectByPrimaryKey((Serializable)((Object)orderProductNo));
    }
}

