/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.cms.dto.GroupUserlDTO;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.constants.trade.OrderStatusClassConstants;
import cc.lechun.common.enums.common.EnvironmentEnum;
import cc.lechun.common.enums.pay.PaySubTypeEnum;
import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.ids.RandomUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.open.SmsUtil;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.trade.MallOrderSendMsgMapper;
import cc.lechun.mall.dao.trade.MallOrderUpdateHistoryMapper;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.deliver.DeliverDateVo;
import cc.lechun.mall.entity.deliver.DeliverVo;
import cc.lechun.mall.entity.deliver.MallAreaEntity;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.shoppingcart.MallShoppingcartVO;
import cc.lechun.mall.entity.trade.EdbOrderInfoVO;
import cc.lechun.mall.entity.trade.EdbOrderProductVO;
import cc.lechun.mall.entity.trade.EdbOrderVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheEntity;
import cc.lechun.mall.entity.trade.MallOrderCacheInItemVo;
import cc.lechun.mall.entity.trade.MallOrderCacheInVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderDetailVo;
import cc.lechun.mall.entity.trade.MallOrderEntitiesVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupAndProductVo;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderSendMsgEntity;
import cc.lechun.mall.entity.trade.MallOrderStatusLogEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.entity.trade.MallOrderUpdateHistoryEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.OrderCountVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.deliver.DeliverNewErpInterface;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.inventory.InventoryInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.MallOrderCacheInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageQueueInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderStatusLogInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallRefundPayDetailInterface;
import cc.lechun.mall.iservice.trade.MallSplitOrderInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.cil.EDBLib;
import cc.lechun.mall.service.trade.MallOrderSaleNewErpService;
import cc.lechun.mall.service.trade.MallOrderSendMsgService;
import cc.lechun.mall.service.trade.cache.MallOrderCacheService;
import cc.lechun.mall.service.trade.defineFieldHandle.DefineFiledHandleInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderService
extends MallOrderCacheService
implements MallOrderInterface {
    @Autowired
    private MallCityInterface cityInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallGroupInterface groupInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    @Autowired
    private MallFreeInterface freeInterface;
    @Autowired
    private MallRegularInterface regularInterface;
    @Autowired
    private MallShoppingcartInterface shoppingcartInterface;
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private DeliverNewErpInterface deliverInterface;
    @Autowired
    private MallSplitOrderInterface splitOrderInterface;
    @Autowired
    private MallOrderCacheInterface orderCacheInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallOrderProductInterface orderProductService;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductInterface;
    @Autowired
    private MallProductInterface mallProductInterface;
    @Autowired
    private MallOrderStatusLogInterface mallOrderStatusLogInterface;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallOrderPayInterface mallOrderPayInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private MallOrderSendMsgService mallOrderSendMsgService;
    @Autowired
    private MallOrderSendMsgMapper mallOrderSendMsgMapper;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallOrderSaleNewErpService mallOrderSaleNewErpService;
    @Autowired
    private InventoryInterface inventoryService;
    @Autowired
    private MallOrderUpdateHistoryMapper orderUpdateHistoryMapper;
    @Autowired
    private MallAreaInterface areaService;
    @Autowired
    private MallCityInterface cityService;
    @Autowired
    private DefineFiledHandleInterface defineFiledHandleInterface;
    @Autowired
    private MallOrderMessageQueueInterface messageQueueService;
    @Autowired
    private MallRefundPayDetailInterface mallRefundPayDetailInterface;
    @Value(value="${lechun.environment}")
    private String environment;

    @Override
    public List<GroupUserlDTO> getPickupOrderList(Integer smallerDay, Integer greaterDay) {
        ArrayList<GroupUserlDTO> result = new ArrayList<GroupUserlDTO>();
        List<Map<String, String>> list = this.mallOrderMapper.getPickupOrderList(greaterDay, smallerDay);
        if (list != null) {
            list.forEach(customerInfo -> {
                GroupUserlDTO groupUserlDTO = new GroupUserlDTO();
                groupUserlDTO.setCustomerId(((String)customerInfo.get("customerId")).toString());
                groupUserlDTO.setMobile(((String)customerInfo.get("mobile")).toString());
                groupUserlDTO.setOpenId(((String)customerInfo.get("openId")).toString());
                this.logger.info("\u67e5\u8be2\u7528\u6237:{}", (Object)groupUserlDTO.toString());
                result.add(groupUserlDTO);
            });
            HashSet<GroupUserlDTO> set = new HashSet<GroupUserlDTO>(result);
            result.clear();
            result.addAll(set);
        }
        return result;
    }

    @Override
    public boolean updateOrder(MallOrderEntity orderEntity) {
        int i = this.mallOrderMapper.updateByPrimaryKeySelective(orderEntity);
        return i == 1;
    }

    @Override
    public boolean insertOrder(MallOrderEntity orderEntity) {
        int i = this.mallOrderMapper.insertSelective(orderEntity);
        return i == 1;
    }

    @Override
    public boolean deleteOrder(String orderNo, String customerId) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setStatus(OrderStatusEnum.DELETE.getValue());
        orderEntity.setDeleteTime(DateUtils.now());
        orderEntity.setOrderNo(orderNo);
        return this.updateOrder(orderEntity);
    }

    @Override
    public boolean cancelOrder(String orderNo, String customerId) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setStatus(OrderStatusEnum.CANCEL.getValue());
        orderEntity.setOrderNo(orderNo);
        orderEntity.setCancelTime(DateUtils.now());
        return this.updateOrder(orderEntity);
    }

    @Override
    public boolean paySuccessOrder(String orderNo, String statusName) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        Integer status = OrderStatusEnum.getValue(statusName);
        orderEntity.setStatus(status);
        orderEntity.setOrderNo(orderNo);
        return this.updateOrder(orderEntity);
    }

    public boolean exportOrderSuccess(MallOrderMainEntity mainOrder, MallOrderEntity order) {
        Boolean b = this.updateOrderStatus(order.getOrderNo(), OrderStatusEnum.EXPORT.getName(), mainOrder.getCustomerId(), order.getStatus());
        if (b.booleanValue()) {
            List<MallOrderEntity> orderList = this.getOrderList(mainOrder.getOrderMainNo());
            boolean allExport = true;
            for (MallOrderEntity orderEntity : orderList) {
                if (orderEntity.getStatus().intValue() == OrderStatusEnum.EXPORT.getValue()) continue;
                allExport = false;
                break;
            }
            if (allExport) {
                return this.orderMainInterface.updateOrderMainStatus(mainOrder.getOrderMainNo(), OrderStatusEnum.EXPORT.getName(), mainOrder.getCustomerId(), mainOrder.getStatus());
            }
        }
        return b;
    }

    public boolean exportOrderSuccess(String orderMainNo, String orderNo) {
        return this.exportOrderSuccess(this.orderMainInterface.selectByPrimaryKey(orderMainNo), this.getmallOrder(orderNo));
    }

    @Override
    public boolean updateOrderStatus(String OrderNo, String orderStatus, String customerId, int oldStatus) {
        Integer status = OrderStatusEnum.getValue(orderStatus);
        if (status == null) {
            return false;
        }
        MallOrderEntity orderEntity = this.tradeCommonInterface.getUpdateStatusOrderEntity(OrderNo, status);
        return this.updateOrder(orderEntity);
    }

    @Override
    public BaseJsonVo buildOrderEntities(MallMainOrderVo mainOrderVo) {
        this.logger.info("++++++++++++++++++++++mainOrderVo+++++++++++++mainOrderVo={}", (Object)JSON.toJSONString((Object)mainOrderVo));
        String message = "";
        ArrayList<MallOrderEntity> orderEntities = new ArrayList<MallOrderEntity>();
        try {
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                MallOrderEntity orderEntity = new MallOrderEntity();
                orderEntity.setExportTime(null);
                orderEntity.setArrivedTime(null);
                orderEntity.setDelivedTime(null);
                orderEntity.setTotalAmount(orderVo.getTotalAmount());
                orderEntity.setCancelReason("");
                orderEntity.setCancelTime(null);
                orderEntity.setChannelOrderdedailNo("");
                orderEntity.setCompleteTime(null);
                MallCityEntity cityEntity = null;
                boolean noDeliver = this.tradeCommonInterface.isNoDeliverOrder(mainOrderVo);
                if (!noDeliver) {
                    this.logger.info("++++++++++++++++++++++orderVo.getDeliverVo()+++++++++++++orderVo.getDeliverVo()={}", (Object)JSON.toJSONString((Object)(orderVo.getDeliverVo() != null ? orderVo.getDeliverVo() : "")));
                    cityEntity = this.cityInterface.getCity(mainOrderVo.getAddressVo().getCityId());
                } else {
                    this.logger.info("\u975e\u5b9e\u7269\u4e0d\u914d\u9001\u8ba2\u5355");
                }
                orderEntity.setAddressType(noDeliver ? 0 : mainOrderVo.getAddressVo().getAddressType());
                orderEntity.setConsigneeAc(cityEntity == null ? "" : cityEntity.getAc());
                orderEntity.setConsigneeAddr(noDeliver ? "" : mainOrderVo.getAddressVo().getAddress());
                orderEntity.setConsigneeAreaid(noDeliver ? 0 : mainOrderVo.getAddressVo().getAreaId());
                orderEntity.setConsigneeAreaname(noDeliver ? "" : mainOrderVo.getAddressVo().getAreaName());
                orderEntity.setConsigneeCityname(noDeliver ? "" : mainOrderVo.getAddressVo().getCityName());
                orderEntity.setConsigneeHousenum("");
                orderEntity.setConsigneeName(noDeliver ? "" : mainOrderVo.getAddressVo().getConsigneeName());
                orderEntity.setConsigneePhone(noDeliver ? "" : mainOrderVo.getAddressVo().getConsigneePhone());
                orderEntity.setConsigneePostcode(noDeliver ? "" : mainOrderVo.getAddressVo().getPostcode());
                orderEntity.setConsigneeProvincename(noDeliver ? "" : mainOrderVo.getAddressVo().getProvinceName());
                orderEntity.setConsigneeTel(noDeliver ? "" : mainOrderVo.getAddressVo().getConsigneeTel());
                orderEntity.setAddrId(noDeliver ? "" : mainOrderVo.getAddressVo().getAddrId());
                orderEntity.setDcId(noDeliver ? "" : orderVo.getDeliverVo().getDcId());
                orderEntity.setDeliverDate(noDeliver ? null : DateUtils.getDateFromString((String)orderVo.getDeliverVo().getDeliverDate(), (String)"yyyy-MM-dd"));
                orderEntity.setDeliverId(noDeliver ? 0 : Integer.parseInt(orderVo.getDeliverVo().getDeliverId()));
                orderEntity.setDeliverName(noDeliver ? "" : orderVo.getDeliverVo().getDeliverName());
                orderEntity.setDeliverRequest("");
                orderEntity.setDeliverTime(noDeliver ? "" : "9:00-19:00");
                orderEntity.setFreight(noDeliver ? new BigDecimal(0) : orderVo.getFreight());
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
                orderEntity.setPickupTime(noDeliver ? null : DateUtils.getDateFromString((String)orderVo.getDeliverVo().getPickDate(), (String)"yyyy-MM-dd"));
                orderEntity.setDeleteTime(null);
                orderEntity.setDelivingTime(null);
                orderEntity.setExportCount(0);
                orderEntity.setExportTime(null);
                orderEntity.setIceBag(0);
                orderEntity.setOrderAmount(orderVo.getOrderAmount());
                orderEntity.setOrderNo(orderVo.getOrderNo());
                orderEntity.setOrderMainNo(mainOrderVo.getMainOrderNo());
                orderEntity.setPayAmount(orderVo.getPayAmount());
                orderEntity.setPickupCount(0);
                orderEntity.setPickUpNo(orderVo.getOrderNo());
                orderEntity.setPsTimes(orderVo.getDeliverSequence());
                orderEntity.setQuantity(orderVo.getQuantity());
                orderEntity.setRemark("");
                orderEntity.setSoldDeptId(1);
                orderEntity.setSoldTypeId(1);
                orderEntity.setSpec(6);
                orderEntity.setStatus(1);
                orderEntity.setTotalAmount(orderVo.getTotalAmount());
                orderEntity.setWaybillNo("");
                orderEntity.setCouponAmount(orderVo.getCouponAmount());
                orderEntity.setBalanceAmount(orderVo.getBalanceAmount());
                if (!noDeliver && "\u7f8e\u56e2\u914d\u9001".equals(orderVo.getDeliverVo().getDeliverName())) {
                    orderEntity.setSpeedUp("1");
                }
                if ("-1".equals(orderEntity.getSpeedUp())) {
                    orderEntity.setSpeedUp("0");
                }
                orderEntities.add(orderEntity);
            }
            return BaseJsonVo.success(orderEntities);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38";
            this.logger.error(message + e.toString());
            return BaseJsonVo.error((String)message);
        }
    }

    @Override
    public List<MallOrderEntity> findOrders(String orderMainNo) {
        MallOrderEntity searchParam = new MallOrderEntity();
        searchParam.setOrderMainNo(orderMainNo);
        return this.mallOrderMapper.getList(searchParam);
    }

    @Override
    public Integer getUserOrderCount(String customerId) {
        return this.mallOrderMapper.getUserOrderCount(customerId);
    }

    @Override
    public Integer getUserOrderCountPaid(String customerId) {
        return this.mallOrderMapper.getUserOrderCountPaid(customerId);
    }

    @Override
    public BaseJsonVo getOrderVoFromCache(int platFormId, String customerId, MallOrderCacheVo orderCacheVo) {
        MallOrderCacheInVo orderCacheInVo;
        block21: {
            String cacheId = orderCacheVo.getCacheId();
            MallOrderCacheEntity orderCacheEntity = this.orderCacheInterface.getOrderCacheEntity(cacheId);
            if (orderCacheEntity != null) {
                try {
                    orderCacheInVo = (MallOrderCacheInVo)JsonUtils.fromJson((String)orderCacheEntity.getCacheContent(), MallOrderCacheInVo.class);
                    orderCacheVo.setPayJumpType(orderCacheInVo.getPayJumpType());
                    orderCacheVo.setTransportType(orderCacheInVo.getTransportType());
                    if (orderCacheInVo == null) {
                        return BaseJsonVo.error((String)"\u7f13\u5b58\u4e0d\u5b58\u5728");
                    }
                    break block21;
                }
                catch (IOException e) {
                    return BaseJsonVo.error((String)"\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
                }
            }
            return BaseJsonVo.error((String)"\u7f13\u5b58\u4e0d\u5b58\u5728");
        }
        if (orderCacheInVo.getOrderSource() != orderCacheVo.getOrderSource()) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u6765\u6e90\u4e0d\u4e00\u81f4");
        }
        List<MallOrderCacheInItemVo> itemVoList = orderCacheInVo.getMallOrderCacheInItemVoList();
        if (itemVoList == null) {
            return BaseJsonVo.error((String)"\u7f13\u5b58\u6ca1\u6709\u5546\u54c1\u4fe1\u606f");
        }
        ArrayList<MallGroupVO> groupVOList = new ArrayList<MallGroupVO>();
        ArrayList<MallProductVO> productVOList = new ArrayList<MallProductVO>();
        ArrayList<MallPromotionVO> promotionVOList = new ArrayList<MallPromotionVO>();
        for (MallOrderCacheInItemVo inItemVo : itemVoList) {
            BaseJsonVo result;
            if (inItemVo.getItemType() == SalesTypeEnum.SALES_GROUP.getValue()) {
                result = this.groupInterface.buildGroupVO(inItemVo.getItemId(), inItemVo.getQuantity(), "", true);
                if (result.isSuccess()) {
                    MallGroupVO groupVO = (MallGroupVO)result.getValue();
                    if (groupVO.getValid().booleanValue()) {
                        groupVOList.add(groupVO);
                        continue;
                    }
                    return BaseJsonVo.error((String)("\u83b7\u53d6\u7ec4\u5408\u5f02\u5e38(GroupVo)" + groupVO.getInvalidReason()));
                }
                return BaseJsonVo.error((String)("\u83b7\u53d6\u7ec4\u5408\u5f02\u5e38(GroupVo)" + result.getError_msg()));
            }
            if (inItemVo.getItemType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                boolean longPeriod = orderCacheInVo.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue();
                result = this.productInterface.buildProductVO(inItemVo.getItemId(), inItemVo.getQuantity(), "", "", "", "", longPeriod, true, null, null);
                if (result.isSuccess()) {
                    MallProductVO productVO = (MallProductVO)result.getValue();
                    if (productVO.getValid().booleanValue()) {
                        productVOList.add(productVO);
                        continue;
                    }
                    return BaseJsonVo.error((String)("\u83b7\u53d6\u5546\u54c1\u5f02\u5e38(ProductVo)" + productVO.getInvalidReason()));
                }
                return BaseJsonVo.error((String)("\u83b7\u53d6\u5546\u54c1\u5f02\u5e38(ProductVo)" + result.getError_msg()));
            }
            if (inItemVo.getItemType() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                boolean longPeriod = orderCacheInVo.getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue();
                result = this.promotionInterface.buildPromotionVO(inItemVo.getItemId(), inItemVo.getQuantity(), true);
                if (result.isSuccess()) {
                    MallPromotionVO promotionVO = (MallPromotionVO)result.getValue();
                    if (promotionVO.getValid().booleanValue()) {
                        promotionVOList.add(promotionVO);
                        continue;
                    }
                    return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(PromotionVo)" + promotionVO.getInvalidReason()));
                }
                return BaseJsonVo.error((String)("\u83b7\u53d6\u4fc3\u9500\u5f02\u5e38(PromotionVo)" + result.getError_msg()));
            }
            return BaseJsonVo.error((String)"\u9500\u552e\u7c7b\u578b\u9519\u8bef(SalesType)");
        }
        if (orderCacheInVo.getDeliverType() != 1 && orderCacheInVo.getDeliverType() != 2 && orderCacheInVo.getDeliverType() != 3 && orderCacheInVo.getDeliverType() != 4 && orderCacheInVo.getDeliverType() != 5) {
            return BaseJsonVo.error((String)"\u914d\u9001\u7c7b\u578b\u9519\u8bef(deliverType)");
        }
        if (orderCacheInVo.getDeliverType() == 1) {
            orderCacheInVo.setDeliverPeriod(1);
            orderCacheInVo.setDeliverCount(1);
        } else {
            MallRegularEntity regularEntity = this.regularInterface.getRegular4GroupDType(this.platFormInterface.getPlatForm(platFormId).getPlatformGroupId(), orderCacheInVo.getDeliverType());
            if (regularEntity != null) {
                orderCacheInVo.setDeliverPeriod(7);
                orderCacheInVo.setDeliverCount(regularEntity.getRegularDeliverCount());
            }
        }
        List<MallOrderVo> mallOrderVos = this.getOrderVos(productVOList, groupVOList, promotionVOList, customerId, orderCacheInVo.getOrderSource(), platFormId, orderCacheInVo.getDeliverCount(), orderCacheInVo.getDeliverPeriod(), orderCacheInVo.getDeliverType(), orderCacheInVo.getBindCode(), orderCacheInVo.getDefineField(), orderCacheVo);
        if (mallOrderVos != null && mallOrderVos.size() > 0) {
            return BaseJsonVo.success(mallOrderVos);
        }
        return BaseJsonVo.error((String)"\u83b7\u53d6OrderVo\u5f02\u5e38");
    }

    @Override
    public List<MallOrderVo> ShoppingConvertOrder(List<MallShoppingcartVO> shoppingcartVOs) {
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        for (MallShoppingcartVO shoppingcartVO : shoppingcartVOs) {
            MallOrderVo orderVo = new MallOrderVo();
            try {
                Iterator<MallProductVO> itrProduct = shoppingcartVO.getProducts().iterator();
                while (itrProduct.hasNext()) {
                    if (itrProduct.next().getValid().booleanValue()) continue;
                    itrProduct.remove();
                }
                Iterator<MallGroupVO> itrGroup = shoppingcartVO.getGroups().iterator();
                while (itrGroup.hasNext()) {
                    if (itrGroup.next().getValid().booleanValue()) continue;
                    itrGroup.remove();
                }
                Iterator<MallPromotionVO> itrPromotion = shoppingcartVO.getPromotions().iterator();
                while (itrPromotion.hasNext()) {
                    if (itrPromotion.next().getValid().booleanValue()) continue;
                    itrPromotion.remove();
                }
                Iterator<MallProductVO> itrProductsPool = shoppingcartVO.getProductsPool().iterator();
                while (itrProductsPool.hasNext()) {
                    if (itrProductsPool.next().getValid().booleanValue()) continue;
                    itrProductsPool.remove();
                }
                if (!(shoppingcartVO.getProducts() != null && shoppingcartVO.getProducts().size() != 0 || shoppingcartVO.getGroups() != null && shoppingcartVO.getGroups().size() != 0 || shoppingcartVO.getPromotions() != null && shoppingcartVO.getPromotions().size() != 0)) continue;
                ObjectConvert.fatherConvertToChild((Object)shoppingcartVO, (Object)orderVo);
                orderVo.setQuantity(orderVo.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
                orderVos.add(orderVo);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return orderVos;
    }

    private List<MallOrderVo> getOrderVos(List<MallProductVO> productVOs, List<MallGroupVO> groupVOs, List<MallPromotionVO> promotionVOs, String customerId, int orderSource, int platFormId, int deliverCount, int deliverPeriod, int deliverType, String bindCode, String defineFiled, MallOrderCacheVo orderCacheVo) {
        ArrayList<MallOrderVo> orderVos = new ArrayList();
        MallOrderVo orderVo = new MallOrderVo();
        orderVo.setProducts(productVOs);
        orderVo.setGroups(groupVOs);
        orderVo.setPromotions(promotionVOs);
        orderVo.setCustomerId(customerId);
        orderVo.setOrderSource(orderSource);
        orderVo.setPlatFormId(platFormId);
        orderVo.setPlatFormGroupId(this.platFormInterface.getPlatFormGroupId(platFormId));
        orderVo.setDeliverCount(deliverCount);
        orderVo.setDeliverPeriod(deliverPeriod);
        orderVo.setDeliverType(deliverType);
        orderVo.setTransportType(this.productInterface.getTransportType(orderVo));
        orderVo.setBindCode(bindCode);
        orderVo.setDefineField(defineFiled);
        orderVo.setSelfMadeType(this.productInterface.getSelfMode(orderVo));
        if (deliverType != 1) {
            this.priceCalcInterface.totalOrderPrice(orderVo);
            this.shoppingcartInterface.collectProducts(orderVo);
            orderVo.setQuantity(orderVo.getProductsPool().stream().mapToInt(e -> e.getCount()).sum());
            if (orderCacheVo.getCacheType() == 2) {
                for (int i = 1; i <= deliverCount; ++i) {
                    if (i == 1) {
                        orderVo.setDeliverSequence(i);
                        orderVo.setDeliverCount(1);
                        orderVos.add(orderVo);
                        continue;
                    }
                    MallOrderVo tmpVo = new MallOrderVo();
                    BeanUtils.copyProperties((Object)orderVo, (Object)tmpVo);
                    tmpVo.setDeliverSequence(i);
                    tmpVo.setDeliverCount(1);
                    orderVos.add(tmpVo);
                }
            } else {
                orderVos.add(orderVo);
            }
        } else {
            orderVos = this.splitOrderInterface.splitOrder(orderVo);
        }
        return orderVos;
    }

    @Override
    public List<MallOrderEntity> getOrderList(String orderMainNo) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setOrderMainNo(orderMainNo);
        return this.mallOrderMapper.getList(orderEntity);
    }

    public List<MallOrderEntity> getOrderList(String orderMainNo, String orderNo) {
        MallOrderEntity orderEntity = new MallOrderEntity();
        orderEntity.setOrderMainNo(orderMainNo);
        if (orderNo != null && !orderNo.isEmpty()) {
            ArrayList<MallOrderEntity> orderEntities = new ArrayList<MallOrderEntity>();
            orderEntities.add((MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo)));
            return orderEntities;
        }
        return this.mallOrderMapper.getList(orderEntity);
    }

    @Override
    public void getOrderInfo(OrderListVo orderListVo) {
        String orderNo = orderListVo.getOrderNo();
        List<Object> orderEntities = new ArrayList();
        orderEntities = this.getOrderList(orderListVo.getOrderMainNo());
        if (orderEntities != null && orderEntities.size() > 0) {
            orderListVo.setOrderNo(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getOrderNo());
            orderListVo.setDeliverDate(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getDeliverDate());
            orderListVo.setPickUpDate(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPickupTime());
            orderListVo.setEvaluateStatus(orderEntities.stream().filter(order -> order.getEvaluateStatus() == 0).findAny().isPresent() ? 0 : 1);
            if (orderListVo.getOrderClass() == 1 && orderListVo.getEvaluateStatus() == 0 && orderListVo.getStatus() == OrderStatusEnum.COMPLETION.getValue()) {
                orderListVo.setCanEvaluateStatus(1);
            }
            orderListVo.setSubBalanceAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getBalanceAmount());
            orderListVo.setSubCouponAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getCouponAmount());
            orderListVo.setSubFreight(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getFreight());
            orderListVo.setSubOrderAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getOrderAmount());
            orderListVo.setSubPayAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPayAmount());
            orderListVo.setSubTotalAmount(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getTotalAmount());
            orderListVo.setPsTimes(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getPsTimes());
            orderListVo.setArrivedTime(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getArrivedTime());
            orderListVo.setWayBillNo(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getWaybillNo());
            orderListVo.setAddressType(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getAddressType());
            orderListVo.setConsigneeProvincename(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeProvincename());
            orderListVo.setConsigneeCityname(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeCityname());
            orderListVo.setConsigneeAreaname(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAreaname());
            orderListVo.setConsigneeAreaid(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAreaid());
            orderListVo.setConsigneeHousenum(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeHousenum());
            orderListVo.setConsigneeAddr(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeAddr());
            orderListVo.setConsigneeName(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneeName());
            orderListVo.setConsigneePhone(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getConsigneePhone());
            orderListVo.setDeliverName(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getDeliverName());
            orderListVo.setSpeedUp(Integer.valueOf(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getSpeedUp()));
            orderListVo.setStatus(((MallOrderEntity)orderEntities.get(orderEntities.size() - 1)).getStatus());
            boolean exists = false;
            ArrayList<MallOrderDetailVo> orderDetailVos = new ArrayList<MallOrderDetailVo>();
            for (MallOrderEntity mallOrderEntity : orderEntities) {
                if (orderEntities.size() > 1 && (mallOrderEntity.getDeliverDate() != null && mallOrderEntity.getDeliverDate().after(DateUtils.currentDate()) && !exists || mallOrderEntity.getOrderNo().equals(orderNo))) {
                    orderListVo.setOrderNo(mallOrderEntity.getOrderNo());
                    orderListVo.setDeliverDate(mallOrderEntity.getDeliverDate());
                    orderListVo.setPickUpDate(mallOrderEntity.getPickupTime());
                    orderListVo.setEvaluateStatus(mallOrderEntity.getEvaluateStatus());
                    if (orderListVo.getOrderClass() == 1 && orderListVo.getEvaluateStatus() == 0 && orderListVo.getStatus() == OrderStatusEnum.COMPLETION.getValue()) {
                        orderListVo.setCanEvaluateStatus(1);
                    }
                    orderListVo.setSubBalanceAmount(mallOrderEntity.getBalanceAmount());
                    orderListVo.setSubCouponAmount(mallOrderEntity.getCouponAmount());
                    orderListVo.setSubFreight(mallOrderEntity.getFreight());
                    orderListVo.setSubOrderAmount(mallOrderEntity.getOrderAmount());
                    orderListVo.setSubPayAmount(mallOrderEntity.getPayAmount());
                    orderListVo.setSubTotalAmount(mallOrderEntity.getTotalAmount());
                    orderListVo.setPsTimes(mallOrderEntity.getPsTimes());
                    orderListVo.setArrivedTime(mallOrderEntity.getArrivedTime());
                    orderListVo.setWayBillNo(mallOrderEntity.getWaybillNo());
                    orderListVo.setAddressType(mallOrderEntity.getAddressType());
                    orderListVo.setConsigneeProvincename(mallOrderEntity.getConsigneeProvincename());
                    orderListVo.setConsigneeCityname(mallOrderEntity.getConsigneeCityname());
                    orderListVo.setConsigneeAreaname(mallOrderEntity.getConsigneeAreaname());
                    orderListVo.setConsigneeAreaid(mallOrderEntity.getConsigneeAreaid());
                    orderListVo.setConsigneeHousenum(mallOrderEntity.getConsigneeHousenum());
                    orderListVo.setConsigneeAddr(mallOrderEntity.getConsigneeAddr());
                    orderListVo.setConsigneeName(mallOrderEntity.getConsigneeName());
                    orderListVo.setConsigneePhone(mallOrderEntity.getConsigneePhone());
                    orderListVo.setDeliverName(mallOrderEntity.getDeliverName());
                    orderListVo.setStatus(mallOrderEntity.getStatus());
                    exists = true;
                }
                MallOrderDetailVo orderDetailVo = new MallOrderDetailVo();
                orderDetailVo.setOrderMainNo(orderListVo.getOrderMainNo());
                orderDetailVo.setOrderNo(mallOrderEntity.getOrderNo());
                orderDetailVo.setPsTimes(mallOrderEntity.getPsTimes());
                int statusClass = this.getStatusClass(mallOrderEntity, (Integer)orderListVo.getOrderClass());
                orderDetailVo.setStatusClassName(OrderStatusClassConstants.getStatusClassName(statusClass));
                orderDetailVo.setStatusName(OrderStatusEnum.getName(mallOrderEntity.getStatus()));
                orderDetailVos.add(orderDetailVo);
            }
            orderListVo.setOrderDetailVos(orderDetailVos);
            orderListVo.setDeliverDateShow(DateUtils.formatDate((Date)orderListVo.getDeliverDate(), (String)"MM\u6708dd\u65e5"));
        }
    }

    @Override
    public MallOrderEntity getmallOrder(String orderNo) {
        return (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
    }

    @Override
    public MallOrderEntity getmallOrder(MallOrderEntity orderEntity) {
        return (MallOrderEntity)this.mallOrderMapper.getSingle(orderEntity);
    }

    @Override
    public BaseJsonVo updateOrderEvaluate(String orderNo) {
        MallOrderEntity mallOrderEntity = new MallOrderEntity();
        mallOrderEntity.setOrderNo(orderNo);
        mallOrderEntity.setEvaluateStatus(1);
        this.mallOrderMapper.updateByPrimaryKeySelective(mallOrderEntity);
        return BaseJsonVo.success((Object)"\u66f4\u65b0\u8bc4\u4ef7\u6210\u529f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseJsonVo editOrderAddress(String customerId, String orderNo, String addressId) {
        CustomerAddressEntity addressEntity = this.customerAddressInterface.getCustomerAddress(addressId);
        if (addressEntity == null) {
            return BaseJsonVo.error((String)"\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (!addressEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u7528\u6237\u5730\u5740\u9519\u8bef");
        }
        MallOrderEntity orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
        if (orderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!orderMainEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u9519\u8bef");
        }
        boolean b = this.orderMainInterface.iseditOrder(orderEntity.getOrderNo(), orderEntity.getDeliverDate(), orderEntity.getPickupTime(), orderMainEntity.getPlatformGroupId(), orderEntity.getStatus());
        if (!b) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u80fd\u4fee\u6539");
        }
        if (!orderEntity.getConsigneeCityname().equals(addressEntity.getCityName())) {
            return BaseJsonVo.error((String)"\u6682\u4e0d\u5141\u8bb8\u8de8\u5e02\u4fee\u6539");
        }
        String oldAddress = orderEntity.getConsigneeName() + "," + orderEntity.getConsigneePhone() + "," + orderEntity.getConsigneeAreaid() + "," + orderEntity.getConsigneeAddr() + "," + DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)"");
        String newAddress = addressEntity.getConsigneeName() + "," + addressEntity.getConsigneePhone() + "," + addressEntity.getAreaId() + "," + addressEntity.getAddress() + "," + DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)"");
        if (orderEntity.getConsigneeAreaid() != addressEntity.getAreaId() || orderEntity.getConsigneeAddr().equals(addressEntity.getAddress())) {
            MallOrderVo orderVo = new MallOrderVo();
            orderVo.setOrderSource(OrderSourceEnum.CART.getValue());
            orderVo.setPlatFormId(orderMainEntity.getPlatformId());
            orderVo.setDeliverCount(1);
            orderVo.setBindCode(orderMainEntity.getBindCode());
            ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
            List<MallOrderGroupProductEntity> orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
            orderGroupProductEntities.forEach(mallOrderGroupProductEntity -> {
                BaseJsonVo sr = this.mallProductInterface.buildProductVO(mallOrderGroupProductEntity.getProductId(), mallOrderGroupProductEntity.getQuantity(), null, null, null, null, false, false, null, null);
                if (sr.isSuccess()) {
                    MallProductVO productVO = (MallProductVO)sr.getValue();
                    productVOS.add(productVO);
                }
            });
            orderVo.setProducts(productVOS);
            CustomerAddressVo addressVo = new CustomerAddressVo();
            try {
                ObjectConvert.fatherConvertToChild((Object)addressEntity, (Object)addressVo);
                addressVo.setEnable(true);
                addressVo.setSpeedUp("0");
            }
            catch (Exception e) {
                this.logger.error("\u4fee\u6539\u8ba2\u5355\u5730\u5740\u9519\u8bef\uff1a" + orderNo, (Throwable)e);
                return BaseJsonVo.error((String)"\u5730\u5740\u9519\u8bef");
            }
            this.shoppingcartInterface.collectProducts(orderVo);
            DeliverVo deliverVo = this.deliverInterface.getDeliverByErp(orderVo, addressVo, DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)""), 0, 2);
            if (deliverVo == null || !StringUtils.isNotEmpty((String)deliverVo.getDeliverId()) || "0".equals(deliverVo.getDeliverId())) return BaseJsonVo.error((String)"\u4fee\u6539\u540e\u5730\u5740\u5e93\u5b58\u4e0d\u8db3");
            ArrayList<MallOrderEntity> entities = new ArrayList<MallOrderEntity>(1);
            entities.add(orderEntity);
            if (deliverVo.getDcId().equals(orderEntity.getDcId())) {
                BaseJsonVo baseJsonVo = this.inventoryService.unLockProductInventoryByErpThr(entities);
            } else {
                orderEntity.setDeliverId(Integer.valueOf(deliverVo.getDeliverId()));
                orderEntity.setDeliverName(deliverVo.getDeliverName());
                orderEntity.setDcId(deliverVo.getDcId());
            }
            orderEntity.setDeliverDate(DateUtils.StrToDate((String)deliverVo.getDeliverDate(), (String)""));
            orderEntity.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd"));
            MallOrderEntitiesVo orderEntitiesVo = new MallOrderEntitiesVo();
            orderEntitiesVo.setOrderEntities(entities);
            orderEntitiesVo.setOrderMainEntity(orderMainEntity);
            if (orderEntitiesVo.getOrderEntities() != null && orderEntitiesVo.getOrderEntities().size() > 0) {
                String messageByNomal;
                String messageByCold = this.mallOrderSaleNewErpService.checkOrderSaleCold(orderEntitiesVo, null);
                if (messageByCold != null) {
                    // empty if block
                }
                if ((messageByNomal = this.mallOrderSaleNewErpService.checkOrderSaleNomal(orderEntitiesVo, null)) != null) {
                    // empty if block
                }
            }
            orderEntity.setConsigneeName(addressEntity.getConsigneeName());
            orderEntity.setConsigneePhone(addressEntity.getConsigneePhone());
            orderEntity.setConsigneeAddr(addressEntity.getAddress());
            orderEntity.setConsigneeProvincename(addressEntity.getProvinceName());
            orderEntity.setConsigneeCityname(addressEntity.getCityName());
            orderEntity.setConsigneeAreaname(addressEntity.getAreaName());
            orderEntity.setConsigneeAreaid(addressEntity.getAreaId());
            orderEntity.setDeliverId(Integer.valueOf(deliverVo.getDeliverId()));
            orderEntity.setDeliverName(deliverVo.getDeliverName());
            orderEntity.setDeliverDate(DateUtils.StrToDate((String)deliverVo.getDeliverDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            orderEntity.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            orderEntity.setAddressType(addressEntity.getAddressType());
            this.mallOrderMapper.updateByPrimaryKeySelective(orderEntity);
        } else {
            orderEntity.setConsigneeName(addressEntity.getConsigneeName());
            orderEntity.setConsigneePhone(addressEntity.getConsigneePhone());
            orderEntity.setConsigneeAddr(addressEntity.getAddress());
            orderEntity.setConsigneeProvincename(addressEntity.getProvinceName());
            orderEntity.setConsigneeCityname(addressEntity.getCityName());
            orderEntity.setConsigneeAreaname(addressEntity.getAreaName());
            orderEntity.setConsigneeAreaid(addressEntity.getAreaId());
            this.mallOrderMapper.updateByPrimaryKeySelective(orderEntity);
        }
        MallOrderUpdateHistoryEntity historyEntity = new MallOrderUpdateHistoryEntity();
        historyEntity.setId(IDGenerate.getUniqueIdStr());
        historyEntity.setUserId(customerId);
        historyEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
        historyEntity.setOrderNo(orderNo);
        historyEntity.setCreateTime(DateUtils.now((String)""));
        historyEntity.setUpdateType(22);
        historyEntity.setOldValue(oldAddress);
        historyEntity.setNewValue(newAddress);
        historyEntity.setValueStr("\u5546\u57ce");
        this.orderUpdateHistoryMapper.insert(historyEntity);
        this.messageQueueService.sendOrderUpdateQueue(orderMainEntity.getOrderMainNo());
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public BaseJsonVo getOrderDefaultDeliverDate(String orderNo) {
        MallOrderEntity orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
        if (orderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        boolean b = this.orderMainInterface.iseditOrder(orderEntity.getOrderNo(), orderEntity.getDeliverDate(), orderEntity.getPickupTime(), orderMainEntity.getPlatformGroupId(), orderEntity.getStatus());
        if (!b) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u80fd\u4fee\u6539");
        }
        MallOrderVo orderVo = new MallOrderVo();
        orderVo.setOrderSource(OrderSourceEnum.CART.getValue());
        orderVo.setPlatFormId(orderMainEntity.getPlatformId());
        orderVo.setDeliverCount(1);
        orderVo.setBindCode(orderMainEntity.getBindCode());
        ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
        List<MallOrderGroupProductEntity> orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
        orderGroupProductEntities.forEach(mallOrderGroupProductEntity -> {
            BaseJsonVo sr = this.mallProductInterface.buildProductVO(mallOrderGroupProductEntity.getProductId(), mallOrderGroupProductEntity.getQuantity(), null, null, null, null, false, false, null, null);
            if (sr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)sr.getValue();
                productVOS.add(productVO);
            }
        });
        orderVo.setProducts(productVOS);
        CustomerAddressVo addressVo = new CustomerAddressVo();
        MallAreaEntity area = this.areaService.getArea(orderEntity.getConsigneeAreaid());
        this.logger.info(JsonUtils.toJson((Object)area, (boolean)true));
        MallCityEntity city = this.cityService.getCity(area.getCityId());
        this.logger.info(JsonUtils.toJson((Object)city, (boolean)true));
        addressVo.setAddrId("1");
        addressVo.setProvinceId(city.getProvinceId());
        addressVo.setProvinceName(orderEntity.getConsigneeProvincename());
        addressVo.setCityId(city.getCityId());
        addressVo.setCityName(orderEntity.getConsigneeCityname());
        addressVo.setAreaName(orderEntity.getConsigneeAreaname());
        addressVo.setAreaId(orderEntity.getConsigneeAreaid());
        addressVo.setAddress(orderEntity.getConsigneeAddr());
        addressVo.setEnable(true);
        addressVo.setSpeedUp("0");
        this.shoppingcartInterface.collectProducts(orderVo);
        DeliverVo deliverVo = this.deliverInterface.getDeliverByErp(orderVo, addressVo, null, 0, 1);
        deliverVo.setDeliverDate(DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)"yyyy-MM-dd"));
        List<DeliverDateVo> deliverDateVos = deliverVo.getDeliverDateVos();
        deliverDateVos.forEach(vo -> {
            if ("\u660e\u65e5".equals(vo.getDeliverDateShow())) {
                vo.setDeliverDateShow(DateUtils.formatDateChina((String)vo.getDeliverDate(), (String)"") + "(\u660e\u65e5)");
            } else if ("\u540e\u65e5".equals(vo.getDeliverDateShow())) {
                vo.setDeliverDateShow(DateUtils.formatDateChina((String)vo.getDeliverDate(), (String)"") + "(\u540e\u65e5)");
            } else {
                vo.setDeliverDateShow(vo.getDeliverDateShow() + "(" + vo.getWeek() + ")");
            }
        });
        DeliverDateVo lastDeliverDateVo = deliverDateVos.get(deliverDateVos.size() - 1);
        if (lastDeliverDateVo != null) {
            for (int i = 1; i <= 7; ++i) {
                DeliverDateVo vo2 = new DeliverDateVo();
                vo2.setInventory(1);
                vo2.setDeliverDate(DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)lastDeliverDateVo.getDeliverDate()), (int)i), (String)"yyyy-MM-dd"));
                vo2.setDeliverDateShow(DateUtils.formatDateChina((String)DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)lastDeliverDateVo.getDeliverDate()), (int)i), (String)"yyyy-MM-dd"), (String)""));
                vo2.setSpeedUp(0);
                vo2.setSort(7 + i);
                vo2.setWeek(DateUtils.getShortWeekOfDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)lastDeliverDateVo.getDeliverDate()), (int)i)));
                vo2.setDeliverDateShow(vo2.getDeliverDateShow() + "(" + vo2.getWeek() + ")");
                deliverDateVos.add(vo2);
            }
        }
        Integer undelivercount = this.mallOrderMapper.getCurOrderAfterUndeliverOrder(orderEntity.getOrderMainNo(), orderEntity.getOrderNo(), DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)""));
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("deliver", deliverVo);
        map.put("undelivercount", Integer.valueOf(undelivercount + 1));
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo editOrderDeliverDate(String customerId, String orderNo, Date deliverDate) {
        if (deliverDate == null) {
            return BaseJsonVo.error((String)"\u65f6\u95f4\u4e0d\u5b58\u5728");
        }
        MallOrderEntity orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo));
        if (orderEntity == null) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderEntity.getOrderMainNo());
        if (orderMainEntity == null) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!orderMainEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u9519\u8bef");
        }
        if (orderEntity.getDeliverDate().compareTo(deliverDate) == 0) {
            return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        boolean b = this.orderMainInterface.iseditOrder(orderEntity.getOrderNo(), orderEntity.getDeliverDate(), orderEntity.getPickupTime(), orderMainEntity.getPlatformGroupId(), orderEntity.getStatus());
        if (!b) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u80fd\u4fee\u6539");
        }
        MallOrderVo orderVo = new MallOrderVo();
        orderVo.setOrderSource(OrderSourceEnum.CART.getValue());
        orderVo.setPlatFormId(orderMainEntity.getPlatformId());
        orderVo.setDeliverCount(1);
        orderVo.setBindCode(orderMainEntity.getBindCode());
        ArrayList<MallProductVO> productVOS = new ArrayList<MallProductVO>();
        List<MallOrderGroupProductEntity> orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
        orderGroupProductEntities.forEach(mallOrderGroupProductEntity -> {
            BaseJsonVo sr = this.mallProductInterface.buildProductVO(mallOrderGroupProductEntity.getProductId(), mallOrderGroupProductEntity.getQuantity(), null, null, null, null, false, false, null, null);
            if (sr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)sr.getValue();
                productVOS.add(productVO);
            }
        });
        orderVo.setProducts(productVOS);
        CustomerAddressVo addressVo = new CustomerAddressVo();
        MallAreaEntity area = this.areaService.getArea(orderEntity.getConsigneeAreaid());
        MallCityEntity city = this.cityService.getCity(area.getCityId());
        addressVo.setAddrId("1");
        addressVo.setProvinceId(city.getProvinceId());
        addressVo.setProvinceName(orderEntity.getConsigneeProvincename());
        addressVo.setCityId(city.getCityId());
        addressVo.setCityName(orderEntity.getConsigneeCityname());
        addressVo.setAreaName(orderEntity.getConsigneeAreaname());
        addressVo.setAreaId(orderEntity.getConsigneeAreaid());
        addressVo.setAddress(orderEntity.getConsigneeAddr());
        addressVo.setEnable(true);
        addressVo.setSpeedUp("0");
        String oldDeliverDate = DateUtils.formatDate((Date)orderEntity.getDeliverDate(), (String)"");
        this.shoppingcartInterface.collectProducts(orderVo);
        DeliverVo deliverVo = this.deliverInterface.getDeliverByErp(orderVo, addressVo, DateUtils.formatDate((Date)deliverDate, (String)""), 0, 2);
        if (deliverVo != null && StringUtils.isNotEmpty((String)deliverVo.getDeliverId()) && !"0".equals(deliverVo.getDeliverId())) {
            ArrayList<MallOrderEntity> entities = new ArrayList<MallOrderEntity>(1);
            entities.add(orderEntity);
            if (deliverVo.getDcId().equals(orderEntity.getDcId())) {
                BaseJsonVo baseJsonVo = this.inventoryService.unLockProductInventoryByErpThr(entities);
            } else {
                orderEntity.setDeliverId(Integer.valueOf(deliverVo.getDeliverId()));
                orderEntity.setDeliverName(deliverVo.getDeliverName());
                orderEntity.setDcId(deliverVo.getDcId());
            }
            orderEntity.setDeliverDate(DateUtils.StrToDate((String)deliverVo.getDeliverDate(), (String)""));
            orderEntity.setPickupTime(DateUtils.StrToDate((String)deliverVo.getPickDate(), (String)"yyyy-MM-dd"));
            MallOrderEntitiesVo orderEntitiesVo = new MallOrderEntitiesVo();
            orderEntitiesVo.setOrderEntities(entities);
            orderEntitiesVo.setOrderMainEntity(orderMainEntity);
            if (orderEntitiesVo.getOrderEntities() != null && orderEntitiesVo.getOrderEntities().size() > 0) {
                String messageByNomal;
                String messageByCold = this.mallOrderSaleNewErpService.checkOrderSaleCold(orderEntitiesVo, null);
                if (messageByCold != null) {
                    // empty if block
                }
                if ((messageByNomal = this.mallOrderSaleNewErpService.checkOrderSaleNomal(orderEntitiesVo, null)) != null) {
                    // empty if block
                }
            }
        } else {
            return BaseJsonVo.error((String)"\u4fee\u6539\u540e\u65e5\u671f\u5e93\u5b58\u4e0d\u8db3");
        }
        orderEntity.setDeliverId(Integer.valueOf(deliverVo.getDeliverId()));
        orderEntity.setDeliverName(deliverVo.getDeliverName());
        orderEntity.setDeliverDate(DateUtils.StrToDate((String)deliverVo.getDeliverDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        orderEntity.setPickupTime(DateUtils.StrToDate((String)(deliverVo.getPickDate() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        this.mallOrderMapper.updateByPrimaryKeySelective(orderEntity);
        MallOrderUpdateHistoryEntity historyEntity = new MallOrderUpdateHistoryEntity();
        historyEntity.setId(IDGenerate.getUniqueIdStr());
        historyEntity.setUserId(customerId);
        historyEntity.setOrderMainNo(orderMainEntity.getOrderMainNo());
        historyEntity.setOrderNo(orderNo);
        historyEntity.setCreateTime(DateUtils.now((String)""));
        historyEntity.setUpdateType(21);
        historyEntity.setOldValue(oldDeliverDate);
        historyEntity.setNewValue(DateUtils.formatDate((Date)deliverDate, (String)""));
        historyEntity.setValueStr("\u5546\u57ce");
        this.orderUpdateHistoryMapper.insert(historyEntity);
        this.messageQueueService.sendOrderUpdateQueue(orderMainEntity.getOrderMainNo());
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public BaseJsonVo getOrderEditProducts(String orderNo) {
        List<MallOrderGroupProductEntity> orderProducts = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
        if (orderProducts == null || orderProducts.size() == 0) {
            return BaseJsonVo.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        BaseJsonVo regularResult = this.regularInterface.getRegularProductList(1000, 1);
        List productList = null;
        if (!regularResult.isSuccess()) {
            return BaseJsonVo.error((String)"\u6682\u65e0\u53ef\u66ff\u6362\u5546\u54c1");
        }
        productList = (List)regularResult.getValue();
        ArrayList list = new ArrayList();
        productList.forEach(product -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("PRO_ID", product.getProId());
            map.put("PRO_NAME", product.getProName());
            map.put("PRO_PRICE", product.getProPrice());
            map.put("PRO_TYPE_ID", product.getProTypeId());
            Optional<MallOrderGroupProductEntity> resultQuantity = orderProducts.stream().filter(orderProduct -> orderProduct.getProductId().equals(product.getProId())).findAny();
            if (resultQuantity.isPresent()) {
                map.put("QUANTITY", resultQuantity.get().getQuantity());
            } else {
                map.put("QUANTITY", 0);
            }
            Optional<MallOrderGroupProductEntity> resultPrice = orderProducts.stream().filter(orderProduct -> orderProduct.getOriginPrice().compareTo(new BigDecimal(product.getProPrice())) == 0).findAny();
            if (resultPrice.isPresent()) {
                map.put("isedit", 1);
                map.put("LIMIT_BUY_COUNT", product.getLimitBuyCount());
                list.add(map);
            } else {
                map.put("isedit", 0);
            }
        });
        orderProducts.forEach(orderProduct -> {
            Optional<Map> pros = list.stream().filter(map -> map.get("PRO_ID").equals(orderProduct.getProductId())).findAny();
            if (!pros.isPresent()) {
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("PRO_ID", orderProduct.getProductId());
                map2.put("PRO_NAME", orderProduct.getProductName());
                map2.put("PRO_PRICE", orderProduct.getOriginPrice());
                map2.put("PRO_TYPE_ID", this.productInterface.getProduct(orderProduct.getProductId()).getProTypeId());
                map2.put("QUANTITY", orderProduct.getQuantity());
                map2.put("isedit", 0);
                list.add(map2);
            }
        });
        return BaseJsonVo.success(list);
    }

    @Override
    public BaseJsonVo editOrderProducts(String orderNo, List<Map<String, String>> productList) {
        MallOrderEntity order = this.getmallOrder(orderNo);
        MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        Boolean isEdit = this.orderMainInterface.iseditOrder(orderNo, order.getDeliverDate(), order.getPickupTime(), orderMain.getPlatformGroupId(), order.getStatus());
        if (!isEdit.booleanValue()) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u8ba2\u5355\u4e0d\u53ef\u4fee\u6539");
        }
        BaseJsonVo regularResult = this.regularInterface.getRegularProductList(orderMain.getPlatformGroupId(), 1);
        if (!regularResult.isSuccess()) {
            return BaseJsonVo.error((String)"\u6682\u65e0\u53ef\u66ff\u6362\u5546\u54c1");
        }
        List regularProductList = (List)regularResult.getValue();
        Boolean[] hasNotExist = new Boolean[]{false};
        productList.forEach(map -> {
            Optional<MallProductVO> result = regularProductList.stream().filter(orderProduct -> orderProduct.getProId().equals(map.get("proId"))).findAny();
            if (!result.isPresent()) {
                hasNotExist[0] = true;
            }
        });
        if (hasNotExist[0].booleanValue()) {
            return BaseJsonVo.error((String)"\u4fee\u6539\u540e\u7684\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        List<MallOrderGroupProductEntity> orderProducts = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
        Double oldTotal = orderProducts.stream().mapToDouble(orderProduct -> orderProduct.getOriginPrice().multiply(new BigDecimal(orderProduct.getQuantity())).doubleValue()).sum();
        BigDecimal[] newTotal = new BigDecimal[]{new BigDecimal(0)};
        productList.forEach(product -> {
            newTotal[0] = newTotal[0].add(new BigDecimal(this.productInterface.getProduct((String)product.get("proId")).getProPrice()).multiply(new BigDecimal((String)product.get("count"))));
        });
        if (newTotal[0].doubleValue() <= 0.0 || newTotal[0].compareTo(PriceUtils.format((Double)oldTotal)) == 0) {
            return BaseJsonVo.error((String)("\u4fee\u6539\u540e\u7684\u5546\u54c1\u91d1\u989d" + newTotal[0] + "\u9700\u7b49\u4e8e\u539f\u6765\u5546\u54c1\u91d1\u989d" + PriceUtils.format((Double)oldTotal)));
        }
        Integer oldTotalCount = orderProducts.stream().mapToInt(orderProduct -> orderProduct.getQuantity()).sum();
        Integer[] newTotalCount = new Integer[]{0};
        productList.forEach(product -> {
            newTotalCount[0] = newTotalCount[0] + Integer.valueOf((String)product.get("count"));
        });
        this.logger.info("\u5b50\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u65b0[" + orderNo + "]\uff1a" + newTotalCount[0]);
        this.logger.info("\u5b50\u8ba2\u5355\u5546\u54c1\u6570\u91cf\u65e7[" + orderNo + "]\uff1a\uff1a" + oldTotalCount);
        if (newTotalCount[0].compareTo(oldTotalCount) != 0) {
            order.setQuantity(newTotalCount[0]);
            this.mallOrderMapper.updateByPrimaryKey(order);
            orderMain.setQuantity(orderMain.getQuantity() + (newTotalCount[0] - oldTotalCount));
            this.logger.info("\u5b50\u8ba2\u5355\u5546\u54c1\u6570\u91cf[" + orderNo + "]\uff1aupdate\uff1a" + order.getQuantity());
            this.logger.info("\u4e3b\u8ba2\u5355\u5546\u54c1\u6570\u91cf[" + orderNo + "]\uff1aupdate\uff1a" + orderMain.getQuantity());
            this.orderMainInterface.updateOrderMain(orderMain);
        }
        MallOrderVo orderVo = new MallOrderVo();
        orderVo.setOrderSource(OrderSourceEnum.CART.getValue());
        orderVo.setPlatFormId(orderMain.getPlatformId());
        orderVo.setDeliverCount(1);
        orderVo.setBindCode(orderMain.getBindCode());
        orderVo.setOrderNo(orderNo);
        ArrayList oldProductVOS = new ArrayList();
        List<MallOrderGroupProductEntity> orderGroupProductEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(orderNo);
        orderGroupProductEntities.forEach(mallOrderGroupProductEntity -> {
            BaseJsonVo sr = this.mallProductInterface.buildProductVO(mallOrderGroupProductEntity.getProductId(), mallOrderGroupProductEntity.getQuantity(), null, null, null, null, false, false, null, null);
            if (sr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)sr.getValue();
                oldProductVOS.add(productVO);
            }
        });
        ArrayList<MallProductVO> newProductVOS = new ArrayList<MallProductVO>();
        productList.forEach(map -> {
            BaseJsonVo sr = this.mallProductInterface.buildProductVO((String)map.get("proId"), Integer.valueOf((String)map.get("count")), null, null, null, null, false, false, null, null);
            if (sr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)sr.getValue();
                MallPriceVO priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.LONGPERIOD_BUY, SalesTypeEnum.SALES_PRODUCT, productVO.getProId(), orderMain.getCustomerId(), orderMain.getDeliverCount());
                if (priceVO != null && priceVO.getOriginPrice() != null) {
                    productVO.setProPrice(String.valueOf(priceVO.getOriginPrice()));
                }
                if (priceVO != null && priceVO.getFactPrice() != null) {
                    productVO.setFactPrice(priceVO.getFactPrice());
                }
                newProductVOS.add(productVO);
            }
        });
        orderVo.setProducts(newProductVOS);
        CustomerAddressVo addressVo = new CustomerAddressVo();
        MallAreaEntity area = this.areaService.getArea(order.getConsigneeAreaid());
        MallCityEntity city = this.cityService.getCity(area.getCityId());
        addressVo.setAddrId("1");
        addressVo.setProvinceId(city.getProvinceId());
        addressVo.setProvinceName(order.getConsigneeProvincename());
        addressVo.setCityId(city.getCityId());
        addressVo.setCityName(order.getConsigneeCityname());
        addressVo.setAreaName(order.getConsigneeAreaname());
        addressVo.setAreaId(order.getConsigneeAreaid());
        addressVo.setAddress(order.getConsigneeAddr());
        addressVo.setEnable(true);
        addressVo.setSpeedUp("0");
        this.shoppingcartInterface.collectProducts(orderVo);
        DeliverVo deliverVo = this.deliverInterface.getDeliverByErp(orderVo, addressVo, null, 0, 1);
        if (deliverVo == null || StringUtils.isEmpty((String)deliverVo.getDeliverId()) || "0".equals(deliverVo.getDeliverId())) {
            return BaseJsonVo.error((String)"\u5e93\u5b58\u4e0d\u8db3");
        }
        List<DeliverDateVo> deliverDateVos = deliverVo.getDeliverDateVos();
        Boolean[] inventory = new Boolean[]{false};
        String deliverDate = DateUtils.formatDate((Date)order.getDeliverDate(), (String)"yyyy-MM-dd");
        if (DateUtils.getDateFromString((String)deliverDateVos.get(deliverDateVos.size() - 1).getDeliverDate(), (String)"yyyy-MM-dd").compareTo(order.getDeliverDate()) < 0) {
            inventory[0] = true;
        }
        deliverDateVos.forEach(vo -> {
            this.logger.info("\u5faa\u73af\u5224\u65ad\u6709\u6ca1\u6709\u914d\u9001\u65e5\u671f\uff0c\u5f53\u524d\u5faa\u73af[" + vo.getInventory() + "][" + vo.getDeliverDate() + "]\uff0c\u8ba2\u5355\u914d\u9001\u65e5\u671f[" + deliverDate + "]");
            if (vo.getDeliverDate().equals(deliverDate) && vo.getInventory() == 1) {
                inventory[0] = true;
            }
        });
        if (!inventory[0].booleanValue()) {
            return BaseJsonVo.error((String)"\u5e93\u5b58\u4e0d\u8db3");
        }
        ArrayList<MallOrderEntity> entities = new ArrayList<MallOrderEntity>(1);
        BaseJsonVo baseJsonVo = this.inventoryService.unLockProductInventoryByErpThr(entities);
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        MallOrderCacheVo cacheVo = new MallOrderCacheVo();
        cacheVo.setOrderSource(OrderSourceEnum.LONGPERIOD_BUY.getValue());
        MallMainOrderVo mainOrderVo = new MallMainOrderVo();
        mainOrderVo.setOrderCacheVo(cacheVo);
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        orderVos.add(orderVo);
        mainOrderVo.setMallOrderVos(orderVos);
        mainOrderVo.setMainOrderNo(orderMain.getOrderMainNo());
        this.orderProductService.deleteByOrderNo(orderNo);
        BaseJsonVo productsResult = this.orderProductService.buildOrderProductEntities(mainOrderVo);
        if (!productsResult.isSuccess()) {
            return productsResult;
        }
        MallOrderGroupAndProductVo orderGroupAndProductVo = (MallOrderGroupAndProductVo)productsResult.getValue();
        orderGroupAndProductVo.getOrderProductEntities().forEach(orderProductEntity -> this.orderProductService.insertOrderProduct((MallOrderProductEntity)orderProductEntity));
        orderGroupAndProductVo.getOrderGroupProductEntities().forEach(orderGroupProductEntity -> this.orderGroupProductInterface.insertOrderGroupProduct((MallOrderGroupProductEntity)orderGroupProductEntity));
        MallOrderEntitiesVo orderEntitiesVo = new MallOrderEntitiesVo();
        orderEntitiesVo.setOrderEntities(entities);
        orderEntitiesVo.setOrderMainEntity(orderMain);
        if (orderEntitiesVo.getOrderEntities() != null && orderEntitiesVo.getOrderEntities().size() > 0) {
            String messageByNomal;
            String messageByCold = this.mallOrderSaleNewErpService.checkOrderSaleCold(orderEntitiesVo, null);
            if (messageByCold != null) {
                this.logger.error("[" + orderNo + "]\u4fee\u6539\u8ba2\u5355\u5546\u54c1\uff0c\u6263\u51cf\u5e93\u5b58\u5931\u8d25");
            }
            if ((messageByNomal = this.mallOrderSaleNewErpService.checkOrderSaleNomal(orderEntitiesVo, null)) != null) {
                this.logger.error("[" + orderNo + "]\u4fee\u6539\u8ba2\u5355\u5546\u54c1\uff0c\u6263\u51cf\u5e93\u5b58\u5931\u8d25");
            }
        }
        MallOrderUpdateHistoryEntity historyEntity = new MallOrderUpdateHistoryEntity();
        historyEntity.setId(IDGenerate.getUniqueIdStr());
        historyEntity.setUserId(orderMain.getCustomerId());
        historyEntity.setOrderMainNo(orderMain.getOrderMainNo());
        historyEntity.setOrderNo(orderNo);
        historyEntity.setCreateTime(DateUtils.now((String)""));
        historyEntity.setUpdateType(24);
        StringBuilder sb = new StringBuilder();
        for (MallProductVO mallProductVO : oldProductVOS) {
            sb.append(mallProductVO.getProId()).append(":").append(mallProductVO.getCount()).append(";");
        }
        historyEntity.setOldValue(sb.toString());
        sb = new StringBuilder();
        for (Map map2 : productList) {
            sb.append(map2.get("proId")).append(":").append(map2.get("count")).append(";");
        }
        historyEntity.setNewValue(sb.toString());
        historyEntity.setValueStr("\u5546\u57ce");
        this.orderUpdateHistoryMapper.insert(historyEntity);
        this.messageQueueService.sendOrderUpdateQueue(orderMain.getOrderMainNo());
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public Map<String, Long> getCustomerOrderCount(String customerId) {
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerId);
        if (customerEntity == null) {
            return null;
        }
        List<OrderCountVo> orderCountVos = this.mallOrderMapper.getCustomerOrderCount(customerId, customerEntity.getPlatformGroupId());
        if (orderCountVos == null) {
            orderCountVos = new ArrayList<OrderCountVo>();
        }
        for (OrderCountVo o : orderCountVos) {
            o.setStatusClass(this.getStatusClass(o.getStatus(), o.getEvaluateStatus(), o.getOrderClass()));
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        Map<String, List<OrderCountVo>> mapCount = orderCountVos.stream().collect(Collectors.groupingBy(c -> c.getOrderMainNo()));
        map.put("status0", Long.valueOf(mapCount.size()));
        mapCount = orderCountVos.stream().filter(c -> c.getStatusClass() == 1 && c.getMainOrderStatus() == 1).collect(Collectors.groupingBy(c -> c.getOrderMainNo()));
        map.put("status1", Long.valueOf(mapCount.size()));
        List vos = orderCountVos.stream().filter(c -> c.getStatusClass() == 2).collect(Collectors.toList());
        map.put("status2", Long.valueOf(vos.size()));
        map.put("status3", orderCountVos.stream().filter(c -> c.getStatusClass() == 3).count());
        map.put("status4", orderCountVos.stream().filter(c -> c.getStatusClass() == 4 && c.getOrderClass() == 1 && c.getEvaluateStatus() == 0).count());
        map.put("status5", orderCountVos.stream().filter(c -> c.getStatusClass() == 5).count());
        return map;
    }

    @Override
    public int getStatusClass(String orderNo) {
        MallOrderEntity order = this.getmallOrder(orderNo);
        MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        return this.getStatusClass(order, orderMain.getOrderClass());
    }

    @Override
    public int getStatusClass(String orderNo, Integer orderClass) {
        MallOrderEntity order = this.getmallOrder(orderNo);
        return this.getStatusClass(order, orderClass);
    }

    @Override
    public int getStatusClass(MallOrderEntity order) {
        MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(order.getOrderMainNo());
        return this.getStatusClass(order, orderMain.getOrderClass());
    }

    @Override
    public int getStatusClass(MallOrderEntity order, Integer orderClass) {
        return this.getStatusClass(order.getStatus(), order.getEvaluateStatus(), orderClass);
    }

    @Override
    public int getStatusClass(Integer orderStatus, Integer evaluateStatus, Integer orderClass) {
        int statusClass = OrderStatusClassConstants.getStatusClassByStatus(orderStatus);
        if (statusClass == 4 && orderClass == 1 && evaluateStatus == 1) {
            statusClass = 7;
        }
        return statusClass;
    }

    @Override
    @Transactional
    public BaseJsonVo updateOrderStatusByEdb(String orderNo, String orderStatus, String deliverDate, String waybillNo, String deliverId, String deliverName) {
        if (StringUtils.isNotEmpty((String)orderNo) || StringUtils.isNotEmpty((String)orderStatus)) {
            List<MallOrderEntity> mallOrderEntityList = this.mallOrderMapper.getOrderMainInfoByOrderNo(orderNo);
            if (mallOrderEntityList != null && mallOrderEntityList.size() > 0) {
                MallOrderEntity mallOrderEntity = mallOrderEntityList.get(0);
                if (orderStatus != null && mallOrderEntity.getStatus().compareTo(Integer.valueOf(orderStatus)) >= 0) {
                    return BaseJsonVo.success((Object)"");
                }
                Date pickupTime = DateUtils.now();
                if (OrderStatusEnum.DELIVING.getValue() == Integer.valueOf(orderStatus).intValue()) {
                    this.mallOrderMapper.updateOrderStatusCheckByEdb(orderNo, orderStatus);
                } else if (OrderStatusEnum.DELIVERED.getValue() == Integer.valueOf(orderStatus).intValue()) {
                    if (deliverDate != null && StringUtils.isNotEmpty((String)deliverDate)) {
                        pickupTime = DateUtils.getDateFromString((String)deliverDate);
                    }
                    this.mallOrderMapper.updateOrderStatusByEdb(orderNo, orderStatus, pickupTime, waybillNo, deliverId, deliverName);
                }
                MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(mallOrderEntity.getOrderMainNo());
                if ("10".equals(orderStatus) && mallOrderEntity.getPsTimes() < orderMain.getDeliverCount()) {
                    this.logger.info("\u591a\u5b50\u5355\u66f4\u65b0\u4e3b\u8ba2\u5355[" + orderMain.getOrderMainNo() + "]\u72b6\u6001 : " + orderMain.getStatus() + " -> " + orderStatus);
                    this.orderMainInterface.updateOrderStatusByEdb(mallOrderEntity.getOrderMainNo(), String.valueOf(OrderStatusEnum.PART_DELIVERED.getValue()));
                } else {
                    this.logger.info("\u66f4\u65b0\u4e3b\u8ba2\u5355[" + orderMain.getOrderMainNo() + "]\u72b6\u6001 : " + orderMain.getStatus() + " -> " + orderStatus);
                    this.orderMainInterface.updateOrderStatusByEdb(mallOrderEntity.getOrderMainNo(), orderStatus);
                }
                MallOrderStatusLogEntity mallOrderStatusLogEntity = new MallOrderStatusLogEntity();
                mallOrderStatusLogEntity.setOrderMainNo(mallOrderEntity.getOrderMainNo());
                mallOrderStatusLogEntity.setOrderNo(orderNo);
                mallOrderStatusLogEntity.setMethodName("MallOrderService.updateOrderStatusByEdb");
                StringBuffer sb = new StringBuffer();
                sb.append("waybillNo:" + waybillNo).append(",");
                sb.append("deliverName:" + deliverName);
                mallOrderStatusLogEntity.setMethodParam(sb.toString());
                mallOrderStatusLogEntity.setOldStatus(mallOrderEntity.getStatus());
                mallOrderStatusLogEntity.setNewStatus(Integer.valueOf(orderStatus));
                mallOrderStatusLogEntity.setCreateTime(new Date());
                this.mallOrderStatusLogInterface.insertOrderStatusLog(mallOrderStatusLogEntity);
                if ("10".equals(orderStatus)) {
                    MallOrderSendMsgEntity mallOrderSendMsgEntity = new MallOrderSendMsgEntity();
                    mallOrderSendMsgEntity.setOrderMainNo(mallOrderEntity.getOrderMainNo());
                    mallOrderSendMsgEntity.setOrderNo(orderNo);
                    List<MallOrderSendMsgEntity> mallOrderSendMsgEntityList = this.mallOrderSendMsgMapper.getMsgInfoList(mallOrderSendMsgEntity);
                    if (mallOrderSendMsgEntityList == null || mallOrderSendMsgEntityList.size() == 0) {
                        mallOrderSendMsgEntity.setIsSendMsg(0);
                        mallOrderSendMsgEntity.setPlatformId(orderMain.getPlatformId());
                        mallOrderSendMsgEntity.setCreateTime(pickupTime);
                        this.mallOrderSendMsgService.insertOrderSendMsgInfo(mallOrderSendMsgEntity);
                    }
                }
                this.defineFiledHandleInterface.TakeGoodAfter(orderMain.getOrderMainNo());
                return BaseJsonVo.success((Object)200);
            }
            this.logger.info("****error****\u8c03\u7528\u65b9\u6cd5updateOrderStatusByEdb\u53c2\u6570\u9519\u8bef**t_mall_order \u8868\u4e2d\u65e0\u6570\u636e*****\u53c2\u6570\uff1aorderNo={},orderStatus={}", (Object)orderNo, (Object)orderStatus);
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.logger.info("****error****\u8c03\u7528\u65b9\u6cd5updateOrderStatusByEdb\u53c2\u6570\u9519\u8bef*******\u53c2\u6570\uff1aorderNo={},orderStatus={}", (Object)orderNo, (Object)orderStatus);
        return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public BaseJsonVo edbOrderSync(String orderMainNo) {
        block30: {
            this.logger.info("\u5f00\u59cb\u540c\u6b65");
            try {
                this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u5f00\u59cb\u3011[" + orderMainNo + "]");
                MallOrderMainEntity orderMain = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
                List<MallOrderEntity> orderEntities = this.getOrderList(orderMainNo);
                if (orderMain.getOrderSource().intValue() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() || orderMain.getOrderClass().intValue() != OrderClassEnum.MALL_ORDER.getValue()) {
                    this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u4e0d\u540c\u6b65\u3011[" + orderMainNo + "]\u975e\u5b9e\u7269\u8ba2\u5355\u4e0d\u9700\u8981\u540c\u6b65\u5230EDB");
                    return BaseJsonVo.success((Object)"\u4e0d\u9700\u8981\u540c\u6b65\u5230EDB");
                }
                if (orderMain.getOrderSource().intValue() == OrderSourceEnum.TEAM_BUY.getValue() && orderMain.getStatus().intValue() != OrderStatusEnum.PAYCONFIRM.getValue()) {
                    this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u4e0d\u540c\u6b65\u3011[" + orderMainNo + "]\u672a\u6210\u56e2\u8ba2\u5355\u4e0d\u80fd\u540c\u6b65\u5230EDB");
                    return BaseJsonVo.success((Object)"\u4e0d\u9700\u8981\u540c\u6b65\u5230EDB");
                }
                List<MallOrderPayEntity> payEntities = this.mallOrderPayInterface.getList(orderMainNo);
                HashMap<String, Object> payMap = new HashMap<String, Object>();
                payMap.put("wechatAmount", new BigDecimal(0));
                payMap.put("thirdTradeNo", "");
                payMap.put("alipayAmount", new BigDecimal(0));
                payMap.put("couponAmount", new BigDecimal(0));
                payMap.put("cashticketNo", "");
                payMap.put("unionpayAmount", new BigDecimal(0));
                payMap.put("giftChangeAmount", new BigDecimal(0));
                payMap.put("cashAmount", new BigDecimal(0));
                payMap.put("balanceAmount", new BigDecimal(0));
                payMap.put("balanceChargeAmount", new BigDecimal(0));
                payMap.put("balanceFreeAmount", new BigDecimal(0));
                payMap.put("balanceGiftAmount", new BigDecimal(0));
                for (MallOrderPayEntity pay : payEntities) {
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.WECHAT_PAY.getValue()) {
                        payMap.put("wechatAmount", pay.getPayamount());
                        payMap.put("thirdTradeNo", pay.getThirdTradeNo());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.ALIPAY_PAY.getValue()) {
                        payMap.put("alipayAmount", pay.getPayamount());
                        payMap.put("thirdTradeNo", pay.getThirdTradeNo());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.COUPON_PAY.getValue()) {
                        payMap.put("couponAmount", ((BigDecimal)payMap.get("couponAmount")).add(pay.getPayamount()));
                        payMap.put("cashticketNo", pay.getCashticketNo());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.BANK_PAY.getValue()) {
                        payMap.put("unionpayAmount", pay.getPayamount());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.GIFT_PAY.getValue()) {
                        payMap.put("giftChangeAmount", pay.getPayamount());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.OFFLINE_PAY.getValue()) {
                        payMap.put("cashAmount", pay.getPayamount());
                        continue;
                    }
                    if (pay.getPaytypeId().intValue() == PayTypeEnum.MILKBANK_PAY.getValue() || pay.getPaytypeId().intValue() != PayTypeEnum.BALANCE_PAY.getValue()) continue;
                    if (pay.getPaySubtypeId() == 0) {
                        payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                        continue;
                    }
                    if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_CHARGE_PAY.getValue()) {
                        payMap.put("balanceChargeAmount", pay.getPayamount());
                        payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                        continue;
                    }
                    if (pay.getPaySubtypeId().intValue() == PaySubTypeEnum.BALANCE_SUB_GIVE_PAY.getValue()) {
                        payMap.put("balanceFreeAmount", pay.getPayamount());
                        payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                        continue;
                    }
                    if (pay.getPaySubtypeId().intValue() != PaySubTypeEnum.BALANCE_SUB_GIFTCARD_PAY.getValue() && pay.getPaySubtypeId().intValue() != PaySubTypeEnum.BALANCE_SUB_CARDPLAN_PAY.getValue()) continue;
                    payMap.put("balanceGiftAmount", pay.getPayamount());
                    payMap.put("balanceAmount", PriceUtils.add((BigDecimal)pay.getPayamount(), (BigDecimal)((BigDecimal)payMap.get("balanceAmount"))));
                }
                HashMap<String, BigDecimal> orderPayMap = new HashMap<String, BigDecimal>();
                orderPayMap.put("wechatAmount", new BigDecimal(0));
                orderPayMap.put("alipayAmount", new BigDecimal(0));
                orderPayMap.put("couponAmount", new BigDecimal(0));
                orderPayMap.put("balanceAmount", new BigDecimal(0));
                orderPayMap.put("balanceChargeAmount", new BigDecimal(0));
                orderPayMap.put("balanceFreeAmount", new BigDecimal(0));
                orderPayMap.put("balanceGiftAmount", new BigDecimal(0));
                orderPayMap.put("unionpayAmount", new BigDecimal(0));
                orderPayMap.put("giftChangeAmount", new BigDecimal(0));
                orderPayMap.put("cashAmount", new BigDecimal(0));
                ArrayList<EdbOrderVO> orderVOS = new ArrayList<EdbOrderVO>();
                for (MallOrderEntity order : orderEntities) {
                    String kwAndEdbStoreId;
                    String[] kwAndEdbStoreIdArray;
                    List<MallOrderGroupProductEntity> productEntities = this.orderGroupProductInterface.getOrderGroupProductListByOrderNo(order.getOrderNo());
                    if (productEntities == null || productEntities.size() == 0 || order.getStatus() != 3 || order.getPickupTime().before(DateUtils.getDateFromString((String)"2019-03-10 00:00:00"))) continue;
                    if ("1".equals(order.getSpeedUp())) {
                        this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u4e0d\u540c\u6b65\u3011[" + orderMainNo + "][" + order.getOrderNo() + "]\u524d\u7f6e\u4ed3\u8ba2\u5355\uff1a\u4e0d\u9700\u8981\u540c\u6b65\u5230EDB");
                        continue;
                    }
                    EdbOrderInfoVO edbOrderInfo = new EdbOrderInfoVO();
                    edbOrderInfo.setOrderMainNo(orderMainNo);
                    edbOrderInfo.setOrderNo(order.getOrderNo());
                    edbOrderInfo.setConsigneeName(order.getConsigneeName());
                    edbOrderInfo.setConsigneePhone(order.getConsigneePhone());
                    edbOrderInfo.setConsigneeProvinceName(order.getConsigneeProvincename());
                    edbOrderInfo.setConsigneeCityName(order.getConsigneeCityname());
                    edbOrderInfo.setConsigneeAreaName(order.getConsigneeAreaname());
                    edbOrderInfo.setConsigneeAddr(order.getConsigneeProvincename() + order.getConsigneeCityname() + order.getConsigneeAreaname() + order.getConsigneeAddr());
                    edbOrderInfo.setConsigneePostcode(order.getConsigneePostcode());
                    edbOrderInfo.setPickupDate(DateUtils.formatDate((Date)order.getPickupTime(), (String)""));
                    edbOrderInfo.setStatus("\u5df2\u4ed8\u6b3e");
                    edbOrderInfo.setCreateTime(DateUtils.formatDate((Date)(DateUtils.getDateDiff((Date)orderMain.getCreateTime(), (Date)DateUtils.now()) > 180L ? DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-180) : orderMain.getCreateTime()), (String)""));
                    edbOrderInfo.setPayTime(DateUtils.formatDate((Date)(DateUtils.getDateDiff((Date)orderMain.getPayTime(), (Date)DateUtils.now()) > 180L ? DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)-180) : orderMain.getPayTime()), (String)""));
                    edbOrderInfo.setTotalAmount(PriceUtils.parse((BigDecimal)order.getTotalAmount()));
                    edbOrderInfo.setOrderAmount(PriceUtils.parse((BigDecimal)order.getOrderAmount()));
                    edbOrderInfo.setPayAmount(PriceUtils.parse((BigDecimal)order.getPayAmount()));
                    edbOrderInfo.setFreight(PriceUtils.parse((BigDecimal)order.getFreight()));
                    edbOrderInfo.setChannelId(orderMain.getPlatformId() == 1 ? "2" : "6");
                    edbOrderInfo.setCustomerId(orderMain.getCustomerId());
                    edbOrderInfo.setInvoiceFlag(String.valueOf(orderMain.getInvoiceFlag()));
                    edbOrderInfo.setInvoiceTitle(orderMain.getInvoiceTitle());
                    edbOrderInfo.setInvoiceContent(orderMain.getInvoiceContent());
                    edbOrderInfo.setInvoiceType(String.valueOf(orderMain.getInvoiceType()));
                    edbOrderInfo.setBuyFlag(String.valueOf(orderMain.getBuyFlag()));
                    edbOrderInfo.setDeliverCount(orderMain.getDeliverCount());
                    edbOrderInfo.setPsTime(order.getPsTimes());
                    edbOrderInfo.setOrderClass(orderMain.getOrderClass());
                    if (order != null && StringUtils.isNotEmpty((String)order.getDcId()) && (kwAndEdbStoreIdArray = (kwAndEdbStoreId = order.getDcId()).split("\\|")) != null && kwAndEdbStoreIdArray.length > 1) {
                        edbOrderInfo.setDcId(Integer.valueOf(kwAndEdbStoreIdArray[1]));
                    }
                    edbOrderInfo.setDeliverName(order.getDeliverName());
                    edbOrderInfo.setKefuRemark("KD[" + order.getDeliverName() + "] " + order.getRemark());
                    edbOrderInfo.setThirdTradeNo((String)payMap.get("thirdTradeNo"));
                    edbOrderInfo.setWechatAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("wechatAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setAlipayAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("alipayAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setCouponAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("couponAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setBalanceAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setBalanceChargeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceChargeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setBalanceFreeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceFreeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setBalanceGiftAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("balanceGiftAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setUnionpayAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("unionpayAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setGiftChangeAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("giftChangeAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setCashAmount(PriceUtils.parse((BigDecimal)((BigDecimal)payMap.get("cashAmount")).multiply(order.getOrderAmount()).divide(orderMain.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                    edbOrderInfo.setCashticketNo((String)payMap.get("cashticketNo"));
                    order.setPayAmount(order.getPayAmount().add(PriceUtils.format((String)edbOrderInfo.getBalanceAmount())));
                    HashMap<String, BigDecimal> productPayMap = new HashMap<String, BigDecimal>();
                    productPayMap.put("orderAmount", new BigDecimal(0));
                    productPayMap.put("freightAmount", new BigDecimal(0));
                    productPayMap.put("wechatAmount", new BigDecimal(0));
                    productPayMap.put("alipayAmount", new BigDecimal(0));
                    productPayMap.put("balanceAmount", new BigDecimal(0));
                    productPayMap.put("balanceChargeAmount", new BigDecimal(0));
                    productPayMap.put("balanceFreeAmount", new BigDecimal(0));
                    productPayMap.put("balanceGiftAmount", new BigDecimal(0));
                    productPayMap.put("unionpayAmount", new BigDecimal(0));
                    productPayMap.put("giftChangeAmount", new BigDecimal(0));
                    productPayMap.put("cashAmount", new BigDecimal(0));
                    productPayMap.put("couponAmount", new BigDecimal(0));
                    ArrayList<EdbOrderProductVO> productVOS = new ArrayList<EdbOrderProductVO>();
                    HashMap<String, String> remark = new HashMap<String, String>();
                    for (MallOrderGroupProductEntity product : productEntities) {
                        EdbOrderProductVO edbProduct = new EdbOrderProductVO();
                        edbProduct.setOrderMainId(orderMainNo);
                        edbProduct.setOrderId(order.getOrderNo());
                        if (StringUtils.isNotEmpty((String)product.getGroupId()) && !"0".equals(product.getGroupId())) {
                            edbProduct.setGroupId(product.getGroupId());
                            edbProduct.setGroupName(this.groupInterface.getGroup(product.getGroupId()).getGroupName());
                        }
                        MallProductEntity pro = this.mallProductInterface.getProduct(product.getProductId());
                        edbProduct.setBarCode(pro.getBarCode());
                        edbProduct.setProductName(product.getProductName());
                        edbProduct.setQuantity(product.getQuantity());
                        if ("201912022103431786777600".equals(order.getOrderMainNo())) {
                            this.logger.info("order.getPayAmount()" + order.getPayAmount().toString());
                            this.logger.info("order.getPayAmount().subtract(order.getFreight())" + order.getPayAmount().subtract(order.getFreight()).toString());
                            this.logger.info("product.getUnitPrice()" + product.getUnitPrice());
                            this.logger.info("new BigDecimal(product.getQuantity())" + new BigDecimal(product.getQuantity()));
                            this.logger.info("product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))" + product.getUnitPrice().multiply(new BigDecimal(product.getQuantity())));
                        }
                        edbProduct.setFreightPerAmount(order.getFreight().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)order.getFreight().multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        MallOrderProductEntity orderProductEntity = this.orderProductService.selectByPrimaryKey(product.getOrderProductNo());
                        BigDecimal fullCutAmount = new BigDecimal("0");
                        BigDecimal ticketAmount = new BigDecimal("0");
                        BigDecimal collageMulAmount = new BigDecimal("0");
                        BigDecimal collageNewAmount = new BigDecimal("0");
                        if (orderProductEntity != null) {
                            fullCutAmount = orderProductEntity.getFullCutAmount();
                            collageMulAmount = orderProductEntity.getCollageMulAmount();
                            collageNewAmount = orderProductEntity.getCollageNewAmount();
                            if (orderProductEntity.getTicketAmount() != null) {
                                ticketAmount = orderProductEntity.getTicketAmount();
                            }
                        }
                        this.logger.info("\u770b\u4e3b\u952e:" + product.getOrderProductNo());
                        this.logger.info("\u770b\u5168\u90e8:" + JsonUtils.toJson((Object)orderProductEntity, (boolean)false));
                        this.logger.info("orderProductEntity.getUnitPrice():" + orderProductEntity.getUnitPrice());
                        this.logger.info("orderProductEntity.getQuantity():" + orderProductEntity.getQuantity());
                        this.logger.info("fullCutAmount:" + fullCutAmount);
                        this.logger.info("ticketAmount:" + ticketAmount);
                        this.logger.info("product.getQuantity():" + product.getQuantity());
                        this.logger.info("collageMulAmount:" + collageMulAmount);
                        this.logger.info("collageNewAmount:" + collageNewAmount);
                        this.logger.info("edbProduct.getFreightPerAmount():" + edbProduct.getFreightPerAmount());
                        this.logger.info("out:" + PriceUtils.parse((BigDecimal)orderProductEntity.getUnitPrice().multiply(new BigDecimal(orderProductEntity.getQuantity())).subtract(fullCutAmount).subtract(ticketAmount.multiply(new BigDecimal(orderProductEntity.getQuantity()))).subtract(collageMulAmount).subtract(collageNewAmount)));
                        edbProduct.setTotalPrice(PriceUtils.parse((BigDecimal)orderProductEntity.getUnitPrice().multiply(new BigDecimal(orderProductEntity.getQuantity())).subtract(fullCutAmount).add(new BigDecimal(edbProduct.getFreightPerAmount()))));
                        edbProduct.setTotalAmount(PriceUtils.parse((BigDecimal)orderProductEntity.getUnitPrice().multiply(new BigDecimal(orderProductEntity.getQuantity())).subtract(fullCutAmount).subtract(ticketAmount.multiply(new BigDecimal(orderProductEntity.getQuantity()))).subtract(collageMulAmount).subtract(collageNewAmount)));
                        edbProduct.setUnitPrice(PriceUtils.parse((BigDecimal)new BigDecimal(edbProduct.getTotalPrice()).divide(new BigDecimal(orderProductEntity.getQuantity()), 10, RoundingMode.HALF_EVEN)));
                        edbProduct.setOrderPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)order.getOrderAmount().multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("orderAmount", ((BigDecimal)productPayMap.get("orderAmount")).add(new BigDecimal(edbProduct.getOrderPerAmount())));
                        productPayMap.put("freightAmount", ((BigDecimal)productPayMap.get("freightAmount")).add(new BigDecimal(edbProduct.getFreightPerAmount())));
                        edbProduct.setWechatPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getWechatAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("wechatAmount", ((BigDecimal)productPayMap.get("wechatAmount")).add(new BigDecimal(edbProduct.getWechatPerAmount())));
                        edbProduct.setAlipayPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getAlipayAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("alipayAmount", ((BigDecimal)productPayMap.get("alipayAmount")).add(new BigDecimal(edbProduct.getAlipayPerAmount())));
                        edbProduct.setCouponPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getCouponAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("couponAmount", ((BigDecimal)productPayMap.get("couponAmount")).add(new BigDecimal(edbProduct.getCouponPerAmount())));
                        edbProduct.setBalancePerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getBalanceAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("balanceAmount", ((BigDecimal)productPayMap.get("balanceAmount")).add(new BigDecimal(edbProduct.getBalancePerAmount())));
                        edbProduct.setBalanceChargePerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getBalanceChargeAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("balanceChargeAmount", ((BigDecimal)productPayMap.get("balanceChargeAmount")).add(new BigDecimal(edbProduct.getBalanceChargePerAmount())));
                        edbProduct.setBalanceFreePerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getBalanceFreeAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("balanceFreeAmount", ((BigDecimal)productPayMap.get("balanceFreeAmount")).add(new BigDecimal(edbProduct.getBalanceFreePerAmount())));
                        edbProduct.setBalanceGiftPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getBalanceGiftAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("balanceGiftAmount", ((BigDecimal)productPayMap.get("balanceGiftAmount")).add(new BigDecimal(edbProduct.getBalanceGiftPerAmount())));
                        edbProduct.setUnionpayPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getUnionpayAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("unionpayAmount", ((BigDecimal)productPayMap.get("unionpayAmount")).add(new BigDecimal(edbProduct.getUnionpayPerAmount())));
                        edbProduct.setGiftChangePerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getGiftChangeAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("giftChangeAmount", ((BigDecimal)productPayMap.get("giftChangeAmount")).add(new BigDecimal(edbProduct.getGiftChangePerAmount())));
                        edbProduct.setCashPerAmount(order.getOrderAmount().compareTo(BigDecimal.ZERO) == 0 ? "0.00" : PriceUtils.parse((BigDecimal)new BigDecimal(edbOrderInfo.getCashAmount()).multiply(product.getUnitPrice().multiply(new BigDecimal(product.getQuantity()))).divide(order.getOrderAmount(), 10, RoundingMode.HALF_EVEN)));
                        productPayMap.put("cashAmount", ((BigDecimal)productPayMap.get("cashAmount")).add(new BigDecimal(edbProduct.getCashPerAmount())));
                        if (StringUtils.isNotEmpty((String)edbProduct.getGroupName())) {
                            remark.put(edbProduct.getGroupName(), (StringUtils.isEmpty((String)((String)remark.get(edbProduct.getGroupName()))) ? "" : (String)remark.get(edbProduct.getGroupName())) + pro.getProNameSx() + "X" + edbProduct.getQuantity() + ";");
                        }
                        productVOS.add(edbProduct);
                    }
                    if (orderMain.getOrderSource().intValue() == OrderSourceEnum.CARDPLAN.getValue()) {
                        edbOrderInfo.setRemark("\u5361\u5151\u6362\u5b9e\u7269");
                    }
                    EdbOrderVO edbOrderVO = new EdbOrderVO();
                    edbOrderVO.setOrderInfo(edbOrderInfo);
                    edbOrderVO.setProduct_item(productVOS);
                    orderVOS.add(edbOrderVO);
                }
                this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u6784\u5efa\u5b8c\u6210\u3011[" + orderMainNo + "] \u5b50\u8ba2\u5355\u4e2a\u6570\uff1a" + orderVOS.size());
                for (EdbOrderVO vo : orderVOS) {
                    if (DateUtils.getDateFromString((String)vo.getOrderInfo().getPickupDate()).compareTo(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1)) >= 0) {
                        this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u53d6\u6d88\u540c\u6b65\u3011[" + orderMainNo + "][" + vo.getOrderInfo().getOrderNo() + "]\u914d\u9001\u65f6\u95f4\u662f" + vo.getOrderInfo().getPickupDate() + "\uff0c\u4eca\u5929\u662f" + DateUtils.now((String)"yyyy-MM-dd") + "\uff0c\u65f6\u95f4\u672a\u5230\u6240\u4ee5\u4e0d\u540c\u6b65\u81f3E\u5e97\u5b9d");
                        continue;
                    }
                    MallOrderSyncInfoEntity syncInfo = new MallOrderSyncInfoEntity();
                    syncInfo.setOrderNo(vo.getOrderInfo().getOrderNo());
                    syncInfo.setApiName("edbTradeAdd_LC");
                    syncInfo.setSuccess(1);
                    List<MallOrderSyncInfoEntity> list = this.orderSyncInfoService.getList(syncInfo);
                    if (list != null && list.size() > 0) {
                        this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u53d6\u6d88\u540c\u6b65\u3011[" + orderMainNo + "][" + vo.getOrderInfo().getOrderNo() + "]\u5df2\u540c\u6b65\u6210\u529f\u7684\u8ba2\u5355\u4e0d\u518d\u540c\u6b65");
                        continue;
                    }
                    this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u6784\u5efa\u5b8c\u6210\u3011[" + orderMainNo + "][" + vo.getOrderInfo().getOrderNo() + "]\u914d\u9001\u65f6\u95f4\u662f" + vo.getOrderInfo().getPickupDate() + "\uff0c\u4eca\u5929\u662f" + DateUtils.now((String)"yyyy-MM-dd") + "\uff0c\u73b0\u5728\u540c\u6b65\u81f3E\u5e97\u5b9d");
                    JAXBContext context = null;
                    try {
                        context = JAXBContext.newInstance((Class[])new Class[]{vo.getClass()});
                        Marshaller marshaller = context.createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)true);
                        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                        marshaller.setProperty("jaxb.fragment", (Object)true);
                        StringWriter writer = new StringWriter();
                        marshaller.marshal((Object)vo, (Writer)writer);
                        String orderStr = writer.toString();
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("xmlValues", orderStr);
                        MallOrderSyncInfoEntity entity = new MallOrderSyncInfoEntity();
                        entity.setOrderMainNo(vo.getOrderInfo().getOrderMainNo());
                        entity.setOrderNo(vo.getOrderInfo().getOrderNo());
                        BaseJsonVo result = EDBLib.edbRequstPost("edbTradeAdd_LC", param, entity);
                        if (result.isSuccess()) {
                            this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u540c\u6b65\u6210\u529f\u3011[" + orderMainNo + "][" + vo.getOrderInfo().getOrderNo() + "]\uff1a" + result.getValue());
                            this.exportOrderSuccess(orderMainNo, vo.getOrderInfo().getOrderNo());
                            continue;
                        }
                        this.logger.info("\u3010\u5546\u57ce\u8ba2\u5355\u540c\u6b65\u5230EDB\u3011\u3010\u540c\u6b65\u5931\u8d25\u3011[" + orderMainNo + "][" + vo.getOrderInfo().getOrderNo() + "]\uff1a" + result.getMessage());
                        if (!EnvironmentEnum.PRODUCT.getValue().equals(this.environment) || this.redisService.hHasKey("EDB_SYNC_FAIL", vo.getOrderInfo().getOrderNo())) continue;
                        String msg_id = RandomUtils.generateId() + "";
                        SmsUtil.sendSms((String)"18612519503", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        SmsUtil.sendSms((String)"15910702720", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        SmsUtil.sendSms((String)"18612713230", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        this.redisService.hsave("EDB_SYNC_FAIL", vo.getOrderInfo().getOrderNo(), 1);
                    }
                    catch (JAXBException e) {
                        this.logger.error("\u540c\u6b65\u8ba2\u5355\u65f6\u51fa\u9519" + orderMainNo, (Throwable)e);
                        if (!EnvironmentEnum.PRODUCT.getValue().equals(this.environment) || this.redisService.hHasKey("EDB_SYNC_FAIL", vo.getOrderInfo().getOrderNo())) continue;
                        String msg_id = RandomUtils.generateId() + "";
                        SmsUtil.sendSms((String)"18612519503", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        SmsUtil.sendSms((String)"15910702720", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        SmsUtil.sendSms((String)"18612713230", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + vo.getOrderInfo().getOrderNo() + "]"), (String)RandomUtils.generateStrId());
                        this.redisService.hsave("EDB_SYNC_FAIL", vo.getOrderInfo().getOrderNo(), 1);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u540c\u6b65\u8ba2\u5355\u65f6\u51fa\u9519" + orderMainNo, (Throwable)e);
                if (this.redisService.hHasKey("EDB_SYNC_FAIL", orderMainNo)) break block30;
                SmsUtil.sendSms((String)"18612519503", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + orderMainNo + "]"), (String)RandomUtils.generateStrId());
                SmsUtil.sendSms((String)"15910702720", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + orderMainNo + "]"), (String)RandomUtils.generateStrId());
                SmsUtil.sendSms((String)"18612713230", (String)("\u5fae\u4fe1\u8ba2\u5355\u540c\u6b65EDB\u5931\u8d25[" + orderMainNo + "]"), (String)RandomUtils.generateStrId());
            }
        }
        return null;
    }

    @Override
    public BaseJsonVo confirmOrder(String orderNo) {
        StringBuilder builder = new StringBuilder();
        builder.append("<order>");
        builder.append("<orderInfo>");
        builder.append("<out_tid>" + orderNo + "</out_tid>");
        String format = "yyyy-MM-dd HH:mm:ss";
        builder.append("<check_time>" + DateUtils.now((String)format) + "</check_time>");
        builder.append("</orderInfo>");
        builder.append("</order>");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("xmlValues", builder.toString());
        BaseJsonVo jsonVo = EDBLib.edbRequstPost("edbOrderCheckSync", params, null);
        return jsonVo;
    }

    @Override
    public BaseJsonVo edbOrderSyncQuartz() {
        List<String> orderMainNos = this.mallOrderMapper.findUnsyncEdbOrders();
        this.logger.info("EDB\u540c\u6b65\u4efb\u52a1\uff0c\u5373\u5c06\u540c\u6b65\uff1a" + orderMainNos.toString());
        orderMainNos.forEach(orderMainNo -> this.edbOrderSync((String)orderMainNo));
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public PageInfo findUnsyncEDBOrders(int currentPage, int pageSize) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<Map<String, Object>> orderMainNos = this.mallOrderMapper.findUnsyncEdbOrdersDetail();
        orderMainNos.forEach(order -> {
            order.put("ORDER_CLASS", OrderClassEnum.getName((Integer)order.get("ORDER_CLASS")) + "(" + order.get("ORDER_CLASS") + ")");
            order.put("ORDER_SOURCE", OrderSourceEnum.getName((Integer)order.get("ORDER_SOURCE")) + "(" + order.get("ORDER_SOURCE") + ")");
            order.put("MAIN_STATUS", OrderStatusEnum.getName((Integer)order.get("MAIN_STATUS")) + "(" + order.get("MAIN_STATUS") + ")");
            order.put("SUB_STATUS", OrderStatusEnum.getName((Integer)order.get("SUB_STATUS")) + "(" + order.get("SUB_STATUS") + ")");
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(orderMainNos);
        return pg;
    }

    @Override
    public List<Map<String, String>> getUnConfirmedOrders(Date fifteenDaysAgo) {
        return this.mallOrderMapper.getUnConfirmedOrders(fifteenDaysAgo);
    }

    @Override
    public void backupWealthData() {
        String curDate = DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyyMMdd");
        this.logger.info(curDate);
        this.mallOrderMapper.insertWealthBack(curDate);
    }

    @Override
    public Map<String, BigDecimal> getFinalOrderAmount(String orderNo) {
        MallOrderEntity orderEntity;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal refundAmount = BigDecimal.ZERO;
        HashedMap map = new HashedMap();
        if (StringUtils.isNotEmpty((String)orderNo) && (orderEntity = (MallOrderEntity)this.mallOrderMapper.selectByPrimaryKey((Serializable)((Object)orderNo))) != null) {
            amount = orderEntity.getOrderAmount().subtract(orderEntity.getCouponAmount());
            BaseJsonVo js = this.mallRefundPayDetailInterface.getOrderRefundInfo(null, orderNo);
            if (js.isSuccess()) {
                List detailVos = (List)js.getValue();
                refundAmount = BigDecimal.valueOf(detailVos.stream().filter(c -> c.getPaytypeId() != 3).mapToDouble(c -> c.getFactReturnAmount().doubleValue()).sum());
            }
        }
        map.put("orderAmount", amount);
        map.put("refundAmount", refundAmount);
        return map;
    }
}

