/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.common.enums.pay.PayTypeEnum;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.trade.MallRefundFailRecordMapper;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.MallRefundFailRecordEntity;
import cc.lechun.mall.iservice.trade.MallRefundFailRecordInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallRefundFailRecordService
extends BaseService
implements MallRefundFailRecordInterface {
    @Autowired
    private MallRefundFailRecordMapper mallRefundFailRecordMapper;

    @Override
    public void saveRefundFailRecordInfo(PayInputEntity payInputEntity, Map<String, Object> map) {
        MallRefundFailRecordEntity refundFailRecordEntity = new MallRefundFailRecordEntity();
        refundFailRecordEntity.setRefundPayId(map.get("refundPayId").toString());
        List refundFailRecordList = this.mallRefundFailRecordMapper.getList(refundFailRecordEntity);
        if (refundFailRecordList != null && refundFailRecordList.size() > 0) {
            refundFailRecordEntity = (MallRefundFailRecordEntity)refundFailRecordList.get(0);
            refundFailRecordEntity.setReqNum(refundFailRecordEntity.getReqNum() + 1);
            refundFailRecordEntity.setReqParam(JSON.toJSONString((Object)payInputEntity.getEntity()));
            refundFailRecordEntity.setResParam(JSON.toJSONString(map));
            refundFailRecordEntity.setCreateTime(new Date());
            this.mallRefundFailRecordMapper.updateByPrimaryKeySelective(refundFailRecordEntity);
        } else {
            String refundFailId = IDGenerate.getUniqueIdStr();
            refundFailRecordEntity.setId(refundFailId);
            refundFailRecordEntity.setOrderMainNo(payInputEntity.getOrderMainNo());
            refundFailRecordEntity.setOrderNo(payInputEntity.getOrderNo());
            refundFailRecordEntity.setReqParam(JSON.toJSONString((Object)payInputEntity.getEntity()));
            refundFailRecordEntity.setResParam(JSON.toJSONString(map));
            refundFailRecordEntity.setRefundPayId(map.get("refundPayId").toString());
            refundFailRecordEntity.setRemark(PayTypeEnum.getPayTypeName((int)payInputEntity.getPayType()));
            refundFailRecordEntity.setCreateTime(new Date());
            refundFailRecordEntity.setReqNum(1);
            this.logger.info("=======refundFailRecordEntity={}", (Object)JSON.toJSONString((Object)refundFailRecordEntity));
            this.mallRefundFailRecordMapper.insertSelective(refundFailRecordEntity);
        }
    }

    @Override
    public List<MallRefundFailRecordEntity> getRefundFailRecord(MallRefundFailRecordEntity refundFailRecordEntity) {
        return this.mallRefundFailRecordMapper.getList(refundFailRecordEntity);
    }

    @Override
    public PageInfo getOrderRefundFailRecordList(int currentPage, int pageSize, MallRefundFailRecordEntity refundFailRecordEntity) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallRefundFailRecordEntity> refundFailRecordEntityList = this.mallRefundFailRecordMapper.getRefundFailRecordByParam(refundFailRecordEntity);
        PageInfo pg = page.toPageInfo();
        pg.setList(refundFailRecordEntityList);
        return pg;
    }

    @Override
    public BaseJsonVo modifyRefundNum(String refundPayId, String reqNum) {
        int reqNumInt = Integer.valueOf(reqNum);
        this.logger.info("====================modifyRefundNum=======refundPayId={},reqNum={}", (Object)refundPayId, (Object)reqNum);
        int i = this.mallRefundFailRecordMapper.modifyRefundNum(refundPayId, reqNumInt);
        this.logger.info("====================modifyRefundNum=======i={}", (Object)i);
        return BaseJsonVo.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public BaseJsonVo deleteRefundInfo(String refundPayId) {
        this.logger.info("====================deleteRefundInfo=======refundPayId={}", (Object)refundPayId);
        this.mallRefundFailRecordMapper.deleteRefundInfo(refundPayId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }
}

