/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingRuleInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="10_check")
public class CheckHandle
implements OrderHandleInterface {
    @Autowired
    private MallShoppingRuleInterface shoppingRuleInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        for (MallOrderVo c : mallMainOrderVo.getMallOrderVos()) {
            if (c.getProducts() != null && c.getProducts().size() > 0) {
                for (MallProductVO mallProductVO : c.getProducts()) {
                    if (mallProductVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallProductVO.getInvalidReason());
                }
            }
            if (c.getGroups() != null && c.getGroups().size() > 0) {
                for (MallGroupVO mallGroupVO : c.getGroups()) {
                    if (mallGroupVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallGroupVO.getInvalidReason());
                }
            }
            if (c.getPromotions() != null && c.getPromotions().size() > 0) {
                for (MallPromotionVO mallPromotionVO : c.getPromotions()) {
                    if (mallPromotionVO.getValid().booleanValue()) continue;
                    return BaseJsonVo.error((String)mallPromotionVO.getInvalidReason());
                }
            }
            if (c.getFrees() != null && c.getFrees().size() <= 0) continue;
        }
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(mallMainOrderVo.getPlatFormId());
        if (platFormEntity != null) {
            mallMainOrderVo.setTipMessage(this.dictionaryInterface.getValidDictionaryList(platFormEntity.getPlatformGroupId(), 20));
        }
        return BaseJsonVo.success((Object)"");
    }
}

