/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade.orderHandle;

import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.DeliverFreightVo;
import cc.lechun.mall.entity.deliver.MallFreightCalVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.iservice.deliver.DeliverFreightInterface;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.orderHandle.OrderHandleInterface;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="40_freight")
public class FreightHandle
implements OrderHandleInterface {
    private static final Logger logger = LoggerFactory.getLogger(FreightHandle.class);
    @Autowired
    private DeliverFreightInterface freightInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallFreightInterface mallFreightService;

    @Override
    public BaseJsonVo orderHandle(MallMainOrderVo mallMainOrderVo) {
        if (this.tradeCommonInterface.isNoDeliverOrder(mallMainOrderVo)) {
            return BaseJsonVo.success((Object)"");
        }
        String[] err = new String[]{""};
        int cityId = mallMainOrderVo.getAddressVo() != null ? mallMainOrderVo.getAddressVo().getCityId() : 0;
        String address = mallMainOrderVo.getAddressVo() != null ? mallMainOrderVo.getAddressVo().getAddress() : "";
        int platFormId = mallMainOrderVo.getPlatFormId();
        mallMainOrderVo.getMallOrderVos().forEach(c -> {
            DeliverFreightVo deliverFreightVo = new DeliverFreightVo();
            deliverFreightVo.setCityId(cityId);
            if (c.getDeliverVo() != null) {
                deliverFreightVo.setDeliverId(c.getDeliverVo().getDeliverId());
            }
            deliverFreightVo.setPlatFormId(platFormId);
            deliverFreightVo.setAmount(c.getFactPrice());
            deliverFreightVo.setQuantity(c.getProductsPool().stream().mapToInt(d -> d.getCount()).sum());
            deliverFreightVo.setOrderSource(c.getOrderSource());
            Boolean coldGroups = false;
            Boolean nomalGroups = false;
            BigDecimal freightAmount = new BigDecimal(0);
            if (!coldGroups.booleanValue() && cityId != 0) {
                ArrayList<MallFreightCalVo> mallFreightCalVoList = new ArrayList<MallFreightCalVo>();
                MallFreightCalVo mallFreightCalVo = new MallFreightCalVo();
                mallFreightCalVo.setCityId(String.valueOf(cityId));
                mallFreightCalVo.setOrderSource(c.getOrderSource());
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == 0) {
                    mallFreightCalVo.setDeliverId(String.valueOf(c.getTransportType()));
                }
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == 1) {
                    mallFreightCalVo.setDeliverId("3");
                }
                if (mallMainOrderVo.getOrderCacheVo().getSpeedUp() == -1) {
                    if (c.getDeliverVo().getSpeedupInventory() == 1) {
                        mallFreightCalVo.setDeliverId("3");
                    } else {
                        mallFreightCalVo.setDeliverId(String.valueOf(c.getTransportType()));
                    }
                }
                mallFreightCalVo.setPlatFormGroupId(c.getPlatFormGroupId());
                mallFreightCalVo.setAmount(c.getPrice());
                if (c.getGroups() != null && c.getGroups().size() > 0) {
                    mallFreightCalVo.setGorupId(StringUtils.join((Object[])c.getGroups().stream().map(g -> g.getGroupId()).toArray(), (String)","));
                }
                if (c.getProducts() != null && c.getProducts().size() > 0) {
                    mallFreightCalVo.setProductId(StringUtils.join((Object[])c.getProducts().stream().map(g -> g.getProId()).toArray(), (String)","));
                }
                if (c.getPromotions() != null && c.getPromotions().size() > 0) {
                    mallFreightCalVo.setPromotionId(StringUtils.join((Object[])c.getPromotions().stream().map(g -> g.getPromotionId()).toArray(), (String)","));
                }
                mallFreightCalVo.setBindCode(c.getBindCode());
                mallFreightCalVoList.add(mallFreightCalVo);
                JSONArray freightArray = this.mallFreightService.getFreightByCityAmountDeliveryType(mallFreightCalVoList, coldGroups, nomalGroups);
                if (freightArray != null && freightArray.size() > 0) {
                    for (JSONObject freightObject : freightArray) {
                        String freightAmountStr = freightObject.getString("freightAmount");
                        freightAmount = freightAmount.add(new BigDecimal(freightAmountStr));
                    }
                }
            }
            c.setFreight(freightAmount);
            c.setTotalAmount(PriceUtils.add((BigDecimal)c.getOrderAmount(), (BigDecimal)c.getFreight()));
        });
        if (err[0].isEmpty()) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)err[0]);
    }
}

