/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.weixin.TemplateMessageMapper;
import cc.lechun.mall.entity.weixin.TemplateMessageBodyVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.bean.message.templatemessage.MiniSubscribeMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessage;
import weixin.popular.bean.message.templatemessage.TemplateMessageItem;

@Service
public class TemplateMessageService
extends BaseService
implements TemplateMessageInterface {
    @Autowired
    private TemplateMessageMapper templateMessageMapper;
    @Autowired
    private WeiXinKeywordInterface keywordInterface;
    @Autowired
    private MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="TemplateMessageService.getTemplateMessageById")
    public TemplateMessageEntity getTemplateMessageById(@ParameterValueKeyProvider Integer id) {
        return (TemplateMessageEntity)this.templateMessageMapper.selectByPrimaryKey(id);
    }

    @Override
    public BaseJsonVo save(TemplateMessageEntity templateMessageEntity) {
        boolean b = false;
        TemplateMessageEntity templateMessageEntity1 = new TemplateMessageEntity();
        templateMessageEntity1.setMessageName(templateMessageEntity.getMessageName());
        templateMessageEntity1.setPlatformId(templateMessageEntity.getPlatformId());
        templateMessageEntity1 = (TemplateMessageEntity)this.templateMessageMapper.getSingle(templateMessageEntity1);
        if (templateMessageEntity.getMessageId() == null || templateMessageEntity.getMessageId() == 0) {
            if (templateMessageEntity1 != null) {
                return BaseJsonVo.error((String)("\u5df2\u5b58\u5728\uff1a" + templateMessageEntity.getMessageName()));
            }
            templateMessageEntity.setCreatTime(DateUtils.now());
            b = this.templateMessageMapper.insertSelective(templateMessageEntity) > 0;
        } else {
            if (templateMessageEntity1 != null && templateMessageEntity1.getMessageId().intValue() != templateMessageEntity.getMessageId().intValue()) {
                return BaseJsonVo.error((String)("\u5df2\u5b58\u5728\uff1a" + templateMessageEntity.getMessageName()));
            }
            b = this.templateMessageMapper.updateByPrimaryKeySelective(templateMessageEntity) > 0;
        }
        this.memcachedService.delete("TemplateMessageService.getTemplateMessageById", templateMessageEntity.getTemplateId() == null ? "" : templateMessageEntity.getTemplateId());
        if (b) {
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public PageInfo list(Integer page, Integer pageSize, TemplateMessageEntity templateMessageEntity) {
        Page lst = PageHelper.startPage((int)page, (int)pageSize).doSelectPage(() -> this.templateMessageMapper.getTemplateMessageList(templateMessageEntity));
        return new PageInfo((List)lst);
    }

    @Override
    public boolean delete(Integer id) {
        this.memcachedService.delete("TemplateMessageService.getTemplateMessageById", String.valueOf(id));
        return this.templateMessageMapper.deleteByPrimaryKey(id) > 0;
    }

    @Override
    public List<TemplateMessageEntity> getTemplateMessageList(Integer platformId) {
        TemplateMessageEntity messageEntity = new TemplateMessageEntity();
        messageEntity.setPlatformId(platformId);
        return this.templateMessageMapper.getList(messageEntity);
    }

    @Override
    public BaseJsonVo getTemplateMessageContent(Integer messageId, Map<String, String> variable) {
        try {
            TemplateMessageEntity templateMessageEntity = this.getTemplateMessageById(messageId);
            if (templateMessageEntity.getPlatformId() == 4) {
                return this.getMiniTemplateMessageContent(templateMessageEntity, messageId, variable);
            }
            TemplateMessage templateMessage = new TemplateMessage();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    templateMessage.setUrl(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                }
                LinkedHashMap<String, TemplateMessageItem> data = new LinkedHashMap<String, TemplateMessageItem>();
                TemplateMessageItem first = new TemplateMessageItem();
                first.setValue(this.keywordInterface.replaceVariable(templateMessageEntity.getFirst(), variable));
                first.setColor(templateMessageEntity.getTopColor());
                data.put("first", first);
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    TemplateMessageItem body = new TemplateMessageItem();
                    body.setValue(bodyVo.getValue());
                    body.setColor(bodyVo.getColor());
                    data.put(bodyVo.getTitle(), body);
                }
                TemplateMessageItem remark = new TemplateMessageItem();
                remark.setValue(this.keywordInterface.replaceVariable(templateMessageEntity.getRemark(), variable));
                remark.setColor(templateMessageEntity.getBottomColor());
                data.put("remark", remark);
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    private BaseJsonVo<MiniSubscribeMessage> getMiniTemplateMessageContent(TemplateMessageEntity templateMessageEntity, Integer messageId, Map<String, String> variable) {
        try {
            MiniSubscribeMessage templateMessage = new MiniSubscribeMessage();
            LinkedHashMap data = new LinkedHashMap();
            if (templateMessageEntity != null) {
                templateMessage.setTemplate_id(templateMessageEntity.getTemplateId());
                templateMessage.setTouser("");
                if (StringUtils.isNotEmpty((String)templateMessageEntity.getUrl())) {
                    templateMessage.setPage(this.keywordInterface.replaceVariable(templateMessageEntity.getUrl(), variable));
                }
                if (templateMessageEntity.getVariable().isEmpty()) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                String bodyStr = this.keywordInterface.replaceVariable(templateMessageEntity.getVariable(), variable);
                List bodyVos = JsonUtils.getListByArray(TemplateMessageBodyVo.class, (String)bodyStr);
                if (bodyVos == null || bodyVos.size() == 0) {
                    return BaseJsonVo.error((String)"\u6a21\u677f\u6d88\u606f\u6ca1\u6709\u8bbe\u7f6ebody");
                }
                int i = 0;
                for (TemplateMessageBodyVo bodyVo : bodyVos) {
                    ++i;
                    LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                    item.put("value", this.keywordInterface.replaceVariable(bodyVo.getValue(), variable));
                    data.put(bodyVo.getTitle(), item);
                }
                templateMessage.setData(data);
            }
            return BaseJsonVo.success((Object)templateMessage);
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            return BaseJsonVo.error((String)"\u7ec4\u7ec7\u6d88\u606f\u5360\u4f4d\u7b26Map\u5f02\u5e38");
        }
    }

    @Override
    public TemplateMessageEntity getTemplateMessage(Integer id) {
        return (TemplateMessageEntity)this.templateMessageMapper.selectByPrimaryKey(id);
    }
}

