/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.weixin;

import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.vo.ActiveCashticketMessageVo;
import cc.lechun.common.file.OssService;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.popular.bean.message.EventMessage;
import weixin.popular.bean.xmlmessage.XMLImageMessage;
import weixin.popular.bean.xmlmessage.XMLMessage;
import weixin.popular.bean.xmlmessage.XMLNewsMessage;
import weixin.popular.bean.xmlmessage.XMLTextMessage;

@Service
public class WeiXinMessage
extends BaseService {
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private WeiXinMediaInterface weiXinMediaService;
    @Autowired
    private OssService ossInterface;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;

    public XMLMessage pushTextMessage(EventMessage eventMessage, String outContent) {
        XMLTextMessage xmlTextMessage = new XMLTextMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), outContent);
        return xmlTextMessage;
    }

    public XMLMessage pushImageMessage(EventMessage eventMessage, String mediaId) {
        XMLImageMessage xmlImageMessage = new XMLImageMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), mediaId);
        return xmlImageMessage;
    }

    public XMLMessage pushMessage(EventMessage eventMessage, WeiXinKeywordEntity weiXinKeywordEntity, int platformId) {
        if (weiXinKeywordEntity != null) {
            this.logger.info("\u56de\u590d\u5173\u952e\u5b57:{}", (Object)weiXinKeywordEntity.toString());
            if ("coupon".equals(weiXinKeywordEntity.getType())) {
                String bindCodeCash = this.activeService.getActiveCouponByKeyWordId(weiXinKeywordEntity.getId());
                if (StringUtils.isNotEmpty((String)bindCodeCash)) {
                    ActiveCashticketMessageVo activeCashticketMessageVo = new ActiveCashticketMessageVo();
                    activeCashticketMessageVo.setBindCode(bindCodeCash);
                    activeCashticketMessageVo.setOpenId(eventMessage.getFromUserName());
                    activeCashticketMessageVo.setVersionDetailId("");
                    activeCashticketMessageVo.setSendMessage(true);
                    activeCashticketMessageVo.setPlatFormId(platformId);
                    this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendActiveCashTicket, MessageParam.messageParam((String)eventMessage.getFromUserName(), (Object)activeCashticketMessageVo));
                } else {
                    this.logger.info("\u5173\u952e\u5b57\u6ca1\u6709\u7ed1\u5b9a\u6d3b\u52a8\u6216\u6d3b\u52a8\u6ca1\u6709\u5173\u8054\u4f18\u60e0\u5238\u6216\u6d3b\u52a8\u5df2\u8fc7\u671f,\u5173\u952e\u5b57:{}", (Object)weiXinKeywordEntity.getKeyword());
                }
            } else if ("image".equals(weiXinKeywordEntity.getType())) {
                if (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getMediaId())) {
                    return this.pushImageMessage(eventMessage, weiXinKeywordEntity.getMediaId());
                }
                this.logger.info("\u7d20\u6750id\u4e3a\u7a7a{}", (Object)weiXinKeywordEntity.toString());
            } else if ("news".equals(weiXinKeywordEntity.getType())) {
                if (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getMediaId())) {
                    List<WeiXinMediaEntity> mediaList = this.weiXinMediaService.getMediaListByMediaId(weiXinKeywordEntity.getMediaId());
                    ArrayList<XMLNewsMessage.Article> list = new ArrayList<XMLNewsMessage.Article>();
                    if (mediaList.size() >= 1) {
                        for (WeiXinMediaEntity weiXinMedia : mediaList) {
                            XMLNewsMessage.Article item = new XMLNewsMessage.Article();
                            String url = weiXinMedia.getUrl();
                            item.setUrl(url);
                            item.setDescription(weiXinMedia.getDigest());
                            item.setPicurl(this.ossInterface.getImageResoure(weiXinMedia.getImageUrl()));
                            item.setTitle(weiXinMedia.getTitle());
                            list.add(item);
                        }
                        XMLNewsMessage xmlNewsMessage = new XMLNewsMessage(eventMessage.getFromUserName(), eventMessage.getToUserName(), list);
                        return xmlNewsMessage;
                    }
                }
            } else if ("text".equals(weiXinKeywordEntity.getType())) {
                String content = "";
                content = StringUtils.isNotEmpty((String)weiXinKeywordEntity.getUrl()) ? (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getTitle()) ? weiXinKeywordEntity.getTitle() : "<a href='" + weiXinKeywordEntity.getUrl() + "'>" + (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getContent()) ? weiXinKeywordEntity.getContent() : "") + "</a>") : (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getTitle()) ? weiXinKeywordEntity.getTitle() : "") + (StringUtils.isNotEmpty((String)weiXinKeywordEntity.getContent()) ? weiXinKeywordEntity.getContent() : "");
                return this.pushTextMessage(eventMessage, content);
            }
        }
        return null;
    }

    public XMLMessage pushMessage(EventMessage eventMessage, Integer keywordId, int platformId) {
        WeiXinKeywordEntity weiXinKeywordEntity;
        if (keywordId != null && keywordId > 0 && (weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(keywordId)) != null) {
            return this.pushMessage(eventMessage, weiXinKeywordEntity, platformId);
        }
        return null;
    }
}

