/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.domain;

import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.dao.PaperMapper;
import cc.lechun.organization.entity.OrgTypeNumEntity;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperBonusVo;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperEntityVo;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperDomain
extends BaseService
implements IOrgPaperDomain {
    @Resource
    private PaperMapper paperMapper;

    @Override
    public List<PaperBonusVo> getBonusesList(String userId, String bonusTime, Integer questionClassId) {
        return this.paperMapper.getBonusesList(userId, bonusTime, questionClassId);
    }

    @Override
    public List<PaperEntity> getPaperBonusDetaiList(String userId, Date start, Date end, Integer questionClassId, Integer reportStatus) {
        return this.paperMapper.getPaperBonusDetaiList(userId, start, end, questionClassId, reportStatus);
    }

    @Override
    public boolean insert(PaperEntity paperEntity) {
        return this.paperMapper.insert(paperEntity) > 0;
    }

    @Override
    public boolean update(PaperEntity paperEntity) {
        paperEntity.setUpdateTime(new Date());
        return this.paperMapper.updateByPrimaryKeySelective(paperEntity) > 0;
    }

    @Override
    public boolean delete(String id) {
        return this.paperMapper.deleteByPrimaryKey((Serializable)((Object)id)) > 0;
    }

    @Override
    public PaperEntity select(String id) {
        return (PaperEntity)this.paperMapper.selectByPrimaryKey((Serializable)((Object)id));
    }

    @Override
    public PaperEntity getSingle(PaperEntity searchEntity) {
        return (PaperEntity)this.paperMapper.getSingle(searchEntity);
    }

    @Override
    public List<PaperEntity> getList(PaperEntity searchEntity) {
        return this.paperMapper.getList(searchEntity);
    }

    @Override
    public PageInfo getPageList(int pageNum, int pageSize, PaperEntity search, Set<String> permitUsers, String userId, Integer deptId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        this.paperMapper.getListVo(search, permitUsers, userId, deptId);
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public List<PaperEntity> getPaperList(PaperEntity search, Set<String> permitUsers, String userId) {
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        return this.paperMapper.getPaperList(search, permitUsers, userId);
    }

    @Override
    public PageInfo<Map<String, Object>> getPublicPages(int pageNum, int pageSize, PaperEntity search, Set<String> permitUsers, String userId) {
        Page page = PageHelper.startPage((int)pageNum, (int)pageSize);
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        this.paperMapper.getPublicListVo(permitUsers, search.getPeriodId());
        PageInfo rs = page.toPageInfo();
        return rs;
    }

    @Override
    public List<PaperEntity> selectPaperInfo(PaperEntity paperEntity) {
        return this.paperMapper.selectPaperInfo(paperEntity);
    }

    @Override
    public List<PaperEntity> getPaperByPeriodId(List<Integer> periodIdList, String userId, Integer questionClassId) {
        return this.paperMapper.getPaperByPeriodId(periodIdList, userId, questionClassId);
    }

    @Override
    public List<PaperEntity> selectPaperByIdList(List<String> paperIdList) {
        return this.paperMapper.selectPaperByIdList(paperIdList);
    }

    @Override
    public List<PaperEntity> getPaperByTime(PaperEntityVo paperEntityVo) {
        return this.paperMapper.getPaperByTime(paperEntityVo);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfo(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.paperMapper.getPaperNumInfo(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByWeek(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.paperMapper.getPaperNumInfoByWeek(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByMonth(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.paperMapper.getPaperNumInfoByMonth(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByStatus(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.paperMapper.getPaperNumInfoByStatus(periodIdList, questionClassId, userId);
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportData(Integer periodId, Integer questionClassId, Set<String> permitUsers) {
        String users = "";
        for (String s : permitUsers) {
            users = users + s + ",";
        }
        return this.paperMapper.getExportData(periodId, questionClassId, users.substring(0, users.length() - 1));
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportDataKpi(Integer periodId, Integer questionClassId, Set<String> permitUsers) {
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        if (Integer.valueOf("10").equals(questionClassId)) {
            return this.paperMapper.getExportDataKpi(periodId, questionClassId, permitUsers);
        }
        return this.paperMapper.getExportDataOkr(periodId, questionClassId, permitUsers);
    }

    @Override
    public List<OrgTypeNumEntity> getWeekNumInfoAll(List<Integer> periodIdList, String userId) {
        return this.paperMapper.getWeekNumInfoAll(periodIdList, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getWeekNumInfoByFinish(List<Integer> periodIdList, String userId) {
        return this.paperMapper.getWeekNumInfoByFinish(periodIdList, userId);
    }

    @Override
    public List<PaperAnswerEntity> getAnswerInfoByParam(List<Integer> periodIdList, String userId) {
        return this.paperMapper.getAnswerInfoByParam(periodIdList, userId);
    }

    @Override
    public int updatePaperStatusByParam(PaperEntity paperEntity) {
        return this.paperMapper.updatePaperStatusByParam(paperEntity);
    }

    @Override
    public int savePaperInfo(PaperEntity paperEntity) {
        return this.paperMapper.savePaperInfo(paperEntity);
    }

    @Override
    public List<PaperEntity> getExportPaperList(Integer questionClassId) {
        return this.paperMapper.getExportPaperList(questionClassId);
    }

    @Override
    public List<PaperEntity> getUnConfirmKpi(Set<String> permitUsers, Integer periodId) {
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        return this.paperMapper.getUnConfirmKpi(permitUsers, periodId);
    }

    @Override
    public List<PaperEntity> getSelfUnConfirmKpi(Set<String> permitUsers, Integer periodId) {
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        return this.paperMapper.getSelfUnConfirmKpi(permitUsers, periodId);
    }

    @Override
    public List<PaperEntity> getUserAndGrowthUnConfirmReport(Integer questionClassId, String loginId, Set<String> permitUsers, Integer periodId) {
        if (permitUsers != null && permitUsers.size() == 0) {
            permitUsers.add(UUID.randomUUID().toString());
        }
        return this.paperMapper.getUserAndGrowthUnConfirmReport(questionClassId, loginId, permitUsers, periodId);
    }

    @Override
    public List<PaperEntity> unStandardUserAndGrowthRemind(Integer questionClassId, Set<Integer> periods) {
        return this.paperMapper.unStandardUserAndGrowthRemind(questionClassId, periods);
    }

    @Override
    public List<PaperEntity> selfUnConfirmWeekEndRemind(Set<String> permitUsers, Integer periodId) {
        return this.paperMapper.selfUnConfirmWeekEndRemind(permitUsers, periodId);
    }
}

