/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.enums.organization.JianDaoyunAppEnum;
import cc.lechun.common.enums.organization.OrgQuestionClassEnum;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.KpiEntity;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.KpiInterface;
import cc.lechun.organization.iservice.OrgPaperExportInterface;
import cc.lechun.utils.JianDaoYunAPIUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgPaperExport
implements OrgPaperExportInterface {
    private JianDaoyunAppEnum jianDaoyunAppEnum = JianDaoyunAppEnum.JIANDAOYUN_CMS_ORG_APPID;
    @Autowired
    private IOrgPaperDomain paperDomain;
    @Autowired
    private IOrgPaperService paperService;
    @Autowired
    private IOrgPaperAnswerService paperAnswerService;
    @Autowired
    private IOrgQuestionClassDomain orgQuestionClassDomain;
    @Autowired
    private SysUserInterface sysUserInterface;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private KpiInterface kpiInterface;

    @Override
    public List<Map<String, Object>> getFormFields() {
        JianDaoYunAPIUtils jianDaoYunAPIUtils = JianDaoYunAPIUtils.getInstance(this.jianDaoyunAppEnum, OrgQuestionClassEnum.User);
        return jianDaoYunAPIUtils.getFormWidgets();
    }

    @Override
    public List<Map<String, Object>> getFormData() {
        JianDaoYunAPIUtils jianDaoYunAPIUtils = JianDaoYunAPIUtils.getInstance(this.jianDaoyunAppEnum, OrgQuestionClassEnum.User);
        Object[] fields = this.getFormFields().stream().map(c -> c.get("name")).toArray();
        return jianDaoYunAPIUtils.getAllFormData(fields, (Map<String, Object>)new HashedMap());
    }

    @Override
    public void exportDataToJianDaoyun() {
        List<QuestionClassEntity> questionClassEntities = this.orgQuestionClassDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : questionClassEntities) {
            OrgQuestionClassEnum classEnum;
            if (!c.getClassId().equals(1) && !c.getClassId().equals(2) && !c.getClassId().equals(3) && !c.getClassId().equals(8) && !c.getClassId().equals(10) || (classEnum = OrgQuestionClassEnum.valueOf(c.getClassNameEn())) == null) continue;
            JianDaoYunAPIUtils jianDaoYunAPIUtils = JianDaoYunAPIUtils.getInstance(this.jianDaoyunAppEnum, classEnum);
            List<Map<String, Object>> fields = jianDaoYunAPIUtils.getFormWidgets();
            List<PaperEntity> paperEntities = this.paperDomain.getExportPaperList(c.getClassId());
            for (PaperEntity p : paperEntities) {
                Object data = new HashedMap();
                if (!c.getClassId().equals(10)) {
                    data = this.exportPaperAnswer(p, c, fields);
                } else {
                    this.exportPaperKpis(p, c, fields);
                }
                if (data.size() <= 0) continue;
                Map<String, Object> result = null;
                result = StringUtils.isNotEmpty((String)p.getExportId()) ? jianDaoYunAPIUtils.updateData(p.getExportId(), (Map<String, Object>)data) : jianDaoYunAPIUtils.createData((Map<String, Object>)data);
                if (result == null || result.get("_id") == null) continue;
                String id = result.get("_id").toString();
                this.paperService.updatePaperExportStatusByParam(p.getId(), id);
            }
        }
    }

    private Map<String, Object> exportPaperKpis(PaperEntity p, QuestionClassEntity c, List<Map<String, Object>> fields) {
        KpiEntity kpiEntity = new KpiEntity();
        kpiEntity.setPaperId(p.getId());
        List kpiEntities = this.kpiInterface.getList(kpiEntity);
        HashedMap data = new HashedMap();
        return data;
    }

    private Map<String, Object> exportPaperAnswer(PaperEntity p, QuestionClassEntity c, List<Map<String, Object>> fields) {
        PeriodEntity periodEntity;
        MallUserEntity userEntity;
        List<PaperAnswerEntity> editVos = this.paperAnswerService.getList(p.getId());
        HashedMap data = new HashedMap();
        if (editVos.size() > 0 && (userEntity = this.sysUserInterface.getMallUser(p.getUserId())) != null && StringUtils.isNotEmpty((String)userEntity.getDingdingId()) && (periodEntity = this.periodService.getPeriodEntity(p.getPeriodId())) != null) {
            Integer week = periodEntity.getHeadPeriod();
            String dingding_id = userEntity.getDingdingId();
            PeriodEntity lastPeriod = (PeriodEntity)this.periodService.getLastPeriod(p.getPeriodId()).getValue();
            Integer lastWeek = week;
            if (lastPeriod != null) {
                lastWeek = lastPeriod.getHeadPeriod();
            }
            if (c.getClassId().equals(8)) {
                data.put("month", week);
                data.put("last_month", lastWeek);
                data.put("create_time", periodEntity.getPeriodEnd());
                data.put("is_nice", Integer.valueOf(1).equals(p.getIsNice()) ? "\u662f" : "\u5426");
                data.put("weekofweek", this.paperAnswerService.getThisMonthWeek(p, periodEntity));
            } else if (c.getClassId() == 11) {
                data.put("create_time", periodEntity.getPeriodEnd());
            }
            if (c.getClassId().equals(3)) {
                data.put("week", periodEntity.getHeadPeriod());
                data.put("create_time", periodEntity.getPeriodEnd());
                data.put("month", periodEntity.getPeriodStart().getMonth() + 1);
                data.put("last_week", lastWeek);
                data.put("weekofweek", this.paperAnswerService.getThisWeekOfWeek(p, periodEntity));
                data.put("weekofweek_next", this.paperAnswerService.getNextWeekOfWeek(p, periodEntity));
            } else {
                data.put("week", periodEntity.getPeriodDesc());
            }
            data.put("dingding_id", dingding_id);
            String isStandard = "\u5426";
            isStandard = Integer.valueOf(1).equals(p.getReportStatus()) ? "\u662f" : "\u5426";
            data.put("report_status", isStandard);
            data.put("paper_id", p.getId());
            for (Map<String, Object> m : fields) {
                String o;
                if (!m.get("name").toString().startsWith("q_")) continue;
                String questionId = m.get("name").toString().replace("q_", "");
                Optional<PaperAnswerEntity> answer = editVos.stream().filter(e -> e.getQuestionId().equals(Integer.parseInt(questionId))).findFirst();
                if (!answer.isPresent()) continue;
                String strAnswer = answer.get().getAnswer();
                if (answer.get().getQuestionId().equals(1)) {
                    strAnswer = "0001".equals(strAnswer) ? "\u5185\u90e8\u7528\u6237" : "\u6d88\u8d39\u8005";
                }
                strAnswer = strAnswer.replace("lastMonthFactValue", "lastmonth_factvalue");
                strAnswer = strAnswer.replace("lastMonthValue", "lastmonth_value");
                if ((strAnswer = strAnswer.replace("nextMonthValue", "nextmonth_value")).contains("relationUserId")) {
                    o = null;
                    try {
                        o = JsonUtils.isValidate((String)strAnswer) ? (List)JsonUtils.fromJson((String)strAnswer, ArrayList.class) : null;
                        Iterator iterator = o.iterator();
                        while (iterator.hasNext()) {
                            LinkedHashMap l = (LinkedHashMap)iterator.next();
                            MallUserEntity relUser = this.sysUserInterface.getMallUser(l.get("relationUserId").toString());
                            if (relUser == null) continue;
                            l.put("relation_userid", relUser.getDingdingId());
                        }
                        strAnswer = JsonUtils.toJson((Object)o, (boolean)false);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                try {
                    o = JsonUtils.isValidate((String)strAnswer) ? JsonUtils.fromJson((String)strAnswer, Object.class) : strAnswer;
                    data.put(m.get("name").toString(), o);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        return data;
    }
}

