/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.dingding.DingdingUtils;
import cc.lechun.common.result.CodeNameVo;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.entity.OrgQuestionClassTimeoutVO;
import cc.lechun.organization.entity.OrgTypeNumEntity;
import cc.lechun.organization.entity.OrgWeekEndUnFinishVo;
import cc.lechun.organization.entity.PaperAnswerEntity;
import cc.lechun.organization.entity.PaperAnswerRelationEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.PaperPageListVo;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.idomain.IOrgPaperAnswerDomain;
import cc.lechun.organization.idomain.IOrgPaperDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassDomain;
import cc.lechun.organization.idomain.IOrgQuestionClassTimeoutDomain;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.idomain.IOrgVoteDomain;
import cc.lechun.organization.iservice.IOrgPaperAnswerRelationService;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgPermittedUsersService;
import cc.lechun.organization.iservice.IPeriodService;
import cc.lechun.organization.iservice.PaperSendlogInterface;
import cc.lechun.utils.DateUtil;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgPaperService
extends BaseService<PaperEntity, String>
implements IOrgPaperService {
    @Autowired
    private IOrgPaperDomain orgPaperDomain;
    @Autowired
    private IPeriodService periodService;
    @Autowired
    private SysUserInterface userInterface;
    @Autowired
    private IOrgPermittedUsersService permittedUsersService;
    @Autowired
    private IOrgQuestionClassDomain classDomain;
    @Autowired
    @Lazy
    private IOrgPaperService paperService;
    @Autowired
    private IOrgQuestionDomain orgQuestionDomain;
    @Autowired
    private IOrgVoteDomain orgVoteService;
    @Autowired
    private IOrgPaperAnswerDomain orgPaperAnswerDomain;
    @Autowired
    IOrgQuestionClassTimeoutDomain timeoutDomain;
    @Autowired
    private IOrgPaperAnswerRelationService relationService;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private IOrgPaperAnswerDomain paperAnswerDomain;
    @Autowired
    private PaperSendlogInterface paperSendlogInterface;
    @Autowired
    private DingdingUtils dingdingUtils;
    @Autowired
    private IOrgQuestionClassDomain questionClassDomain;
    private BigDecimal bonuse = new BigDecimal(0);
    private final BigDecimal base = new BigDecimal(50);
    private final BigDecimal facor = new BigDecimal(25);

    @Override
    public BaseJsonVo setWeekAfterWeek(Integer id, String userId, Integer finished) {
        PaperAnswerRelationEntity relationEntity = this.relationService.getPaperAnswerRelationEntityById(id);
        if (relationEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        PaperAnswerEntity answerEntity = this.orgPaperAnswerDomain.select(relationEntity.getAnswerId());
        if (answerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        QuestionEntity questionEntity = this.orgQuestionDomain.select(answerEntity.getQuestionId());
        if (questionEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        if (questionEntity.getQuestionClassId() != 9) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        if (!this.userInterface.isLeadership(userId, answerEntity.getUserId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        return this.relationService.saveAnswer(id, finished);
    }

    private Date LocalDateTodate(LocalDate localDate) {
        if (localDate != null) {
            ZoneId zone = ZoneId.systemDefault();
            Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
            Date date = Date.from(instant);
            return date;
        }
        return null;
    }

    @Override
    public BaseJsonVo savePaper(PaperEntity paperEntity) {
        boolean success = false;
        paperEntity.setUpdateTime(new Date());
        PaperEntity search = new PaperEntity();
        search.setPeriodId(paperEntity.getPeriodId());
        search.setUserId(paperEntity.getUserId());
        search.setQuestionClassId(paperEntity.getQuestionClassId());
        PaperEntity paperExists = this.orgPaperDomain.getSingle(search);
        if (StringUtils.isEmpty((String)paperEntity.getId())) {
            paperEntity.setId(IDGenerate.getUniqueIdStr());
        }
        if (paperExists == null) {
            success = this.orgPaperDomain.insert(paperEntity);
        }
        return success ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public BaseJsonVo buildPaper() {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                this.paperService.buildPaper(u.getUserId(), c.getClassId());
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo buildPaper(Integer periodId) {
        List<QuestionClassEntity> classEntities = this.classDomain.getQuestionClassEntityList(0);
        for (QuestionClassEntity c : classEntities) {
            if (c.getRoleId() == null) continue;
            List<MallUserEntity> userEntities = this.userInterface.getSysUserList4RoleId(c.getRoleId());
            for (MallUserEntity u : userEntities) {
                try {
                    this.paperService.buildPaper(u.getUserId(), c.getClassId(), periodId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo buildPaper(String userId, Integer classId) {
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        BaseJsonVo<PeriodEntity> periodEntity = this.periodService.currentPeriod(periodType);
        if (periodEntity.getValue() == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        if (!periodType.equals(((PeriodEntity)periodEntity.getValue()).getPeriodType())) {
            return BaseJsonVo.error((String)"\u8be5\u62a5\u544a\u7c7b\u578b\u548c\u671f\u6b21\u7c7b\u578b\u4e0d\u5bf9\u5e94");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(((PeriodEntity)periodEntity.getValue()).getId());
        paperEntity.setPeriodName(((PeriodEntity)periodEntity.getValue()).getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo buildPaper(String userId, Integer classId, Integer periodId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        if (!periodType.equals(periodEntity.getPeriodType())) {
            return BaseJsonVo.error((String)"\u8be5\u62a5\u544a\u7c7b\u578b\u548c\u671f\u6b21\u7c7b\u578b\u4e0d\u5bf9\u5e94");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(periodEntity.getId());
        paperEntity.setPeriodName(periodEntity.getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaper(paperEntity);
    }

    @Override
    public BaseJsonVo getPaperPageList(PageForm pageForm, PaperEntity paperEntity, String userId, Integer deptId) {
        List<MallUserEntity> userEntities;
        QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(paperEntity.getQuestionClassId());
        if (questionClassEntity != null && (userEntities = this.userInterface.getSysUserList4RoleId(questionClassEntity.getRoleId())).stream().filter(c -> c.getUserId().equals(userId)).count() > 0L) {
            this.buildPaper(userId, paperEntity.getQuestionClassId());
        }
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        Set<String> users1 = null;
        users.add(userId);
        if ((Integer.valueOf(10).equals(paperEntity.getQuestionClassId()) || Integer.valueOf(16).equals(paperEntity.getQuestionClassId())) && (users1 = this.userInterface.getFinancialSubordinate(userId)) != null && users1.size() > 0) {
            users.addAll(users1);
        }
        PageInfo pageInfo = this.orgPaperDomain.getPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId, deptId);
        List vo = pageInfo.getList();
        BaseJsonVo flat = this.isUPdateFlag(userId);
        for (PaperPageListVo v : vo) {
            v.setUpdateFlag(flat.isSuccess() ? 1 : 0);
            this.getStatus(paperEntity, userId, v, users1);
        }
        this.logger.info("----pagelist forEach end");
        return BaseJsonVo.success((Object)pageInfo);
    }

    @Override
    public int getPaperPageTotal(PageForm pageForm, PaperEntity paperEntity, String userId) {
        List<MallUserEntity> userEntities;
        QuestionClassEntity questionClassEntity = this.classDomain.getQuestionClassEntity(paperEntity.getQuestionClassId());
        if (questionClassEntity != null && (userEntities = this.userInterface.getSysUserList4RoleId(questionClassEntity.getRoleId())).stream().filter(c -> c.getUserId().equals(userId)).count() > 0L) {
            this.buildPaper(userId, paperEntity.getQuestionClassId());
        }
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        Set<String> users1 = null;
        users.add(userId);
        if (Integer.valueOf(10).equals(paperEntity.getQuestionClassId()) && (users1 = this.userInterface.getFinancialSubordinate(userId)) != null && users1.size() > 0) {
            users.addAll(users1);
        }
        PageInfo pageInfo = this.orgPaperDomain.getPageList(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId, 0);
        return pageInfo.getList().size();
    }

    @Override
    public BaseJsonVo<OrgQuestionClassTimeoutVO> isEdit(PaperEntity paperEntity, String userId, Set<String> users1) {
        BaseJsonVo<OrgQuestionClassTimeoutVO> baseJsonVo = this.timeoutDomain.isEdit(paperEntity, userId, 1);
        if (baseJsonVo.isSuccess()) {
            if (Integer.valueOf(10).equals(paperEntity.getQuestionClassId())) {
                if (users1 != null && users1.contains(paperEntity.getUserId())) {
                    return baseJsonVo;
                }
                if (userId.equals(paperEntity.getUserId())) {
                    return baseJsonVo;
                }
            } else if (userId.equals(paperEntity.getUserId())) {
                return baseJsonVo;
            }
        }
        BaseJsonVo error = BaseJsonVo.error();
        error.setValue(baseJsonVo.getValue());
        return error;
    }

    public boolean isLeaderEdit(PaperEntity paperEntity, String userId) {
        return this.timeoutDomain.isEdit(paperEntity, userId, 2).isSuccess();
    }

    public boolean isDissentEdit(PaperEntity paperEntity, String userId) {
        return this.timeoutDomain.isEdit(paperEntity, userId, 3).isSuccess() && userId.equals(paperEntity.getUserId());
    }

    private boolean isVote(PaperEntity paperEntity, String userId) {
        return !userId.equals(paperEntity.getUserId());
    }

    @Override
    public BaseJsonVo getPublicPapers(PageForm pageForm, PaperEntity paperEntity, String userId) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(userId);
        users.add(userId);
        PageInfo<Map<String, Object>> pageInfo = this.orgPaperDomain.getPublicPages(pageForm.getCurrentPage(), pageForm.getPageSize(), paperEntity, users, userId);
        HashSet<String> paperIds = new HashSet<String>();
        pageInfo.getList().forEach(vo -> paperIds.add((String)vo.get("paperId")));
        this.logger.info("*****" + JsonUtils.toJson(paperIds, (boolean)false));
        QuestionEntity param = new QuestionEntity();
        param.setQuestionClassId(paperEntity.getQuestionClassId());
        param.setIsPublicColumn(1);
        List<QuestionEntity> publicQuestions = this.orgQuestionDomain.getList(param);
        ArrayList<String> publicColumns = new ArrayList<String>();
        publicColumns.add("\u8bbf\u8c08\u4eba");
        publicColumns.add("\u8bbf\u8c08\u65f6\u95f4");
        publicColumns.add("\u83b7\u5f97\u8d5e\u6570");
        int from = 3;
        for (QuestionEntity entity : publicQuestions) {
            publicColumns.add(from - 1, entity.getQuestionName());
            if (paperIds.size() > 0) {
                List<PaperAnswerEntity> paperAnswers = this.orgPaperAnswerDomain.findPublicAnswers(paperIds, entity.getId());
                for (PaperAnswerEntity answerEntity : paperAnswers) {
                    Optional<Map> map = pageInfo.getList().stream().filter(paper -> paper.get("paperId").equals(answerEntity.getPaperId())).findAny();
                    if (!map.isPresent()) continue;
                    String content = answerEntity.getAnswer();
                    if ("0001".equals(answerEntity.getAnswer())) {
                        content = "\u5185\u90e8\u7528\u6237";
                    }
                    if ("0002".equals(answerEntity.getAnswer())) {
                        content = "\u6d88\u8d39\u8005";
                    }
                    map.get().put(from == 3 ? "customerType" : "customerPic", content);
                    map.get().put("createTime", answerEntity.getCreateTime());
                }
            }
            ++from;
        }
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>();
        map.put("columns", publicColumns);
        map.put("data", (ArrayList<Object>)pageInfo);
        return BaseJsonVo.success(map);
    }

    @Override
    public BaseJsonVo modityPaperStatus(PaperEntity paperEntity, MallUserEntity userEntity) {
        String userId = this.orgPaperDomain.select(paperEntity.getId()).getUserId();
        if (!this.userInterface.isLeadership(userEntity.getUserId(), userId).booleanValue()) {
            return BaseJsonVo.error((String)"\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        boolean flag = false;
        PaperEntity temp = this.orgPaperDomain.select(paperEntity.getId());
        BaseJsonVo<OrgQuestionClassTimeoutVO> baseJsonVo = this.timeoutDomain.isEdit(temp, temp.getUserId(), 2);
        OrgQuestionClassTimeoutVO timeoutVO2 = (OrgQuestionClassTimeoutVO)baseJsonVo.getValue();
        if (timeoutVO2 != null) {
            Date e = timeoutVO2.getEndTime();
            this.logger.info("\u5ba1\u6279\u7ed3\u675f\u65f6\u95f4:{}", (Object)timeoutVO2.getEndTime());
            this.logger.info("\u5ba1\u6279\u7ed3\u675f\u65f6\u95f4:{}", (Object)DateUtils.formatDate((Date)e, (String)""));
            this.logger.info("\u5f53\u524d\u65f6\u95f4:{}", (Object)DateUtils.now());
            if (e != null && e.after(DateUtils.now())) {
                flag = true;
            }
            this.logger.info("flag:{}", (Object)flag);
        } else {
            this.logger.info("\u672a\u914d\u7f6e\u5ba1\u6279\u65f6\u95f4,\u53d6\u9ed8\u8ba4\u7684");
            flag = this.periodService.checkCurrentPeriodOrLastPeriod(temp.getPeriodId());
        }
        if (flag) {
            paperEntity.setUpdateTime(new Date());
            this.orgPaperDomain.update(paperEntity);
            return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u8bc4\u4ef7\u5931\u8d25,\u5df2\u8fc7\u8bc4\u4ef7\u65f6\u9650!");
    }

    private void getStatus(PaperEntity paperEntity, String userId, PaperPageListVo c, Set<String> users1) {
        if (c.getQuestionClassId() == 1 && c.getQuestionClassId() == 2 && c.getReportStatus() == 3) {
            c.setReportStatus(1);
        }
        if (c.getStatus() == null || c.getStatus() == 0) {
            c.setStatus(0);
            c.setStatusName("\u672a\u586b\u5199");
            c.setIsVote(0);
            c.setCommit("");
            c.setVoteNum(0);
        }
        this.logger.info("getStatus.isEdit.begin");
        BaseJsonVo<OrgQuestionClassTimeoutVO> timeoutVOBaseJsonVo = this.isEdit(c, userId, users1);
        this.logger.info("getStatus.isEdit.end");
        OrgQuestionClassTimeoutVO timeoutVO = (OrgQuestionClassTimeoutVO)timeoutVOBaseJsonVo.getValue();
        if (timeoutVO != null) {
            Date s = timeoutVO.getStartTime();
            Date e = timeoutVO.getEndTime();
            c.setStartEditTime(s == null ? "" : DateUtils.formatDate((Date)s, (String)"yyyy-MM-dd HH:mm:ss"));
            c.setEndEditTime(e == null ? "" : DateUtils.formatDate((Date)e, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (paperEntity.getQuestionClassId() == 16) {
            c.setIsEdit(1);
        } else {
            c.setIsEdit(timeoutVOBaseJsonVo.isSuccess() ? 1 : 0);
        }
        c.setIsLeaderEdit(this.isLeaderEdit(c, userId) ? 1 : 0);
        c.setIsDissentEdit(this.isDissentEdit(c, userId) ? 1 : 0);
        c.setIsLeader(0);
        if (users1 != null && users1.contains(c.getUserId())) {
            if (userId.equals(c.getUserId())) {
                c.setIsLeader(5);
            } else if (this.userInterface.isLeadershipRelationNew(userId, c.getUserId()).booleanValue()) {
                c.setIsLeader(6);
            } else {
                c.setIsLeader(4);
            }
        } else if (this.userInterface.isLeadershipRelationNew(userId, c.getUserId()).booleanValue()) {
            c.setIsLeader(2);
        } else if (this.userInterface.isLeadership(userId, c.getUserId()).booleanValue() && !userId.equals(c.getUserId())) {
            c.setIsLeader(1);
        } else if (!userId.equals(c.getUserId())) {
            c.setIsLeader(3);
        }
        this.logger.info("getStatus.isLeadershipRelation.end");
        if (!userId.equals(c.getUserId())) {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
                VoteEntity queryVote = new VoteEntity();
                queryVote.setVoteUserId(userId);
                queryVote.setPeriodId(paperEntity.getPeriodId());
                queryVote.setQuestionClassId(paperEntity.getQuestionClassId());
                queryVote.setUserId(c.getUserId());
                queryVote.setVoteType(1);
                VoteEntity voteEntity = this.orgVoteService.getVoteEntity(queryVote);
                if (voteEntity != null) {
                    c.setIsVote(2);
                    c.setVoteNum(1);
                    c.setCommit(StringUtils.isNotEmpty((String)voteEntity.getCommit()) ? voteEntity.getCommit() : "\u672a\u8bc4\u8bba");
                } else {
                    this.timeoutDomain.isEdit(paperEntity, paperEntity.getUserId(), 2);
                    OrgQuestionClassTimeoutVO timeoutVO2 = (OrgQuestionClassTimeoutVO)timeoutVOBaseJsonVo.getValue();
                    boolean flag = false;
                    if (timeoutVO2 != null) {
                        Date e = timeoutVO2.getEndTime();
                        this.logger.info("\u5ba1\u6279\u7ed3\u675f\u65f6\u95f4:{}", (Object)timeoutVO2.getEndTime());
                        if (e != null && e.after(DateUtils.now())) {
                            flag = true;
                        }
                    } else {
                        this.logger.info("\u672a\u914d\u7f6e\u5ba1\u6279\u65f6\u95f4,\u53d6\u9ed8\u8ba4\u7684");
                        flag = this.periodService.checkCurrentPeriodOrLastPeriod(paperEntity.getPeriodId());
                    }
                    c.setIsVote(flag ? 1 : 0);
                    c.setCommit("");
                    c.setVoteNum(0);
                }
            } else {
                c.setIsVote(0);
            }
        } else {
            if (c.getStatus() == 1) {
                c.setStatusName("\u5df2\u586b\u5199");
            }
            c.setIsVote(0);
        }
    }

    @Override
    public List<String> getThankTwiceThisMonth(String userId) {
        String monthStart = DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyy-MM") + "-01 00:00:00";
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.now());
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        String monthEnd = DateUtils.formatDate((Date)cal.getTime(), (String)"yyyy-MM-dd") + " 00:00:00";
        List<String> thankTwiceThisMonth = this.orgPaperAnswerDomain.getThankTwiceThisMonth(userId, monthStart, monthEnd);
        return thankTwiceThisMonth;
    }

    @Override
    public List<PaperEntity> getPaperByPeriodId(List<Integer> periodIdList, String userId, Integer questionClassId) {
        return this.orgPaperDomain.getPaperByPeriodId(periodIdList, userId, questionClassId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfo(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfo(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByWeek(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByWeek(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByMonth(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByMonth(periodIdList, questionClassId, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getPaperNumInfoByStatus(List<Integer> periodIdList, Integer questionClassId, String userId) {
        return this.orgPaperDomain.getPaperNumInfoByStatus(periodIdList, questionClassId, userId);
    }

    @Override
    public BaseJsonVo modityWeekAfterWeek(Integer id, String userId, Integer isFinishLeader, Integer isFinishEmploye, Boolean checked) {
        PaperAnswerRelationEntity relationEntity;
        if (checked == null) {
            checked = false;
        }
        if ((relationEntity = this.relationService.getPaperAnswerRelationEntityById(id)) == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        PaperAnswerEntity answerEntity = this.paperAnswerDomain.select(relationEntity.getAnswerId());
        if (answerEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
        }
        this.updatePaperTimeByParam(answerEntity.getPaperId());
        BaseJsonVo js = this.relationService.modityRelationAnswer(id, userId, isFinishLeader, isFinishEmploye);
        List<PaperAnswerRelationEntity> relationEntities = this.relationService.getAllAnswerByParam(answerEntity.getId());
        if (checked.booleanValue()) {
            Integer reportStatus = 0;
            reportStatus = relationEntities.stream().filter(c -> Integer.valueOf(1).equals(c.getIsFinishLeader())).count() == (long)relationEntities.size() ? Integer.valueOf(2) : (relationEntities.stream().filter(c -> Integer.valueOf(0).equals(c.getIsFinishLeader())).count() == (long)relationEntities.size() ? Integer.valueOf(3) : Integer.valueOf(1));
            PaperEntity paperEntity = (PaperEntity)this.paperService.selectByPrimaryKey((Serializable)((Object)answerEntity.getPaperId()));
            if (paperEntity == null) {
                return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1");
            }
            paperEntity.setReportStatus(reportStatus);
            this.paperService.updateByPrimaryKeySelective(paperEntity);
        }
        return js;
    }

    @Override
    public BaseJsonVo saveRemarkInfo(Integer id, String leaderRemark, String employRemark) {
        BaseJsonVo js = this.relationService.saveRemarkInfo(id, leaderRemark, employRemark);
        return js;
    }

    @Override
    public BaseJsonVo saveIsDissentInfo(Integer id, Integer isDissentLeader, Integer isDissent) {
        BaseJsonVo js = this.relationService.saveIsDissentInfo(id, isDissentLeader, isDissent);
        return js;
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportDataKpi(PaperEntity paperEntity) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(paperEntity.getUserId());
        users.add(paperEntity.getUserId());
        Set<String> users1 = this.userInterface.getFinancialSubordinate(paperEntity.getUserId());
        if (users1 != null) {
            users.addAll(users1);
        }
        List<LinkedHashMap<String, String>> lst = this.orgPaperDomain.getExportDataKpi(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), users);
        return lst;
    }

    @Override
    public List<LinkedHashMap<String, String>> getExportData(PaperEntity paperEntity) {
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResource(paperEntity.getUserId());
        users.add(paperEntity.getUserId());
        List<LinkedHashMap<String, String>> lst = this.orgPaperDomain.getExportData(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), users);
        HashedMap listMap = new HashedMap();
        int i = 0;
        for (LinkedHashMap<String, String> m : lst) {
            for (String k : m.keySet()) {
                Optional<CodeNameVo> optional;
                List codeNameVos1;
                QuestionEntity questionEntity;
                if (k.indexOf("#") < 0) continue;
                Integer id = Integer.valueOf(k.split("#")[0]);
                if (i == 0 && (questionEntity = this.orgQuestionDomain.select(id)) != null) {
                    List codeNameVos;
                    if (questionEntity.getQuestionType() == 2 && (codeNameVos = JsonUtils.getListByArray(CodeNameVo.class, (String)questionEntity.getQuestionOption())) != null) {
                        listMap.put(questionEntity.getId(), codeNameVos);
                    }
                    if (questionEntity.getQuestionType() == 9) {
                        listMap.put(questionEntity.getId(), questionEntity.getId());
                    }
                }
                if (listMap.get(id) instanceof List && (codeNameVos1 = (List)listMap.get(id)) != null && codeNameVos1.size() > 0 && (optional = codeNameVos1.stream().filter(c -> c.getCode().equals(m.get(k))).findFirst()).isPresent()) {
                    m.put(k, optional.get().getName());
                }
                if (!(listMap.get(id) instanceof Integer) || (Integer)listMap.get(id) != 42) continue;
                this.logger.info("codename:9");
                codeNameVos1 = JsonUtils.getListByArray(CodeNameVo.class, (String)m.get(k));
                this.logger.info("codename1:" + (codeNameVos1 == null ? "0" : JsonUtils.toJson((Object)codeNameVos1, (boolean)false)));
                if (codeNameVos1 == null) continue;
                Object[] os = codeNameVos1.stream().filter(c -> c.getCheck() == 1).map(c -> c.getName()).toArray();
                this.logger.info("codename2:" + JsonUtils.toJson((Object)os, (boolean)false));
                if (os == null) continue;
                StringBuilder sb = new StringBuilder();
                for (Object o : os) {
                    sb.append(o.toString());
                    sb.append(",");
                }
                m.put(k, sb.toString());
            }
            ++i;
        }
        return lst;
    }

    @Override
    public List<OrgTypeNumEntity> getWeekNumInfoAll(List<Integer> periodIdList, String userId) {
        return this.orgPaperDomain.getWeekNumInfoAll(periodIdList, userId);
    }

    @Override
    public List<OrgTypeNumEntity> getWeekNumInfoByFinish(List<Integer> periodIdList, String userId) {
        return this.orgPaperDomain.getWeekNumInfoByFinish(periodIdList, userId);
    }

    @Override
    public List<PaperAnswerEntity> getAnswerInfoByParam(List<Integer> periodIdList, String userId) {
        return this.orgPaperDomain.getAnswerInfoByParam(periodIdList, userId);
    }

    @Override
    public BaseJsonVo buildPaperByWeekAfter(String userId, Integer classId, Integer periodId) {
        PeriodEntity periodEntity = this.periodService.getPeriodEntity(periodId);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)userId) || classId == null) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(classId);
        if (!periodType.equals(periodEntity.getPeriodType())) {
            return BaseJsonVo.error((String)"\u8be5\u62a5\u544a\u7c7b\u578b\u548c\u671f\u6b21\u7c7b\u578b\u4e0d\u5bf9\u5e94");
        }
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(IDGenerate.getUniqueIdStr());
        paperEntity.setQuestionClassId(classId);
        paperEntity.setPeriodId(periodEntity.getId());
        paperEntity.setPeriodName(periodEntity.getPeriodDesc());
        paperEntity.setUserId(userId);
        paperEntity.setBonus(new BigDecimal(0));
        paperEntity.setReportStatus(0);
        paperEntity.setUpdateTime(new Date());
        MallUserEntity userEntity = this.userInterface.getMallUser(userId);
        if (userEntity != null) {
            paperEntity.setUserName(userEntity.getUserNick());
        }
        paperEntity.setCreateTime(new Date());
        paperEntity.setStatus(0);
        return this.savePaperByWeekAfter(paperEntity);
    }

    public BaseJsonVo savePaperByWeekAfter(PaperEntity paperEntity) {
        int i = 0;
        paperEntity.setUpdateTime(new Date());
        PaperEntity search = new PaperEntity();
        search.setPeriodId(paperEntity.getPeriodId());
        search.setUserId(paperEntity.getUserId());
        search.setQuestionClassId(paperEntity.getQuestionClassId());
        PaperEntity paperExists = this.orgPaperDomain.getSingle(search);
        if (StringUtils.isEmpty((String)paperEntity.getId())) {
            paperEntity.setId(IDGenerate.getUniqueIdStr());
        }
        if (paperExists == null) {
            i = this.orgPaperDomain.savePaperInfo(paperEntity);
        }
        return i > 0 ? BaseJsonVo.success((Object)paperEntity.getId()) : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @Override
    public int updatePaperStatusByParam(PaperEntity paperEntity) {
        paperEntity.setUpdateTime(new Date());
        return this.orgPaperDomain.updatePaperStatusByParam(paperEntity);
    }

    @Override
    public BaseJsonVo isUPdateFlag(String loginUserId) {
        List<DictionaryEntity> validDictionaryList = this.dictionaryInterface.getValidDictionaryList(1000, 208);
        if (validDictionaryList.size() > 0) {
            MallUserEntity user = this.userInterface.getMallUser(loginUserId);
            if (validDictionaryList.stream().filter(c -> c.getDictionaryName().equals(user.getUserName())).count() <= 0L) {
                return BaseJsonVo.error((String)"\u6ca1\u6709\u6743\u9650");
            }
        } else {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u6743\u9650");
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public void updatePaperTimeByParam(String paperId) {
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(paperId);
        paperEntity.setUpdateTime(new Date());
        this.orgPaperDomain.update(paperEntity);
    }

    @Override
    public void updatePaperExportStatusByParam(String paperId, String jiandaoyunId) {
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setId(paperId);
        paperEntity.setIsExport(1);
        paperEntity.setExportTime1(new Date());
        paperEntity.setExportId(jiandaoyunId);
        this.orgPaperDomain.update(paperEntity);
    }

    @Override
    public List<Map<String, Object>> getSubordinateUnConfirmReport(String loginId) {
        Set<String> subordinate = this.userInterface.getDirectSubordinate(loginId, false);
        subordinate.remove(loginId);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        HashedMap map = new HashedMap();
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u786e\u8ba4\u7684\u7528\u6237\u8bbf\u8c08");
        map.put("url", "#/" + this.getPathNameByquestionClassId(1));
        map.put("questionClassName", "\u7528\u6237\u8bbf\u8c08");
        Set<String> users = this.permittedUsersService.findAllPermittedUsersFromResourceWithoutCache(loginId, this.getPathNameByquestionClassId(1), (Boolean)false);
        users.remove(loginId);
        map.put("list", this.orgPaperDomain.getUserAndGrowthUnConfirmReport(1, loginId, users, null).stream().sorted(Comparator.comparing(PaperEntity::getUserName).thenComparing(PaperEntity::getPeriodId).reversed()).collect(Collectors.toList()));
        maps.add((Map<String, Object>)map);
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u786e\u8ba4\u7684\u5b66\u4e60\u6210\u957f");
        map.put("url", "#/" + this.getPathNameByquestionClassId(2));
        map.put("questionClassName", "\u5b66\u4e60\u6210\u957f");
        users = this.permittedUsersService.findAllPermittedUsersFromResourceWithoutCache(loginId, this.getPathNameByquestionClassId(2), (Boolean)false);
        users.remove(loginId);
        map.put("list", this.orgPaperDomain.getUserAndGrowthUnConfirmReport(2, loginId, users, null).stream().sorted(Comparator.comparing(PaperEntity::getUserName).thenComparing(PaperEntity::getPeriodId).reversed()).collect(Collectors.toList()));
        maps.add((Map<String, Object>)map);
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u786e\u8ba4\u7684\u5468\u4e8b\u5468\u6bd5");
        map.put("url", "#/" + this.getPathNameByquestionClassId(3));
        map.put("questionClassName", "\u5468\u62a5");
        map.put("list", this.getUnConfirmWeekReport(subordinate, loginId, 9));
        maps.add((Map<String, Object>)map);
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u786e\u8ba4\u7684\u6708\u590d\u76d8");
        map.put("url", "#/" + this.getPathNameByquestionClassId(8));
        map.put("questionClassName", "\u6708\u590d\u76d8");
        map.put("list", this.getUnConfirmWeekReport(subordinate, loginId, 8));
        maps.add((Map<String, Object>)map);
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u786e\u8ba4\u7684\u6708\u4ef7\u503c\u8bc4\u4f30");
        map.put("url", "#/" + this.getPathNameByquestionClassId(10));
        map.put("questionClassName", "\u6708\u4ef7\u503c\u8bc4\u4f30");
        map.put("list", this.orgPaperDomain.getUnConfirmKpi(subordinate, null).stream().sorted(Comparator.comparing(PaperEntity::getUserName).thenComparing(PaperEntity::getPeriodId).reversed()).collect(Collectors.toList()));
        maps.add((Map<String, Object>)map);
        map = new HashedMap();
        map.put("name", "\u5f85\u6211\u6253\u5206\u7684\u5b63\u5ea6KPI");
        map.put("url", "http://erpnew.lechun.cc/admin_sys_performance_mine.html");
        map.put("questionClassName", "\u5b63\u5ea6KPI");
        map.put("list", this.getUnConfirmWeekReport(subordinate, loginId, 14));
        maps.add((Map<String, Object>)map);
        return maps;
    }

    private List<PaperEntity> getUnConfirmWeekReport(Set<String> users, String loginId, Integer questionClassId) {
        List<Object> rtn = new ArrayList();
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setQuestionClassId(questionClassId);
        paperEntity.setReportStatus(0);
        paperEntity.setStatus(1);
        if (questionClassId == 8) {
            paperEntity.setIsNice(0);
        }
        List<PaperEntity> paperEntities = this.orgPaperDomain.getPaperList(paperEntity, users, loginId);
        if (questionClassId == 9) {
            for (PaperEntity p : paperEntities) {
                paperEntity = new PaperEntity();
                paperEntity.setQuestionClassId(3);
                paperEntity.setStatus(1);
                paperEntity.setPeriodId(p.getPeriodId());
                paperEntity.setUserId(p.getUserId());
                PaperEntity pp = (PaperEntity)this.getSingle(paperEntity);
                if (pp == null) continue;
                rtn.add(pp);
            }
        } else {
            rtn = paperEntities;
        }
        return rtn.stream().sorted(Comparator.comparing(PaperEntity::getUserName).thenComparing(PaperEntity::getPeriodId).reversed()).collect(Collectors.toList());
    }

    private String getPathNameByquestionClassId(Integer questionClassId) {
        String path = "";
        switch (questionClassId) {
            case 1: {
                path = "userinterview";
                break;
            }
            case 2: {
                path = "growth";
                break;
            }
            case 3: {
                path = "cooperate";
                break;
            }
            case 8: {
                path = "monthreplay";
                break;
            }
            case 9: {
                path = "weekafterweek";
                break;
            }
            case 10: {
                path = "quarterkpi";
                break;
            }
        }
        return path;
    }

    private List<PaperEntity> WeekUnWriteRemind(PeriodEntity curPeriod, PeriodEntity lastPeriod, Integer questionClassId) {
        PaperEntity search = new PaperEntity();
        search.setStatus(0);
        search.setPeriodId(questionClassId == 3 ? curPeriod.getId() : lastPeriod.getId());
        search.setQuestionClassId(questionClassId);
        return this.orgPaperDomain.getPaperList(search, null, "");
    }

    /*
     * WARNING - void declaration
     */
    private List<PaperEntity> UnConfirmWeekEndRemind(PeriodEntity curPeriod, PeriodEntity lastPeriod, Integer questionClassId, Integer remindType) {
        PaperEntity paperEntity = new PaperEntity();
        paperEntity.setQuestionClassId(questionClassId);
        paperEntity.setReportStatus((Integer)(questionClassId == 9 && remindType == 5 ? null : Integer.valueOf(0)));
        paperEntity.setStatus(1);
        paperEntity.setPeriodId(questionClassId == 3 || questionClassId == 9 ? curPeriod.getId() : lastPeriod.getId());
        List<Object> paperEntities = new ArrayList();
        if (Integer.valueOf(10).equals(questionClassId)) {
            paperEntities = Integer.valueOf(3).equals(remindType) ? this.orgPaperDomain.getSelfUnConfirmKpi(null, lastPeriod.getId()) : this.orgPaperDomain.getUnConfirmKpi(null, lastPeriod.getId());
        } else if (Integer.valueOf(9).equals(questionClassId)) {
            if (Integer.valueOf(3).equals(remindType)) {
                paperEntities = this.orgPaperDomain.selfUnConfirmWeekEndRemind(null, lastPeriod.getId());
            }
            if (Integer.valueOf(2).equals(remindType) || Integer.valueOf(4).equals(remindType) || Integer.valueOf(6).equals(remindType) || Integer.valueOf(7).equals(remindType)) {
                ArrayList<Integer> periods = new ArrayList<Integer>();
                periods.add(paperEntity.getPeriodId());
                BaseJsonVo<List<OrgWeekEndUnFinishVo>> unfinshList = this.relationService.getWeekEndUnfinshList(periods);
                if (unfinshList.isSuccess()) {
                    void var9_13;
                    ArrayList arrayList = new ArrayList();
                    if (remindType == 2 || remindType == 6) {
                        List list = ((List)unfinshList.getValue()).stream().filter(c -> c.getStatus() > 0).collect(Collectors.toList());
                    }
                    if (remindType == 4 || remindType == 7) {
                        List list = ((List)unfinshList.getValue()).stream().filter(c -> c.getStatus1() > 0).collect(Collectors.toList());
                    }
                    for (OrgWeekEndUnFinishVo finishVo : var9_13) {
                        paperEntities.add(this.selectByPrimaryKey((Serializable)((Object)finishVo.getPaperId())));
                    }
                }
            }
            if (Integer.valueOf(5).equals(remindType)) {
                paperEntities = this.orgPaperDomain.getPaperList(paperEntity, null, "");
            }
        } else {
            paperEntities = this.orgPaperDomain.getPaperList(paperEntity, null, "");
        }
        if (Integer.valueOf(3).equals(remindType) || Integer.valueOf(6).equals(remindType) || Integer.valueOf(7).equals(remindType)) {
            return paperEntities;
        }
        ArrayList<PaperEntity> leaderPaperEntities = new ArrayList<PaperEntity>();
        for (PaperEntity paperEntity2 : paperEntities) {
            MallUserEntity leaderUser;
            MallUserEntity userEntity = this.userInterface.getMallUser(paperEntity2.getUserId());
            if (userEntity == null || (leaderUser = this.userInterface.getMallUser(userEntity.getLeader())) == null || !StringUtils.isNotEmpty((String)leaderUser.getDingdingId())) continue;
            Optional<PaperEntity> optionalPaperEntity = leaderPaperEntities.stream().filter(c -> c.getUserId().equals(leaderUser.getUserId())).findFirst();
            if (!optionalPaperEntity.isPresent()) {
                PaperEntity leaderPaper = new PaperEntity();
                leaderPaper.setId(paperEntity2.getId());
                leaderPaper.setUserId(leaderUser.getUserId());
                leaderPaper.setUserName(paperEntity2.getUserName());
                leaderPaperEntities.add(leaderPaper);
                continue;
            }
            optionalPaperEntity.get().setUserName(optionalPaperEntity.get().getUserName() + "," + paperEntity2.getUserName());
        }
        return leaderPaperEntities;
    }

    private List<PaperEntity> unStandardUserAndGrowthRemind(PeriodEntity curPeriod, PeriodEntity lastPeriod, Integer questionClassId, Date today) {
        Set<Integer> periods = DateUtil.getWeekOfQuarter(today);
        Integer mod = 0;
        if (Integer.valueOf(1).equals(questionClassId)) {
            mod = 2;
        }
        if (Integer.valueOf(2).equals(questionClassId)) {
            mod = 3;
        }
        Integer min = (Integer)periods.stream().min((e, f) -> e.compareTo((Integer)f)).get();
        if ((curPeriod.getHeadPeriod() - min) % mod != 0) {
            return new ArrayList<PaperEntity>();
        }
        for (Integer p : periods) {
            PeriodEntity search = new PeriodEntity();
            search.setPeriodType(0);
            search.setHeadPeriod(p);
            search.setHeadYear(curPeriod.getHeadYear());
            PeriodEntity pp = (PeriodEntity)this.periodService.getSingle(search);
            p = pp.getId();
        }
        return this.orgPaperDomain.unStandardUserAndGrowthRemind(questionClassId, periods);
    }

    private List<PaperEntity> getQuarterlyKpi(PeriodEntity curPeriod, PeriodEntity lastPeriod, Integer questionClassId) {
        return null;
    }

    @Override
    public BaseJsonVo dingdingRemindSend(Date today, Integer questionClassId, Integer remindType) {
        Integer periodType = this.periodService.getPeriodTypeByQuestionClass(questionClassId);
        String remindType4 = "\u4eb2\u7231\u7684leader\uff0c\u60a8\u7684\u56e2\u961f\u6210\u5458{0}\uff08\u53d6\u81ea\u5468\u4e94\u7684\u7edf\u8ba1\u7ed3\u679c\uff09\u622a\u81f3\u5468\u4e94\u5e76\u672a\u5468\u4e8b\u5468\u6bd5\u3002\u8bf7\u53ca\u65f6\u68c0\u67e5\u4ed6/\u5979\u662f\u5426\u5df2\u7ecf\u5728\u5468\u672b\u5b8c\u6210\u4e86\u5e94\u4ea4\u4ed8\u7684\u4efb\u52a1\u5e76\u53ca\u65f6\u786e\u8ba4\u548c\u53cd\u9988\u300c\u5468\u4e8b\u5468\u6bd5\u300d\u54e6~\u9700\u8981\u60a8\u5bf9\u300c\u6bcf\u4e00\u9879\u300d\u90fd\u6253\u52fe\u786e\u8ba4\u5b8c\u6210\u624d\u4f1a\u7b97\u6210\u4e00\u6b21\u201c\u5468\u4e8b\u5468\u6bd5\u201d\uff0c\u8bf7\u60a8\u767e\u5fd9\u4e4b\u4e2d\u62bd\u51fa\u65f6\u95f4\u4e8e20:00\u524d\u5b8c\u6210\uff0c\u8c22\u8c22";
        String remindType5 = "\u4eb2\u7231\u7684leader\uff0c\u8bf7\u60a8\u53ca\u65f6\u786e\u8ba4\u548c\u53cd\u9988\u56e2\u961f\u6210\u5458\u672c\u5468\u7684\u300c\u5468\u4e8b\u5468\u6bd5\u300d\u4efb\u52a1\uff0c\u8fd9\u4e9b\u4efb\u52a1\u9700\u8981\u56e2\u961f\u4f19\u4f34\u5468\u4e94\u4ea4\u4ed8\uff0c\u56e2\u961f\u6210\u5458\u5468\u4e8b\u5468\u6bd5\u7684\u5b8c\u6210\u60c5\u51b5\u5173\u7cfb\u5230\u5927\u5bb6\u6bcf\u4e2a\u5b63\u5ea6\u7684\u6210\u957f\u4f53\u7cfb\u8868\u73b0\uff0c\u8bf7\u4e8e\u5468\u4e00\u4e0b\u534814:00\u524d\u5b8c\u6210\u4e0e\u56e2\u961f\u6210\u5458\u7684\u53cc\u5411\u786e\u8ba4\u54e6";
        String remindType6 = "\u4eb2\u7231\u7684\u5c0f\u4f19\u4f34\uff0c\u5f88\u9057\u61be\uff0c\u622a\u81f3\u672c\u5468\u4e9420:00\u60a8\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1\u672a\u6309\u65f6\u5b8c\u6210\uff0c\u8bf7\u5468\u672b\u5230\u516c\u53f8\u7ee7\u7eed\u594b\u6218\uff0c\u4ea4\u4ed8\u672c\u5468\u7684\u4efb\u52a1\uff0c\u4f7f\u547d\u5fc5\u8fbe\uff01";
        String remindType7 = "\u4eb2\u7231\u7684\u5c0f\u4f19\u4f34\uff0c\u5f88\u9057\u61be\uff0c\u622a\u81f3\u672c\u5468\u65e520:00\u60a8\u7684\u5468\u4e8b\u5468\u6bd5\u4efb\u52a1\u672a\u6309\u65f6\u5b8c\u6210\uff0c\u8bf7\u4e0b\u5468\u5230\u516c\u53f8\u73b0\u573a\u529e\u516c\uff0c\u6309\u65f6\u4ea4\u4ed8\u5de5\u4f5c\u4efb\u52a1\uff0c\u4f7f\u547d\u5fc5\u8fbe\uff01";
        BaseJsonVo<PeriodEntity> curPeriod = this.periodService.getPeriod(today, periodType);
        if (!curPeriod.isSuccess()) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u671f\u4e0d\u5b58\u5728");
        }
        BaseJsonVo<PeriodEntity> lastPeriod = this.periodService.getLastPeriod(((PeriodEntity)curPeriod.getValue()).getId());
        if (!lastPeriod.isSuccess()) {
            return BaseJsonVo.error((String)"\u4e0a\u4e00\u671f\u4e0d\u5b58\u5728");
        }
        QuestionClassEntity classEntity = this.questionClassDomain.select(questionClassId);
        if (classEntity == null) {
            return BaseJsonVo.error((String)"\u95ee\u9898\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List<Object> paperEntities = new ArrayList();
        paperEntities = Integer.valueOf(1).equals(questionClassId) || Integer.valueOf(2).equals(questionClassId) && Integer.valueOf(2).equals(remindType) ? this.unStandardUserAndGrowthRemind((PeriodEntity)curPeriod.getValue(), (PeriodEntity)lastPeriod.getValue(), questionClassId, today) : (Integer.valueOf(1).equals(remindType) ? this.WeekUnWriteRemind((PeriodEntity)curPeriod.getValue(), (PeriodEntity)lastPeriod.getValue(), questionClassId) : this.UnConfirmWeekEndRemind((PeriodEntity)curPeriod.getValue(), (PeriodEntity)lastPeriod.getValue(), questionClassId, remindType));
        Integer successCount = 0;
        Integer i = 0;
        for (PaperEntity p : paperEntities) {
            BaseJsonVo jsonVo;
            String content;
            MallUserEntity userEntity = this.userInterface.getMallUser(p.getUserId());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            String key = "dingdingRemindSend_" + p.getId() + p.getUserId() + remindType;
            Object o = this.redisCacheUtil.get(key);
            if (o != null) continue;
            this.paperSendlogInterface.saveSendlog(p.getId(), userEntity.getDingdingId(), userEntity.getUserNick(), questionClassId, remindType, classEntity.getUnwriteTitle() + "|" + classEntity.getUnwriteRemind(), "", "");
            if (userEntity != null && Integer.valueOf(1).equals(userEntity.getStatus()) && StringUtils.isNotEmpty((String)userEntity.getDingdingId())) {
                Integer n3 = successCount;
                Integer n4 = successCount = Integer.valueOf(successCount + 1);
            }
            i = 0;
            String string = Integer.valueOf(1).equals(remindType) ? classEntity.getUnwriteRemind() : (content = Integer.valueOf(2).equals(remindType) ? classEntity.getConfirmRemind() : classEntity.getSelfConfirmRemind());
            if (questionClassId == 9 && Integer.valueOf(4).equals(remindType)) {
                content = remindType4.replace("{0}", p.getUserName());
            }
            if (questionClassId == 9 && Integer.valueOf(5).equals(remindType)) {
                content = remindType5;
            }
            if (questionClassId == 9 && Integer.valueOf(6).equals(remindType)) {
                content = remindType6;
            }
            if (questionClassId == 9 && Integer.valueOf(7).equals(remindType)) {
                content = remindType7;
            }
            if (userEntity == null || !Integer.valueOf(1).equals(userEntity.getStatus()) || !StringUtils.isNotEmpty((String)userEntity.getDingdingId()) || !(jsonVo = this.dingdingUtils.sendOAMessage(userEntity.getDingdingId(), "", content)).isSuccess()) continue;
            long l = DateUtil.getRemainSecondsOneDay(new Date());
        }
        return BaseJsonVo.success((Object)"\u53d1\u9001\u5b8c\u6210");
    }

    @Override
    public BaseJsonVo updateHistoryWeekEndFinishStatus(String date) {
        PeriodEntity lastEntity = (PeriodEntity)this.periodService.getLastPeriodByType(0).getValue();
        PeriodEntity currEntity = (PeriodEntity)this.periodService.currentPeriod(0).getValue();
        if (StringUtils.isNotEmpty((String)date) && (currEntity = (PeriodEntity)this.periodService.getPeriod(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"), 0).getValue()) != null) {
            lastEntity = (PeriodEntity)this.periodService.getLastPeriod(currEntity.getId()).getValue();
        }
        if (lastEntity == null) {
            return BaseJsonVo.error((String)"\u4e0a\u5468\u4e0d\u5b58\u5728");
        }
        if (currEntity == null) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u5468\u4e0d\u5b58\u5728");
        }
        if (lastEntity.getId() == 385) {
            PaperEntity paperEntity = new PaperEntity();
            paperEntity.setPeriodId(lastEntity.getId());
            paperEntity.setQuestionClassId(9);
            List<PaperEntity> lastPapers = this.orgPaperDomain.getList(paperEntity);
            paperEntity.setPeriodId(currEntity.getId());
            List<PaperEntity> currPapers = this.orgPaperDomain.getList(paperEntity);
            for (PaperEntity p : currPapers) {
                Optional<PaperEntity> lastOp = lastPapers.stream().filter(c -> c.getUserId().equals(p.getUserId())).findFirst();
                if (!lastOp.isPresent()) continue;
                p.setFinishWorkhour(lastOp.get().getFinishWorkhour());
                p.setFinishCount1(lastOp.get().getFinishCount1());
                p.setFinishCount(lastOp.get().getFinishCount());
                p.setUnfinishCount(lastOp.get().getUnfinishCount());
                p.setUnfinishCount1(lastOp.get().getUnfinishCount1());
                this.updateByPrimaryKey(p);
            }
            return BaseJsonVo.success((Object)"");
        }
        ArrayList<Integer> periods = new ArrayList<Integer>();
        periods.add(lastEntity.getId());
        BaseJsonVo<List<OrgWeekEndUnFinishVo>> jsonVo = this.relationService.getWeekEndfinshList(periods);
        if (jsonVo.isSuccess()) {
            List finishVos = (List)jsonVo.getValue();
            for (OrgWeekEndUnFinishVo v : finishVos) {
                PaperEntity paperEntity = new PaperEntity();
                paperEntity.setUserId(v.getUserId());
                paperEntity.setPeriodId(currEntity.getId());
                paperEntity.setQuestionClassId(9);
                if ((paperEntity = (PaperEntity)this.getSingle(paperEntity)) == null) continue;
                if (v.getStatus() == 1) {
                    paperEntity.setUnfinishCount(v.getStatus() + v.getUnfinishCount());
                    paperEntity.setFinishCount(0);
                } else {
                    paperEntity.setUnfinishCount(0);
                    paperEntity.setFinishCount(v.getTotalFinishCount());
                    paperEntity.setFinishWorkhour(v.getFinishWorkhour());
                }
                if (v.getStatus1() == 1) {
                    paperEntity.setUnfinishCount1(v.getStatus1() + v.getUnfinishCount1());
                    paperEntity.setFinishCount1(0);
                } else {
                    paperEntity.setUnfinishCount1(0);
                    paperEntity.setFinishCount1(v.getTotalFinishCount1());
                }
                this.updateByPrimaryKey(paperEntity);
            }
        }
        return BaseJsonVo.success((Object)"");
    }
}

