/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.organization.domain.OrgQuestionClassDomain;
import cc.lechun.organization.entity.QuestionClassEntity;
import cc.lechun.organization.entity.QuestionEntity;
import cc.lechun.organization.entity.QuestionListVo;
import cc.lechun.organization.idomain.IOrgQuestionDomain;
import cc.lechun.organization.iservice.IOrgQuestionQueryService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgQuestionQueryService
extends BaseService
implements IOrgQuestionQueryService {
    @Autowired
    private IOrgQuestionDomain questionService;
    @Autowired
    private OrgQuestionClassDomain questionClassService;

    @Override
    @ReadThroughSingleCache(namespace="OrgQuestionQueryService.getQuestionList", expiration=300)
    public List<QuestionListVo> getQuestionList(@ParameterValueKeyProvider Integer quetionClassId) {
        ArrayList<QuestionListVo> resultList = new ArrayList<QuestionListVo>();
        QuestionClassEntity questionClassEntity = this.questionClassService.getQuestionClassEntity(quetionClassId);
        List<QuestionClassEntity> questionClassEntityList = this.questionClassService.getQuestionClassEntityList(quetionClassId);
        if (questionClassEntityList == null || questionClassEntityList.size() == 0) {
            QuestionEntity questionEntity = new QuestionEntity();
            questionEntity.setQuestionClassId(quetionClassId);
            List<QuestionEntity> list = this.questionService.getQuestionList(quetionClassId, 1);
            list.forEach(q -> {
                QuestionListVo questionListDomain = new QuestionListVo();
                BeanUtils.copyProperties((Object)q, (Object)questionListDomain);
                questionListDomain.setQuestionClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
                if (questionListDomain != null) {
                    resultList.add(questionListDomain);
                }
            });
        }
        ArrayList list = new ArrayList();
        questionClassEntityList.forEach(c -> {
            QuestionEntity questionEntity = new QuestionEntity();
            questionEntity.setQuestionClassId(quetionClassId);
            List<QuestionEntity> tempList = this.questionService.getQuestionList(c.getClassId(), 1);
            if (tempList != null && tempList.size() > 0) {
                tempList.forEach(q -> {
                    QuestionListVo questionListDomain = new QuestionListVo();
                    BeanUtils.copyProperties((Object)q, (Object)questionListDomain);
                    questionListDomain.setQuestionClassName(questionClassEntity == null ? "" : questionClassEntity.getClassName());
                    questionListDomain.setChildQuestionClassName(c == null ? "" : c.getClassName());
                    if (questionListDomain != null) {
                        resultList.add(questionListDomain);
                    }
                });
            }
        });
        return resultList;
    }

    @Override
    public BaseJsonVo saveQuestion(QuestionEntity questionEntity) {
        QuestionEntity query = new QuestionEntity();
        query.setQuestionName(questionEntity.getQuestionName());
        QuestionEntity temp = this.questionService.getSingle(query);
        if (temp != null) {
            return BaseJsonVo.error((String)"\u95ee\u9898\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        if (questionEntity.getId() == null) {
            return this.questionService.insert(questionEntity) ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
        }
        return this.questionService.update(questionEntity) ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }
}

