/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.organization.service;

import cc.lechun.common.constants.CommonConstants;
import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import cc.lechun.organization.dao.PeriodMapper;
import cc.lechun.organization.entity.PeriodEntity;
import cc.lechun.organization.iservice.IPeriodService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PeriodService
extends BaseService<PeriodEntity, Integer>
implements IPeriodService {
    private static final String CURRENT_PERIOD = "CURRENT_PERIOD";
    @Autowired
    PeriodMapper periodMapper;
    @Autowired
    RedisCacheUtil<PeriodEntity> redisService;
    @Autowired
    SysUserInterface userInterface;
    @Autowired
    DictionaryInterface dictionaryService;
    @Autowired
    private IPeriodService periodService;

    @Override
    public List<PeriodEntity> getPeriodEntityList(Integer periodType) {
        PeriodEntity periodEntity = new PeriodEntity();
        periodEntity.setPeriodType(periodType);
        return this.periodMapper.getList(periodEntity);
    }

    @Override
    public Boolean checkCurrentPeriodOrLastPeriod(int periodId) {
        this.logger.info("periodId >>>>>>>> " + periodId);
        BaseJsonVo<PeriodEntity> jsonVo = this.periodService.isInPeriod(periodId);
        Boolean temp = jsonVo.isSuccess();
        if (temp.booleanValue()) {
            return true;
        }
        PeriodEntity periodEntity = (PeriodEntity)this.periodService.selectByPrimaryKey(Integer.valueOf(periodId));
        if (periodEntity == null) {
            return false;
        }
        BaseJsonVo<PeriodEntity> baseJsonVo = this.getLastPeriodByType(periodEntity.getPeriodType());
        if (baseJsonVo.isSuccess()) {
            return periodId == ((PeriodEntity)baseJsonVo.getValue()).getId();
        }
        return false;
    }

    @Override
    public PeriodEntity getPeriodEntity(int id) {
        String key = "getPeriodEntity_new_" + id;
        Object o = this.redisService.get(key);
        if (o != null) {
            return (PeriodEntity)o;
        }
        PeriodEntity p = (PeriodEntity)this.periodMapper.selectByPrimaryKey(Integer.valueOf(id));
        if (p != null) {
            this.redisService.set(key, (Object)p, Long.valueOf(300L));
        }
        return p;
    }

    private PeriodEntity getCurrentPeriod() {
        return this.getCurrentPeriod(0);
    }

    private PeriodEntity getCurrentPeriod(Integer type) {
        Object periodObject;
        if (this.redisService.exists("CURRENT_PERIOD_" + type) && (periodObject = this.redisService.get("CURRENT_PERIOD_" + type)) instanceof PeriodEntity) {
            return (PeriodEntity)periodObject;
        }
        PeriodEntity periodEntity = this.periodMapper.getCurrentPeriod(type);
        this.setCurrentPeriodCache(periodEntity);
        return periodEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentPeriodCache(PeriodEntity periodEntity) {
        Class<PeriodService> clazz = PeriodService.class;
        synchronized (PeriodService.class) {
            long expire;
            if (periodEntity == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (!this.redisService.exists("CURRENT_PERIOD_" + periodEntity.getPeriodType()) && (expire = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)periodEntity.getPeriodEnd(), (int)1))) > 60L) {
                this.redisService.set("CURRENT_PERIOD_" + periodEntity.getPeriodType(), (Object)periodEntity, Long.valueOf(expire - 60L));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(Date date, Integer type) {
        PeriodEntity periodEntity = this.getCurrentPeriod(type);
        if (date.compareTo(periodEntity.getPeriodStart()) >= 0 && date.compareTo(periodEntity.getPeriodStart()) <= 0) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(String date, Integer type) {
        Date thisDate = DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
        thisDate = thisDate == null ? DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd") : thisDate;
        return this.isInPeriod(thisDate, type);
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriod(int id) {
        PeriodEntity p = this.getPeriodEntity(id);
        this.logger.info("p >>>>>>>> " + JsonUtils.toJson((Object)p, (boolean)false));
        PeriodEntity periodEntity = p;
        if (p != null) {
            periodEntity = this.getCurrentPeriod(p.getPeriodType());
            this.logger.info("periodEntity >>>>>>>> " + JsonUtils.toJson((Object)periodEntity, (boolean)false));
            if (periodEntity != null && periodEntity.getId() != null) {
                this.logger.info("equals >>>>>>>> " + (periodEntity.getId() == id));
                if (periodEntity.getId() == id) {
                    return BaseJsonVo.success((Object)periodEntity);
                }
            }
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isNextPeriod(int id) {
        PeriodEntity periodEntity = this.getPeriodEntity(id);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        if ((periodEntity = this.getCurrentPeriod(periodEntity.getPeriodType())) == null) {
            return BaseJsonVo.error((String)"\u5f53\u524d\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        BaseJsonVo<PeriodEntity> baseJsonVo = this.getNextPeriod(periodEntity.getId());
        if (!baseJsonVo.isSuccess()) {
            return BaseJsonVo.error((String)"\u4e0b\u4e00\u671f\u6b21\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        periodEntity = (PeriodEntity)baseJsonVo.getValue();
        if (periodEntity.getId() == id) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(Date date, Integer type) {
        PeriodEntity periodEntity = this.getCurrentPeriod(type);
        if (date.compareTo(periodEntity.getPeriodStart()) >= 0 && date.compareTo(periodEntity.getPeriodStart()) <= 0) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        PeriodEntity lastPeriod = (PeriodEntity)this.getLastPeriodByType(type).getValue();
        if (date.compareTo(lastPeriod.getPeriodStart()) >= 0 && date.compareTo(lastPeriod.getPeriodEnd()) <= 0) {
            long dateDiffSecond = DateUtils.getDateDiffSecond((Date)periodEntity.getPeriodStart(), (Date)date);
            DictionaryEntity delay_hours = this.dictionaryService.getDictionary(CommonConstants.DEFAULT_PLATFORM_GROUP_ID, 58, "DELAY_HOURS");
            if (delay_hours != null && dateDiffSecond < (long)(Integer.valueOf(delay_hours.getDictionaryName()) * 3600)) {
                return BaseJsonVo.success((Object)lastPeriod);
            }
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(String date, Integer type) {
        Date thisDate = DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd HH:mm:ss");
        thisDate = thisDate == null ? DateUtils.StrToDate((String)date, (String)"yyyy-MM-dd") : thisDate;
        return this.isInPeriodWithDelay(thisDate, type);
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithDelay(int id) {
        PeriodEntity periodEntity = null;
        for (int type = 0; type < 4; ++type) {
            PeriodEntity lastPeriod;
            periodEntity = this.getCurrentPeriod(type);
            if (periodEntity != null && periodEntity.getId() == id) {
                return BaseJsonVo.success((Object)periodEntity);
            }
            BaseJsonVo<PeriodEntity> baseJsonVo = this.getLastPeriodByType(type);
            if (!baseJsonVo.isSuccess() || id != (lastPeriod = (PeriodEntity)baseJsonVo.getValue()).getId()) continue;
            long dateDiffSecond = DateUtils.getDateDiffSecond((Date)periodEntity.getPeriodStart(), (Date)DateUtils.now());
            DictionaryEntity delay_hours = this.dictionaryService.getDictionary(CommonConstants.DEFAULT_PLATFORM_GROUP_ID, 58, "DELAY_HOURS");
            if (delay_hours == null || dateDiffSecond >= (long)(Integer.valueOf(delay_hours.getDictionaryName()) * 3600)) continue;
            return BaseJsonVo.success((Object)lastPeriod);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> isInPeriodWithNum(Integer year, int periodNum, Integer type) {
        PeriodEntity periodEntity = this.getCurrentPeriod(type);
        if (year.intValue() == periodEntity.getHeadYear().intValue() && periodEntity.getHeadPeriod() == periodNum) {
            return BaseJsonVo.success((Object)periodEntity);
        }
        BaseJsonVo periodVo = BaseJsonVo.error();
        periodVo.setValue((Object)periodEntity);
        return periodVo;
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriodWithNum(Integer year, int periodNum, Integer type) {
        PeriodEntity param = new PeriodEntity();
        param.setHeadYear(year);
        param.setHeadPeriod(periodNum);
        param.setPeriodType(type);
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error(null);
    }

    @Override
    public BaseJsonVo<PeriodEntity> currentPeriod(Integer type) {
        return BaseJsonVo.success((Object)this.getCurrentPeriod(type));
    }

    @Override
    public BaseJsonVo<PeriodEntity> getLastPeriodByType(Integer type) {
        PeriodEntity currentPeriod = (PeriodEntity)this.currentPeriod(type).getValue();
        if (currentPeriod == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        PeriodEntity param = new PeriodEntity();
        param.setPeriodType(type);
        param.setPeriodEnd(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodStart(), (int)-1));
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo<PeriodEntity> getLastPeriod(int id) {
        PeriodEntity currentPeriod = this.getPeriodEntity(id);
        PeriodEntity param = new PeriodEntity();
        param.setPeriodEnd(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodStart(), (int)-1));
        param.setPeriodType(currentPeriod.getPeriodType());
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0a\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriodByPeriod(int period) {
        return this.getPeriodByPeriod(period, 0);
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriodByPeriod(int period, Integer type) {
        BaseJsonVo<PeriodEntity> baseJsonVo = this.getLastPeriodByType(type);
        if (baseJsonVo.isSuccess()) {
            PeriodEntity param = new PeriodEntity();
            param.setPeriodEnd(DateUtils.getAddDateByDay((Date)((PeriodEntity)baseJsonVo.getValue()).getPeriodStart(), (int)(-(period * 7 + 1))));
            List list = this.periodMapper.getList(param);
            if (list != null && list.size() > 0) {
                return BaseJsonVo.success(list.get(0));
            }
            return BaseJsonVo.error((String)("\u83b7\u53d6" + period * 7 + "\u5929\u524d\u7684\u671f\u6b21\u51fa\u9519"));
        }
        return BaseJsonVo.error((String)("\u83b7\u53d6" + period * 7 + "\u5929\u524d\u7684\u671f\u6b21\u51fa\u9519"));
    }

    @Override
    public BaseJsonVo<PeriodEntity> getNextPeriod(int id) {
        PeriodEntity currentPeriod = this.getPeriodEntity(id);
        PeriodEntity param = new PeriodEntity();
        param.setPeriodStart(DateUtils.getAddDateByDay((Date)currentPeriod.getPeriodEnd(), (int)1));
        param.setPeriodType(currentPeriod.getPeriodType());
        List list = this.periodMapper.getList(param);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u4e0b\u4e00\u4e2a\u671f\u6b21");
    }

    @Override
    public BaseJsonVo createPeriods() {
        int whatDayOfWeekTodayIs;
        Integer count = this.userInterface.getRoleUserCount(29);
        PeriodEntity currentDayPeriod = this.getCurrentPeriod(4);
        PeriodEntity nextDayPeriod = new PeriodEntity();
        nextDayPeriod.setPeriodType(4);
        nextDayPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)currentDayPeriod.getPeriodEnd(), (int)1));
        List daySearchResult = this.periodMapper.getList(nextDayPeriod);
        if (daySearchResult == null || daySearchResult.size() == 0) {
            nextDayPeriod.setPeriodEnd(nextDayPeriod.getPeriodStart());
            nextDayPeriod.setHeadYear(Integer.valueOf(DateUtils.formatDate((Date)nextDayPeriod.getPeriodStart(), (String)"yyyy")));
            nextDayPeriod.setHeadPeriod(nextDayPeriod.getHeadYear().intValue() == currentDayPeriod.getHeadYear().intValue() ? currentDayPeriod.getHeadPeriod() + 1 : 1);
            nextDayPeriod.setPeriodDesc(nextDayPeriod.getHeadYear() + "\u5e74\u7b2c" + nextDayPeriod.getHeadPeriod() + "\u5929(" + DateUtils.formatDate((Date)nextDayPeriod.getPeriodStart(), (String)"MM.dd") + ")");
            nextDayPeriod.setParticipantNumber(count);
            nextDayPeriod.setInMonth(this.getMonth(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
            nextDayPeriod.setInQuarter(this.getQuarter(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
            this.periodMapper.insert(nextDayPeriod);
        }
        if ((whatDayOfWeekTodayIs = DateUtils.getWeekIndexOfDate((Date)DateUtils.now())) > 5) {
            PeriodEntity currentWeekPeriod = this.getCurrentPeriod(0);
            PeriodEntity nextWeekPeriod = new PeriodEntity();
            nextWeekPeriod.setPeriodType(0);
            nextWeekPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)currentWeekPeriod.getPeriodEnd(), (int)1));
            List weekSearchResult = this.periodMapper.getList(nextWeekPeriod);
            if (weekSearchResult == null || weekSearchResult.size() == 0) {
                nextWeekPeriod.setPeriodEnd(DateUtils.getAddDateByDay((Date)nextWeekPeriod.getPeriodStart(), (int)6));
                Calendar calendar = Calendar.getInstance();
                calendar.setFirstDayOfWeek(2);
                calendar.setTime(nextWeekPeriod.getPeriodStart());
                nextWeekPeriod.setHeadPeriod(calendar.get(3));
                nextWeekPeriod.setHeadYear(nextWeekPeriod.getHeadPeriod() == 1 ? currentWeekPeriod.getHeadYear() + 1 : currentWeekPeriod.getHeadYear());
                nextWeekPeriod.setPeriodDesc(nextWeekPeriod.getHeadYear() + "\u5e74\u7b2c" + nextWeekPeriod.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)nextWeekPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextWeekPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
                nextWeekPeriod.setParticipantNumber(count);
                nextDayPeriod.setInMonth(this.getMonth(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
                nextDayPeriod.setInQuarter(this.getQuarter(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
                this.periodMapper.insert(nextWeekPeriod);
            }
            PeriodEntity nextWeekAfterPeriod = new PeriodEntity();
            nextWeekAfterPeriod.setPeriodType(0);
            nextWeekAfterPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)nextWeekPeriod.getPeriodEnd(), (int)1));
            List weekAfterSearchResult = this.periodMapper.getList(nextWeekAfterPeriod);
            int i = 0;
            if (weekAfterSearchResult == null || weekAfterSearchResult.size() == 0) {
                nextWeekAfterPeriod.setPeriodEnd(DateUtils.getAddDateByDay((Date)nextWeekAfterPeriod.getPeriodStart(), (int)6));
                Calendar calendar = Calendar.getInstance();
                calendar.setFirstDayOfWeek(2);
                calendar.setTime(nextWeekPeriod.getPeriodStart());
                nextWeekAfterPeriod.setHeadPeriod(calendar.get(3));
                nextWeekAfterPeriod.setHeadYear(nextWeekPeriod.getHeadPeriod() == 1 ? currentWeekPeriod.getHeadYear() + 1 : currentWeekPeriod.getHeadYear());
                nextWeekAfterPeriod.setPeriodDesc(nextWeekAfterPeriod.getHeadYear() + "\u5e74\u7b2c" + nextWeekAfterPeriod.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)nextWeekAfterPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextWeekAfterPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
                nextWeekAfterPeriod.setParticipantNumber(count);
                i = this.periodMapper.insert(nextWeekAfterPeriod);
            }
        } else {
            this.logger.info(">>>>>>>\u4eca\u5929\u5468" + whatDayOfWeekTodayIs + "\u672a\u5230\u5468\u516d\u65e5\uff0c\u4e0d\u751f\u6210\u4e0b\u5468\u671f\u6b21");
        }
        Calendar calendar = Calendar.getInstance();
        int whatDayOfMonthTodayIs = calendar.get(5);
        if (whatDayOfMonthTodayIs > 24) {
            PeriodEntity currentMonthPeriod = this.getCurrentPeriod(1);
            PeriodEntity nextMonthPeriod = new PeriodEntity();
            nextMonthPeriod.setPeriodType(1);
            nextMonthPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)currentMonthPeriod.getPeriodEnd(), (int)1));
            List monthSearchResult = this.periodMapper.getList(nextMonthPeriod);
            if (monthSearchResult == null || monthSearchResult.size() == 0) {
                calendar.setTime(nextMonthPeriod.getPeriodStart());
                calendar.set(5, calendar.getActualMaximum(5));
                nextMonthPeriod.setPeriodEnd(calendar.getTime());
                nextMonthPeriod.setHeadPeriod(calendar.get(2) + 1);
                nextMonthPeriod.setHeadYear(calendar.get(1));
                nextMonthPeriod.setPeriodDesc(nextMonthPeriod.getHeadYear() + "\u5e74" + nextMonthPeriod.getHeadPeriod() + "\u6708(" + DateUtils.formatDate((Date)nextMonthPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextMonthPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
                nextMonthPeriod.setParticipantNumber(count);
                this.periodMapper.insert(nextMonthPeriod);
                nextDayPeriod.setInMonth(this.getMonth(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
                nextDayPeriod.setInQuarter(this.getQuarter(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
            }
        } else {
            this.logger.info(">>>>>>>\u672a\u523025\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u6708\u671f\u6b21");
        }
        PeriodEntity currentQuarterPeriod = this.getCurrentPeriod(2);
        long dateDiff = DateUtils.getDateDiff((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)currentQuarterPeriod.getPeriodEnd(), (int)1));
        if (dateDiff < 11L) {
            PeriodEntity nextQuarterPeriod = new PeriodEntity();
            nextQuarterPeriod.setPeriodType(2);
            nextQuarterPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)currentQuarterPeriod.getPeriodEnd(), (int)1));
            List quarterSearchResult = this.periodMapper.getList(nextQuarterPeriod);
            if (quarterSearchResult == null || quarterSearchResult.size() == 0) {
                Calendar cQ = Calendar.getInstance();
                cQ.setTime(nextQuarterPeriod.getPeriodStart());
                cQ.add(2, 2);
                cQ.set(5, cQ.getActualMaximum(5));
                nextQuarterPeriod.setPeriodEnd(cQ.getTime());
                switch (cQ.get(2)) {
                    case 2: {
                        nextQuarterPeriod.setHeadPeriod(1);
                        break;
                    }
                    case 5: {
                        nextQuarterPeriod.setHeadPeriod(2);
                        break;
                    }
                    case 8: {
                        nextQuarterPeriod.setHeadPeriod(3);
                        break;
                    }
                    case 11: {
                        nextQuarterPeriod.setHeadPeriod(4);
                    }
                }
                nextQuarterPeriod.setHeadYear(calendar.get(1));
                nextQuarterPeriod.setPeriodDesc(nextQuarterPeriod.getHeadYear() + "\u5e74\u7b2c" + nextQuarterPeriod.getHeadPeriod() + "\u5b63\u5ea6(" + DateUtils.formatDate((Date)nextQuarterPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextQuarterPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
                nextQuarterPeriod.setParticipantNumber(count);
                nextDayPeriod.setInQuarter(this.getQuarter(nextDayPeriod.getPeriodStart(), nextDayPeriod.getPeriodEnd()));
                this.periodMapper.insert(nextQuarterPeriod);
            }
        } else {
            this.logger.info(">>>>>>>\u672a\u5230\u5b63\u5ea6\u524d10\u5929\uff0c\u4e0d\u751f\u6210\u4e0b\u5b63\u5ea6\u671f\u6b21");
        }
        PeriodEntity currentYearPeriod = this.getCurrentPeriod(3);
        long dateYearDiff = DateUtils.getDateDiff((Date)DateUtils.now(), (Date)DateUtils.getAddDateByDay((Date)currentYearPeriod.getPeriodEnd(), (int)1));
        if (dateYearDiff < 16L) {
            PeriodEntity nextYearPeriod = new PeriodEntity();
            nextYearPeriod.setPeriodType(3);
            nextYearPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)currentQuarterPeriod.getPeriodEnd(), (int)1));
            List yearSearchResult = this.periodMapper.getList(nextYearPeriod);
            if (yearSearchResult == null || yearSearchResult.size() == 0) {
                Calendar cQ = Calendar.getInstance();
                cQ.setTime(nextYearPeriod.getPeriodStart());
                cQ.add(2, 11);
                cQ.set(5, cQ.getActualMaximum(5));
                nextYearPeriod.setPeriodEnd(cQ.getTime());
                nextYearPeriod.setHeadPeriod(1);
                nextYearPeriod.setHeadYear(calendar.get(1));
                nextYearPeriod.setPeriodDesc(nextYearPeriod.getHeadYear() + "\u5e74");
                nextYearPeriod.setParticipantNumber(count);
                this.periodMapper.insert(nextYearPeriod);
            }
        } else {
            this.logger.info(">>>>>>>\u672a\u5230\u5e74\u5ea6\u524d15\u5929\uff0c\u4e0d\u751f\u6210\u4e0b\u5e74\u671f\u6b21");
        }
        return BaseJsonVo.success(null);
    }

    @Override
    public BaseJsonVo createPeriod() {
        int whatDayTodayIs = DateUtils.getWeekIndexOfDate((Date)DateUtils.now());
        this.logger.info("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u4eca\u5929\u5468" + whatDayTodayIs);
        if (whatDayTodayIs < 6) {
            this.logger.info("\u672a\u5230\u5468\u516d\u65e5\uff0c\u4e0d\u751f\u6210\u4e0b\u5468\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u5230\u5468\u516d\u65e5\uff0c\u4e0d\u751f\u6210\u4e0b\u5468\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)(10 - DateUtils.getWeekIndexOfDate((Date)DateUtils.now())));
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        PeriodEntity entity = new PeriodEntity();
        entity.setPeriodType(0);
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(calendar.get(3));
        List list = this.periodMapper.getList(entity);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        Date periodStart = DateUtils.getAddDateByDay((Date)date, (int)-2);
        Date periodEnd = DateUtils.getAddDateByDay((Date)date, (int)4);
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        Integer count = this.userInterface.getRoleUserCount(29);
        entity.setParticipantNumber(count);
        entity.setPeriodDesc(calendar.get(1) + "\u5e74\u7b2c" + entity.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public BaseJsonVo createMonthPeriod() {
        Calendar calendar = Calendar.getInstance();
        int whatDayTodayIs = calendar.get(5);
        if (whatDayTodayIs < 28) {
            this.logger.info("\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u6708\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u6708\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)10);
        calendar.setTime(date);
        PeriodEntity entity = new PeriodEntity();
        entity.setPeriodType(1);
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(calendar.get(2) + 1);
        List list = this.periodMapper.getList(entity);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        calendar.set(5, 1);
        Date periodStart = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date periodEnd = calendar.getTime();
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        Integer count = this.userInterface.getRoleUserCount(29);
        entity.setParticipantNumber(count);
        entity.setPeriodDesc("" + calendar.get(1) + "\u5e74" + entity.getHeadPeriod() + "\u6708(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        this.periodMapper.insert(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public BaseJsonVo createQuarterPeriod() {
        Calendar calendar = Calendar.getInstance();
        int whatDayTodayIs = calendar.get(5);
        if (whatDayTodayIs < 28) {
            this.logger.info("\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u5b63\u5ea6\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u5b63\u5ea6\u671f\u6b21");
        }
        int whatMonthTodayIs = calendar.get(2);
        if (whatMonthTodayIs != 2 && whatMonthTodayIs != 5 && whatMonthTodayIs != 8 && whatMonthTodayIs != 11) {
            this.logger.info("\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u5b63\u5ea6\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u523028\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u5b63\u5ea6\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)10);
        calendar.setTime(date);
        int monthStart = calendar.get(2);
        int quarter = 0;
        switch (monthStart) {
            case 0: 
            case 1: 
            case 2: {
                monthStart = 0;
                quarter = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                monthStart = 3;
                quarter = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                monthStart = 6;
                quarter = 3;
                break;
            }
            default: {
                monthStart = 9;
                quarter = 4;
            }
        }
        PeriodEntity entity = new PeriodEntity();
        entity.setPeriodType(2);
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(quarter);
        List list = this.periodMapper.getList(entity);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        calendar.set(2, monthStart);
        calendar.set(5, 1);
        Date periodStart = calendar.getTime();
        calendar.add(2, 2);
        calendar.set(5, calendar.getActualMaximum(5));
        Date periodEnd = calendar.getTime();
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        Integer count = this.userInterface.getRoleUserCount(29);
        entity.setParticipantNumber(count);
        entity.setPeriodDesc("" + calendar.get(1) + "\u5e74\u7b2c" + (entity.getHeadPeriod() + 1) + "\u5b63\u5ea6(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        this.periodMapper.insert(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public BaseJsonVo createYearPeriod() {
        Calendar calendar = Calendar.getInstance();
        int whatDayTodayIs = calendar.get(5);
        int whatMonthTodayIs = calendar.get(2);
        if (whatMonthTodayIs != 11 || whatDayTodayIs < 28) {
            this.logger.info("\u672a\u523012\u670828\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u4e00\u5e74\u671f\u6b21");
            return BaseJsonVo.success((Object)"\u672a\u523012\u670828\u53f7\uff0c\u4e0d\u751f\u6210\u4e0b\u4e00\u5e74\u671f\u6b21");
        }
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.now(), (int)10);
        calendar.setTime(date);
        PeriodEntity entity = new PeriodEntity();
        entity.setPeriodType(3);
        entity.setHeadYear(calendar.get(1));
        entity.setHeadPeriod(1);
        List list = this.periodMapper.getList(entity);
        if (list != null && list.size() > 0) {
            return BaseJsonVo.success(list.get(0));
        }
        calendar.set(2, 0);
        calendar.set(5, 1);
        Date periodStart = calendar.getTime();
        calendar.set(2, 11);
        calendar.set(5, calendar.getActualMaximum(5));
        Date periodEnd = calendar.getTime();
        entity.setPeriodStart(periodStart);
        entity.setPeriodEnd(periodEnd);
        Integer count = this.userInterface.getRoleUserCount(29);
        entity.setParticipantNumber(count);
        entity.setPeriodDesc("" + calendar.get(1) + "\u5e74(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
        this.periodMapper.insert(entity);
        return BaseJsonVo.success((Object)entity);
    }

    @Override
    public void createPeriodInit(String dateStr) {
        Date initNow = DateUtils.getDateFromString((String)dateStr, (String)"yyyy-MM-dd");
        do {
            Date date = DateUtils.getAddDateByDay((Date)initNow, (int)3);
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(date);
            PeriodEntity entity = new PeriodEntity();
            entity.setHeadYear(calendar.get(1));
            entity.setHeadPeriod(calendar.get(3));
            Date periodStart = DateUtils.getAddDateByDay((Date)initNow, (int)1);
            Date periodEnd = DateUtils.getAddDateByDay((Date)initNow, (int)7);
            entity.setPeriodStart(periodStart);
            entity.setPeriodEnd(periodEnd);
            Integer count = this.userInterface.getRoleUserCount(29);
            entity.setParticipantNumber(count);
            entity.setPeriodDesc(calendar.get(1) + "\u5e74\u7b2c" + entity.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)entity.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)entity.getPeriodEnd(), (String)"MM.dd") + ")");
            this.logger.info(">>>>>>>>>>>" + JsonUtils.toJson((Object)entity, (boolean)true));
            this.periodMapper.insert(entity);
        } while ((initNow = DateUtils.getAddDateByDay((Date)initNow, (int)7)).compareTo(DateUtils.now()) <= 0);
    }

    @Override
    public BaseJsonVo<PeriodEntity> getPeriod(Date date, Integer type) {
        PeriodEntity periodEntity = this.periodMapper.getPeriod(DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd"), type);
        if (periodEntity == null) {
            return BaseJsonVo.error((String)"\u671f\u6b21\u4e0d\u5b58\u5728");
        }
        return BaseJsonVo.success((Object)periodEntity);
    }

    @Override
    public int getPeriodTypeByQuestionClass(int classId) {
        int type = 0;
        if (classId == 8) {
            type = 1;
        }
        if (classId == 10) {
            type = 2;
        }
        if (classId == 11) {
            type = 4;
        }
        if (classId == 14) {
            type = 2;
        }
        if (classId == 16) {
            type = 2;
        }
        return type;
    }

    @Override
    public List<PeriodEntity> getPeriodInfoByDate(Integer periodType, Date periodStart, Date periodEnd) {
        return this.periodMapper.getPeriodInfoByDate(periodType, periodStart, periodEnd);
    }

    @Override
    public List<PeriodEntity> getPeriodInfoByDateAll(Integer periodType, Date periodStart, Date periodEnd) {
        return this.periodMapper.getPeriodInfoByDateAll(periodType, periodStart, periodEnd);
    }

    @Override
    public BaseJsonVo createNextWeekPeriodInfo(Date periodEnd, int headYear) {
        Integer count = this.userInterface.getRoleUserCount(29);
        PeriodEntity nextWeekPeriod = new PeriodEntity();
        nextWeekPeriod.setPeriodType(0);
        nextWeekPeriod.setPeriodStart(DateUtils.getAddDateByDay((Date)periodEnd, (int)1));
        List weekSearchResult = this.periodMapper.getList(nextWeekPeriod);
        int i = 0;
        if (weekSearchResult == null || weekSearchResult.size() == 0) {
            nextWeekPeriod.setPeriodEnd(DateUtils.getAddDateByDay((Date)nextWeekPeriod.getPeriodStart(), (int)6));
            Calendar calendar = Calendar.getInstance();
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(nextWeekPeriod.getPeriodStart());
            nextWeekPeriod.setHeadPeriod(calendar.get(3));
            nextWeekPeriod.setHeadYear(nextWeekPeriod.getHeadPeriod() == 1 ? headYear + 1 : headYear);
            nextWeekPeriod.setPeriodDesc(nextWeekPeriod.getHeadYear() + "\u5e74\u7b2c" + nextWeekPeriod.getHeadPeriod() + "\u5468(" + DateUtils.formatDate((Date)nextWeekPeriod.getPeriodStart(), (String)"MM.dd") + "\u81f3" + DateUtils.formatDate((Date)nextWeekPeriod.getPeriodEnd(), (String)"MM.dd") + ")");
            nextWeekPeriod.setParticipantNumber(count);
            i = this.periodMapper.insert(nextWeekPeriod);
        }
        return BaseJsonVo.success((Object)i);
    }

    @Override
    public Integer savePeriodInfo(PeriodEntity periodEntity) {
        return this.periodMapper.savePeriodInfo(periodEntity);
    }

    private String getQuarter(Date sdate, Date edate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        int m = cal.get(2) + 1;
        int year = cal.get(1);
        cal.setTime(edate);
        int eday = cal.get(5);
        if (eday <= 3) {
            m = cal.get(2) + 1;
            year = cal.get(1);
        }
        String quarter = "";
        if (m >= 1 && m <= 3) {
            quarter = year + "Q1";
        }
        if (m >= 4 && m <= 6) {
            quarter = year + "Q2";
        }
        if (m >= 7 && m <= 9) {
            quarter = year + "Q3";
        }
        if (m >= 10 && m <= 12) {
            quarter = year + "Q4";
        }
        return quarter;
    }

    private String getMonth(Date sdate, Date edate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(edate);
        int eday = cal.get(5);
        if (eday <= 3) {
            return DateUtils.formatDate((Date)edate, (String)"yyyy-MM");
        }
        return DateUtils.formatDate((Date)sdate, (String)"yyyy-MM");
    }
}

