/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.active.groupon;

import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/grouponManage"})
public class GrouponManageController
extends BaseController {
    @Autowired
    private GrouponInterface grouponService;
    @Autowired
    private PlatFormInterface platFormService;

    @RequestMapping(value={"getGrouponOrderList"})
    public BaseJsonVo getGrouponOrderList(String activeNo) throws AuthorizeException {
        int platformGroupId = this.getUser().getPlatformGroupId();
        HashMap map = new HashMap();
        map.put("platFormList", this.platFormService.getValidPlatFormList(platformGroupId));
        map.put("grouponConfig", this.grouponService.getGrouponConfig(activeNo));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveGrouponConfig"})
    public BaseJsonVo saveGrouponConfig(GrouponConfigEntity grouponConfigEntity) {
        return this.grouponService.saveGrouponConfig(grouponConfigEntity) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"");
    }

    @RequestMapping(value={"getGrouponConfig"})
    public BaseJsonVo getGrouponConfig(String activeNo) throws AuthorizeException {
        int platformGroupId = this.getUser().getPlatformGroupId();
        HashMap map = new HashMap();
        map.put("platFormList", this.platFormService.getValidPlatFormList(platformGroupId));
        map.put("grouponConfig", this.grouponService.getGrouponConfig(activeNo));
        return BaseJsonVo.success(map);
    }
}

