/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.organization;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.organization.entity.PaperEntity;
import cc.lechun.organization.entity.VoteEntity;
import cc.lechun.organization.iservice.IOrgPaperService;
import cc.lechun.organization.iservice.IOrgVoteOperateService;
import cc.lechun.organization.iservice.IPaperReportBounsService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vote"})
public class VoteController
extends BaseController {
    @Autowired
    private IOrgVoteOperateService orgVoteOperateService;
    @Autowired
    private IPaperReportBounsService paperReportBounsService;
    @Autowired
    private IOrgPaperService paperService;

    @RequestMapping(value={"/getVoteList"})
    public BaseJsonVo getVoteList(PageForm pageForm, VoteEntity voteEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (voteEntity == null) {
            voteEntity = new VoteEntity();
        }
        voteEntity.setUserId(user.getUserId());
        return this.orgVoteOperateService.getVoteList(pageForm, voteEntity);
    }

    @RequestMapping(value={"/getRankingList"})
    public BaseJsonVo getRankingList(Integer questionClassId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return this.orgVoteOperateService.getRankingList(questionClassId);
    }

    @RequestMapping(value={"/saveVote"})
    public BaseJsonVo saveVote(String paperId, String commit, Integer voteType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (commit == null) {
            return BaseJsonVo.error((String)"\u8bc4\u8bba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (voteType == null) {
            voteType = 1;
        }
        if (commit.length() < 5) {
            return BaseJsonVo.error((String)"\u4e0d\u5c11\u4e8e5\u5b57\u7b26");
        }
        BaseJsonVo baseJsonVo = this.orgVoteOperateService.saveVote(user.getUserId(), paperId, commit, voteType);
        if (baseJsonVo.isSuccess()) {
            boolean flag;
            PaperEntity paperEntity = (PaperEntity)baseJsonVo.getValue();
            boolean bl = flag = (paperEntity.getQuestionClassId() == 1 || paperEntity.getQuestionClassId() == 2) && voteType == 1;
            if (flag) {
                this.paperReportBounsService.setReportStatusAsync(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), paperEntity);
            }
        }
        return baseJsonVo.isSuccess() ? BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f") : baseJsonVo;
    }

    @RequestMapping(value={"/testSaveVote"})
    public BaseJsonVo testSaveVote(String paperId, String commit, Integer voteType) throws AuthorizeException {
        PaperEntity paperEntity;
        BaseJsonVo baseJsonVo;
        if (commit == null) {
            return BaseJsonVo.error((String)"\u8bc4\u8bba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (voteType == null) {
            voteType = 1;
        }
        if ((baseJsonVo = this.orgVoteOperateService.saveVote("3296352363991805352", paperId, commit, voteType)).isSuccess() && ((paperEntity = (PaperEntity)baseJsonVo.getValue()).getQuestionClassId() == 1 || paperEntity.getQuestionClassId() == 2)) {
            this.paperReportBounsService.setReportStatusAsync(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), paperEntity);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/testCacSaveVote"})
    public BaseJsonVo testCacSaveVote(String paperId, String commit, Integer voteType) throws AuthorizeException {
        PaperEntity paperEntity;
        BaseJsonVo baseJsonVo;
        if (commit == null) {
            return BaseJsonVo.error((String)"\u8bc4\u8bba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (voteType == null) {
            voteType = 1;
        }
        if ((baseJsonVo = this.orgVoteOperateService.saveVote("3296352363991805352", paperId, commit, voteType)).isSuccess() && ((paperEntity = (PaperEntity)baseJsonVo.getValue()).getQuestionClassId() == 1 || paperEntity.getQuestionClassId() == 2)) {
            this.paperReportBounsService.setReportStatusAsync(paperEntity.getPeriodId(), paperEntity.getQuestionClassId(), paperEntity);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/testCaC"})
    public BaseJsonVo testCaC(String paperId, String commit, Integer voteType) throws AuthorizeException {
        PaperEntity paperEntity = (PaperEntity)this.paperService.selectByPrimaryKey((Serializable)((Object)paperId));
        if (paperEntity.getQuestionClassId() == 1 || paperEntity.getQuestionClassId() == 2) {
            this.paperReportBounsService.calculateBonuses(paperEntity);
        }
        return BaseJsonVo.success((Object)"");
    }
}

