/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.platform;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.platform.PlatFormTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.platform.PlatFormGroupEntity;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/platform"})
public class PlatformController
extends BaseController {
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;
    @Autowired
    private PlatFormInterface platFormInterface;

    @RequestMapping(value={"/getplatformlist"})
    @ResponseBody
    public List<PlatFormEntity> getPlatformList() throws AuthorizeException {
        return this.getUserPlatFormList();
    }

    @RequestMapping(value={"/getplatformlist2"})
    @ResponseBody
    public List<PlatFormEntity> getplatformlist2() throws AuthorizeException {
        return this.getUserPlatFormList2();
    }

    @RequestMapping(value={"/getplatformlist2Test"})
    @ResponseBody
    public List<PlatFormEntity> getplatformlist2Test() throws AuthorizeException {
        return this.getUserPlatFormList(1000);
    }

    @RequestMapping(value={"/getPlatFormGroupList"})
    @ResponseBody
    public BaseJsonVo getPlatFormGroupList(PageForm pageForm) {
        return BaseJsonVo.success((Object)this.platFormGroupInterface.getPlatFormGroupList(pageForm.getCurrentPage(), pageForm.getPageSize()));
    }

    @RequestMapping(value={"/saveOrUpdatePlatFormGroup"})
    @ResponseBody
    public BaseJsonVo saveOrUpdatePlatFormGroup(PlatFormGroupEntity platFormGroupEntity) {
        if (platFormGroupEntity.getPlatformGroupId() == null || platFormGroupEntity.getPlatformGroupId() == 0) {
            this.platFormGroupInterface.savePlatFormGroup(platFormGroupEntity);
        } else {
            this.platFormGroupInterface.updatePlatFormGroup(platFormGroupEntity);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getPlatFormTypeList"})
    @ResponseBody
    public BaseJsonVo getPlatFormTypeList() throws AuthorizeException {
        return BaseJsonVo.success((Object)PlatFormTypeEnum.getList());
    }

    @RequestMapping(value={"/getAllPlatFormList"})
    @ResponseBody
    public BaseJsonVo getAllPlatFormList(PageForm pageForm, int platformGroupId) {
        PageInfo pageInfo = this.platFormInterface.getPlatFormList(pageForm.getCurrentPage(), pageForm.getPageSize(), platformGroupId);
        pageInfo.getList().forEach(platFormEntityVo -> platFormEntityVo.setPlatformTypeName(PlatFormTypeEnum.getName((int)platFormEntityVo.getPlatformType())));
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/saveOrUpdatePlatForm"})
    @ResponseBody
    public BaseJsonVo saveOrUpdatePlatForm(PlatFormEntity platFormEntity) {
        if (platFormEntity.getPlatformId() == null || platFormEntity.getPlatformId() == 0) {
            this.platFormInterface.savePlatForm(platFormEntity);
        } else {
            this.platFormInterface.updatePlatForm(platFormEntity);
        }
        return BaseJsonVo.success((Object)"");
    }
}

