/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.sales.RegularTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallRegularEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/regular"})
public class MallRegularController
extends BaseController {
    @Autowired
    private MallRegularInterface mallRegularInterface;

    @RequestMapping(value={"/findAllProducts"})
    @ResponseBody
    public BaseJsonVo findAllProducts() throws AuthorizeException {
        return this.mallRegularInterface.findAllProducts(this.getUser().getPlatformGroupId());
    }

    @RequestMapping(value={"/saveOrUpdateRegularProduct"})
    @ResponseBody
    public BaseJsonVo saveOrUpdateRegularProduct(Integer regularProductId, String productId, String productName, Integer channelType) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (user.getPlatformGroupId() == 0) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u9650\u4fee\u6539\uff0c\u65e0\u6240\u5c5e\u5206\u7ec4");
        }
        return this.mallRegularInterface.saveOrUpdateRegularProduct(regularProductId, productId, productName, channelType, this.getUser().getPlatformGroupId());
    }

    @RequestMapping(value={"/getRegularTypeList"})
    @ResponseBody
    public BaseJsonVo getRegularTypeList() {
        return BaseJsonVo.success((Object)RegularTypeEnum.getList());
    }

    @RequestMapping(value={"/getRegularList"})
    @ResponseBody
    public BaseJsonVo getRegularList(PageForm pageForm) throws AuthorizeException {
        PageInfo pageInfo = this.mallRegularInterface.getRegularList(pageForm.getCurrentPage(), pageForm.getPageSize(), this.getUser().getPlatformGroupId().intValue());
        pageInfo.getList().forEach(mallRegularEntityVo -> {
            mallRegularEntityVo.setRegularTypeName(RegularTypeEnum.getName((int)mallRegularEntityVo.getRegularType()));
            mallRegularEntityVo.setPlatformGroupName(this.getUserValidPlatFormGroupName(mallRegularEntityVo.getPlatformGroupId()));
        });
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/saveOrUpdateRegular"})
    @ResponseBody
    public BaseJsonVo saveOrUpdateRegular(MallRegularEntity mallRegularEntity) throws AuthorizeException {
        if (this.getUser().getPlatformGroupId() == 0) {
            return BaseJsonVo.paramError((String)"\u8bf7\u4f7f\u7528\u5bf9\u5e94\u516c\u53f8\u8d26\u6237\u64cd\u4f5c");
        }
        mallRegularEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        return this.mallRegularInterface.saveOrUpdateRegular(mallRegularEntity);
    }
}

