/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sys;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.user.MallRoleEntity;
import cc.lechun.mall.entity.user.MallRoleResourceEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.user.SysRoleInterface;
import cc.lechun.mall.iservice.user.SysUserInterface;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/role"})
public class RoleController
extends BaseController {
    @Autowired
    private SysRoleInterface sysRoleInterface;
    @Autowired
    private SysUserInterface sysUserInterface;

    @RequestMapping(value={"/saveOrUpdateMallRole"})
    @ResponseBody
    public BaseJsonVo saveOrUpdateMallRole(MallRoleEntity mallRoleEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (mallRoleEntity.getRoleId() != null && mallRoleEntity.getRoleId() != 0) {
            if (!user.getPlatformGroupId().equals(this.sysRoleInterface.getMallRole(mallRoleEntity.getRoleId().intValue()).getPlatformGroupId())) {
                return BaseJsonVo.paramError((String)"\u65e0\u6743\u9650\u4fee\u6539");
            }
            return this.sysRoleInterface.updateMallRole(mallRoleEntity);
        }
        if (!user.getPlatformGroupId().equals(mallRoleEntity.getPlatformGroupId())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u9650\u4fee\u6539");
        }
        return this.sysRoleInterface.saveMallRole(mallRoleEntity);
    }

    @RequestMapping(value={"/getMallRoleList"})
    @ResponseBody
    public BaseJsonVo getMallRoleList(PageForm pageForm, String roleName, String userId) throws AuthorizeException {
        PageInfo pageInfo = this.sysRoleInterface.getMallRoleList(pageForm.getCurrentPage(), pageForm.getPageSize(), roleName, this.getUser().getPlatformGroupId().intValue(), userId);
        pageInfo.getList().forEach(mallRoleEntityVo -> mallRoleEntityVo.setPlatformGroupName(this.getUserValidPlatFormGroupName(mallRoleEntityVo.getPlatformGroupId())));
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/findRoleList"})
    @ResponseBody
    public BaseJsonVo findRoleList() {
        List roles = this.sysRoleInterface.getAllRoles();
        return BaseJsonVo.success((Object)roles);
    }

    @RequestMapping(value={"/getMallRoleResourceList"})
    @ResponseBody
    public BaseJsonVo getMallRoleResourceList(PageForm pageForm, String roleId, int resourceType) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.sysUserInterface.getMallRoleResourceList(pageForm.getCurrentPage(), pageForm.getPageSize(), roleId, resourceType));
    }

    @RequestMapping(value={"/saveRoleResource"})
    @ResponseBody
    public BaseJsonVo saveRoleResource(@RequestBody HashMap map) throws AuthorizeException {
        List ls;
        MallUserEntity user = this.getUser();
        if (map.get("roleId") == null) {
            return BaseJsonVo.paramError((String)"\u53c2\u6570\u9519\u8bef");
        }
        int roleId = Integer.parseInt(map.get("roleId").toString());
        MallRoleEntity mallRoleEntity = this.sysRoleInterface.getMallRole(roleId);
        if (!user.getPlatformGroupId().equals(mallRoleEntity.getPlatformGroupId())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u9650\u4fee\u6539");
        }
        if (map.get("resourceIds") != null && (ls = (List)map.get("resourceIds")) != null && ls.size() > 0) {
            ls.forEach(o -> {
                MallRoleResourceEntity mallRoleResourceEntity = new MallRoleResourceEntity();
                mallRoleResourceEntity.setRoleId(Integer.valueOf(roleId));
                mallRoleResourceEntity.setResourceId((Integer)o.get("resourceId"));
                this.sysUserInterface.saveRoleResource(mallRoleResourceEntity);
            });
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/deleteRoleResource"})
    @ResponseBody
    public BaseJsonVo deleteRoleResource(int id) throws AuthorizeException {
        this.sysUserInterface.deleteRoleResource((long)id);
        return BaseJsonVo.success((Object)"");
    }
}

