/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.weixin;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.weixin.WeiXinGroupEntity;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.weixin.WeiXinGroupInterface;
import cc.lechun.mall.iservice.weixin.WeiXinGroupUserInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/weiXinGroupManage"})
public class WeiXinGroupController
extends BaseController {
    @Autowired
    private WeiXinGroupUserInterface groupUserInterface;
    @Autowired
    private WeiXinGroupInterface groupInterface;
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private PlatFormInterface platFormService;

    @RequestMapping(value={"/getGroupList"})
    private PageInfo getGroupList(PageForm pageForm, WeiXinGroupEntity groupEntity) throws AuthorizeException {
        groupEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        return this.groupInterface.getGroupList(pageForm.getCurrentPage(), pageForm.getPageSize(), groupEntity);
    }

    @RequestMapping(value={"/getGroups"})
    public BaseJsonVo getGroups(Integer platformId) throws AuthorizeException {
        return this.groupInterface.getGroups(this.getUser().getPlatformGroupId(), platformId);
    }

    @RequestMapping(value={"/getGroup"})
    public Map<String, Object> getGroup(String groupId) {
        HashedMap map = new HashedMap();
        WeiXinGroupEntity groupEntity = this.groupInterface.getGroup(groupId);
        map.put("groupEntity", groupEntity);
        map.put("keywordList", this.weiXinKeywordService.getEnableKeywordList(groupEntity.getPlatformId()));
        return map;
    }

    @RequestMapping(value={"/saveGroup"})
    public BaseJsonVo saveGroup(WeiXinGroupEntity groupEntity) throws AuthorizeException {
        groupEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        boolean b = this.groupInterface.saveGroup(groupEntity);
        if (b) {
            return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @RequestMapping(value={"/uploadGroupUsers"})
    public BaseJsonVo uploadGroupUsers(int platformId, String groupId) throws AuthorizeException {
        this.groupInterface.uploadGroupUsers(platformId, groupId);
        return BaseJsonVo.success((Object)"\u5df2\u63d0\u4ea4\u7528\u6237\u4e0a\u4f20\u64cd\u4f5c");
    }

    @RequestMapping(value={"/getSendMessageStatus"})
    public BaseJsonVo getSendMessageStatus(int platformId, String groupId) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        return this.groupInterface.getSendMessageStatus(platformId, groupId);
    }

    @RequestMapping(value={"/sendMessage"})
    public BaseJsonVo sendMessage(Integer platformId, String wxuserName, String groupId) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        if (wxuserName != null && !wxuserName.trim().isEmpty()) {
            return this.groupInterface.prevMessage(platformId, wxuserName, groupId);
        }
        return this.groupInterface.sendMessage(platformGroupId.intValue(), platformId.intValue(), groupId);
    }

    @RequestMapping(value={"/delMessage"})
    public BaseJsonVo delMessage(Integer platformId, String groupId, String actIndex) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        return this.groupInterface.delMessage(platformGroupId.intValue(), platformId.intValue(), groupId, actIndex);
    }

    @RequestMapping(value={"/sendCustomizedMessage"})
    public BaseJsonVo sendCustomizedMessage(Integer platformId, String groupId, String openId) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        return this.groupInterface.sendCustomizedMessage(platformId, groupId, openId);
    }

    @RequestMapping(value={"/deleteByGroupId"})
    public BaseJsonVo deleteByGroupId(Integer platformId, String groupId) throws AuthorizeException {
        Integer platformGroupId = this.getUser().getPlatformGroupId();
        boolean b = this.groupUserInterface.deleteByGroupId(groupId);
        if (b) {
            return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
        }
        return BaseJsonVo.error((String)"\u5220\u9664\u5931\u8d25");
    }

    @RequestMapping(value={"/searchGroup1"})
    public BaseJsonVo searchGroup1(Map<String, Object> map) {
        boolean buyRecord = Boolean.valueOf(map.get("buyRecord") == null ? "false" : map.get("buyRecord").toString());
        if (map.get("dateRange") == null) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4");
        }
        ArrayList dataeRange = (ArrayList)map.get("dateRange");
        String beginTime = (String)dataeRange.get(0);
        String endTime = (String)dataeRange.get(1);
        String haveCashticket = map.get("haveCashticket") == null ? "" : map.get("haveCashticket").toString();
        String noCashticket = map.get("noCashticket") == null ? "" : map.get("noCashticket").toString();
        int searchType = Integer.parseInt(map.get("searchType") == null ? "1" : map.get("searchType").toString());
        return BaseJsonVo.success(map);
    }
}

