/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.cashticket;

import cc.lechun.active.form.cash.CashticketBatchQuaryForm;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.cashticket.CashCreateTypeEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashRuleSearchVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketExportVo;
import cc.lechun.mall.entity.cashticket.CashticketUserInfoEntity;
import cc.lechun.mall.entity.cashticket.EnableCashticketVo;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.form.cashticket.CashUseRuleForm;
import cc.lechun.mall.form.cashticket.CashUseRuleItem;
import cc.lechun.mall.iservice.cashticket.CashticketBatchInterface;
import cc.lechun.mall.iservice.cashticket.CashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.cashticket.CashticketClassInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.cashticket.CashticketInterface;
import cc.lechun.mall.iservice.cashticket.CashticketUserInfoInterface;
import cc.lechun.mall.service.cashticket.cashRule.CashRuleContext;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cash"})
public class CashTicketController
extends BaseController {
    @Autowired
    private CashticketBatchInterface cashticketBatchInterface;
    @Autowired
    private CashticketClassInterface cashticketClassInterface;
    @Autowired
    private CashticketUserInfoInterface cashticketUserInfoInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private CashticketInterface cashticketInterface;
    @Autowired
    private CashticketBatchNewRuleInterface cashticketBatchNewRuleInterface;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private CashRuleContext cashRuleContext;

    @RequestMapping(value={"/setCashCache"})
    public BaseJsonVo setCashCache() throws AuthorizeException {
        return this.cashticketInterface.setCashCache();
    }

    @RequestMapping(value={"/getCashticketList"})
    public BaseJsonVo getCustomerCashticketList(String ticketBatchId, String start, String end, Integer status, String customerId, Integer pageSize, Integer pageCount) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.cashticketCustomerInterface.getCustomerCashticketList(ticketBatchId, start, end, customerId, status, pageSize, pageCount));
    }

    @RequestMapping(value={"/getCashticketBatchList"})
    public BaseJsonVo getCashticketBatchList(PageForm pageForm, CashticketBatchQuaryForm cashticketBatchQuaryForm) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.cashticketBatchInterface.getCashticketBatchList(pageForm, cashticketBatchQuaryForm, user.getPlatformGroupId().intValue()));
    }

    @RequestMapping(value={"/getQueryList"})
    public BaseJsonVo getQueryList() throws AuthorizeException {
        MallUserEntity user = this.getUser();
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("cashCreateTypeEnum", CashCreateTypeEnum.getList());
        map.put("cashDiscountModeEnum", CashDiscountModeEnum.getList());
        map.put("ticetClassList", this.cashticketClassInterface.getCashticketClass(user.getPlatformGroupId().intValue()));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/updateOrAddCashticketBatch"})
    public BaseJsonVo updateOrAddCashticketBatch(CashticketBatchEntity cashticketBatchEntity) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        if (StringUtils.isEmpty((String)cashticketBatchEntity.getTicketBatchId())) {
            cashticketBatchEntity.setCreateUserid(user.getUserId());
            cashticketBatchEntity.setPlatformGroupId(user.getPlatformGroupId());
            if (cashticketBatchEntity.getDiscountMode().intValue() == CashDiscountModeEnum.manjian.getValue() && cashticketBatchEntity.getAmount().compareTo(new BigDecimal(0)) == 0) {
                return BaseJsonVo.paramError((String)"\u6ee1\u51cf\u5238\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a0");
            }
            return this.cashticketBatchInterface.addCashticketBatch(cashticketBatchEntity);
        }
        CashticketBatchEntity oldCashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(cashticketBatchEntity.getTicketBatchId());
        cashticketBatchEntity.setCreateUserid(oldCashticketBatchEntity.getCreateUserid());
        if (oldCashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21");
        }
        if (!user.getPlatformGroupId().equals(oldCashticketBatchEntity.getPlatformGroupId())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u4fee\u6539");
        }
        return this.cashticketBatchInterface.updateCashticketBatch(cashticketBatchEntity);
    }

    @RequestMapping(value={"/deleteCashticketBatch"})
    public BaseJsonVo deleteCashticketBatch(String ticketBatchId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(ticketBatchId);
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.paramError((String)"\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21");
        }
        if (!user.getPlatformGroupId().equals(cashticketBatchEntity.getPlatformGroupId())) {
            return BaseJsonVo.paramError((String)"\u65e0\u6743\u5220\u9664");
        }
        return this.cashticketBatchInterface.deleteCashticketBatch(ticketBatchId);
    }

    @RequestMapping(value={"/getCashticketUserInfoList"})
    public BaseJsonVo getCashticketUserInfoList(PageForm pageForm, String userId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.cashticketUserInfoInterface.getCashticketUserInfoList(pageForm.getCurrentPage(), pageForm.getPageSize(), userId));
    }

    @RequestMapping(value={"/updateOrAddCashtickeUserInfo"})
    public BaseJsonVo updateOrAddCashtickeUserInfo(CashticketUserInfoEntity cashticketUserInfoEntity) throws AuthorizeException {
        if (cashticketUserInfoEntity.getId() == null || cashticketUserInfoEntity.getId() == 0) {
            return this.cashticketUserInfoInterface.saveCashticketUserInfo(cashticketUserInfoEntity);
        }
        return this.cashticketUserInfoInterface.updateCashticketUserInfo(cashticketUserInfoEntity);
    }

    @RequestMapping(value={"/getCashticketGetList"})
    public BaseJsonVo getCashticketGetList(PageForm pageForm, String ticketBatchId, String ticketNo, Integer status) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.cashticketCustomerInterface.getCashticketGetList(pageForm, ticketBatchId, ticketNo, status));
    }

    @RequestMapping(value={"/downloadCashticketList"})
    public void downloadCashticketList(PageForm pageForm, String ticketBatchId, String ticketNo, Integer status, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchInterface.getCashticketBatch(ticketBatchId);
            String fileName = URLEncoder.encode(cashticketBatchEntity.getTicketBatchName(), "UTF-8");
            pageForm.setPageSize(pageForm.getPageSize());
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            PageInfo pageInfo = this.cashticketCustomerInterface.getCashticketGetList(pageForm, ticketBatchId, ticketNo, status);
            ArrayList result = new ArrayList();
            if (pageInfo.getList().size() > 0) {
                pageInfo.getList().forEach(p -> {
                    CashticketExportVo cashticketExportVo = new CashticketExportVo();
                    BeanUtils.copyProperties((Object)p, (Object)cashticketExportVo);
                    result.add(cashticketExportVo);
                });
            }
            EasyExcel.write((OutputStream)response.getOutputStream(), CashticketExportVo.class).autoCloseStream(Boolean.FALSE).sheet("\u4f18\u60e0\u5238").doWrite(result);
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"/getCashticketStatusList"})
    public BaseJsonVo getCashticketStatusList() throws AuthorizeException {
        return BaseJsonVo.success((Object)CashStatusEnum.getList());
    }

    @RequestMapping(value={"/getCashticketBatchForOption"})
    public BaseJsonVo getCashticketBatchForOption() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.cashticketBatchInterface.getCashticketBatchForOption());
    }

    @RequestMapping(value={"/getEnableCashticketList"})
    public BaseJsonVo getEnableCashticketList(PageForm pageForm, String ticketBatchName) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        PageInfo pageInfo = this.cashticketBatchInterface.getCashticketBatchForOption(pageForm, user.getPlatformGroupId(), ticketBatchName);
        List list = pageInfo.getList();
        ArrayList enableCashticketVoList = new ArrayList();
        if (list != null && list.size() >= 1) {
            list.forEach(c -> {
                EnableCashticketVo vo = new EnableCashticketVo();
                BeanUtils.copyProperties((Object)c, (Object)vo);
                enableCashticketVoList.add(vo);
            });
        }
        pageInfo.setList(enableCashticketVoList);
        return BaseJsonVo.success((Object)pageInfo);
    }

    @RequestMapping(value={"/updateCashticketStatus"})
    public BaseJsonVo updateCashticketStatus(int ticketId) {
        this.cashticketInterface.updateCashticketStatus(ticketId, CashStatusEnum.jinyong);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getCashticketBatchUseRuleList"})
    public BaseJsonVo getCashticketBatchUseRuleList(PageForm pageForm, String ticketBatchId) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        return BaseJsonVo.success((Object)this.cashticketBatchNewRuleInterface.getCashticketBatchUseRuleList(pageForm, ticketBatchId, user.getPlatformGroupId()));
    }

    @RequestMapping(value={"/getCashRuleTypeList"})
    public BaseJsonVo getCashRuleTypeList() {
        return BaseJsonVo.success((Object)CashRuleTypeEnum.getList());
    }

    @RequestMapping(value={"/getCashRuleItemList"})
    public BaseJsonVo getCashRuleItemList(CashRuleSearchVo cashRuleSearchVo) throws AuthorizeException {
        MallUserEntity user = this.getUser();
        cashRuleSearchVo.setPlatformGroupId(user.getPlatformGroupId());
        return BaseJsonVo.success((Object)this.cashRuleContext.getCashRuleItemList(cashRuleSearchVo));
    }

    @RequestMapping(value={"/saveCashRuleList"})
    public BaseJsonVo saveCashRuleList(String list, Integer ruleTypeId, String ticketBatchId) throws UnsupportedEncodingException {
        String items = URLDecoder.decode(list, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List tempList = JsonUtils.getListByArray(MallSelectDataVo.class, (String)items);
        CashUseRuleForm cashUseRuleForm = new CashUseRuleForm();
        cashUseRuleForm.setDetailIds(tempList.stream().map(x -> x.getId()).collect(Collectors.toList()));
        cashUseRuleForm.setRuleType(ruleTypeId);
        cashUseRuleForm.setStats(Integer.valueOf(3));
        cashUseRuleForm.setTicketBatchId(ticketBatchId);
        BaseJsonVo baseJsonVo = this.cashticketBatchNewRuleInterface.saveCashRule(cashUseRuleForm);
        if (baseJsonVo.isSuccess() && (ruleTypeId.intValue() == CashRuleTypeEnum.danpin.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.transport.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.taozhuang.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.cuxiao.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.product_class.getValue())) {
            CashticketBatchEntity updateBatch = new CashticketBatchEntity();
            updateBatch.setUseType(Integer.valueOf(2));
            updateBatch.setTicketBatchId(ticketBatchId);
            this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/saveCashRuleList2"})
    public BaseJsonVo saveCashRuleList2(String list, Integer ruleTypeId, String ticketBatchId) throws UnsupportedEncodingException {
        BaseJsonVo baseJsonVo;
        List tempList;
        String items = URLDecoder.decode(list, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        if ((tempList = JsonUtils.getListByArray(MallSelectDataVo.class, (String)items)) == null || tempList.size() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u89c4\u5219!");
        }
        CashUseRuleItem cashUseRuleItem = new CashUseRuleItem();
        cashUseRuleItem.setDetailIds(tempList.stream().map(x -> x.getId()).collect(Collectors.toList()));
        cashUseRuleItem.setRuleType(ruleTypeId);
        cashUseRuleItem.setStats(Integer.valueOf(3));
        cashUseRuleItem.setTicketBatchId(ticketBatchId);
        List ruleVoList = this.cashticketBatchNewRuleInterface.getCashRule(ticketBatchId);
        if (ruleVoList != null && ruleVoList.size() > 0) {
            boolean exist = false;
            String message = "";
            for (CashticketBatchNewRuleVo ruleVo : ruleVoList) {
                if (ruleVo.getRuleType().intValue() != ruleTypeId.intValue()) continue;
                String[] arr = ruleVo.getDetailIds().split(",");
                for (MallSelectDataVo item : tempList) {
                    for (String id : arr) {
                        if (!id.equals(item.getId())) continue;
                        exist = true;
                        message = message + item.getName() + ",";
                    }
                }
            }
            if (exist) {
                return BaseJsonVo.error((String)(message.substring(0, message.length() - 2) + "\u5df2\u5b58\u5728!"));
            }
        }
        if ((baseJsonVo = this.cashticketBatchNewRuleInterface.saveCashRule(cashUseRuleItem)).isSuccess() && (ruleTypeId.intValue() == CashRuleTypeEnum.danpin.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.transport.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.taozhuang.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.cuxiao.getValue() || ruleTypeId.intValue() == CashRuleTypeEnum.product_class.getValue())) {
            CashticketBatchEntity updateBatch = new CashticketBatchEntity();
            updateBatch.setUseType(Integer.valueOf(2));
            updateBatch.setTicketBatchId(ticketBatchId);
            this.cashticketBatchInterface.saveCashticketBatch(updateBatch);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/saveCashRule"})
    public BaseJsonVo saveCashRule(CashUseRuleForm cashUseRuleForm) {
        if (cashUseRuleForm.getRuleType().intValue() == CashRuleTypeEnum.pingtai.getValue()) {
            cashUseRuleForm.setDetailIds(cashUseRuleForm.getPlatforms());
        } else if (cashUseRuleForm.getRuleType().intValue() == CashRuleTypeEnum.danpin.getValue()) {
            cashUseRuleForm.setDetailIds(cashUseRuleForm.getProducts());
        } else if (cashUseRuleForm.getRuleType().intValue() == CashRuleTypeEnum.cuxiao.getValue()) {
            cashUseRuleForm.setDetailIds(cashUseRuleForm.getProms());
        } else if (cashUseRuleForm.getRuleType().intValue() == CashRuleTypeEnum.taozhuang.getValue()) {
            cashUseRuleForm.setDetailIds(cashUseRuleForm.getGroups());
        }
        return this.cashticketBatchNewRuleInterface.saveCashRule(cashUseRuleForm);
    }

    @RequestMapping(value={"/deleteCashRule"})
    public BaseJsonVo deleteCashRule(Long ruleId) {
        return this.cashticketBatchNewRuleInterface.deleteCashRule(ruleId);
    }
}

