/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.deliver;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.deliver.MallFreightEntity;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.deliver.MallFreightInterface;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mallFreight"})
public class MallFreightController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(MallFreightController.class);
    @Autowired
    private MallFreightInterface mallFreightInterface;

    @RequestMapping(value={"/getMallFreightListByPage"}, method={RequestMethod.GET})
    public PageInfo getEvaluateOrderListByPage(PageForm pageForm, MallFreightEntity mallFreightEntity) {
        MallUserEntity user = null;
        try {
            user = this.getUser();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        mallFreightEntity.setPlatformGroupId(user.getPlatformGroupId());
        PageInfo listPage = this.mallFreightInterface.getFreighListByPage(pageForm.getCurrentPage(), pageForm.getPageSize(), mallFreightEntity);
        return listPage;
    }

    @RequestMapping(value={"/saveMallFreightInfo"})
    public BaseJsonVo saveMallFreightInfo(MallFreightEntity mallFreightEntity) {
        String id = IDGenerate.getUniqueIdStr();
        mallFreightEntity.setId(id);
        this.mallFreightInterface.saveMallFreight(mallFreightEntity);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/saveMallFreightRules"}, method={RequestMethod.POST})
    public BaseJsonVo saveMallFreightRules(String mallFreightRulesJson, String unifyId) {
        MallUserEntity user = null;
        try {
            user = this.getUser();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        return this.mallFreightInterface.saveMallFreightRules(mallFreightRulesJson, unifyId, user);
    }

    @RequestMapping(value={"/queryEditDataByFreightId"}, method={RequestMethod.GET})
    public BaseJsonVo queryEditDataByFreightId(String unifyId) {
        if (StringUtils.isEmpty((String)unifyId)) {
            return BaseJsonVo.success((Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        MallUserEntity user = null;
        try {
            user = this.getUser();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        JSONArray jsonArray = this.mallFreightInterface.queryEditDataByFreightId(unifyId, user);
        logger.info("----=========\u7f16\u8f91\u57ce\u5e02\u8fd0\u8d39\u8fd4\u56de\u7684\u53c2\u6570----========={}", (Object)jsonArray);
        return BaseJsonVo.success((Object)jsonArray);
    }

    @RequestMapping(value={"/deleteFreightRules"}, method={RequestMethod.GET})
    public BaseJsonVo deleteFreightRules(String unifyId) {
        MallUserEntity user = null;
        try {
            user = this.getUser();
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
        }
        BaseJsonVo baseJsonVo = this.mallFreightInterface.deleteFreightRules(unifyId, user);
        return baseJsonVo;
    }
}

