/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.prepay;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailQueryVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.entity.prepay.PrepayCardExportVO;
import cc.lechun.mall.entity.prepay.PrepayCardQueryVo;
import cc.lechun.mall.entity.prepay.PrepayCardVo;
import cc.lechun.mall.entity.user.MallUserEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanLogInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardQueryInterface;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"prepay"})
public class PrepayController
extends BaseController {
    @Autowired
    PrepayCardBatchInterface cardBatchInterface;
    @Autowired
    PrepayCardPlanLogInterface planLogInterface;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    PrepayCardQueryInterface prepayCardQueryInterface;
    @Autowired
    private PrepayCardPlanDetailInterface prepayCardPlanDetailInterface;

    @GetMapping(value={"cardBatches"})
    public BaseJsonVo cardBatches(PageForm pageForm) {
        return BaseJsonVo.success((Object)this.cardBatchInterface.cardBatchesByPage(pageForm));
    }

    @GetMapping(value={"disabledCard"})
    public BaseJsonVo disabledCard(String cardId) {
        return this.prepayCardQueryInterface.disabledCard(cardId);
    }

    @RequestMapping(value={"addBatch"})
    public BaseJsonVo addBatch(PrepayCardBatchEntity entity) throws AuthorizeException {
        if (entity.getBatchId() != null && this.prepayCardInterface.batchIsUsed(entity.getBatchId()).booleanValue()) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u5df2\u7ecf\u552e\u5356\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        MallUserEntity user = this.getUser();
        entity.setCreateBy(user.getUserId());
        return this.cardBatchInterface.addBatch(entity);
    }

    @RequestMapping(value={"delBatch"})
    public BaseJsonVo delBatch(Integer batchId) {
        if (this.prepayCardInterface.batchIsUsed(batchId).booleanValue()) {
            return BaseJsonVo.error((String)"\u6279\u6b21\u5df2\u7ecf\u552e\u5356\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        return this.cardBatchInterface.delBatch(batchId);
    }

    @RequestMapping(value={"viewCards"})
    public BaseJsonVo viewCards(PrepayCardEntity card, PageForm pageForm) throws IOException {
        if (card != null && card.getStatus() != null && card.getStatus() < 0) {
            card.setStatus(null);
        }
        return BaseJsonVo.success((Object)this.prepayCardInterface.getViewList(card, pageForm));
    }

    @RequestMapping(value={"exportBatch"})
    public void exportBatch(PrepayCardEntity card, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            PrepayCardBatchEntity prepayCardBatchEntity = (PrepayCardBatchEntity)this.cardBatchInterface.selectByPrimaryKey((Serializable)card.getBatchId());
            String fileName = URLEncoder.encode(prepayCardBatchEntity.getTitle() + "-\u5361\u5bc6-" + DateUtils.formatDate((Date)DateUtils.now(), (String)"yyyyMMdd"), "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            List list = this.prepayCardInterface.getViewList(card);
            EasyExcel.write((OutputStream)response.getOutputStream(), PrepayCardExportVO.class).autoCloseStream(Boolean.FALSE).sheet(prepayCardBatchEntity.getTitle()).doWrite(list);
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            e.printStackTrace();
            this.log.error("eee", (Throwable)e);
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"getCardPlanLog"})
    public BaseJsonVo getCardPlanLog(PageForm pageform, String today, Integer status) {
        return BaseJsonVo.success((Object)this.planLogInterface.getCardPlanLog(pageform, DateUtils.getDateFromString((String)today, (String)"yyyy-MM-dd"), status));
    }

    @RequestMapping(value={"getPrepayCardVoList"})
    public BaseJsonVo getPrepayCardVoList(PrepayCardQueryVo prepayCardQueryVo) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.prepayCardQueryInterface.getPrepayCardVoList(prepayCardQueryVo));
    }

    @RequestMapping(value={"getPrepayCardDetailVoList"})
    public BaseJsonVo getPrepayCardDetailVoList(PrepayCardDetailQueryVo prepayCardDetailQueryVo) {
        prepayCardDetailQueryVo.setEndDate(prepayCardDetailQueryVo.getEnd());
        prepayCardDetailQueryVo.setStartDate(prepayCardDetailQueryVo.getStart());
        return BaseJsonVo.success((Object)this.prepayCardPlanDetailInterface.getPrepayCardDetailVoList(prepayCardDetailQueryVo));
    }

    @RequestMapping(value={"setCardExpireTime"})
    public BaseJsonVo setCardExpireTime(PrepayCardVo prepayCardVo) {
        return BaseJsonVo.success((Object)this.prepayCardInterface.setCardExpireTime(prepayCardVo));
    }

    @RequestMapping(value={"/downloadCardPlan"})
    public void downloadCardPlan(PrepayCardDetailQueryVo prepayCardDetailQueryVo, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            prepayCardDetailQueryVo.setPageSize(999999);
            String fileName = URLEncoder.encode("\u5361\u8ba1\u5212", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
            PageInfo pageInfo = this.prepayCardPlanDetailInterface.getPrepayCardDetailVoList(prepayCardDetailQueryVo);
            this.prepayCardPlanDetailInterface.getPrepayCardDetailVoList(prepayCardDetailQueryVo);
            EasyExcel.write((OutputStream)response.getOutputStream(), PrepayCardDetailVo.class).autoCloseStream(Boolean.FALSE).sheet("\u5976\u5361\u8ba1\u5212").doWrite(pageInfo.getList());
        }
        catch (Exception e) {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("status", "failure");
            map.put("message", "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    @RequestMapping(value={"getPrepayOrderSourceNameList"})
    public BaseJsonVo getPrepayOrderSourceNameList() {
        return BaseJsonVo.success((Object)this.prepayCardQueryInterface.getOrderSourceNameList());
    }
}

