/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.sales.FreeRuleTypeEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallFreeEntity;
import cc.lechun.mall.entity.sales.MallFreeProductEntity;
import cc.lechun.mall.entity.sales.MallFreeRuleEntity;
import cc.lechun.mall.form.sales.FreeRuleForm;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.sales.MallFreeInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"free"})
public class MallFreeController
extends BaseController {
    @Autowired
    private MallFreeInterface mallFreeInterface;
    @Autowired
    private MallCityInterface mallCityInterface;
    @Autowired
    private MallPromotionInterface mallPromotionInterface;
    @Autowired
    private MallVipInterface mallVipInterface;

    @RequestMapping(value={"getVipAllList"})
    public BaseJsonVo getVipAllList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallVipInterface.rightsList(this.getUser().getPlatformGroupId()));
    }

    @RequestMapping(value={"getVipListByStatus"})
    public BaseJsonVo getVipListByStatus() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallVipInterface.getVipListByStatus(this.getUser().getPlatformGroupId()));
    }

    @RequestMapping(value={"getFreeTypeList"})
    public BaseJsonVo getFreeTypeList() throws AuthorizeException {
        return BaseJsonVo.success((Object)FreeRuleTypeEnum.getList());
    }

    @RequestMapping(value={"getPromotionList"})
    public BaseJsonVo getPromotionList() throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallPromotionInterface.getOptionPromotionList(this.getUser().getPlatformGroupId()));
    }

    @RequestMapping(value={"getCityList"})
    public BaseJsonVo getCityList() {
        return BaseJsonVo.success((Object)this.mallCityInterface.getCityList());
    }

    @RequestMapping(value={"getSalesTypeList"})
    public BaseJsonVo getSalesTypeList() {
        ArrayList ls = new ArrayList();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("value", SalesTypeEnum.SALES_PRODUCT.getValue());
        map1.put("name", SalesTypeEnum.SALES_PRODUCT.getName());
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("value", SalesTypeEnum.SALES_GROUP.getValue());
        map2.put("name", SalesTypeEnum.SALES_GROUP.getName());
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("value", SalesTypeEnum.SALES_PROMOTION.getValue());
        map3.put("name", SalesTypeEnum.SALES_PROMOTION.getName());
        ls.add(map1);
        ls.add(map2);
        ls.add(map3);
        return BaseJsonVo.success(ls);
    }

    @RequestMapping(value={"getFreeList"})
    public BaseJsonVo getFreeList(PageForm pageForm, String freeName, Integer status) throws AuthorizeException {
        PageInfo page = this.mallFreeInterface.getFreeList(pageForm.getCurrentPage(), pageForm.getPageSize(), freeName, this.getUser().getPlatformGroupId().intValue(), status);
        if (page.getList() != null) {
            page.getList().forEach(mallFreeEntityVo -> mallFreeEntityVo.setPlatformGroupName(this.getUserValidPlatFormGroupName(mallFreeEntityVo.getPlatformGroupId())));
        }
        return BaseJsonVo.success((Object)page);
    }

    @RequestMapping(value={"getFreeProductList"})
    public BaseJsonVo getFreeProductList(PageForm pageForm, String freeId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallFreeInterface.getFreeProductList(pageForm.getCurrentPage(), pageForm.getPageSize(), freeId));
    }

    @RequestMapping(value={"getFreeRuletList"})
    public BaseJsonVo getFreeRuletList(PageForm pageForm, String freeId) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.mallFreeInterface.getFreeRuletList(pageForm.getCurrentPage(), pageForm.getPageSize(), freeId));
    }

    @RequestMapping(value={"saveOrUpdateFree"})
    public BaseJsonVo saveOrUpdateFree(@RequestBody MallFreeEntity mallFreeEntity) throws AuthorizeException {
        mallFreeEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        return this.mallFreeInterface.saveOrUpdateFree(mallFreeEntity);
    }

    @RequestMapping(value={"saveOrUpdateFreeProduct"})
    public BaseJsonVo saveOrUpdateFreeProduct(MallFreeProductEntity mallFreeProductEntity) throws AuthorizeException {
        return this.mallFreeInterface.saveOrUpdateFreeProduct(mallFreeProductEntity);
    }

    @RequestMapping(value={"saveOrUpdateFreeRule"})
    public BaseJsonVo saveOrUpdateFreeRule(FreeRuleForm freeRuleForm) throws AuthorizeException {
        MallFreeRuleEntity mallFreeRuleEntity = new MallFreeRuleEntity();
        mallFreeRuleEntity.setFreeId(freeRuleForm.getFreeId());
        if (freeRuleForm.getFreeRuleType().intValue() == FreeRuleTypeEnum.amount_type.getValue()) {
            mallFreeRuleEntity.setFreeRuleData(freeRuleForm.getAmount().toString());
            mallFreeRuleEntity.setFreeRuleDataExtend("");
        } else if (freeRuleForm.getFreeRuleType().intValue() == FreeRuleTypeEnum.product_type.getValue()) {
            if (freeRuleForm.getSalesType().intValue() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
                mallFreeRuleEntity.setFreeRuleDataExtend(freeRuleForm.getProductId());
            } else if (freeRuleForm.getSalesType().intValue() == SalesTypeEnum.SALES_GROUP.getValue()) {
                mallFreeRuleEntity.setFreeRuleDataExtend(freeRuleForm.getGroupId());
            } else if (freeRuleForm.getSalesType().intValue() == SalesTypeEnum.SALES_PROMOTION.getValue()) {
                mallFreeRuleEntity.setFreeRuleDataExtend(freeRuleForm.getPromotionId());
            } else {
                return BaseJsonVo.paramError((String)"\u5546\u54c1\u9519\u8bef");
            }
            mallFreeRuleEntity.setFreeRuleData(freeRuleForm.getSalesType().toString());
        } else if (freeRuleForm.getFreeRuleType() == 3) {
            mallFreeRuleEntity.setFreeRuleData("");
            mallFreeRuleEntity.setFreeRuleDataExtend(StringUtils.join((Iterable)freeRuleForm.getCitys(), (String)","));
        } else if (freeRuleForm.getFreeRuleType().intValue() == FreeRuleTypeEnum.vip_type.getValue()) {
            mallFreeRuleEntity.setFreeRuleData(freeRuleForm.getVipId().toString());
            mallFreeRuleEntity.setFreeRuleDataExtend("");
        } else if (freeRuleForm.getFreeRuleType().intValue() == FreeRuleTypeEnum.coupon_type.getValue()) {
            mallFreeRuleEntity.setFreeRuleData(freeRuleForm.getTicketBatchId());
            mallFreeRuleEntity.setFreeRuleDataExtend("");
        } else if (freeRuleForm.getFreeRuleType().intValue() == FreeRuleTypeEnum.prepaycard_type.getValue()) {
            mallFreeRuleEntity.setFreeRuleData(freeRuleForm.getPrepayCardId());
            mallFreeRuleEntity.setFreeRuleDataExtend("");
        } else {
            return BaseJsonVo.paramError((String)"\u7c7b\u578b\u9519\u8bef");
        }
        mallFreeRuleEntity.setFreeRuleType(freeRuleForm.getFreeRuleType());
        return this.mallFreeInterface.saveOrUpdateFreeRule(mallFreeRuleEntity);
    }

    @RequestMapping(value={"deleteFreeProduct"})
    public BaseJsonVo deleteFreeProduct(String freeProductId) throws AuthorizeException {
        return this.mallFreeInterface.deleteFreeProduct(freeProductId);
    }

    @RequestMapping(value={"deleteFreeRule"})
    public BaseJsonVo deleteFreeRule(String freeRuleId) throws AuthorizeException {
        return this.mallFreeInterface.deleteFreeRule(freeRuleId);
    }
}

