/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.cms.controller.sales;

import cc.lechun.cms.controller.BaseController;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductLineEntity;
import cc.lechun.mall.iservice.distribution.DistributorItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product"})
public class MallProductController
extends BaseController {
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private DistributorItemInterface distributorItemInterface;
    @Autowired
    private MallProductCategoryInterface productCategoryInterface;

    @RequestMapping(value={"proTypeList"})
    public List<MallProductLineEntity> prolist() throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        return this.productInterface.getProductTypeList(platFormGroupId);
    }

    @RequestMapping(value={"getSalesTypeList"})
    public BaseJsonVo getSalesTypeList() {
        return BaseJsonVo.success((Object)SalesTypeEnum.getSelectDataList());
    }

    @RequestMapping(value={"prolist"})
    public PageInfo prolist(PageForm pageForm, MallProductEntity mallProductEntity) throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        mallProductEntity.setPlatformGroupId(platFormGroupId);
        return this.productInterface.getProductList(pageForm.getCurrentPage(), pageForm.getPageSize(), mallProductEntity);
    }

    @RequestMapping(value={"getProducts"})
    public BaseJsonVo getProducts() throws AuthorizeException {
        Integer platFormGroupId = this.getUser().getPlatformGroupId();
        List list = this.productInterface.getOnProductList(platFormGroupId);
        if (list != null) {
            return BaseJsonVo.success((Object)list);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @RequestMapping(value={"getProduct"})
    public BaseJsonVo getProduct(String proId) {
        MallProductEntity entity = this.productInterface.getProduct(proId);
        if (entity != null) {
            return BaseJsonVo.success((Object)entity);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @RequestMapping(value={"addProduct"})
    public BaseJsonVo addProduct(MallProductEntity mallProductEntity) throws AuthorizeException {
        mallProductEntity.setPlatformGroupId(this.getUser().getPlatformGroupId());
        BaseJsonVo sr = this.productInterface.addProduct(mallProductEntity);
        if (sr.isSuccess()) {
            MallProductEntity p = (MallProductEntity)sr.getValue();
            this.distributorItemInterface.initDistributorItem(p.getProId(), Integer.valueOf(4));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"importProduct"})
    public BaseJsonVo importProduct(Integer platformGroupId) {
        return this.productInterface.importProduct(platformGroupId);
    }

    @RequestMapping(value={"importCategory"})
    public BaseJsonVo importCategory(Integer platformGroupId) {
        return this.productCategoryInterface.importCategory(platformGroupId);
    }

    @RequestMapping(value={"delProduct"})
    public BaseJsonVo delProduct(MallProductEntity mallProductEntity) {
        BaseJsonVo sr = this.productInterface.delProduct(mallProductEntity);
        if (sr.isSuccess()) {
            this.distributorItemInterface.initDistributorItem(mallProductEntity.getProId(), Integer.valueOf(4));
            return BaseJsonVo.success((Object)"");
        }
        return BaseJsonVo.error((String)sr.getError_msg());
    }

    @RequestMapping(value={"getProductByProType"})
    public BaseJsonVo getProductByProType(String proType) {
        List mallProductEntityList = this.productInterface.getProductByProType(proType);
        return BaseJsonVo.success((Object)mallProductEntityList);
    }

    @RequestMapping(value={"getProductsAll"})
    public BaseJsonVo getProductsAll() {
        this.log.info("+++\u8fdb\u5165\u67e5\u8be2getProductsAll\u65b9\u6cd5");
        int platFormGroupId = 1000;
        List list = this.productInterface.getOnProductList(Integer.valueOf(platFormGroupId));
        this.log.info("+++\u8fdb\u5165\u67e5\u8be2getProductsAll\u65b9\u6cd5 \u8fd4\u56de\u53c2\u6570list={}", (Object)JSON.toJSONString((Object)list));
        if (list != null) {
            return BaseJsonVo.success((Object)list);
        }
        return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
    }
}

