package cc.lechun.framework.common.enums.trade;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/12.
 */
public enum OrderClassEnum {
    MALL_ORDER(1, "实物订单"),
    ACTIVE_ORDER(2, "活动订单"),
    CHARGE_ORDER(3, "充值订单"),
    GIFTCARD_ORDER(4,"礼品卡订单"),
    MARKET_OFFLINE_ORDER(5,"线下订单"),
    CROWD_ORDER(6,"众筹订单"),
    CITY_CROWD_ORDER(8,"开城众筹订单"),
    WISH_ORDER(9,"心愿单订单");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<OrderClassEnum> getList() {
        return Arrays.asList(OrderClassEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        OrderClassEnum[] ls = OrderClassEnum.values();
        for (OrderClassEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        OrderClassEnum[] ls = OrderClassEnum.values();
        for (OrderClassEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    OrderClassEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "OrderClassEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
