package cc.lechun.framework.common.enums.jms;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2017/12/15
 * Description: 消息队列tag枚举  在这里区分商城，活动.....
 */
public enum MessageQueueTagEnum {
    redpackageInvite("redpackageInvite", "红包活动邀请新用户"),
    sendActiveCashTicket("sendActiveCashTicket", "活动发送优惠劵"),
    takedCash("takedCash", "领取时生成优惠券"),
    pushTempQrcode("pushTempQrcode", "推送临时二维码"),
    sendCashLog("sendCashLog", "发放优惠券日志"),
    picScanCode("picScan", "个人二维码扫码"),
    scanCode("scanCode", "活动二维码扫码"),
    attentionNumber("attentionNumber", "关注"),
    testOrder("testOrder", "测试顺序队列"),
    unSubscribe("unSubscribe", "取消关注"),
    subscribe("subscribe", "关注"),
    redisFail("redisFail", "redis失败数据同步"),
    sendCashTicket("sendCashTicket", "发送优惠劵"),
    receiveTicket("receiveTicket","获取优惠券"),
    orderSubmit("submitOrder", "订单提交"),
    userInfo("userInfo", "用户信息"),
    orderPay("orderPay", "订单支付"),
    orderDetail("orderDetail", "支付详情"),
    activeData("active_data", "活动数据"),
    confirmGoods("confirmGoods", "确认收货"),
    omsOrderCreate("omsOrderCreate", "创建订单"),
    omsOrderPay("omsOrderPay", "订单支付"),
    omsOrderCancel("omsOrderCancel", "取消订单"),
    omsOrderDelete("omsOrderDelete", "删除订单"),
    omsOrderUpdate("omsOrderUpdate", "订单修改"),
    omsOrderAppraisal("omsOrderAppraisal", "订单评价"),
    ecOrderDeliverGood("ecOrderDeliverGood", "订单配货中"),
    ecOrderTakeGood("ecOrderTakeGood", "订单待收货"),
    ecOrderEvaluate("ecOrderEvaluate", "订单待评价（订单部分完成）"),
    ecOrderAllEvaluate("ecOrderAllEvaluate", "订单待评价（订单全部完成）"),
    ecOrderRefundApply("ecOrderRefundApply", "订单退款申请"),
    ecOrderRefundProcess("ecOrderRefundApply", "订单退款处理中"),
    ecOrderRefund("ecOrderRefund", "订单已退款"),
    ecOrderClose("ecOrderClose", "订单关闭"),
    ecOrderEdit("ecOrderEdit", "OMS订单修改"),
    vipDayNotice("vipDayNotice","会员日推送通知"),
    finishTaskCharge("finishVipTask","完成储值的会员任务"),
    templeteMessageSend("templeteMessageSend","模板消息推送");
    public String value;
    public String name;

    /**
     * 获取列表
     */
    public static List<MessageQueueTagEnum> getList() {
        return Arrays.asList(MessageQueueTagEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(String value) {
        MessageQueueTagEnum[] ls = MessageQueueTagEnum.values();
        for (MessageQueueTagEnum rs : ls) {
            if (rs.getValue().equals(value)) {
                return rs.getName();
            }
        }
        return "";
    }

    MessageQueueTagEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "MessageQueueTagEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
