package cc.lechun.framework.common.utils.open.map.vo;

import java.io.Serializable;

/**
 * Created by wangxs on 2017/12/22
 * Description: 高德地图返回值
 */
public class AMapResultVo implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String OK = "1";
    public static final String FAIL = "0";

    private boolean success;
    private String status;//返回结果状态值返回值为 0 或 1， 0 表示请求失败；1 表示请求成功。
    private String count;//返回结果数目返回结果的个数。
    private String info;//返回状态说明当 status 为 0 时，info 会返回具体错误原因，否则返回“OK”。详情可以参阅info状态表
    private String infocode;//返回编码 查看网站 http://lbs.amap.com/api/webservice/guide/tools/info

    public String getInfocode() {
        return infocode;
    }

    public void setInfocode(String infocode) {
        this.infocode = infocode;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
        if (status.equals(OK)) {
            this.success = true;
        }
    }

    public String getCount() {
        return count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public String toString() {
        return "AMapResultVo{" +
                "success=" + success +
                ", status='" + status + '\'' +
                ", count='" + count + '\'' +
                ", info='" + info + '\'' +
                ", infocode='" + infocode + '\'' +
                '}';
    }
}
