package cc.lechun.framework.common.utils.file;

import cc.lechun.framework.common.utils.date.DateFormatUtil;
import cc.lechun.framework.common.vo.ExportVo;
import cc.lechun.framework.common.utils.ReflectUtil;
import com.itextpdf.kernel.color.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.border.SolidBorder;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.TextAlignment;

import javax.servlet.ServletOutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ExportPdfUtil {

    /**
     * 导出Pdf
     */
    public static <T> boolean export(ExportVo<T> exportVO,ServletOutputStream out) {
        //表头中文名
        String[] headers = exportVO.getHeaders();
        //表头英文名
        String[] fieldNames = exportVO.getFieldNames();
        //表格初始化列宽
        float[] columnWidth = new float[headers.length];
        for (int i = 0; i < headers.length; i++) {
            columnWidth[i] = headers[i].length();
        }

        try {
            //初始化 pdf document
            PdfDocument pdf = new PdfDocument(new PdfWriter(out));
            PageSize ps = new PageSize(842, 680);

            //初始化document
            Document document = new Document(pdf, ps);

            //表头字体
            PdfFont headerFont = PdfFontFactory.createFont("STSongStd-Light", "UniGB-UCS2-H", false);
            //表体字体
            PdfFont bodyFont = PdfFontFactory.createFont("STSongStd-Light", "UniGB-UCS2-H", false);
            //初始化表格列宽
            Table table = new Table(columnWidth);
            //设置对齐方式
            table.setWidthPercent(100).setTextAlignment(TextAlignment.CENTER).setHorizontalAlignment(HorizontalAlignment.CENTER);

            //初始化表头
            for (int i = 0; i < headers.length; i++) {
                Cell cell = new Cell().add(new Paragraph(headers[i]));
                //设置当前单元样式、字体
                cell.setFont(headerFont).setBorder(new SolidBorder(Color.BLACK, 0.5f)).setFontSize(14);
                table.addHeaderCell(cell);
            }

            // 向pdf中添加行数据
            Class<T> cls = null;
            T t = null;

            for (Iterator<T> iterator = exportVO.getDataset().iterator(); iterator
                    .hasNext();) {
                t = iterator.next();
                if(t instanceof HashMap) {
                    for (int i = 0; i < fieldNames.length; i++) {
                        Object value = ((HashMap) t).get(fieldNames[i]);
                        //保留三位小数，防止导出表格出现数字过长excle显示错误
                        if(null!=value && value  instanceof Double ) {
                            BigDecimal b = new BigDecimal((Double) value);
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }else if(null!=value && value  instanceof BigDecimal ) {
                            BigDecimal b = new BigDecimal(value.toString());
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }
                        // 设置单元格的值
                        Cell cell = new Cell().add(new Paragraph(handleValue(value, exportVO.getDatePattern())));
                        //设置当前单元样式、字体
                        cell.setFont(bodyFont).setBorder(new SolidBorder(Color.BLACK, 0.5f)).setFontSize(8);
                        table.addCell(cell);
                    }
                } else {
                    cls = (Class<T>) t.getClass();
                    for (int i = 0; i < fieldNames.length; i++) {
                        String fieldName = fieldNames[i];
                        String getMethodName = ReflectUtil.getMethodName(fieldName, "get");
                        Method method = cls.getMethod(getMethodName, new Class[]{});
                        Object value = method.invoke(t, new Object[]{});
                        //保留三位小数，防止导出表格出现数字过长excle显示错误
                        if(null!=value && value  instanceof Double ) {
                            BigDecimal b = new BigDecimal((Double) value);
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }else if(null!=value && value  instanceof BigDecimal ) {
                            BigDecimal b = new BigDecimal(value.toString());
                            value = b.setScale(3, BigDecimal.ROUND_HALF_EVEN).doubleValue();
                        }
                        // 设置单元格的值
                        Cell cell = new Cell().add(new Paragraph(handleValue(value, exportVO.getDatePattern())));
                        //设置当前单元样式、字体
                        cell.setFont(bodyFont).setBorder(new SolidBorder(Color.BLACK, 0.5f)).setFontSize(8);
                        table.addCell(cell);
                    }
                }
            }
            document.add(table);

            //关闭document
            document.close();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 处理Objcet类型的 value
     * @param value
     * @param datePattern
     */
    private static String handleValue(Object value, String datePattern) {
        String textValue = "";
        // 日期类型
        if (value instanceof Date) {
            Date date = (Date) value;
            textValue = DateFormatUtil.date2Str(date, datePattern);
        } else { // 其他类型都当作String处理
            textValue = value == null ? "" : value.toString();
        }
        return textValue;
    }
}
