/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.object;

import cc.lechun.framework.common.utils.annotation.AttributeName;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cglib.beans.BeanMap;

public class ObjectConvert {
    public static <T> Map<String, Object> beanToMap(T bean) {
        HashMap map = Maps.newHashMap();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }

    public static <T> Map<String, String> objectConvertToMap(T t) {
        Class<?> cls = t.getClass();
        Field[] fields = cls.getDeclaredFields();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name = attrName == null ? field.getName() : attrName.value()[0];
            value = ObjectConvert.getFieldValueByName(field.getName(), t);
            if (value == null) {
                value = "";
            }
            map.put(name, value.toString());
        }
        return map;
    }

    public static <T> Map<String, Object> objectConvertToObjectMap(T t) {
        Class<?> cls = t.getClass();
        Field[] fields = cls.getDeclaredFields();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name = attrName == null ? field.getName() : attrName.value()[0];
            value = ObjectConvert.getFieldValueByName(field.getName(), t);
            map.put(name, value);
        }
        return map;
    }

    public static <T> Map<String, Object> objectWithSuperConvertToObjectMap(T t) {
        Class<?> cls = t.getClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> tempClass = t.getClass(); tempClass != null && !tempClass.getName().toLowerCase().equals("java.lang.object"); tempClass = tempClass.getSuperclass()) {
            fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name = attrName == null ? field.getName() : attrName.value()[0];
            value = ObjectConvert.getFieldValueByName(field.getName(), t);
            map.put(name, value);
        }
        return map;
    }

    public static <T> SortedMap<String, String> objectConvertToSortedMap(T t) {
        Class<?> cls = t.getClass();
        Field[] fields = cls.getDeclaredFields();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name = attrName == null ? field.getName() : attrName.value()[0];
            value = ObjectConvert.getFieldValueByName(field.getName(), t);
            if (value == null) {
                value = "";
            }
            if (!(value instanceof String || value instanceof Integer || value instanceof Long || value instanceof BigDecimal || value instanceof Boolean || value instanceof Short)) {
                value = JsonUtils.toJson(value, false);
            }
            map.put(name, value.toString());
        }
        return map;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            return method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T requestConvertToObject(HttpServletRequest request, Class<T> clazz) {
        T vo = null;
        try {
            Field[] fields;
            vo = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                AttributeName attrName = field.getAnnotation(AttributeName.class);
                String name = attrName == null ? field.getName() : attrName.value()[0];
                String value = request.getParameter(name);
                field.setAccessible(true);
                if (value == null || value.isEmpty()) continue;
                value = value.trim();
                if (field.getType().equals(Long.class)) {
                    field.set(vo, Long.valueOf(value));
                    continue;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(vo, Integer.valueOf(value));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(vo, value);
                    continue;
                }
                if (field.getType().equals(Date.class)) {
                    Date d = DateUtils.StrToDate(value, "yyyy-MM-dd HH:mm:ss");
                    if (d == null) {
                        d = DateUtils.StrToDate(value, "yyyy-MM-dd");
                    }
                    field.set(vo, d);
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                    continue;
                }
                if (field.getType().equals(Boolean.class)) {
                    field.set(vo, value.toLowerCase() == "true");
                    continue;
                }
                field.set(vo, value);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return vo;
    }

    public static <T> T mapConvertToObject(SortedMap<String, String> map, Class<T> clazz) {
        T vo = null;
        try {
            Field[] fields;
            vo = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                try {
                    AttributeName attrName = field.getAnnotation(AttributeName.class);
                    String name = attrName == null ? field.getName() : attrName.value()[0];
                    String value = (String)map.get(name);
                    field.setAccessible(true);
                    if (value == null || value.isEmpty()) continue;
                    value = value.trim();
                    if (field.getType().equals(Long.class)) {
                        field.set(vo, Long.valueOf(value));
                        continue;
                    }
                    if (field.getType().equals(Integer.class)) {
                        field.set(vo, Integer.valueOf(value));
                        continue;
                    }
                    if (field.getType().equals(String.class)) {
                        field.set(vo, value);
                        continue;
                    }
                    if (field.getType().equals(Date.class)) {
                        Date d = DateUtils.StrToDate(value, "yyyy-MM-dd HH:mm:ss");
                        if (d == null) {
                            d = DateUtils.StrToDate(value, "yyyy-MM-dd");
                        }
                        field.set(vo, d);
                        continue;
                    }
                    if (field.getType().equals(BigDecimal.class)) {
                        field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                        continue;
                    }
                    if (field.getType().equals(Boolean.class)) {
                        field.set(vo, value.toLowerCase() == "true");
                        continue;
                    }
                    field.set(vo, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return vo;
    }

    public static <T> T mapConvertToObject(Map<String, String> map, Class<T> clazz) {
        T vo = null;
        try {
            Field[] fields;
            vo = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                AttributeName attrName = field.getAnnotation(AttributeName.class);
                String name = attrName == null ? field.getName() : attrName.value()[0];
                String value = map.get(name);
                field.setAccessible(true);
                if (value == null || value.isEmpty()) continue;
                value = value.trim();
                if (field.getType().equals(Long.class)) {
                    field.set(vo, Long.valueOf(value));
                    continue;
                }
                if (field.getType().equals(Integer.class)) {
                    field.set(vo, Integer.valueOf(value));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(vo, value);
                    continue;
                }
                if (field.getType().equals(Date.class)) {
                    Date d = DateUtils.StrToDate(value, "yyyy-MM-dd HH:mm:ss");
                    if (d == null) {
                        d = DateUtils.StrToDate(value, "yyyy-MM-dd");
                    }
                    field.set(vo, d);
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    field.set(vo, BigDecimal.valueOf(Double.parseDouble(value)));
                    continue;
                }
                if (field.getType().equals(Boolean.class)) {
                    field.set(vo, value.toLowerCase() == "true");
                    continue;
                }
                field.set(vo, value);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return vo;
    }

    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public static <F, C> void fatherConvertToChild(F father, C child) throws Exception {
        if (child.getClass().getSuperclass() != father.getClass()) {
            throw new Exception("child\u4e0d\u662ffather\u7684\u5b50\u7c7b");
        }
        Class<?> fatherClass = father.getClass();
        Field[] ff = fatherClass.getDeclaredFields();
        for (int i = 0; i < ff.length; ++i) {
            Field f = ff[i];
            f.setAccessible(true);
            try {
                Method m = fatherClass.getMethod("get" + ObjectConvert.upperHeadChar(f.getName()), new Class[0]);
                if (m == null) continue;
                Object obj = m.invoke(father, new Object[0]);
                f.set(child, obj);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String upperHeadChar(String in) {
        String head = in.substring(0, 1);
        String out = head.toUpperCase() + in.substring(1, in.length());
        return out;
    }

    public static <T> String objectConvertToUrpParam(T t) {
        Class<?> cls = t.getClass();
        Field[] fields = cls.getDeclaredFields();
        LinkedHashMap map = new LinkedHashMap();
        StringBuilder sb = new StringBuilder();
        for (Field field : fields) {
            AttributeName attrName = field.getAnnotation(AttributeName.class);
            Object value = null;
            String name = attrName == null ? field.getName() : attrName.value()[0];
            value = ObjectConvert.getFieldValueByName(field.getName(), t);
            if (value == null) {
                value = "";
            }
            sb.append(name);
            sb.append("=");
            if (value instanceof String) {
                sb.append(value);
            } else {
                try {
                    sb.append(URLEncoder.encode(JsonUtils.toJson(value, false), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            sb.append("&");
        }
        return sb.toString().length() > 0 ? sb.toString().substring(0, sb.length() - 1) : sb.toString();
    }
}

