package cc.lechun.framework.common.utils.sign;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.sign.MD5;
import com.github.pagehelper.util.StringUtil;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class UrlUtil {
    private static final String signSalt="ad25b071-0ae5-4900-b644-d31b8a4c9fb5";//默认签名盐值不要改
    //main方法
    public static void main(String[] args) {
        String url="https://portalcheck.lechun.cc/oa/formplayground/1792869295797178368?externalId=1569&raterId=1398163365235658752&enTime=2024-06-11%2017:14:24&sign=35cb69c285adb5f4028661f95413a041";
        LinkedHashMap<String,String> map=getUrlParamsByString(url);
        DateUtils.getDateFromString(map.get("enTime"));

        if(!UrlUtil.validateUrlSign("https://portalcheck.lechun.cc/oa/formplayground/1792869295797178368?externalId=1545&raterId=1744593037741002752&enTime=Tue Jun 11 16:28:34 CST 2024&sign=5f7ccb73ae293e6353d67a614c3d89fb")){
            System.out.println("error");
        }else{
            System.out.println("success");
        }
    }
    public static LinkedHashMap<String, String> getUrlParamsByString(String url) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int start = url.indexOf("?");
        if (start >= 0) {
            String str = url.substring(start + 1);
            try {
                str= URLDecoder.decode(str, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            System.out.println(str);
            String[] paramsArr = str.split("&");
            for (String param : paramsArr) {
                String[] temp = param.split("=");
                map.put(temp[0], temp[1]);
            }
        }
        map.entrySet().stream().sorted(Map.Entry.comparingByKey());
        return map;
    }
    //将map转换成url
    public static String getUrlParamsByMap(LinkedHashMap<String,String> map) {
        if (map == null) {
            return "";
        }
        //map 按key进行排序 lanmda
        map.entrySet().stream().sorted(Map.Entry.comparingByKey());

        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = org.apache.commons.lang.StringUtils.substringBeforeLast(s, "&");
        }
        return s;
    }
    public static String urlSign(String url){
        return urlSign(url,signSalt);
    }
    public static String urlSign(String url,String signSalt){
        if(StringUtil.isEmpty(url)){
            return url;
        }
        try {
            url= URLDecoder.decode(url, "UTF-8");
        } catch (UnsupportedEncodingException e) {

        }
        //排序后
        LinkedHashMap<String,String> map=getUrlParamsByString(url);
        map.remove("sign");
        return MD5.sign(signSalt+getUrlParamsByMap(map));
    }
    public static Boolean validateUrlSign(String url){
        return validateUrlSign(url,signSalt);
    }
    public static Boolean validateUrlSign(String url,String signSalt){
        if(StringUtil.isEmpty(url)){
            return false;
        }
        try {
            url= URLDecoder.decode(url, "UTF-8");
        } catch (UnsupportedEncodingException e) {

        }
        LinkedHashMap<String,String> map=getUrlParamsByString(url);
        String sign=map.get("sign");
        if(StringUtil.isEmpty(sign)){
            return false;
        }
        map.remove("sign");
        String sign2= MD5.sign(signSalt+getUrlParamsByMap(map));
        return sign.equals(sign2);
    }
}
