/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.date;

import cc.lechun.framework.common.utils.date.DateUtils;
import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.quartz.CronExpression;

public class CronUtils {
    private static final Map<Integer, String> dayOfWeekMap = new HashMap<Integer, String>();

    public static void main(String[] args) throws InterruptedException {
        String curTime = DateUtils.formatDate(new Date(), "yyyy-MM-dd HH:mm");
        Date dates = CronUtils.getCronTime("0 0/5 * * * ?", DateUtils.getAddDateBySecond(DateUtils.getDateFromString(curTime), -45));
        System.out.println(CronUtils.parseAndPrint("0 0 11 * * ?"));
    }

    public static String parseAndPrint(String cronExpression) {
        try {
            CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.QUARTZ);
            CronParser parser = new CronParser(cronDefinition);
            Cron cron = parser.parse(cronExpression);
            CronDescriptor descriptor = CronDescriptor.instance((Locale)Locale.CHINA);
            String description = descriptor.describe(cron);
            return description;
        }
        catch (Exception e) {
            System.err.println("\u65e0\u6cd5\u89e3\u6790\u8868\u8fbe\u5f0f: " + cronExpression);
            return "\u65e0\u6cd5\u89e3\u6790\uff1a" + cronExpression;
        }
    }

    public static Date getCronTime(String cron) {
        return CronUtils.getCronTime(cron, DateUtils.getAddDateBySecond(new Date(), 0));
    }

    public static Date getCronTime(String cron, Date initDate) {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        Date execTime = cronExpression.getTimeAfter(initDate);
        if (execTime == null) {
            return null;
        }
        return execTime;
    }

    public static List<Date> getCronTime(String cron, Integer count, Date initDate) {
        CronExpression cronExpression;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        if (count == null) {
            count = 1;
        }
        if (count > 20) {
            count = 20;
        }
        ArrayList<Date> result = new ArrayList<Date>();
        Date exec = new Date();
        for (int i = 0; i < count; ++i) {
            Date execTime = cronExpression.getTimeAfter(initDate);
            if (execTime == null) {
                return result;
            }
            exec = execTime;
            result.add(execTime);
        }
        return result;
    }

    public static List<Date> getCronTime(String cron, Integer count) {
        return CronUtils.getCronTime(cron, count, DateUtils.getAddDateBySecond(new Date(), 0));
    }

    static {
        dayOfWeekMap.put(1, "MON");
        dayOfWeekMap.put(2, "TUE");
        dayOfWeekMap.put(3, "WED");
        dayOfWeekMap.put(4, "THU");
        dayOfWeekMap.put(5, "FRI");
        dayOfWeekMap.put(6, "SAT");
        dayOfWeekMap.put(7, "SUN");
    }
}

