/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.qrcode;

import cc.lechun.framework.common.utils.file.FolderUtils;
import cc.lechun.framework.common.utils.qrcode.MatrixToImageWriterEx;
import cc.lechun.framework.common.utils.qrcode.MatrixToLogoImageConfig;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrcodeUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(QrcodeUtils.class);
    private static transient String DEFAULT_FORMAT = "png";
    private static transient int DEFAULT_WIDTH = 200;
    private static transient int DEFAULT_HEIGHT = 200;

    public static final InputStream gen(String content, File destFile) throws Exception {
        return QrcodeUtils.gen(content, destFile, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, File destFile, File logoFile) throws Exception {
        return QrcodeUtils.gen(content, destFile, logoFile, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, File destFile, File logoFile, int width, int height) throws Exception {
        InputStream inputStream;
        FolderUtils.mkdirs(destFile.getParent());
        BufferedOutputStream output = null;
        BufferedInputStream input = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            if (logoFile != null && logoFile.exists() && logoFile.isFile()) {
                input = new BufferedInputStream(new FileInputStream(logoFile));
            }
            inputStream = QrcodeUtils.gen(content, output, input, width, height);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        IOUtils.closeQuietly(input);
        return inputStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final InputStream gen(String content, File destFile, int width, int height) throws Exception {
        InputStream inputStream;
        FolderUtils.mkdirs(destFile.getParent());
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            inputStream = QrcodeUtils.gen(content, output, width, height);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
                catch (Exception e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        return inputStream;
    }

    public static final InputStream gen(String content, OutputStream output) throws Exception {
        return QrcodeUtils.gen(content, output, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, OutputStream output, InputStream logoInput) throws Exception {
        return QrcodeUtils.gen(content, output, logoInput, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, OutputStream output, InputStream logoInput, int width, int height) throws Exception {
        return QrcodeUtils.gen(content, output, logoInput, width, height, ErrorCorrectionLevel.M);
    }

    public static final InputStream gen(String content, OutputStream output, InputStream logoInput, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) throws Exception {
        BufferedInputStream bufferedInputStream;
        if (StringUtils.isEmpty((String)content)) {
            throw new IllegalArgumentException("qr code content cannot be empty.");
        }
        if (output == null) {
            throw new IllegalArgumentException("qr code output stream cannot be null.");
        }
        BitMatrix matrix = MatrixToImageWriterEx.createQRCode(content, width, height, errorCorrectionLevel);
        BufferedImage image = MatrixToImageWriter.toBufferedImage((BitMatrix)matrix);
        if (logoInput == null) {
            try {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
                ImageIO.write((RenderedImage)image, "png", imOut);
                ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
                return is;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        MatrixToLogoImageConfig logoConfig = new MatrixToLogoImageConfig(Color.BLUE, 4);
        String destPath = FilenameUtils.normalizeNoEndSeparator((String)(String.valueOf(SystemUtils.getJavaIoTmpDir()) + File.separator + UUID.randomUUID().toString() + ".tmp"));
        BufferedInputStream tmpInput = null;
        File destFile = new File(destPath);
        try {
            MatrixToImageWriterEx.writeToFile(matrix, DEFAULT_FORMAT, destPath, logoInput, logoConfig);
            tmpInput = new BufferedInputStream(new FileInputStream(destFile));
            IOUtils.copy((InputStream)tmpInput, (OutputStream)output);
            bufferedInputStream = tmpInput;
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tmpInput);
                destFile.delete();
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)tmpInput);
        destFile.delete();
        return bufferedInputStream;
    }

    public static final InputStream gen(String content, OutputStream output, int width, int height) throws Exception {
        return QrcodeUtils.gen(content, output, null, width, height);
    }

    public static final InputStream gen(String content, String destPath) throws Exception {
        return QrcodeUtils.gen(content, destPath, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, String destPath, int width, int height) throws Exception {
        return QrcodeUtils.gen(content, new File(destPath), width, height);
    }

    public static final InputStream gen(String content, String destPath, String logoPath) throws Exception {
        return QrcodeUtils.gen(content, destPath, logoPath, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public static final InputStream gen(String content, String destPath, String logoPath, int width, int height) throws Exception {
        File foo = new File(destPath);
        File bar = new File(logoPath);
        return QrcodeUtils.gen(content, foo, bar, width, height);
    }

    public static final String parse(InputStream input) throws Exception {
        MultiFormatReader reader = null;
        try {
            BufferedImage image = ImageIO.read(input);
            if (image == null) {
                throw new Exception("cannot read image from inputstream.");
            }
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, "utf-8");
            reader = new MultiFormatReader();
            return reader.decode(bitmap, hints).getText();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("parse QR code error: ", e);
        }
        catch (ReaderException e) {
            e.printStackTrace();
            throw new Exception("parse QR code error: ", e);
        }
    }

    public static final String parse(URL url) throws Exception {
        InputStream in = null;
        try {
            in = url.openStream();
            String string = QrcodeUtils.parse(in);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("parse QR code error: ", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static final String parse(File file) throws Exception {
        String string;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            string = QrcodeUtils.parse(in);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception("parse QR code error: ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public static final String parse(String filePath) throws Exception {
        String string;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(filePath));
            string = QrcodeUtils.parse(in);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception("parse QR code error: ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    static {
        try {
            Object[] foo = new String[]{"240", "240"};
            String format = "jpg";
            if (StringUtils.isNotBlank((String)"jpg")) {
                DEFAULT_FORMAT = StringUtils.strip((String)"jpg").toLowerCase();
            }
            if (ArrayUtils.isNotEmpty((Object[])foo) && foo.length == 2) {
                Integer tmpWidth = Integer.valueOf((String)foo[0]);
                Integer tmpHeight = Integer.valueOf((String)foo[1]);
                if (tmpWidth > 0 && tmpHeight > 0) {
                    DEFAULT_WIDTH = tmpWidth;
                    DEFAULT_HEIGHT = tmpHeight;
                } else {
                    LOGGER.warn("qrcode size must be lager than zero.");
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn("read default qrcode size config error: ", e);
        }
    }
}

