/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <T1, T2> List<Map<T1, T2>> findByEqualsAttribute(String equalsStr, List srcArray, String attribute) {
        ArrayList<Map<T1, T2>> result = new ArrayList<Map<T1, T2>>();
        if (srcArray == null || srcArray.size() == 0 || TreeUtils.isEmpty(equalsStr) || TreeUtils.isEmpty(attribute)) {
            return result;
        }
        for (Object obj : srcArray) {
            Map t = (Map)obj;
            if (t == null || !equalsStr.equals(t.get(attribute))) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> findByEqualsAttribute(String equalsStr, List<T> srcArray, Function<T, ? extends String> attribute) {
        ArrayList<T> result = new ArrayList<T>();
        if (srcArray == null || srcArray.size() == 0 || TreeUtils.isEmpty(equalsStr) || attribute == null) {
            return result;
        }
        for (T t : srcArray) {
            if (t == null || !equalsStr.equals(attribute.apply(t))) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> List<T> findParentListById(String equalsId, List<T> srcArray, Function<T, ? extends String> idField, Function<T, ? extends String> parentIdField) {
        ArrayList result = new ArrayList();
        if (srcArray == null || srcArray.size() == 0 || idField == null || parentIdField == null) {
            return result;
        }
        HashMap<String, String> idAndParentIdMap = new HashMap<String, String>(srcArray.size());
        HashMap map = new HashMap(srcArray.size());
        for (T t : srcArray) {
            if (t == null) continue;
            String id = idField.apply(t);
            String parentId = parentIdField.apply(t);
            if (TreeUtils.isEmpty(id)) continue;
            map.put(id, t);
            if (TreeUtils.isEmpty(parentId)) continue;
            idAndParentIdMap.put(id, parentId);
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        TreeUtils.findParentListByMap(userIdList, equalsId, idAndParentIdMap);
        userIdList.forEach(s -> result.add(map.get(s)));
        return result;
    }

    public static <T1, T2> List<Map<T1, T2>> findParentListById(Object idObj, List srcArray, String idField, String parentIdField) {
        ArrayList result = new ArrayList();
        if (srcArray == null || srcArray.size() == 0 || idObj == null || TreeUtils.isEmpty(idField) || TreeUtils.isEmpty(parentIdField)) {
            return result;
        }
        HashMap<String, String> idAndParentIdMap = new HashMap<String, String>(srcArray.size());
        HashMap<String, Map> map = new HashMap<String, Map>(srcArray.size());
        for (Object obj : srcArray) {
            if (obj == null) continue;
            Map t = (Map)obj;
            Object id = t.get(idField);
            Object parentId = t.get(parentIdField);
            if (TreeUtils.isEmpty(id)) continue;
            map.put(id.toString(), t);
            if (TreeUtils.isEmpty(parentId)) continue;
            idAndParentIdMap.put(id.toString(), parentId.toString());
        }
        String equalsId = idObj.toString();
        ArrayList<String> userIdList = new ArrayList<String>();
        TreeUtils.findParentListByMap(userIdList, equalsId, idAndParentIdMap);
        userIdList.forEach(s -> result.add((Map)map.get(s)));
        return result;
    }

    public static <T> List<T> tree2List(List<T> srcList, Function<T, ? extends List<T>> childField) {
        if (srcList == null || srcList.size() == 0 || childField == null) {
            return srcList;
        }
        ArrayList resultList = new ArrayList(srcList.size());
        for (T t : srcList) {
            TreeUtils.findAllSonByChildField(t, resultList, childField);
        }
        return resultList;
    }

    public static <T1, T2> List<Map<T1, T2>> tree2List(List srcList, String childField) {
        if (srcList == null || srcList.size() == 0 || TreeUtils.isEmpty(childField)) {
            return srcList;
        }
        ArrayList<Map<T1, T2>> resultList = new ArrayList<Map<T1, T2>>(srcList.size());
        for (Object obj : srcList) {
            Map t = (Map)obj;
            TreeUtils.findAllSonByChildField(t, resultList, childField);
        }
        return resultList;
    }

    public static <T1, T2> List<Map<T1, T2>> list2Tree(List srcList, String idName, String parentIdName, String childName) {
        if (srcList == null || srcList.size() == 0 || TreeUtils.isEmpty(idName) || TreeUtils.isEmpty(parentIdName) || TreeUtils.isEmpty(childName)) {
            return srcList;
        }
        if (idName.equals(parentIdName) || idName.equals(childName) || parentIdName.equals(childName)) {
            throw new RuntimeException("\u7f16\u7801\u5f02\u5e38\uff0c\u4e09\u4e2a\u5b57\u6bb5\u4e0d\u80fd\u4efb\u610f\u76f8\u7b49");
        }
        ArrayList<Map<T1, T2>> resultList = new ArrayList<Map<T1, T2>>();
        HashMap<String, List> parentIdAndObjListMap = new HashMap<String, List>(srcList.size());
        for (Object e : srcList) {
            Map map = (Map)e;
            if (map == null || TreeUtils.isEmpty(map.get(idName))) continue;
            if (TreeUtils.isEmpty(map.get(parentIdName))) {
                resultList.add(map);
                continue;
            }
            List tempList = parentIdAndObjListMap.computeIfAbsent(map.get(parentIdName).toString(), k -> new ArrayList());
            tempList.add(map);
        }
        for (Map map : resultList) {
            TreeUtils.insertSonList2ChildAttribute(map, parentIdAndObjListMap, idName, childName);
        }
        return resultList;
    }

    public static <T> List<T> list2Tree(List<T> srcList, Function<T, ? extends String> idField, Function<T, ? extends String> parentIdField, Function<T, ? extends List<T>> childField) {
        if (srcList == null || srcList.size() == 0 || idField == null || parentIdField == null || childField == null) {
            return srcList;
        }
        ArrayList<T> resultList = new ArrayList<T>(srcList.size());
        HashMap<String, List> parentIdAndObjListMap = new HashMap<String, List>(srcList.size());
        for (T t : srcList) {
            if (t == null || TreeUtils.isEmpty(idField.apply(t))) continue;
            if (childField.apply(t) == null) {
                throw new RuntimeException("\u7f16\u7801\u5f02\u5e38\uff0c\u5b9e\u4f53\u5fc5\u987b\u521d\u59cb\u5316\uff0c\u6bd4\u5982\uff1aprivate List child = new ArrayList ();");
            }
            String parentId = parentIdField.apply(t);
            if (TreeUtils.isEmpty(parentId)) {
                resultList.add(t);
                continue;
            }
            List tempList = parentIdAndObjListMap.computeIfAbsent(parentId, k -> new ArrayList());
            tempList.add(t);
        }
        resultList.forEach(s -> TreeUtils.insertSonList2ChildAttribute(s, parentIdAndObjListMap, idField, childField));
        return resultList;
    }

    private static <T> void insertSonList2ChildAttribute(T t, Map<String, List<T>> parentIdAndObjListMap, Function<T, ? extends String> idField, Function<T, ? extends List<T>> childField) {
        String id = idField.apply(t);
        List<T> tempObjList = parentIdAndObjListMap.get(id);
        if (tempObjList != null) {
            childField.apply(t).addAll(tempObjList);
            for (T tempObj : tempObjList) {
                TreeUtils.insertSonList2ChildAttribute(tempObj, parentIdAndObjListMap, idField, childField);
            }
        }
    }

    private static void insertSonList2ChildAttribute(Map t, Map allList, String idName, String childName) {
        String id = t.get(idName).toString();
        List mapList = (List)allList.get(id);
        if (mapList != null) {
            t.put(childName, mapList);
            for (Object o : mapList) {
                TreeUtils.insertSonList2ChildAttribute((Map)o, allList, idName, childName);
            }
        }
    }

    private static boolean isEmpty(Object str) {
        return str == null || str.toString().length() == 0;
    }

    private static void findParentListByMap(List<String> userIdList, String id, Map<String, String> idAndParentIdMap) {
        if (idAndParentIdMap.containsKey(id)) {
            String parentId = idAndParentIdMap.get(id);
            if (userIdList.contains(parentId)) {
                return;
            }
            userIdList.add(parentId);
            TreeUtils.findParentListByMap(userIdList, parentId, idAndParentIdMap);
        }
    }

    private static <T> void findAllSonByChildField(T t, List<T> keepList, Function<T, ? extends List<T>> childField) {
        keepList.add(t);
        if (t == null) {
            return;
        }
        List<T> childSon = childField.apply(t);
        if (childSon != null) {
            for (T tempObject : childSon) {
                TreeUtils.findAllSonByChildField(tempObject, keepList, childField);
            }
        }
    }

    private static void findAllSonByChildField(Map t, List keepList, String childField) {
        keepList.add(t);
        if (t == null) {
            return;
        }
        List childSon = (List)t.get(childField);
        if (childSon != null) {
            for (Map tempObject : childSon) {
                TreeUtils.findAllSonByChildField(tempObject, keepList, childField);
            }
        }
    }
}

