/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class ExcelUtil<T> {
    private static DecimalFormat df = new DecimalFormat("#");

    public void getnn() {
        this.getClass().getClassLoader().getResource("selected.txt");
        System.out.println(this.getClass().getClassLoader().getResource("selected.txt"));
        File f = new File(this.getClass().getResource("").getPath());
        System.out.println(f);
    }

    public static Workbook readExcel(String path) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (StringUtils.isBlank((String)path)) {
            throw new IllegalArgumentException("path is null!");
        }
        HSSFWorkbook workbook = null;
        FileInputStream is = new FileInputStream(path);
        if (path.endsWith(".xls")) {
            workbook = new HSSFWorkbook((InputStream)is);
        } else if (path.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook((InputStream)is);
        } else {
            IOUtils.closeQuietly((InputStream)is);
            throw new IllegalArgumentException("the path is not excel file!");
        }
        return workbook;
    }

    public static Workbook readExcel(InputStream is, String fileName) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (StringUtils.isBlank((String)fileName)) {
            throw new IllegalArgumentException("path is null!");
        }
        HSSFWorkbook workbook = null;
        if (fileName.endsWith(".xls")) {
            workbook = new HSSFWorkbook(is);
        } else if (fileName.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(is);
        } else {
            throw new IllegalArgumentException("the path is not excel file!");
        }
        return workbook;
    }

    public List<T> readInitInventory(InputStream is, String fileName) throws IllegalArgumentException, FileNotFoundException, IOException {
        Workbook workbook = ExcelUtil.readExcel(is, fileName);
        if (workbook == null) {
            return null;
        }
        return this.readInitInventory(workbook.getSheetAt(0));
    }

    public List<T> readInitInventory(Sheet sheet) throws IllegalArgumentException, FileNotFoundException, IOException {
        Row row;
        Cell cell;
        if (sheet == null) {
            System.out.print("<<<<<<\u7a7a\u8868>>>>>>");
            throw new IllegalArgumentException("sheet is null!");
        }
        LinkedList<T> initInventoryOs = new LinkedList<T>();
        T initInventory = null;
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum() && (cell = (row = sheet.getRow(rowNum)).getCell(0)) != null && (cell = row.getCell(1)) != null; ++rowNum) {
            initInventory = this.getObject();
            for (int columnNum = 0; columnNum < row.getLastCellNum(); ++columnNum) {
                cell = row.getCell(columnNum);
                if (ExcelUtil.isBlank(cell)) continue;
                int columnIndex = cell.getColumnIndex();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                this.valueToObject(columnIndex, cell, initInventory);
            }
            initInventoryOs.add(initInventory);
        }
        System.out.println("initInventoryOs.size():" + initInventoryOs.size() + "\ninitInventoryOs>>>>>>" + String.valueOf(initInventoryOs));
        return initInventoryOs;
    }

    public abstract void valueToObject(int var1, Cell var2, T var3);

    public abstract T getObject();

    private static boolean isBlank(Cell cell) {
        return cell == null || cell.getCellType() == 3;
    }

    public String getValue(Cell cell) {
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 0) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                SimpleDateFormat sdf = null;
                sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                Date date = cell.getDateCellValue();
                return sdf.format(date);
            }
            return String.valueOf(cell.getNumericCellValue());
        }
        String value = cell.getStringCellValue();
        return value == null ? "" : value.trim();
    }

    public String getPostfix(String path) {
        String postfix = null;
        if (StringUtils.isNotBlank((String)path) && path.contains(".")) {
            postfix = path.substring(path.lastIndexOf("."));
        }
        return postfix;
    }
}

