/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.sql;

import cc.lechun.framework.common.utils.sql.SqlSegment;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class BaseSingleSqlParser {
    protected String originalSql;
    protected List<SqlSegment> segments;

    public BaseSingleSqlParser(String originalSql) {
        this.originalSql = originalSql;
        this.segments = new ArrayList<SqlSegment>();
        this.initializeSegments();
        this.splitSql2Segment();
    }

    protected abstract void initializeSegments();

    protected void splitSql2Segment() {
        for (SqlSegment sqlSegment : this.segments) {
            sqlSegment.parse(this.originalSql);
        }
    }

    public String getParsedSql() {
        StringBuffer sb = new StringBuffer();
        for (SqlSegment sqlSegment : this.segments) {
            sb.append(sqlSegment.getParsedSqlSegment());
        }
        String retval = sb.toString().replaceAll("@+", "\n");
        return retval;
    }

    public String replaceSql(String where) {
        SqlSegment sqlSegment;
        if (!((String)where).trim().toLowerCase(Locale.ROOT).startsWith("and ") && !((String)where).trim().toLowerCase(Locale.ROOT).startsWith("or ")) {
            where = "and (" + (String)where + ")";
        }
        if ((sqlSegment = (SqlSegment)this.segments.stream().filter(c -> c.getStart().startsWith("where")).findFirst().orElse(null)) != null) {
            sqlSegment.setBody(sqlSegment.getBody() + " " + (String)where);
        } else {
            if (((String)where).trim().toLowerCase(Locale.ROOT).startsWith("and ") || ((String)where).trim().toLowerCase(Locale.ROOT).startsWith("or ")) {
                where = ((String)where).replaceFirst("and ", "").replaceFirst("or ", "");
            }
            if ((sqlSegment = (SqlSegment)this.segments.stream().filter(c -> c.getStart().startsWith("from")).findFirst().orElse(null)) != null) {
                int i = this.segments.indexOf(sqlSegment);
                SqlSegment s = new SqlSegment(" ", "");
                s.setStart("where");
                s.setBody((String)where);
                s.setEnd("");
                this.segments.add(i + 1, s);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (SqlSegment sqlSegment1 : this.segments) {
            sb.append(sqlSegment1.getStart() + " " + sqlSegment1.getBody() + " ");
        }
        String retval = sb.toString().replaceAll("@+", "");
        return retval;
    }

    public List<String> getParsedSqlList() {
        ArrayList<String> sb = new ArrayList<String>();
        for (SqlSegment sqlSegment : this.segments) {
            String retval = sqlSegment.getParsedSqlSegment().replaceAll("@+", "");
            sb.add(retval);
        }
        return sb;
    }

    public List<SqlSegment> RetrunSqlSegments() {
        int SegmentLength = this.segments.size();
        if (SegmentLength != 0) {
            List<SqlSegment> result = this.segments;
            return result;
        }
        return null;
    }
}

