/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gatewaynewserver.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.params.SetParams;

@Component
public class RedisCacheUtilGate<T> {
    private static final Long RELEASE_SUCCESS = 1L;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "EX";
    private static final String RELEASE_LOCK_SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static final Long DEFAULT_EXPIRE_TIME = 60L;
    @Autowired
    private RedisTemplate redisTemplate;

    public void remove(String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.remove(key);
            ++n2;
        }
    }

    public void removePattern(String pattern) {
        try {
            Set keys = this.redisTemplate.keys((Object)pattern);
            if (keys.size() > 0) {
                this.redisTemplate.delete((Collection)keys);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(String key) {
        try {
            if (this.exists(key)) {
                this.redisTemplate.delete((Object)key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(Set<Serializable> keys) {
        if (keys.size() > 0) {
            this.redisTemplate.delete(keys);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public boolean set(String key, Object value) {
        return this.set(key, value, Long.valueOf(0L));
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            if (expireTime != 0L) {
                this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public int decrement(String key, int delta) {
        Long value = this.redisTemplate.opsForValue().increment((Object)key, (long)(-delta));
        return value.intValue();
    }

    public int increment(String key, int delta) {
        Long value = this.redisTemplate.opsForValue().increment((Object)key, (long)delta);
        return value.intValue();
    }

    public <T> ValueOperations<String, T> setCacheObject(String key, T value) {
        return this.setCacheObject(key, value, Long.valueOf(0L));
    }

    public <T> ValueOperations<String, T> setCacheObject(String key, T value, Long expireTime) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value);
        if (expireTime != 0L) {
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
        }
        return operation;
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList) {
        return this.setCacheList(key, dataList, 0L);
    }

    public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList, long expireTime) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        if (dataList != null) {
            int size = dataList.size();
            int i = 0;
            while (i < size) {
                listOperation.rightPush((Object)key, dataList.get(i));
                ++i;
            }
            if (expireTime != 0L) {
                this.redisTemplate.expire((Object)key, expireTime, TimeUnit.SECONDS);
            }
        }
        return listOperation;
    }

    public <T> List<T> getCacheList(String key) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        ListOperations listOperation = this.redisTemplate.opsForList();
        Long size = listOperation.size((Object)key);
        int i = 0;
        while ((long)i < size) {
            dataList.add(listOperation.leftPop((Object)key));
            ++i;
        }
        return dataList;
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        return this.setCacheSet(key, dataSet, Long.valueOf(0L));
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet, Long expireTime) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        Iterator<T> it = dataSet.iterator();
        while (it.hasNext()) {
            setOperation.add(new Object[]{it.next()});
        }
        if (expireTime != 0L) {
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
        }
        return setOperation;
    }

    public boolean setCacheSet(String key, T ... ls) {
        try {
            BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
            Long i = setOperation.add((Object[])ls);
            return i != 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setCacheSet(String key, Long expireTime, T ... ls) {
        try {
            BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
            Long i = setOperation.add((Object[])ls);
            if (expireTime != 0L) {
                this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            }
            return i != 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean removeCacheSet(String key, T ... ls) {
        try {
            BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
            Long i = setOperation.remove((Object[])ls);
            return i != 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Set<T> getCacheSet(String key) {
        HashSet<Object> dataSet = new HashSet<Object>();
        BoundSetOperations operation = this.redisTemplate.boundSetOps((Object)key);
        Long size = operation.size();
        int i = 0;
        while ((long)i < size) {
            dataSet.add(operation.pop());
            ++i;
        }
        return dataSet;
    }

    public <T> HashOperations<String, String, T> setCacheMap(String key, Map<String, T> dataMap) {
        return this.setCacheMap(key, dataMap, Long.valueOf(0L));
    }

    public <T> HashOperations<String, String, T> setCacheMap(String key, Map<String, T> dataMap, Long expireTime) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        if (dataMap != null) {
            for (Map.Entry<String, T> entry : dataMap.entrySet()) {
                hashOperations.put((Object)key, (Object)entry.getKey(), entry.getValue());
            }
            if (expireTime != 0L) {
                this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            }
        }
        return hashOperations;
    }

    public <T> Map<String, T> getCacheMap(String key) {
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        return map;
    }

    public <T> HashOperations<String, Integer, T> setCacheIntegerMap(String key, Map<Integer, T> dataMap) {
        return this.setCacheIntegerMap(key, dataMap, Long.valueOf(0L));
    }

    public <T> HashOperations<String, Integer, T> setCacheIntegerMap(String key, Map<Integer, T> dataMap, Long expireTime) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        if (dataMap != null) {
            for (Map.Entry<Integer, T> entry : dataMap.entrySet()) {
                hashOperations.put((Object)key, (Object)entry.getKey(), entry.getValue());
            }
            if (expireTime != 0L) {
                this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            }
        }
        return hashOperations;
    }

    public <T> Map<Integer, T> getCacheIntegerMap(String key) {
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        return map;
    }

    public Boolean waitLock(String lockKey, String clientId, long expireTime, long waitTime) {
        long nanoWaitTime = TimeUnit.SECONDS.toNanos(waitTime);
        long now = System.nanoTime();
        while (System.nanoTime() - now < nanoWaitTime) {
            if (!this.lock(lockKey, clientId, expireTime).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean lock(String lockKey, String clientId) {
        return this.lock(lockKey, clientId, DEFAULT_EXPIRE_TIME.longValue());
    }

    public Boolean lock(String lockKey, String clientId, long expireTime) {
        return (Boolean)this.redisTemplate.execute(redisConnection -> {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            SetParams setParams = new SetParams();
            setParams.nx();
            setParams.px(expireTime <= 0L ? 1000L : (expireTime > 300L ? 300000L : expireTime * 1000L));
            String result = jedis.set(lockKey, clientId, setParams);
            if (LOCK_SUCCESS.equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    public Boolean releaseLock(String lockKey, String clientId) {
        return (Boolean)this.redisTemplate.execute(redisConnection -> {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            Object result = jedis.eval(RELEASE_LOCK_SCRIPT, Collections.singletonList(lockKey), Collections.singletonList(clientId));
            if (RELEASE_SUCCESS.equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    public Set<Serializable> getKeysPattern(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }
}

