/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.common;

import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.shortlink.ShortLinkInterface;
import cc.lechun.common.file.OssService;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.WeiXinMediaEntity;
import cc.lechun.mall.iservice.weixin.WeiXinMediaInterface;
import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/active"})
public class ActiveCommonController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    private WeiXinMediaInterface weiXinMediaInterface;
    @Autowired
    private OssService ossService;
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private ShortLinkInterface shortLinkService;

    @RequestMapping(value={"/getShare"})
    public BaseJsonVo getShareByBindCode(String bindCode) throws AuthorizeException {
        WeiXinMediaEntity weiXinMediaEntity;
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
        if (activeQrcodeEntity != null && StringUtils.isNotEmpty((String)activeQrcodeEntity.getShareMedia()) && (weiXinMediaEntity = this.weiXinMediaInterface.getMediaByMediaId(activeQrcodeEntity.getShareMedia())) != null) {
            if (StringUtils.isNotEmpty((String)weiXinMediaEntity.getDigest())) {
                weiXinMediaEntity.setDigest(MessageFormat.format(weiXinMediaEntity.getDigest(), customerDetailVo.getNickName()));
                weiXinMediaEntity.setTitle(MessageFormat.format(weiXinMediaEntity.getTitle(), customerDetailVo.getNickName()));
            }
            weiXinMediaEntity.setImageUrl(this.ossService.getImageResoure(weiXinMediaEntity.getImageUrl()));
            return BaseJsonVo.success((Object)weiXinMediaEntity);
        }
        return BaseJsonVo.success((Object)"\u672a\u7ed1\u5b9a\u5206\u4eab\u8fde\u63a5");
    }

    @RequestMapping(value={"/checkIsNewUser"})
    public BaseJsonVo checkIsNewUser(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), customerDetailVo.getPlatformId(), bindCode);
    }

    @RequestMapping(value={"/sendCashticket"})
    public BaseJsonVo sendcashticket(String bindCode, int platFormId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCashticketInterface.sendTicket4CustomerType(customerDetailVo.getCustomerId(), bindCode, "", Integer.valueOf(platFormId), true);
    }

    @RequestMapping(value={"/getLink"})
    public void getLink(HttpServletRequest request, HttpServletResponse response, String link) throws AuthorizeException, IOException {
        String shortLink = this.shortLinkService.getShorterUrl(link = link.replace("/", ""));
        response.sendRedirect(StringUtils.isNotEmpty((String)shortLink) ? shortLink : "https://wx.lechun.cc");
    }

    @RequestMapping(value={"/getShortLink"})
    public String getShortLink(String link) throws AuthorizeException, IOException {
        link = link.replace("/", "");
        return this.shortLinkService.getShorterUrl(link);
    }

    @RequestMapping(value={"/getLongLink"})
    public String getLongLink(String shortKey) throws AuthorizeException, IOException {
        shortKey = shortKey.replace("/", "");
        return this.shortLinkService.getMallUrl(shortKey);
    }
}

