/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.common;

import cc.lechun.active.entity.Cash.CustomerCashVo;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.shortlink.ShortLinkInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.distribution.DistributionInviteLogEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.customer.CustomerAdCookieInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/active"})
public class ActiveCommonController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private ShortLinkInterface shortLinkService;
    @Autowired
    ShareInterface shareInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;
    @Autowired
    DistributionInviteInterface distributionInviteInterface;
    @Autowired
    DistributionInviteLogInterface distributionInviteLogInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    private CustomerAdCookieInterface customerAdCookieInterface;

    @RequestMapping(value={"/getActiveIndexList"})
    public BaseJsonVo getActiveIndexList(HttpServletRequest request, PageForm pageForm) {
        return BaseJsonVo.success((Object)this.activeIndexInterface.getActiveIndexList(pageForm, Integer.valueOf(1000)));
    }

    @RequestMapping(value={"/getShare"})
    public BaseJsonVo getShareByBindCode(HttpServletRequest request, HttpServletResponse response, String bindCode, String productId, Integer groupType, String adCookie, String gdt_vid, String dataSource) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        String pageUrl = request.getHeader("referer");
        if (StringUtils.isNotEmpty((String)adCookie)) {
            try {
                this.customerAdCookieInterface.saveAdCookieCustomerInfo(customerDetailVo.getCustomerId(), adCookie, gdt_vid, Integer.valueOf(StringUtils.isNotEmpty((String)dataSource) ? Integer.valueOf(dataSource) : 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.error((String)"\u6ca1\u6709\u5206\u4eab\u914d\u7f6e");
        if (customerDetailVo != null && StringUtils.isNotEmpty((String)customerDetailVo.getCustomerId())) {
            String customerId = customerDetailVo.getCustomerId();
            String nickName = customerDetailVo.getNickName();
            String inviteCode = "";
            DistributorRelationEntity distributorRelation = this.distributorRelationInterface.getDistributorRelationByRelationUserId(customerDetailVo.getCustomerId(), Integer.valueOf(1));
            if (distributorRelation != null && StringUtils.isNotEmpty((String)distributorRelation.getDistributorRelationCode())) {
                inviteCode = distributorRelation.getDistributorRelationCode();
            }
            this.logger.info("*****\u6211\u770b\u770bbindcode\u662f\u4e0d\u662f\u7a7a\uff1a" + bindCode);
            baseJsonVo = StringUtils.isNotEmpty((String)bindCode) ? this.activeCommonService.getActiveShare(pageUrl, bindCode, inviteCode, customerId, nickName, productId) : this.shareInterface.getShare(pageUrl, inviteCode, customerId, nickName, productId, groupType);
            if (!baseJsonVo.isSuccess()) {
                baseJsonVo = this.shareInterface.getDefaultShare(pageUrl, inviteCode, customerId, nickName, productId, groupType);
            }
            if ("4".equals(request.getParameter("platFormId")) && StringUtils.isEmpty((String)bindCode)) {
                ((Map)baseJsonVo.getValue()).put("url", "");
            }
            if (StringUtils.isNotEmpty((String)bindCode)) {
                BaseJsonVo isNewUser = this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), customerDetailVo.getPlatformId(), bindCode);
                ((Map)baseJsonVo.getValue()).putAll((Map)isNewUser.getValue());
            }
        } else {
            baseJsonVo = this.shareInterface.getDefaultShare(pageUrl, "", "", "\u4e50\u7eaf\u7528\u6237", productId, groupType);
            if ("4".equals(request.getParameter("platFormId"))) {
                ((Map)baseJsonVo.getValue()).put("url", "");
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/checkIsNewUser"})
    public BaseJsonVo checkIsNewUser(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), customerDetailVo.getPlatformId(), bindCode);
    }

    @RequestMapping(value={"/sendCashticket"})
    public BaseJsonVo sendcashticket(HttpServletRequest httpServletRequest, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (customerDetailVo.getSubscribe() == 0) {
            CustomerCashVo customerCashVo = new CustomerCashVo();
            customerCashVo.setSubscribe(customerDetailVo.getSubscribe());
            ActiveQrcodeEntity activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode);
            customerCashVo.setQrcodeUrl(activeQrcodeEntity != null ? this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()) : "");
            return BaseJsonVo.success((Object)customerCashVo);
        }
        BaseJsonVo jsonVo = this.activeCashticketInterface.sendTicket4CustomerType(customerDetailVo.getCustomerId(), bindCode, "", customerDetailVo.getPlatformId(), customerDetailVo.getPlatformGroupId(), true);
        if (jsonVo.isSuccess()) {
            CustomerCashVo customerCashVo = (CustomerCashVo)jsonVo.getValue();
            customerCashVo.setSubscribe(1);
            if (customerCashVo != null) {
                this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a" + JsonUtils.toJson((Object)customerCashVo, (boolean)true));
                List cashticketVos = customerCashVo.getCashDetailVos();
                if (cashticketVos != null && cashticketVos.size() > 0) {
                    for (CashticketVo v : cashticketVos) {
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a\u5faa\u73af:" + v.getTicketBatchName());
                        String distributorRelationCode = httpServletRequest.getParameter("ncp_bat");
                        if (!StringUtils.isNotEmpty((String)distributorRelationCode)) continue;
                        this.logger.info("sendCashticket:\u9886\u53d6\u6210\u529f\uff1a:\u9080\u8bf7\u7801\uff1a" + distributorRelationCode);
                        Boolean bl = this.distributionInviteInterface.invite(distributorRelationCode, customerDetailVo.getCustomerId(), v.getTicketCustomerId().toString(), 2);
                    }
                }
            }
        }
        return jsonVo;
    }

    @RequestMapping(value={"/getLink"})
    public void getLink(HttpServletRequest request, HttpServletResponse response, String link) throws AuthorizeException, IOException {
        String shortLink = this.shortLinkService.getShorterUrl(link = link.replace("/", ""));
        response.sendRedirect(StringUtils.isNotEmpty((String)shortLink) ? shortLink : "https://wx.lechun.cc");
    }

    @RequestMapping(value={"/getShortLink"})
    public String getShortLink(String link) throws AuthorizeException, IOException {
        link = link.replace("/", "");
        return this.shortLinkService.getShorterUrl(link);
    }

    @RequestMapping(value={"/getLongLink"})
    public String getLongLink(String shortKey) throws AuthorizeException, IOException {
        shortKey = shortKey.replace("/", "");
        return this.shortLinkService.getMallUrl(shortKey);
    }

    @RequestMapping(value={"/testId"})
    public DistributionInviteLogEntity testId() throws AuthorizeException, IOException {
        DistributionInviteLogEntity logEntity = new DistributionInviteLogEntity();
        logEntity.setInviteId("1");
        logEntity.setDistributorId(Integer.valueOf(1));
        logEntity.setDistributorRelationId(Integer.valueOf(1));
        logEntity.setDistributorRelationUserId("1");
        logEntity.setInvitedCustomerId("1");
        logEntity.setInviteSource("111");
        logEntity.setInviteTime(new Date());
        logEntity.setInviteType(Integer.valueOf(1));
        logEntity.setStatus(Integer.valueOf(1));
        logEntity.setUneffectLogId(null);
        return logEntity;
    }

    @RequestMapping(value={"/testBaId"})
    public BaseJsonVo testBaId() throws AuthorizeException, IOException {
        return this.activeCashticketInterface.sendCashticketByTicketBatchId("10003256340646139187456", "1029293484646993920", Integer.valueOf(1));
    }

    @RequestMapping(value={"/getActiveInfo"})
    public BaseJsonVo getActiveInfo(String bindCode) throws AuthorizeException {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        if (!activeEntity.getActiveName().contains(":")) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        String[] arr = activeEntity.getActiveName().split(":");
        map.put("name", arr[0]);
        map.put("token", arr[1]);
        map.put("list", this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), Integer.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue())));
        return BaseJsonVo.success(map);
    }
}

