/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.weixin.MessageTypeEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.weixin.WeiXinKeywordEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mall.iservice.weixin.WeiXinKeywordInterface;
import cc.lechun.mallapi.api.CustomerMessageApi;
import cc.lechun.mallapi.dto.CustomerMessageDTO;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerMessageApiService
implements CustomerMessageApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinKeywordInterface weiXinKeywordService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MessageInterface messageService;
    @Autowired
    private RedisService redisService;

    public BaseJsonVo sendCustomerMessage(CustomerMessageDTO customerMessageDTO) {
        return this.sendCustomerMessage(customerMessageDTO.getCustomerId(), customerMessageDTO.getPlatformId().intValue(), customerMessageDTO.getKeyworldId(), customerMessageDTO.getMap());
    }

    public BaseJsonVo sendCustomerMessage(String key, String customerId, int platformId, Integer keyworldId) {
        this.logger.info("key:{},\u7528\u6237:{},\u5e73\u53f0:{},\u6a21\u677fID:{}", new Object[]{key, customerId, platformId, keyworldId});
        LinkedHashMap variableMap = null;
        if (StringUtils.isNotEmpty((String)key)) {
            variableMap = (LinkedHashMap)this.redisService.get(key);
        }
        return this.sendCustomerMessage(customerId, platformId, keyworldId, variableMap);
    }

    public BaseJsonVo sendCustomerMessage(String customerId, int platformId, Integer keyworldId, LinkedHashMap<String, String> variableMap) {
        WeiXinKeywordEntity weiXinKeywordEntity = this.weiXinKeywordService.getWeiXinKeywordById(keyworldId.intValue());
        if (weiXinKeywordEntity == null) {
            return BaseJsonVo.error((String)"\u5173\u952e\u5b57\u4e0d\u5b58\u5728!");
        }
        if (weiXinKeywordEntity.getContent().contains("nickName") || weiXinKeywordEntity.getTitle().contains("nickName")) {
            CustomerDetailVo customerDetailVo;
            if (variableMap == null) {
                variableMap = new LinkedHashMap();
            }
            if ((customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId)) != null) {
                variableMap.put("nickName", StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34");
            }
            for (Map.Entry<String, String> entry : variableMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                this.logger.info("key:" + key + ";value:" + value);
            }
            return this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, weiXinKeywordEntity.getId(), customerId, Integer.valueOf(platformId), variableMap);
        }
        return this.messageService.sendWechatMessage(MessageTypeEnum.CUSTOMZICE_MESSAGE, weiXinKeywordEntity.getId(), customerId, Integer.valueOf(platformId), variableMap);
    }
}

