/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.customer;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.form.customer.AddressForm;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/customerAddress"})
public class CustomerAddressController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerAddressInterface customerAddressInterface;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"/getAddressList"})
    @ResponseBody
    public BaseJsonVo getAddressList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return BaseJsonVo.success((Object)this.customerAddressInterface.getAddressList());
    }

    @RequestMapping(value={"/getCustomerAddress"})
    @ResponseBody
    public BaseJsonVo getCustomerAddress(HttpServletRequest request, HttpServletResponse response, String addrId) throws InterruptedException {
        if (StringUtils.isEmpty((String)addrId) || addrId.equals("null")) {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return BaseJsonVo.success((Object)this.customerAddressInterface.getCustomerAddress(addrId));
    }

    @RequestMapping(value={"/getCustomerAddressList"})
    @ResponseBody
    public BaseJsonVo getCustomerAddressList(HttpServletRequest request, HttpServletResponse response, String addressId, Integer transportType) throws AuthorizeException, InterruptedException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        List ls = this.customerAddressInterface.getValidCustomerAddressList(customerDetailVo.getCustomerId(), addressId, transportType.intValue());
        return BaseJsonVo.success((Object)ls);
    }

    @RequestMapping(value={"/getAddressType"})
    @ResponseBody
    public BaseJsonVo getAddressType(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.customerAddressInterface.getAddressType());
    }

    @RequestMapping(value={"/addAddress"})
    @ResponseBody
    public BaseJsonVo addAddressType(HttpServletRequest request, HttpServletResponse response, AddressForm addressForm) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        addressForm.setCustomerId(customerDetailVo.getCustomerId());
        return this.customerAddressInterface.saveCustomerAddress(addressForm);
    }

    @RequestMapping(value={"/updateAddress"})
    @ResponseBody
    public BaseJsonVo updateAddressType(HttpServletRequest request, HttpServletResponse response, AddressForm addressForm) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        addressForm.setCustomerId(customerDetailVo.getCustomerId());
        return this.customerAddressInterface.updateCustomerAddress(addressForm);
    }

    @RequestMapping(value={"/deleteAddress"})
    @ResponseBody
    public BaseJsonVo deleteAddressType(HttpServletRequest request, HttpServletResponse response, String addrId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerAddressInterface.updateCustomerAddress(addrId);
    }

    @RequestMapping(value={"/updateAddressLastTime"})
    @ResponseBody
    public BaseJsonVo updateAddressLastTime(HttpServletRequest request, HttpServletResponse response, String addrId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        this.customerAddressInterface.updateAddressLastTime(addrId);
        return BaseJsonVo.success((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/getProvinceCityArea"})
    @ResponseBody
    public BaseJsonVo getProvinceCityArea(HttpServletRequest request, HttpServletResponse response, Integer transportType) throws AuthorizeException {
        if (transportType != null && transportType == 1) {
            transportType = 3;
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("provinceVoList", this.customerAddressInterface.getProvinceCityArea(transportType.intValue(), customerDetailVo.getPlatformGroupId().intValue()));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getProvinceCityAreaByErp"})
    @ResponseBody
    public BaseJsonVo getProvinceCityAreaByErp(HttpServletRequest request, HttpServletResponse response, Integer transportType, Integer isLongPeriodBuy) throws AuthorizeException {
        this.logger.info("!!!!!!!!!!!!!\u8fdb\u5165getProvinceCityAreaByErp!!!!!!!!!transportType={},isLongPeriodBuy={}", (Object)transportType, (Object)isLongPeriodBuy);
        Map map = new HashMap();
        map = this.customerAddressInterface.getProvinceCityAreaByErp(transportType, isLongPeriodBuy);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getAreaIsOpen"})
    @ResponseBody
    public BaseJsonVo getAreaIsOpen(HttpServletRequest request, HttpServletResponse response, String areaId) {
        BaseJsonVo baseJsonVo = this.customerAddressInterface.getAreaIsOpen(Integer.valueOf(areaId));
        return baseJsonVo;
    }
}

