/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.evaluate;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.form.evaluate.EvaluateForm;
import cc.lechun.mall.form.evaluate.EvaluateProductForm;
import cc.lechun.mall.iservice.evaluate.EvaluateOrderInterface;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import java.io.IOException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/evaluate"})
public class EvaluateController {
    private static final Logger log = LoggerFactory.getLogger(EvaluateController.class);
    @Autowired
    private EvaluateOrderInterface evaluateOrderInterface;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"/getEvaluateParamVo"})
    @ResponseBody
    public BaseJsonVo getEvaluateParamVo(String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.evaluateOrderInterface.getEvaluateParamVo(orderNo, customerDetailVo.getPlatformGroupId().intValue()));
    }

    @RequestMapping(value={"/saveEvaluate"})
    @ResponseBody
    public BaseJsonVo saveEvaluate(String orderNo, Integer flag, String evaluate, String source, String goodTags, String products) throws AuthorizeException, IOException {
        log.error("evaluate-save:" + orderNo);
        log.error("evaluate-save:" + flag);
        log.error("evaluate-save:" + evaluate);
        log.error("evaluate-save:" + source);
        log.error("evaluate-save:" + goodTags);
        log.error("evaluate-save:" + products);
        if (StringUtils.isEmpty((String)orderNo) || flag == null) {
            return BaseJsonVo.error((String)"\u7cfb\u7edf\u9519\u8bef");
        }
        evaluate = StringUtils.isEmpty((String)evaluate) ? "" : evaluate;
        products = StringUtils.isEmpty((String)products) ? "" : URLDecoder.decode(products, "UTF-8");
        goodTags = StringUtils.isEmpty((String)goodTags) ? "" : URLDecoder.decode(goodTags, "UTF-8");
        EvaluateForm evaluateForm = new EvaluateForm();
        evaluateForm.setOrderNo(orderNo);
        evaluateForm.setFlag(flag);
        evaluateForm.setEvaluate(evaluate);
        evaluateForm.setSource(source);
        if (!StringUtil.isEmpty((String)goodTags)) {
            evaluateForm.setGoodTags(JSON.parseArray((String)goodTags, String.class));
        }
        if (!StringUtil.isEmpty((String)products)) {
            log.error("evaluate-save2[products]:" + products);
            evaluateForm.setProducts(JSON.parseArray((String)products, EvaluateProductForm.class));
        }
        log.info(JSON.toJSONString((Object)evaluateForm));
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        evaluateForm.setPlatform(this.customerLoginService.getPlatFormId());
        return this.evaluateOrderInterface.saveEvaluate(evaluateForm, customerDetailVo);
    }
}

