/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.common.login;

import cc.lechun.common.enums.platform.PlatFormEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.CookieUtils;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.platform.PlatFormAndGroupVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerLoginService {
    private static final Logger log = LoggerFactory.getLogger(CustomerLoginService.class);
    @Autowired
    CustomerInterface customerService;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Value(value="${shiro.cookie.name}")
    private String cookie_name;
    @Value(value="${topdomain:lechun.cc}")
    private String topdomain;
    private String sensorCookieKey = "cusId";

    public void login(HttpServletResponse response, HttpServletRequest request, String sign) {
        CookieUtils.addCookie((HttpServletResponse)response, (String)this.topdomain, (String)this.cookie_name, (String)sign, (int)86400);
    }

    public CustomerDetailVo getCustomer(boolean needTicket) throws AuthorizeException {
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        Cookie cookie = this.getCookie(request);
        String sign = "";
        if (cookie == null) {
            String userTicket = request.getParameter("userTicket");
            if (userTicket != null && !userTicket.isEmpty()) {
                sign = userTicket;
            }
        } else {
            sign = cookie.getValue();
        }
        if (sign != null && !sign.isEmpty()) {
            int platFormId = this.getPlatFormId();
            CustomerDetailVo customerDetail = this.customerService.getCustomerDetailBySign(sign, platFormId);
            if (null != customerDetail) {
                AccessLogEntity log = (AccessLogEntity)request.getAttribute("lechun.api.log");
                log.setCustomerId(customerDetail.getCustomerOpenId());
                return customerDetail;
            }
            CookieUtils.delCookie((HttpServletRequest)RequestDetail.getCurrentRequest(), (HttpServletResponse)RequestDetail.getCurrentResponse(), (String)this.topdomain, (String)this.cookie_name);
        }
        if (needTicket) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        return null;
    }

    public int getPlatFormId() {
        HttpServletRequest request = RequestDetail.getCurrentRequest();
        String value = request.getParameter("platformIdKey");
        if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)(value = request.getParameter("userTerminal"))) && StringUtils.isEmpty((String)(value = request.getParameter("platFormId")))) {
            return PlatFormEnum.LECHUN_WECHAT_MAIN.getValue();
        }
        return Integer.parseInt(value);
    }

    public PlatFormAndGroupVo getPlatFormAndGroup() {
        return this.platFormInterface.getPlatFormAndGroup(this.getPlatFormId());
    }

    private Cookie getCookie(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)this.cookie_name);
    }

    public void setSensorCookie(String customerId, Integer currentOrderCount) {
        CookieUtils.addCookie((HttpServletResponse)RequestDetail.getCurrentResponse(), (String)this.topdomain, (String)this.sensorCookieKey, (String)(customerId + "|" + currentOrderCount), (int)86400);
    }

    public String getCustomerIdFromCookie() {
        String cusId;
        String customerId;
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)RequestDetail.getCurrentRequest(), (String)this.sensorCookieKey);
        if (cookie != null && StringUtils.isNotEmpty((String)(customerId = (cusId = cookie.getValue()).split("|")[0]))) {
            return customerId;
        }
        return null;
    }
}

