/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.iservice.cashticket.CashticketClassInterface;
import cc.lechun.mall.service.dictionary.DictionaryService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CashticketClassService
implements CashticketClassInterface {
    @Autowired
    private DictionaryService dictionaryService;

    @Override
    public List<DictionaryEntity> getCashticketClass(int platformGroupId) {
        return this.dictionaryService.getValidDictionaryList(platformGroupId, 8);
    }

    @Override
    public String getCashticketClassName(int platformGroupId, int ticketClass) {
        DictionaryEntity dictionaryEntity = this.dictionaryService.getDictionary(platformGroupId, 8, ticketClass + "");
        return dictionaryEntity == null ? "" : dictionaryEntity.getDictionaryName();
    }

    @Override
    public String getCashticketClassName(List<DictionaryEntity> list, int ticketClass) {
        String cashticketClassName = "";
        if (list == null || list.size() == 0) {
            return "";
        }
        Optional<DictionaryEntity> dictionaryEntity = list.stream().filter(c -> (ticketClass + "").equals(c.getDictionaryKey())).findFirst();
        return dictionaryEntity.isPresent() ? dictionaryEntity.get().getDictionaryName() : "";
    }
}

