/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.deliver;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.deliver.MallCityMapper;
import cc.lechun.mall.entity.deliver.MallCityEntity;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MallCityService
extends BaseService
implements MallCityInterface {
    @Autowired
    private MallCityMapper cityMapper;
    @Value(value="${erp.getCity.url}")
    private String getCityUrl;

    private List<MallCityEntity> getCityErp(String cityId, String cityName) {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("cityId", cityId);
        mapParam.put("cityName", cityName);
        this.logger.info("*************************getCity********************\u8c03\u7528ERP3.0\u83b7\u53d6cityList\u4f20\u9012\u7684\u53c2\u6570*************mapParam={}", (Object)JSON.toJSONString(mapParam));
        String result = "";
        result = HttpRequest.httpsPostByDeliver((String)this.getCityUrl, (String)JsonUtils.toJson(mapParam, (boolean)false));
        this.logger.info("*************************getCity********************\u8c03\u7528ERP3.0\u8fd4\u56de\u7684\u53c2\u6570*************result={}", (Object)JSON.toJSONString((Object)result));
        if (StringUtils.isNotEmpty((String)result)) {
            JSONObject jsonObject = JSON.parseObject((String)result);
            int status = (Integer)jsonObject.get((Object)"status");
            if (status == 200) {
                boolean success = (Boolean)jsonObject.get((Object)"success");
                if (success) {
                    ArrayList<MallCityEntity> mallCityEntityList = new ArrayList<MallCityEntity>();
                    JSONArray jsonArrayCity = (JSONArray)jsonObject.get((Object)"result");
                    for (JSONObject ob : jsonArrayCity) {
                        String code = (String)ob.get((Object)"code");
                        String name = (String)ob.get((Object)"name");
                        String parentcode = (String)ob.get((Object)"parentcode");
                        Integer nomalstatus = ob.getInteger("nomalstatus");
                        Integer coldstatus = ob.getInteger("coldstatus");
                        Integer freshstatus = ob.getInteger("freshstatus");
                        MallCityEntity mallCityEntity = new MallCityEntity();
                        mallCityEntity.setCityId(Integer.valueOf(code));
                        mallCityEntity.setCityName(name);
                        mallCityEntity.setProvinceId(Integer.valueOf(parentcode));
                        mallCityEntity.setStatus(coldstatus);
                        mallCityEntity.setOpenCityStatus(freshstatus);
                        mallCityEntity.setOrdinaryStatus(nomalstatus);
                        mallCityEntityList.add(mallCityEntity);
                    }
                    return mallCityEntityList;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getCity", expiration=300)
    public MallCityEntity getCity(@ParameterValueKeyProvider Integer cityId) {
        if (cityId == null) {
            return null;
        }
        List<MallCityEntity> mallCityEntityList = this.getCityErp(String.valueOf(cityId), null);
        if (mallCityEntityList != null && mallCityEntityList.size() > 0) {
            return mallCityEntityList.get(0);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="getCity", expiration=300)
    public MallCityEntity getCityByName(String cityName) {
        if (StringUtils.isNotEmpty((String)cityName)) {
            List<MallCityEntity> mallCityEntityList = this.getCityErp(null, cityName);
            if (mallCityEntityList != null && mallCityEntityList.size() > 0) {
                return mallCityEntityList.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public List<MallCityEntity> getCityList() {
        List<MallCityEntity> mallCityEntityList = this.getCityErp(null, null);
        return mallCityEntityList;
    }
}

